/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.web;

import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.web.exception.LauncherException;
import com.nlbhub.nlb.web.service.rest.GetNLBDataService;
import org.apache.wink.server.internal.servlet.RestServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class Launcher
implements Runnable {
    private Server m_server = new Server();

    public Launcher() {
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
        ServerConnector http = new ServerConnector(this.m_server);
        http.setHost("localhost");
        http.setPort(8111);
        http.setIdleTimeout(30000L);
        this.m_server.addConnector((Connector)http);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.m_server.setHandler((Handler)context);
        ServletHolder holder = context.addServlet(RestServlet.class, "/nlb/*");
        holder.setInitParameter("javax.ws.rs.Application", "com.nlbhub.nlb.web.service.rest.NLBServiceWebApplication");
    }

    private void start() throws LauncherException {
        try {
            if (!this.m_server.isStopped()) {
                throw new LauncherException("Cannot start server because it is not stopped");
            }
            this.m_server.start();
            this.m_server.join();
        }
        catch (Exception e) {
            throw new LauncherException("Exception during server start", e);
        }
    }

    public void stop() throws LauncherException {
        try {
            if (!this.m_server.isRunning()) {
                throw new LauncherException("Cannot stop server because it is not running");
            }
            this.m_server.stop();
        }
        catch (Exception e) {
            throw new LauncherException("Exception during server stop", e);
        }
    }

    public boolean isRunning() {
        return this.m_server.isRunning();
    }

    public void setNLBLibraryRoot(String path) throws LauncherException {
        if (this.m_server.isRunning()) {
            throw new LauncherException("Cannot change NLB library root while server is running!");
        }
        GetNLBDataService.s_nlbLibraryRoot = path + "/";
    }

    public void putNLBInMemoryToCache(String bookId, NonLinearBook nlb) {
        GetNLBDataService.putNLBInMemoryToCache(bookId, nlb);
    }

    public void clearNLBCache() {
        GetNLBDataService.clearNLBCache();
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (LauncherException launcherException) {
            // empty catch block
        }
    }
}

