/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.web.service.rest;

import com.nlbhub.nlb.api.DummyProgressData;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.ProgressData;
import com.nlbhub.nlb.domain.AbstractIdentifiableItem;
import com.nlbhub.nlb.domain.AbstractModifyingItem;
import com.nlbhub.nlb.domain.LinkImpl;
import com.nlbhub.nlb.domain.ModificationImpl;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.PageImpl;
import com.nlbhub.nlb.exception.DecisionException;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.JaxbMarshaller;
import com.nlbhub.nlb.util.StringHelper;
import com.nlbhub.user.domain.DecisionPoint;
import com.nlbhub.user.domain.History;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.wink.common.internal.MultivaluedMapImpl;

@Path(value="{bookId}")
public class GetNLBDataService {
    public static String s_nlbLibraryRoot = "/D:/work/Azartox/NLB/books/";
    private static final Map<String, NonLinearBook> m_nlbCache = new HashMap<String, NonLinearBook>();
    private static final JaxbMarshaller PAGE_MARSHALLER = new JaxbMarshaller(new Class[]{PageImpl.class, LinkImpl.class, AbstractModifyingItem.class, AbstractIdentifiableItem.class, ModificationImpl.class});
    private static final JaxbMarshaller DECISIONS_MARSHALLER = new JaxbMarshaller(new Class[]{History.class, DecisionPoint.class});
    private static History s_history = new History();

    @GET
    @Produces(value={"text/html"})
    @Path(value="start")
    public Response start(@PathParam(value="bookId") PathSegment bookId) {
        s_history.clear();
        return this.getStartPointData(bookId, null, null);
    }

    @GET
    @Produces(value={"text/html"})
    public Response getStartPointData(@PathParam(value="bookId") PathSegment bookId, @QueryParam(value="rollback") Boolean rollback, @QueryParam(value="visit-count") Integer visitCount) {
        try {
            NonLinearBook mainNLB = this.getNLBFromCache(bookId.getPath());
            ModuleData moduleData = this.getNonLinearBookModuleData(bookId, mainNLB);
            DecisionPoint decisionPointToBeMade = new DecisionPoint(bookId.toString(), moduleData.getModule().getStartPoint());
            s_history.suggestDecisionPointToBeMade(decisionPointToBeMade, rollback != null ? rollback : false, visitCount != null ? visitCount : -1);
            Page pageToBeVisited = moduleData.getModule().getPageById(moduleData.getModule().getStartPoint());
            s_history.setDecisionPointToBeMadeText(!StringHelper.isEmpty((String)pageToBeVisited.getCaption()) ? pageToBeVisited.getCaption() : pageToBeVisited.getId());
            Response response = this.generateFilteredResponse(moduleData, moduleData.getModule().getStartPoint());
            s_history.makeDecision();
            return response;
        }
        catch (NLBIOException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NLBConsistencyException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NLBVCSException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (DecisionException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ScriptException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Response.serverError().build();
    }

    private ModuleData getNonLinearBookModuleData(PathSegment bookId, NonLinearBook mainNLB) {
        ModuleData result = new ModuleData();
        NonLinearBook module = mainNLB;
        MultivaluedMap mvm = bookId.getMatrixParameters();
        int parentDepth = 0;
        for (Map.Entry entry : mvm.entrySet()) {
            int curParentDepth = Integer.parseInt((String)entry.getKey());
            if (curParentDepth <= parentDepth) continue;
            parentDepth = curParentDepth;
            String modulePageId = (String)((List)entry.getValue()).get(0);
            Page page = module.getPageById(modulePageId);
            module = page.getModule();
        }
        result.setModuleDepth(parentDepth);
        result.setModule(module);
        result.setMainNLBId(bookId.getPath());
        return result;
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="page/{toPageId}")
    public Response getPageData(@PathParam(value="bookId") PathSegment bookId, @PathParam(value="toPageId") String toPageId, @QueryParam(value="rollback") Boolean rollback, @QueryParam(value="visit-count") Integer visitCount) {
        try {
            s_history.suggestDecisionPointToBeMade(new DecisionPoint(bookId.toString(), toPageId), rollback != null ? rollback : false, visitCount != null ? visitCount : -1);
            NonLinearBook mainNLB = this.getNLBFromCache(bookId.getPath());
            ModuleData moduleData = this.getNonLinearBookModuleData(bookId, mainNLB);
            Page pageToBeVisited = moduleData.getModule().getPageById(toPageId);
            s_history.setDecisionPointToBeMadeText(!StringHelper.isEmpty((String)pageToBeVisited.getCaption()) ? pageToBeVisited.getCaption() : pageToBeVisited.getId());
            Response response = this.generateFilteredResponse(moduleData, toPageId);
            s_history.makeDecision();
            return response;
        }
        catch (NLBIOException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ScriptException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NLBConsistencyException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NLBVCSException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (DecisionException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Response.serverError().build();
    }

    private NonLinearBook getNLBFromCache(String bookId) throws NLBIOException, NLBConsistencyException, NLBVCSException {
        NonLinearBook nlb;
        if (m_nlbCache.containsKey(bookId)) {
            nlb = m_nlbCache.get(bookId);
        } else {
            String path = s_nlbLibraryRoot + bookId;
            File rootDir = new File(path);
            if (!rootDir.exists()) {
                throw new NLBIOException("Specified NLB root directory " + path + " does not exist");
            }
            nlb = new NonLinearBookImpl();
            nlb.load(path, (ProgressData)new DummyProgressData());
            m_nlbCache.put(bookId, nlb);
        }
        return nlb;
    }

    public static void putNLBInMemoryToCache(String bookId, NonLinearBook nlb) {
        m_nlbCache.put(bookId, nlb);
    }

    public static void clearNLBCache() {
        m_nlbCache.clear();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="link/{fromPageId}/{linkId}")
    public Response followLink(@PathParam(value="bookId") PathSegment bookId, @PathParam(value="fromPageId") String fromPageId, @PathParam(value="linkId") String linkId, @QueryParam(value="rollback") Boolean rollback, @QueryParam(value="visit-count") Integer visitCount) {
        try {
            Response response;
            s_history.suggestDecisionPointToBeMade(new DecisionPoint(bookId.toString(), fromPageId, linkId), rollback != null ? rollback : false, visitCount != null ? visitCount : -1);
            NonLinearBook mainNLB = this.getNLBFromCache(bookId.getPath());
            ModuleData moduleData = this.getNonLinearBookModuleData(bookId, mainNLB);
            Link link = moduleData.getModule().getPageById(fromPageId).getLinkById(linkId);
            if (link != null) {
                s_history.setDecisionPointToBeMadeText(link.getText());
                response = this.generateFilteredResponse(moduleData, link.getTarget());
                s_history.makeDecision();
            } else {
                response = Response.serverError().build();
            }
            return response;
        }
        catch (NLBIOException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ScriptException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NLBConsistencyException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NLBVCSException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (DecisionException ex) {
            Logger.getLogger(GetNLBDataService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Response.serverError().build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="history")
    public Response getHistory(final @PathParam(value="bookId") PathSegment bookId) {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DECISIONS_MARSHALLER.marshal((Object)s_history, (OutputStream)outputStream, false);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toString("UTF-8").getBytes("UTF-8"));
                    GetNLBDataService.this.transform(bookId.getPath(), inputStream, "xsl/history.xsl", output);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }
        };
        Response.ResponseBuilder builder = Response.ok((Object)stream);
        builder.type("text/html");
        builder.status(Response.Status.OK);
        return builder.build();
    }

    public void transform(String mainNLBId, String normalLinkBookId, String traversalLinkBookId, ReturnBookIdAndModulePage returnBookIdAndModulePage, InputStream inputStream, String xslID, OutputStream outputStream) throws TransformerException, TransformerConfigurationException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer transformer = tfactory.newTransformer(new StreamSource(new File(xslID)));
        transformer.setParameter("mainNLBId", mainNLBId);
        transformer.setParameter("normalLinkBookId", normalLinkBookId);
        transformer.setParameter("traversalLinkBookId", traversalLinkBookId);
        transformer.setParameter("returnLinkBookId", returnBookIdAndModulePage.getBookId());
        transformer.setParameter("returnModulePageId", returnBookIdAndModulePage.getModulePageId());
        transformer.transform(new StreamSource(inputStream), new StreamResult(outputStream));
    }

    public void transform(String mainNLBId, InputStream inputStream, String xslID, OutputStream outputStream) throws TransformerException, TransformerConfigurationException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer transformer = tfactory.newTransformer(new StreamSource(new File(xslID)));
        transformer.setParameter("mainNLBId", mainNLBId);
        transformer.transform(new StreamSource(inputStream), new StreamResult(outputStream));
    }

    protected Response generateResponse(final String mainNLBId, final String normalLinkBookId, final String traversalLinkBookId, final ReturnBookIdAndModulePage returnBookIdAndModulePage, final Page page) {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    PAGE_MARSHALLER.marshal((Object)page, (OutputStream)outputStream, false);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toString("UTF-8").getBytes("UTF-8"));
                    GetNLBDataService.this.transform(mainNLBId, normalLinkBookId, traversalLinkBookId, returnBookIdAndModulePage, inputStream, "xsl/page.xsl", output);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }
        };
        Response.ResponseBuilder builder = Response.ok((Object)stream);
        builder.type("text/html");
        builder.status(Response.Status.OK);
        return builder.build();
    }

    protected Response generateFilteredResponse(ModuleData moduleData, String pageId) throws ScriptException, NLBConsistencyException {
        String traversalLinkBookId;
        String normalLinkBookId;
        ReturnBookIdAndModulePage returnBookIdAndPage;
        DecisionPoint decisionPointToBeMade;
        Page filteredPage = moduleData.getModule().createFilteredPage(pageId, s_history);
        AutomaticDecision automaticDecision = this.addPossibleNextDecisions(filteredPage, decisionPointToBeMade = s_history.getDecisionPointToBeMade(), returnBookIdAndPage = this.getReturnLinkBookId(decisionPointToBeMade, moduleData), normalLinkBookId = this.getNormalLinkBookId(decisionPointToBeMade), traversalLinkBookId = this.getTraversalLinkBookId(decisionPointToBeMade, moduleData, pageId));
        if (automaticDecision != null) {
            s_history.makeDecision();
            return automaticDecision.proceed();
        }
        return this.generateResponse(moduleData.getMainNLBId(), normalLinkBookId, traversalLinkBookId, returnBookIdAndPage, filteredPage);
    }

    private AutomaticDecision addPossibleNextDecisions(Page pageToBeVisited, DecisionPoint decisionPointToBeMade, ReturnBookIdAndModulePage returnBookIdAndPage, String normalLinkBookId, String traversalLinkBookId) {
        AutomaticDecision automaticDecision = null;
        for (Link link : pageToBeVisited.getLinks()) {
            DecisionPoint decisionPoint;
            if (link.isTraversalLink()) {
                decisionPoint = new DecisionPoint(traversalLinkBookId, link.getTarget());
                decisionPointToBeMade.addPossibleNextDecisionPoint(decisionPoint);
                if (automaticDecision != null || !link.isAuto()) continue;
                automaticDecision = new TraverseAutomaticDecision(decisionPoint, s_history.predictDecisionCount(decisionPoint));
                continue;
            }
            if (link.isReturnLink()) {
                if (StringHelper.isEmpty((String)pageToBeVisited.getReturnPageId())) {
                    decisionPoint = new DecisionPoint(returnBookIdAndPage.getBookId(), returnBookIdAndPage.getModulePageId());
                    decisionPointToBeMade.addPossibleNextDecisionPoint(decisionPoint);
                } else {
                    decisionPoint = new DecisionPoint(returnBookIdAndPage.getBookId(), pageToBeVisited.getReturnPageId());
                    decisionPointToBeMade.addPossibleNextDecisionPoint(decisionPoint);
                }
                if (automaticDecision != null || !link.isAuto()) continue;
                automaticDecision = new ReturnAutomaticDecision(decisionPoint, s_history.predictDecisionCount(decisionPoint));
                continue;
            }
            decisionPoint = new DecisionPoint(normalLinkBookId, pageToBeVisited.getId(), link.getId());
            decisionPointToBeMade.addPossibleNextDecisionPoint(decisionPoint);
            if (automaticDecision != null || !link.isAuto()) continue;
            automaticDecision = new NormalAutomaticDecision(decisionPoint, s_history.predictDecisionCount(decisionPoint));
        }
        return automaticDecision;
    }

    private String getNormalLinkBookId(DecisionPoint decisionPoint) {
        return decisionPoint.getBookId();
    }

    private String getTraversalLinkBookId(DecisionPoint decisionPoint, ModuleData moduleData, String pageId) {
        return decisionPoint.getBookId() + ";" + (moduleData.getModuleDepth() + 1) + "=" + pageId;
    }

    private ReturnBookIdAndModulePage getReturnLinkBookId(DecisionPoint decisionPoint, ModuleData moduleData) {
        ReturnBookIdAndModulePage result = new ReturnBookIdAndModulePage();
        String[] idParts = decisionPoint.getBookId().split(";");
        StringBuilder bookIdBuilder = new StringBuilder();
        bookIdBuilder.append(idParts[0]);
        for (int i = 1; i < idParts.length; ++i) {
            String[] moduleIdParts = idParts[i].split("=");
            if (Integer.parseInt(moduleIdParts[0]) != moduleData.getModuleDepth()) {
                bookIdBuilder.append(";").append(idParts[i]);
                continue;
            }
            result.setModulePageId(moduleIdParts[1]);
        }
        result.setBookId(bookIdBuilder.toString());
        return result;
    }

    private class ModuleData {
        private String m_mainNLBId;
        private NonLinearBook m_module;
        private int m_moduleDepth;

        private ModuleData() {
        }

        private NonLinearBook getModule() {
            return this.m_module;
        }

        private void setModule(NonLinearBook module) {
            this.m_module = module;
        }

        private int getModuleDepth() {
            return this.m_moduleDepth;
        }

        private void setModuleDepth(int moduleDepth) {
            this.m_moduleDepth = moduleDepth;
        }

        private String getMainNLBId() {
            return this.m_mainNLBId;
        }

        private void setMainNLBId(String mainNLBId) {
            this.m_mainNLBId = mainNLBId;
        }
    }

    private class ReturnBookIdAndModulePage {
        private String m_bookId;
        private String m_modulePageId;

        private ReturnBookIdAndModulePage() {
        }

        private String getBookId() {
            return this.m_bookId;
        }

        private void setBookId(String bookId) {
            this.m_bookId = bookId;
        }

        private String getModulePageId() {
            return this.m_modulePageId;
        }

        private void setModulePageId(String modulePageId) {
            this.m_modulePageId = modulePageId;
        }
    }

    private class ReturnAutomaticDecision
    extends AutomaticDecision {
        protected ReturnAutomaticDecision(DecisionPoint decisionPoint, int count) {
            super(decisionPoint, count);
        }

        @Override
        public Response proceed() {
            DecisionPoint decisionPoint = this.getDecisionPoint();
            return GetNLBDataService.this.getPageData(new ManualPathSegment(decisionPoint.getBookId()), decisionPoint.getToPageId(), false, this.getCount());
        }
    }

    private class TraverseAutomaticDecision
    extends AutomaticDecision {
        protected TraverseAutomaticDecision(DecisionPoint decisionPoint, int count) {
            super(decisionPoint, count);
        }

        @Override
        public Response proceed() {
            DecisionPoint decisionPoint = this.getDecisionPoint();
            return GetNLBDataService.this.getStartPointData(new ManualPathSegment(decisionPoint.getBookId()), false, this.getCount());
        }
    }

    private class NormalAutomaticDecision
    extends AutomaticDecision {
        protected NormalAutomaticDecision(DecisionPoint decisionPoint, int count) {
            super(decisionPoint, count);
        }

        @Override
        public Response proceed() {
            DecisionPoint decisionPoint = this.getDecisionPoint();
            return GetNLBDataService.this.followLink(new ManualPathSegment(decisionPoint.getBookId()), decisionPoint.getFromPageId(), decisionPoint.getLinkId(), false, this.getCount());
        }
    }

    private abstract class AutomaticDecision {
        private DecisionPoint m_decisionPoint;
        private int m_count;

        protected AutomaticDecision(DecisionPoint decisionPoint, int count) {
            this.m_decisionPoint = decisionPoint;
            this.m_count = count;
        }

        public DecisionPoint getDecisionPoint() {
            return this.m_decisionPoint;
        }

        public int getCount() {
            return this.m_count;
        }

        public abstract Response proceed();
    }

    private class ManualPathSegment
    implements PathSegment {
        private String m_path;
        private MultivaluedMap<String, String> m_matrixParameters;

        private ManualPathSegment(String bookId) {
            String[] parts = bookId.split(";");
            this.m_path = parts[0];
            this.m_matrixParameters = new MultivaluedMapImpl();
            for (int i = 1; i < parts.length; ++i) {
                String[] matrixParts = parts[i].split("=");
                ArrayList<String> elements = (ArrayList<String>)this.m_matrixParameters.get((Object)matrixParts[0]);
                if (elements == null) {
                    elements = new ArrayList<String>();
                    this.m_matrixParameters.put((Object)matrixParts[0], elements);
                }
                elements.add(matrixParts[1]);
            }
        }

        public String getPath() {
            return this.m_path;
        }

        public MultivaluedMap<String, String> getMatrixParameters() {
            return this.m_matrixParameters;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.m_path);
            for (Map.Entry entry : this.m_matrixParameters.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    builder.append(";").append((String)entry.getKey()).append("=").append(value);
                }
            }
            return builder.toString();
        }
    }
}

