/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerCloneException;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;
import sun.rmi.transport.ObjectTable;

public class UnicastRemoteObject
extends RemoteServer {
    private int port = 0;
    private RMIClientSocketFactory csf = null;
    private RMIServerSocketFactory ssf = null;
    private static final long serialVersionUID = 4974527148936298033L;

    protected UnicastRemoteObject() throws RemoteException {
        this(0);
    }

    protected UnicastRemoteObject(int n) throws RemoteException {
        this.port = n;
        UnicastRemoteObject.exportObject((Remote)this, n);
    }

    protected UnicastRemoteObject(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        this.port = n;
        this.csf = rMIClientSocketFactory;
        this.ssf = rMIServerSocketFactory;
        UnicastRemoteObject.exportObject(this, n, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.reexport();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            UnicastRemoteObject unicastRemoteObject = (UnicastRemoteObject)super.clone();
            unicastRemoteObject.reexport();
            return unicastRemoteObject;
        }
        catch (RemoteException remoteException) {
            throw new ServerCloneException("Clone failed", remoteException);
        }
    }

    private void reexport() throws RemoteException {
        if (this.csf == null && this.ssf == null) {
            UnicastRemoteObject.exportObject((Remote)this, this.port);
        } else {
            UnicastRemoteObject.exportObject(this, this.port, this.csf, this.ssf);
        }
    }

    @Deprecated
    public static RemoteStub exportObject(Remote remote) throws RemoteException {
        return (RemoteStub)UnicastRemoteObject.exportObject(remote, new UnicastServerRef(true));
    }

    public static Remote exportObject(Remote remote, int n) throws RemoteException {
        return UnicastRemoteObject.exportObject(remote, new UnicastServerRef(n));
    }

    public static Remote exportObject(Remote remote, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        return UnicastRemoteObject.exportObject(remote, new UnicastServerRef2(n, rMIClientSocketFactory, rMIServerSocketFactory));
    }

    public static boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
        return ObjectTable.unexportObject(remote, bl);
    }

    private static Remote exportObject(Remote remote, UnicastServerRef unicastServerRef) throws RemoteException {
        if (remote instanceof UnicastRemoteObject) {
            ((UnicastRemoteObject)remote).ref = unicastServerRef;
        }
        return unicastServerRef.exportObject(remote, null, false);
    }
}

