/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import net.sf.saxon.dom.AttrOverNodeInfo;
import net.sf.saxon.dom.DOMAttributeMap;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.ElementOverNodeInfo;
import net.sf.saxon.dom.PIOverNodeInfo;
import net.sf.saxon.dom.TextOverNodeInfo;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class NodeOverNodeInfo
implements Node {
    protected NodeInfo node;

    public NodeInfo getUnderlyingNodeInfo() {
        return this.node;
    }

    public static NodeOverNodeInfo wrap(NodeInfo node) {
        NodeOverNodeInfo n;
        if (node == null) {
            return null;
        }
        switch (node.getNodeKind()) {
            case 9: {
                n = new DocumentOverNodeInfo();
                break;
            }
            case 1: {
                n = new ElementOverNodeInfo();
                break;
            }
            case 2: {
                n = new AttrOverNodeInfo();
                break;
            }
            case 3: 
            case 8: {
                n = new TextOverNodeInfo();
                break;
            }
            case 7: {
                n = new PIOverNodeInfo();
                break;
            }
            case 13: {
                n = new AttrOverNodeInfo();
                break;
            }
            default: {
                return null;
            }
        }
        n.node = node;
        return n;
    }

    public final boolean isSameNode(Node other) {
        return other instanceof NodeOverNodeInfo && this.node.isSameNodeInfo(((NodeOverNodeInfo)other).node);
    }

    public boolean equals(Object obj) {
        return obj instanceof Node && this.isSameNode((Node)obj);
    }

    public int hashCode() {
        return ((Object)this.node).hashCode();
    }

    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    public String getNodeName() {
        switch (this.node.getNodeKind()) {
            case 9: {
                return "#document";
            }
            case 1: {
                return this.node.getDisplayName();
            }
            case 2: {
                return this.node.getDisplayName();
            }
            case 3: {
                return "#text";
            }
            case 8: {
                return "#comment";
            }
            case 7: {
                return this.node.getLocalPart();
            }
            case 13: {
                if (this.node.getLocalPart().length() == 0) {
                    return "xmlns";
                }
                return "xmlns:" + this.node.getLocalPart();
            }
        }
        return "#unknown";
    }

    public String getLocalName() {
        switch (this.node.getNodeKind()) {
            case 1: 
            case 2: {
                return this.node.getLocalPart();
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
            case 13: {
                if (this.node.getLocalPart().length() == 0) {
                    return "xmlns";
                }
                return this.node.getLocalPart();
            }
        }
        return null;
    }

    public boolean hasChildNodes() {
        return this.node.iterateAxis((byte)3).next() != null;
    }

    public boolean hasAttributes() {
        return true;
    }

    public short getNodeType() {
        short kind = (short)this.node.getNodeKind();
        if (kind == 13) {
            return 2;
        }
        return kind;
    }

    public Node getParentNode() {
        return NodeOverNodeInfo.wrap(this.node.getParent());
    }

    public Node getPreviousSibling() {
        return NodeOverNodeInfo.wrap(this.node.iterateAxis((byte)11).next());
    }

    public Node getNextSibling() {
        return NodeOverNodeInfo.wrap(this.node.iterateAxis((byte)7).next());
    }

    public Node getFirstChild() {
        return NodeOverNodeInfo.wrap(this.node.iterateAxis((byte)3).next());
    }

    public Node getLastChild() {
        AxisIterator children = this.node.iterateAxis((byte)3);
        NodeInfo last = null;
        Object next;
        while ((next = children.next()) != null) {
            last = (NodeInfo)next;
        }
        return NodeOverNodeInfo.wrap(last);
    }

    public String getNodeValue() {
        switch (this.node.getNodeKind()) {
            case 1: 
            case 9: {
                return null;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                return this.node.getStringValue();
            }
        }
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
    }

    public NodeList getChildNodes() {
        try {
            NodeInfo node;
            ArrayList<Node> nodes = new ArrayList<Node>(10);
            AxisIterator iter = this.node.iterateAxis((byte)3);
            while ((node = (NodeInfo)iter.next()) != null) {
                nodes.add(NodeOverNodeInfo.wrap(node));
            }
            return new DOMNodeList(nodes);
        }
        catch (XPathException err) {
            return null;
        }
    }

    public NamedNodeMap getAttributes() {
        if (this.node.getNodeKind() == 1) {
            return new DOMAttributeMap(this.node);
        }
        return null;
    }

    public Document getOwnerDocument() {
        return (Document)((Object)NodeOverNodeInfo.wrap(this.node.getDocumentRoot()));
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node appendChild(Node newChild) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node cloneNode(boolean deep) {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String feature, String version) {
        return !(!feature.equalsIgnoreCase("XML") && !feature.equalsIgnoreCase("Core") || version != null && version.length() != 0 && !version.equals("3.0") && !version.equals("2.0") && !version.equals("1.0"));
    }

    public String getNamespaceURI() {
        if (this.node.getNodeKind() == 13) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String uri = this.node.getURI();
        return "".equals(uri) ? null : uri;
    }

    public String getPrefix() {
        if (this.node.getNodeKind() == 13) {
            if (this.node.getLocalPart().length() == 0) {
                return null;
            }
            return "xmlns";
        }
        String p = this.node.getNamePool().getPrefix(this.node.getNameCode());
        return "".equals(p) ? null : p;
    }

    public void setPrefix(String prefix) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        boolean DOCUMENT_POSITION_DISCONNECTED = true;
        int DOCUMENT_POSITION_PRECEDING = 2;
        int DOCUMENT_POSITION_FOLLOWING = 4;
        int DOCUMENT_POSITION_CONTAINS = 8;
        int DOCUMENT_POSITION_CONTAINED_BY = 16;
        if (!(other instanceof NodeOverNodeInfo)) {
            return 1;
        }
        int c = this.node.compareOrder(((NodeOverNodeInfo)other).node);
        if (c == 0) {
            return 0;
        }
        if (c == -1) {
            short result = 4;
            short d = this.compareDocumentPosition(other.getParentNode());
            if (d == 0 || (d & 0x10) != 0) {
                result = (short)(result | 0x10);
            }
            return result;
        }
        if (c == 1) {
            short result = 2;
            short d = this.getParentNode().compareDocumentPosition(other);
            if (d == 0 || (d & 8) != 0) {
                result = (short)(result | 8);
            }
            return result;
        }
        throw new AssertionError();
    }

    public String getTextContent() throws DOMException {
        if (this.node.getNodeKind() == 9) {
            return null;
        }
        return this.node.getStringValue();
    }

    public void setTextContent(String textContent) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
    }

    public String lookupPrefix(String namespaceURI) {
        if (this.node.getNodeKind() == 9) {
            return null;
        }
        if (this.node.getNodeKind() == 1) {
            Object ns;
            AxisIterator iter = this.node.iterateAxis((byte)8);
            do {
                if ((ns = iter.next()) != null) continue;
                return null;
            } while (!ns.getStringValue().equals(namespaceURI));
            return ns.getLocalPart();
        }
        return this.getParentNode().lookupPrefix(namespaceURI);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return namespaceURI.equals(this.lookupNamespaceURI(""));
    }

    public String lookupNamespaceURI(String prefix) {
        if (this.node.getNodeKind() == 9) {
            return null;
        }
        if (this.node.getNodeKind() == 1) {
            Object ns;
            AxisIterator iter = this.node.iterateAxis((byte)8);
            do {
                if ((ns = iter.next()) != null) continue;
                return null;
            } while (!ns.getLocalPart().equals(prefix));
            return ns.getStringValue();
        }
        return this.getParentNode().lookupNamespaceURI(prefix);
    }

    public boolean isEqualNode(Node arg) {
        if (!(arg instanceof NodeOverNodeInfo)) {
            throw new IllegalArgumentException("Other Node must wrap a Saxon NodeInfo");
        }
        try {
            return DeepEqual.deepEquals(SingletonIterator.makeIterator(this.node), SingletonIterator.makeIterator(((NodeOverNodeInfo)arg).node), new GenericAtomicComparer(CodepointCollator.getInstance(), this.node.getConfiguration().getConversionContext()), this.node.getConfiguration(), 46);
        }
        catch (XPathException err) {
            return false;
        }
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Object getUserData(String key) {
        return null;
    }

    protected static void disallowUpdate() throws DOMException {
        throw new UnsupportedOperationException("The Saxon DOM implementation cannot be updated");
    }
}

