/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.providers.entity.html;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wink.common.internal.model.ModelUtils;
import org.apache.wink.common.model.synd.SyndCategory;
import org.apache.wink.common.model.synd.SyndContent;
import org.apache.wink.common.model.synd.SyndEntry;
import org.apache.wink.common.model.synd.SyndLink;
import org.apache.wink.common.model.synd.SyndPerson;
import org.apache.wink.common.model.synd.SyndText;
import org.apache.wink.common.model.synd.SyndTextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSyndEntryAdapter {
    private final SyndEntry syndEntry;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private boolean isContentXml = false;

    public HtmlSyndEntryAdapter(SyndEntry metadata) {
        this.syndEntry = metadata;
    }

    public String getId() {
        String id = this.syndEntry.getId();
        if (id != null) {
            return id;
        }
        return "";
    }

    public String getUpdated() {
        if (this.syndEntry.getUpdated() != null) {
            return this.simpleDateFormat.format(this.syndEntry.getUpdated());
        }
        return "";
    }

    public String getTitle() {
        SyndText title = this.syndEntry.getTitle();
        if (title != null) {
            return title.getValue();
        }
        return "";
    }

    public List<SyndLink> getLinks() {
        return this.syndEntry.getLinks();
    }

    public List<SyndCategory> getCategories() {
        return this.syndEntry.getCategories();
    }

    public String getAuthor() {
        String name;
        List authors = this.syndEntry.getAuthors();
        if (!authors.isEmpty() && (name = ((SyndPerson)authors.get(0)).getName()) != null) {
            return name;
        }
        return "";
    }

    public String getPublished() {
        if (this.syndEntry.getPublished() != null) {
            return this.simpleDateFormat.format(this.syndEntry.getPublished());
        }
        return "";
    }

    public String getSummary() {
        String summary = "";
        if (this.syndEntry.getSummary() != null) {
            summary = this.syndEntry.getSummary().getValue();
        }
        return summary;
    }

    public String getContent() throws IOException {
        SyndContent content = this.syndEntry.getContent();
        if (content != null) {
            String src = content.getSrc();
            if (src != null) {
                return src;
            }
            String type = content.getType();
            String value = String.valueOf(content.getValue());
            String string = value = value != null ? value : "";
            if (type != null && (SyndTextType.xhtml.name().equals(type) || ModelUtils.isTypeXml((String)type))) {
                return StringEscapeUtils.escapeXml((String)value);
            }
            return value;
        }
        return "";
    }

    public boolean isContentXml() {
        return this.isContentXml;
    }
}

