/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder;

import com.nlbhub.nlb.api.PropertyManager;
import com.nlbhub.nlb.api.config.Settings;
import com.nlbhub.nlb.builder.form.MainFrame;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import com.nlbhub.nlb.exception.NLBJAXBException;
import com.nlbhub.nlb.vcs.Author;
import com.nlbhub.nlb.vcs.DummyVCSAdapter;
import com.nlbhub.nlb.vcs.GitAdapterWithPathDecoration;
import com.nlbhub.nlb.vcs.VCSAdapter;
import com.nlbhub.nlb.web.Launcher;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;

public class NLBBMain
implements Runnable {
    private final NonLinearBookFacade m_nlbFacade;
    private final Launcher m_launcher = new Launcher();

    public NLBBMain(boolean novcs) {
        Author author = new Author("author", "author@example.com");
        DummyVCSAdapter vcsAdapter = novcs ? new DummyVCSAdapter() : new GitAdapterWithPathDecoration(author);
        this.m_nlbFacade = new NonLinearBookFacade(author, (VCSAdapter)vcsAdapter);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new NLBBMain(args.length > 0 && "novcs".equalsIgnoreCase(args[0])));
    }

    private void createAndShowGUI() throws ClassNotFoundException, UnsupportedLookAndFeelException, IllegalAccessException, InstantiationException, IOException, FontFormatException {
        final JFrame frame = new JFrame("Non-Linear Book Builder");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                if (NLBBMain.this.m_nlbFacade.hasChanges()) {
                    Object[] ObjButtons = new String[]{"No", "Yes"};
                    int PromptResult = JOptionPane.showOptionDialog(frame, "There are unsaved changes. Are you sure you want to exit?", "Non-Linear Book Builder", -1, 2, null, ObjButtons, ObjButtons[0]);
                    if (PromptResult == 1) {
                        System.exit(0);
                    }
                } else {
                    System.exit(0);
                }
            }
        });
        this.m_nlbFacade.createNewBook();
        MainFrame mf = new MainFrame(this.m_nlbFacade, this.m_launcher);
        Container container = frame.getContentPane();
        JComponent component = mf.$$$getRootComponent$$$();
        container.add(component);
        JMenuBar menuBar = NLBBMain.createMenuBar();
        mf.serrext();
        Settings settings = PropertyManager.getSettings();
        if (settings.getDefaultConfig().getGeneral().isSetLookAndFeel()) {
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!settings.getDefaultConfig().getGeneral().getLookAndFeel().equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NLBBMain.setUIFont(this.loadFont());
        SwingUtilities.updateComponentTreeUI(component);
        SwingUtilities.updateComponentTreeUI(menuBar);
        frame.pack();
        frame.setVisible(true);
    }

    private Font loadFont() throws IOException, FontFormatException {
        File fontFile = new File("fonts/ttf/dejavu/DejaVuSans.ttf");
        Font customFont = Font.createFont(0, fontFile).deriveFont(12.0f);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ge.registerFont(Font.createFont(0, fontFile));
        return customFont;
    }

    private static void setUIFont(Font font) {
        FontUIResource f = new FontUIResource(font);
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
        UIManager.getLookAndFeelDefaults().put("defaultFont", font);
    }

    private static JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(new JMenuItem("New    CTRL+N"));
        menuBar.add(file);
        return menuBar;
    }

    @Override
    public void run() {
        try {
            PropertyManager.init();
            this.createAndShowGUI();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NLBJAXBException e) {
            e.printStackTrace();
        }
    }
}

