/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.form;

import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.builder.form.DialogModifications;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import com.nlbhub.nlb.util.MultiLangString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DialogLinkProperties
extends JDialog
implements NLBObserver {
    private final String m_observerId;
    private Link m_link;
    private NonLinearBookFacade m_nlbFacade;
    private Variable m_variable;
    private Variable m_constraint;
    private MultiLangString m_linkTexts;
    private MultiLangString m_altTexts;
    private String m_selectedLanguage;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField m_linkIdTextField;
    private JTextField m_linkTextTextField;
    private JButton m_linkColorButton;
    private JTextField m_linkConstraintsTextField;
    private JTextField m_linkVariableTextField;
    private JButton m_modificationsButton;
    private JButton m_undoButton;
    private JButton m_redoButton;
    private JCheckBox m_autoCheckBox;
    private JComboBox m_languageComboBox;
    private JTabbedPane m_tabbedPane1;
    private JCheckBox m_onceCheckBox;
    private JTextField m_altTextTextField;

    public DialogLinkProperties(final NonLinearBookFacade nlbFacade, final Link link) {
        this.$$$setupUI$$$();
        this.m_nlbFacade = nlbFacade;
        this.setLinkProperties(link);
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.setTitle("Link properties");
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogLinkProperties.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogLinkProperties.this.onCancel();
            }
        });
        this.m_modificationsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogModifications dialog = new DialogModifications(DialogLinkProperties.this.m_nlbFacade, (ModifyingItem)link);
                dialog.showDialog();
            }
        });
        this.m_undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nlbFacade.undo(link.getId());
                DialogLinkProperties.this.setLinkProperties(link);
            }
        });
        this.m_redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nlbFacade.redo(link.getId());
                DialogLinkProperties.this.setLinkProperties(link);
            }
        });
        this.m_languageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                DialogLinkProperties.this.refreshTextsForCurrentLanguage();
                String selectedLanguage = (String)cb.getSelectedItem();
                DialogLinkProperties.this.m_linkTextTextField.setText(DialogLinkProperties.this.m_linkTexts.get(selectedLanguage));
                DialogLinkProperties.this.m_altTextTextField.setText(DialogLinkProperties.this.m_altTexts.get(selectedLanguage));
                DialogLinkProperties.this.m_selectedLanguage = selectedLanguage;
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogLinkProperties.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogLinkProperties.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.m_observerId = nlbFacade.addObserver((NLBObserver)this);
    }

    private void refreshTextsForCurrentLanguage() {
        this.m_linkTexts.put(this.m_selectedLanguage, this.m_linkTextTextField.getText());
        this.m_altTexts.put(this.m_selectedLanguage, this.m_altTextTextField.getText());
    }

    public void showDialog() {
        this.pack();
        this.updateView();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogLinkProperties.this.buttonOK.requestFocusInWindow();
            }
        });
        this.setVisible(true);
    }

    private void setLinkProperties(Link link) {
        this.m_link = link;
        this.m_variable = this.m_nlbFacade.getNlb().getVariableById(link.getVarId());
        this.m_constraint = this.m_nlbFacade.getNlb().getVariableById(link.getConstrId());
        this.m_linkIdTextField.setText(link.getId());
        this.m_linkVariableTextField.setText(this.m_variable != null ? this.m_variable.getName() : "");
        this.m_linkTextTextField.setText(link.getText());
        this.m_altTextTextField.setText(link.getAltText());
        this.m_autoCheckBox.setSelected(link.isAuto());
        this.m_onceCheckBox.setSelected(link.isOnce());
        this.m_linkConstraintsTextField.setText(this.m_constraint != null ? this.m_constraint.getValue() : "");
        DefaultComboBoxModel<String> languageComboboxModel = new DefaultComboBoxModel<String>();
        languageComboboxModel.addElement("ru");
        languageComboboxModel.addElement("en");
        this.m_languageComboBox.setModel(languageComboboxModel);
        this.m_languageComboBox.setSelectedIndex(link.getCurrentNLB().getLanguage().equals("ru") ? 0 : 1);
        this.m_linkTexts = link.getTexts();
        this.m_altTexts = link.getAltTexts();
        this.m_selectedLanguage = (String)languageComboboxModel.getSelectedItem();
    }

    private void onOK() {
        this.refreshTextsForCurrentLanguage();
        this.m_nlbFacade.updateLink(this.m_link, this.m_linkVariableTextField.getText(), this.m_linkConstraintsTextField.getText(), this.m_linkTexts, this.m_altTexts, this.m_autoCheckBox.isSelected(), this.m_onceCheckBox.isSelected());
        this.m_nlbFacade.removeObserver(this.m_observerId);
        this.dispose();
    }

    private void onCancel() {
        this.m_nlbFacade.redoAll(this.m_link.getId());
        this.m_nlbFacade.removeObserver(this.m_observerId);
        this.dispose();
    }

    public void updateView() {
        this.m_undoButton.setEnabled(this.m_nlbFacade.canUndo(this.m_link.getId()));
        this.m_redoButton.setEnabled(this.m_nlbFacade.canRedo(this.m_link.getId()));
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel1, "Center");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel2, "North");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout(0, 0));
        panel2.add((Component)panel3, "Center");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel4, "East");
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridBagLayout());
        panel4.add((Component)panel5, "North");
        JPanel panel6 = new JPanel();
        panel6.setLayout(new FlowLayout(1, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel5.add((Component)panel6, gbc);
        this.buttonOK = new JButton();
        this.buttonOK.setPreferredSize(new Dimension(75, 25));
        this.buttonOK.setText("OK");
        panel6.add(this.buttonOK);
        JPanel panel7 = new JPanel();
        panel7.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        panel5.add((Component)panel7, gbc);
        this.buttonCancel = new JButton();
        this.buttonCancel.setPreferredSize(new Dimension(77, 25));
        this.buttonCancel.setText("Cancel");
        panel7.add(this.buttonCancel);
        JPanel panel8 = new JPanel();
        panel8.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel8, "Center");
        JPanel panel9 = new JPanel();
        panel9.setLayout(new BorderLayout(0, 0));
        panel8.add((Component)panel9, "Center");
        this.m_tabbedPane1 = new JTabbedPane();
        panel9.add((Component)this.m_tabbedPane1, "Center");
        JPanel panel10 = new JPanel();
        panel10.setLayout(new GridBagLayout());
        this.m_tabbedPane1.addTab("Text", panel10);
        JPanel panel11 = new JPanel();
        panel11.setLayout(new GridBagLayout());
        panel11.setMinimumSize(new Dimension(468, 33));
        panel11.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel11, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setHorizontalScrollBarPolicy(31);
        scrollPane1.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel11.add((Component)scrollPane1, gbc);
        this.m_linkTextTextField = new JTextField();
        this.m_linkTextTextField.setColumns(40);
        scrollPane1.setViewportView(this.m_linkTextTextField);
        JLabel label1 = new JLabel();
        label1.setFont(new Font(label1.getFont().getName(), label1.getFont().getStyle(), label1.getFont().getSize()));
        label1.setText("Link text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel10.add((Component)label1, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel10.add((Component)spacer1, gbc);
        JPanel panel12 = new JPanel();
        panel12.setLayout(new GridBagLayout());
        panel12.setMinimumSize(new Dimension(468, 33));
        panel12.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel12, gbc);
        JScrollPane scrollPane2 = new JScrollPane();
        scrollPane2.setHorizontalScrollBarPolicy(31);
        scrollPane2.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel12.add((Component)scrollPane2, gbc);
        this.m_altTextTextField = new JTextField();
        this.m_altTextTextField.setColumns(40);
        scrollPane2.setViewportView(this.m_altTextTextField);
        JLabel label2 = new JLabel();
        label2.setFont(new Font(label2.getFont().getName(), label2.getFont().getStyle(), label2.getFont().getSize()));
        label2.setText("Alt text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        panel10.add((Component)label2, gbc);
        JPanel panel13 = new JPanel();
        panel13.setLayout(new GridBagLayout());
        this.m_tabbedPane1.addTab("Properties", panel13);
        JLabel label3 = new JLabel();
        label3.setText("Link Id");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel13.add((Component)label3, gbc);
        JPanel panel14 = new JPanel();
        panel14.setLayout(new GridBagLayout());
        panel14.setMinimumSize(new Dimension(468, 33));
        panel14.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel13.add((Component)panel14, gbc);
        JScrollPane scrollPane3 = new JScrollPane();
        scrollPane3.setHorizontalScrollBarPolicy(31);
        scrollPane3.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel14.add((Component)scrollPane3, gbc);
        this.m_linkIdTextField = new JTextField();
        this.m_linkIdTextField.setColumns(40);
        this.m_linkIdTextField.setEditable(false);
        scrollPane3.setViewportView(this.m_linkIdTextField);
        JPanel panel15 = new JPanel();
        panel15.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel13.add((Component)panel15, gbc);
        JPanel panel16 = new JPanel();
        panel16.setLayout(new FlowLayout(0, 5, 5));
        panel15.add((Component)panel16, "West");
        this.m_linkColorButton = new JButton();
        this.m_linkColorButton.setEnabled(false);
        this.m_linkColorButton.setText("Link color");
        panel16.add(this.m_linkColorButton);
        JPanel panel17 = new JPanel();
        panel17.setLayout(new FlowLayout(1, 5, 5));
        panel15.add((Component)panel17, "East");
        this.m_modificationsButton = new JButton();
        this.m_modificationsButton.setText("Modifications...");
        panel17.add(this.m_modificationsButton);
        JPanel panel18 = new JPanel();
        panel18.setLayout(new FlowLayout(0, 5, 5));
        panel15.add((Component)panel18, "Center");
        this.m_autoCheckBox = new JCheckBox();
        this.m_autoCheckBox.setText("Auto");
        panel18.add(this.m_autoCheckBox);
        this.m_onceCheckBox = new JCheckBox();
        this.m_onceCheckBox.setText("Once");
        panel18.add(this.m_onceCheckBox);
        JLabel label4 = new JLabel();
        label4.setText("Link constraints");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        panel13.add((Component)label4, gbc);
        JPanel panel19 = new JPanel();
        panel19.setLayout(new GridBagLayout());
        panel19.setMinimumSize(new Dimension(468, 33));
        panel19.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel13.add((Component)panel19, gbc);
        JScrollPane scrollPane4 = new JScrollPane();
        scrollPane4.setHorizontalScrollBarPolicy(31);
        scrollPane4.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel19.add((Component)scrollPane4, gbc);
        this.m_linkConstraintsTextField = new JTextField();
        this.m_linkConstraintsTextField.setColumns(40);
        scrollPane4.setViewportView(this.m_linkConstraintsTextField);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel13.add((Component)spacer2, gbc);
        JLabel label5 = new JLabel();
        label5.setText("Link variable");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        panel13.add((Component)label5, gbc);
        JPanel panel20 = new JPanel();
        panel20.setLayout(new GridBagLayout());
        panel20.setMinimumSize(new Dimension(468, 33));
        panel20.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel13.add((Component)panel20, gbc);
        JScrollPane scrollPane5 = new JScrollPane();
        scrollPane5.setHorizontalScrollBarPolicy(31);
        scrollPane5.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel20.add((Component)scrollPane5, gbc);
        this.m_linkVariableTextField = new JTextField();
        this.m_linkVariableTextField.setColumns(40);
        scrollPane5.setViewportView(this.m_linkVariableTextField);
        JPanel panel21 = new JPanel();
        panel21.setLayout(new BorderLayout(0, 0));
        panel8.add((Component)panel21, "North");
        JToolBar toolBar1 = new JToolBar();
        toolBar1.setBorderPainted(false);
        toolBar1.setFloatable(false);
        panel21.add((Component)toolBar1, "West");
        this.m_undoButton = new JButton();
        this.m_undoButton.setIcon(new ImageIcon(this.getClass().getResource("/common/undo.png")));
        this.m_undoButton.setText("Undo");
        toolBar1.add(this.m_undoButton);
        this.m_redoButton = new JButton();
        this.m_redoButton.setIcon(new ImageIcon(this.getClass().getResource("/common/redo.png")));
        this.m_redoButton.setText("Redo");
        toolBar1.add(this.m_redoButton);
        this.m_languageComboBox = new JComboBox();
        panel21.add((Component)this.m_languageComboBox, "East");
        JPanel panel22 = new JPanel();
        panel22.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel22, "Center");
        label1.setLabelFor(this.m_linkTextTextField);
        label2.setLabelFor(this.m_altTextTextField);
        label3.setLabelFor(this.m_linkIdTextField);
        label4.setLabelFor(this.m_linkConstraintsTextField);
        label5.setLabelFor(this.m_linkVariableTextField);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

