/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.form;

import com.nlbhub.nlb.api.Modification;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.builder.model.ModificationsTableModelSwing;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class DialogModifications
extends JDialog
implements NLBObserver {
    private final String m_observerId;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JXTable m_modifications;
    private JButton m_addButton;
    private JButton m_removeButton;
    private JButton m_undoButton;
    private JButton m_redoButton;
    private JButton m_moveUpButton;
    private JButton m_moveDownButton;
    private ModificationsTableModelSwing m_modificationsTableModel;
    private ModifyingItem m_modifyingItem = null;
    private final NonLinearBookFacade m_nlbFacade;
    private static final JComboBox<String> CB_DATA_TYPE = new JComboBox<String>(){
        {
            this.addItem(Variable.DataType.AUTO.name());
            this.addItem(Variable.DataType.STRING.name());
            this.addItem(Variable.DataType.NUMBER.name());
            this.addItem(Variable.DataType.BOOLEAN.name());
        }
    };
    private static final JComboBox<String> CB_MODIFICATION_TYPE = new JComboBox<String>(){
        {
            this.addItem(Modification.Type.ASSIGN.name());
            this.addItem(Modification.Type.TAG.name());
            this.addItem(Modification.Type.GETTAG.name());
            this.addItem(Modification.Type.WHILE.name());
            this.addItem(Modification.Type.IF.name());
            this.addItem(Modification.Type.IFHAVE.name());
            this.addItem(Modification.Type.ELSE.name());
            this.addItem(Modification.Type.ELSEIF.name());
            this.addItem(Modification.Type.END.name());
            this.addItem(Modification.Type.RETURN.name());
            this.addItem(Modification.Type.HAVE.name());
            this.addItem(Modification.Type.CLONE.name());
            this.addItem(Modification.Type.CNTNR.name());
            this.addItem(Modification.Type.ID.name());
            this.addItem(Modification.Type.ADD.name());
            this.addItem(Modification.Type.ADDU.name());
            this.addItem(Modification.Type.ADDINV.name());
            this.addItem(Modification.Type.ADDALL.name());
            this.addItem(Modification.Type.ADDALLU.name());
            this.addItem(Modification.Type.REMOVE.name());
            this.addItem(Modification.Type.RMINV.name());
            this.addItem(Modification.Type.CLEAR.name());
            this.addItem(Modification.Type.CLRINV.name());
            this.addItem(Modification.Type.OBJS.name());
            this.addItem(Modification.Type.SSND.name());
            this.addItem(Modification.Type.WSND.name());
            this.addItem(Modification.Type.SND.name());
            this.addItem(Modification.Type.SPUSH.name());
            this.addItem(Modification.Type.WPUSH.name());
            this.addItem(Modification.Type.PUSH.name());
            this.addItem(Modification.Type.POP.name());
            this.addItem(Modification.Type.SINJECT.name());
            this.addItem(Modification.Type.INJECT.name());
            this.addItem(Modification.Type.EJECT.name());
            this.addItem(Modification.Type.SHUFFLE.name());
            this.addItem(Modification.Type.PRN.name());
            this.addItem(Modification.Type.DSC.name());
            this.addItem(Modification.Type.PDSC.name());
            this.addItem(Modification.Type.PDSCS.name());
            this.addItem(Modification.Type.ACT.name());
            this.addItem(Modification.Type.ACTT.name());
            this.addItem(Modification.Type.ACTF.name());
            this.addItem(Modification.Type.USE.name());
            this.addItem(Modification.Type.SIZE.name());
            this.addItem(Modification.Type.RND.name());
            this.addItem(Modification.Type.ACHMAX.name());
            this.addItem(Modification.Type.ACHIEVE.name());
            this.addItem(Modification.Type.ACHIEVED.name());
            this.addItem(Modification.Type.GOTO.name());
            this.addItem(Modification.Type.SNAPSHOT.name());
            this.addItem(Modification.Type.OPENURL.name());
            this.addItem(Modification.Type.WINGEOM.name());
            this.addItem(Modification.Type.INVGEOM.name());
            this.addItem(Modification.Type.WINCOLOR.name());
            this.addItem(Modification.Type.INVCOLOR.name());
        }
    };

    public DialogModifications(final NonLinearBookFacade nlbFacade, final ModifyingItem modifyingItem) {
        this.$$$setupUI$$$();
        this.m_nlbFacade = nlbFacade;
        this.setModifyingItemProperties(modifyingItem);
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.setTitle("Modifications");
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogModifications.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogModifications.this.onCancel();
            }
        });
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogModifications.this.onAdd();
            }
        });
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogModifications.this.onRemove();
            }
        });
        this.m_moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogModifications.this.onMoveUpSelectedLink();
                DialogModifications.this.m_modifications.updateUI();
            }
        });
        this.m_moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogModifications.this.onMoveDownSelectedLink();
                DialogModifications.this.m_modifications.updateUI();
            }
        });
        this.m_undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nlbFacade.undo(modifyingItem.getId() + "_m");
                DialogModifications.this.setModifyingItemProperties(modifyingItem);
            }
        });
        this.m_redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nlbFacade.redo(modifyingItem.getId() + "_m");
                DialogModifications.this.setModifyingItemProperties(modifyingItem);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogModifications.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogModifications.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.m_observerId = nlbFacade.addObserver((NLBObserver)this);
    }

    private void onMoveUpSelectedLink() {
        ModificationsTableModelSwing model = (ModificationsTableModelSwing)this.m_modifications.getModel();
        int selectedRow = this.m_modifications.getSelectedRow();
        if (selectedRow > 0) {
            model.moveUp(selectedRow);
            this.m_modifications.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
        }
    }

    private void onMoveDownSelectedLink() {
        ModificationsTableModelSwing model = (ModificationsTableModelSwing)this.m_modifications.getModel();
        int selectedRow = this.m_modifications.getSelectedRow();
        if (selectedRow < this.m_modifications.getRowCount() - 1) {
            model.moveDown(selectedRow);
            this.m_modifications.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
        }
    }

    public void showDialog() {
        this.pack();
        this.updateView();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogModifications.this.buttonOK.requestFocusInWindow();
            }
        });
        this.setVisible(true);
    }

    private void setModifyingItemProperties(ModifyingItem modifyingItem) {
        this.m_modifyingItem = modifyingItem;
        this.m_modificationsTableModel = new ModificationsTableModelSwing(this.m_nlbFacade.getNlb(), modifyingItem.getModifications());
        this.m_modifications.setModel((TableModel)this.m_modificationsTableModel);
        TableColumnExt extColumn = this.m_modifications.getColumnExt(0);
        extColumn.setCellEditor((TableCellEditor)new DefaultCellEditor(new JCheckBox()));
        TableColumnExt dataTypeColumn = this.m_modifications.getColumnExt(2);
        dataTypeColumn.setCellEditor((TableCellEditor)new DefaultCellEditor(CB_DATA_TYPE));
        TableColumnExt typeColumn = this.m_modifications.getColumnExt(4);
        typeColumn.setCellEditor((TableCellEditor)new DefaultCellEditor(CB_MODIFICATION_TYPE));
    }

    private void onRemove() {
        this.m_modificationsTableModel.remove(this.m_modificationsTableModel.getModificationIdsAt(this.m_modifications.getSelectedRows()));
        this.m_modifications.clearSelection();
        this.m_modifications.updateUI();
    }

    private void onAdd() {
        this.m_modificationsTableModel.add(this.m_modifyingItem);
        this.m_modifications.updateUI();
    }

    private void onOK() {
        this.m_nlbFacade.updateModifications(this.m_modifyingItem, this.m_modificationsTableModel.getTableModel());
        this.dispose();
    }

    private void onCancel() {
        this.m_nlbFacade.redoAll(this.m_modifyingItem.getId() + "_m");
        this.m_nlbFacade.removeObserver(this.m_observerId);
        this.dispose();
    }

    public void updateView() {
        this.m_undoButton.setEnabled(this.m_nlbFacade.canUndo(this.m_modifyingItem.getId() + "_m"));
        this.m_redoButton.setEnabled(this.m_nlbFacade.canRedo(this.m_modifyingItem.getId() + "_m"));
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel1, "Center");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel2, "Center");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout(0, 0));
        panel2.add((Component)panel3, "Center");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel4, "East");
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridBagLayout());
        panel4.add((Component)panel5, "North");
        JPanel panel6 = new JPanel();
        panel6.setLayout(new FlowLayout(1, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel5.add((Component)panel6, gbc);
        this.buttonOK = new JButton();
        this.buttonOK.setMaximumSize(new Dimension(95, 25));
        this.buttonOK.setMinimumSize(new Dimension(95, 25));
        this.buttonOK.setPreferredSize(new Dimension(95, 25));
        this.buttonOK.setText("OK");
        panel6.add(this.buttonOK);
        JPanel panel7 = new JPanel();
        panel7.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        panel5.add((Component)panel7, gbc);
        this.buttonCancel = new JButton();
        this.buttonCancel.setMaximumSize(new Dimension(95, 25));
        this.buttonCancel.setMinimumSize(new Dimension(95, 25));
        this.buttonCancel.setPreferredSize(new Dimension(95, 25));
        this.buttonCancel.setText("Cancel");
        panel7.add(this.buttonCancel);
        JPanel panel8 = new JPanel();
        panel8.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        panel5.add((Component)panel8, gbc);
        this.m_addButton = new JButton();
        this.m_addButton.setMaximumSize(new Dimension(95, 25));
        this.m_addButton.setMinimumSize(new Dimension(95, 25));
        this.m_addButton.setPreferredSize(new Dimension(95, 25));
        this.m_addButton.setText("Add");
        panel8.add(this.m_addButton);
        JPanel panel9 = new JPanel();
        panel9.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 1;
        panel5.add((Component)panel9, gbc);
        this.m_removeButton = new JButton();
        this.m_removeButton.setMaximumSize(new Dimension(95, 25));
        this.m_removeButton.setMinimumSize(new Dimension(95, 25));
        this.m_removeButton.setPreferredSize(new Dimension(95, 25));
        this.m_removeButton.setText("Remove");
        panel9.add(this.m_removeButton);
        JPanel panel10 = new JPanel();
        panel10.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.fill = 1;
        panel5.add((Component)panel10, gbc);
        this.m_moveUpButton = new JButton();
        this.m_moveUpButton.setMaximumSize(new Dimension(95, 25));
        this.m_moveUpButton.setMinimumSize(new Dimension(95, 25));
        this.m_moveUpButton.setPreferredSize(new Dimension(95, 25));
        this.m_moveUpButton.setText("Move up");
        panel10.add(this.m_moveUpButton);
        JPanel panel11 = new JPanel();
        panel11.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.fill = 1;
        panel5.add((Component)panel11, gbc);
        this.m_moveDownButton = new JButton();
        this.m_moveDownButton.setMaximumSize(new Dimension(95, 25));
        this.m_moveDownButton.setMinimumSize(new Dimension(95, 25));
        this.m_moveDownButton.setPreferredSize(new Dimension(95, 25));
        this.m_moveDownButton.setText("Move down");
        panel11.add(this.m_moveDownButton);
        JPanel panel12 = new JPanel();
        panel12.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel12, "Center");
        JScrollPane scrollPane1 = new JScrollPane();
        panel12.add((Component)scrollPane1, "Center");
        this.m_modifications = new JXTable();
        this.m_modifications.setCellSelectionEnabled(true);
        this.m_modifications.setColumnSelectionAllowed(true);
        this.m_modifications.setSortable(false);
        this.m_modifications.setVisibleRowCount(5);
        this.m_modifications.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        scrollPane1.setViewportView((Component)this.m_modifications);
        JPanel panel13 = new JPanel();
        panel13.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel13, "South");
        JPanel panel14 = new JPanel();
        panel14.setLayout(new FlowLayout(0, 5, 5));
        this.contentPane.add((Component)panel14, "North");
        JLabel label1 = new JLabel();
        label1.setText("Actions");
        panel14.add(label1);
        JToolBar toolBar1 = new JToolBar();
        toolBar1.setBorderPainted(false);
        toolBar1.setFloatable(false);
        panel14.add(toolBar1);
        this.m_undoButton = new JButton();
        this.m_undoButton.setIcon(new ImageIcon(this.getClass().getResource("/common/undo.png")));
        this.m_undoButton.setText("Undo");
        toolBar1.add(this.m_undoButton);
        this.m_redoButton = new JButton();
        this.m_redoButton.setIcon(new ImageIcon(this.getClass().getResource("/common/redo.png")));
        this.m_redoButton.setText("Redo");
        toolBar1.add(this.m_redoButton);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

