/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.form;

import com.nlbhub.nlb.api.MediaFile;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.builder.form.DialogLinkProperties;
import com.nlbhub.nlb.builder.form.DialogMediaLibrary;
import com.nlbhub.nlb.builder.form.DialogModifications;
import com.nlbhub.nlb.builder.form.MainFrame;
import com.nlbhub.nlb.builder.model.LinksTableModelSwing;
import com.nlbhub.nlb.builder.util.ImageHelper;
import com.nlbhub.nlb.builder.util.WheelScaleListener;
import com.nlbhub.nlb.builder.util.Zoomer;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import com.nlbhub.nlb.util.MultiLangString;
import com.nlbhub.nlb.util.StringHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXImageView;
import org.jdesktop.swingx.JXTable;

public class DialogPageProperties
extends JDialog
implements NLBObserver {
    private final String m_observerId;
    private Zoomer m_zoomer;
    private Page m_page;
    private NonLinearBookFacade m_nlbFacade;
    private MultiLangString m_pageCaptionTexts;
    private MultiLangString m_pageTexts;
    private MultiLangString m_traverseTexts;
    private MultiLangString m_returnTexts;
    private MultiLangString m_autowireInTexts;
    private MultiLangString m_autowireOutTexts;
    private String m_selectedLanguage;
    private String m_imageFileName;
    private String m_soundFileName;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField m_pageCaptionTextField;
    private JCheckBox m_useCheckBox;
    private JTextField m_pageVariableTextField;
    private JButton m_setTextColorButton;
    private JButton m_setPageColorButton;
    private JButton m_setBorderColorButton;
    private JTextArea m_pageText;
    private JButton m_moveUpButton;
    private JButton m_moveDownButton;
    private JButton m_editButton;
    private JButton m_deleteButton;
    private JTextField m_pageIdTextField;
    private JXTable m_linksTable;
    private JButton m_modificationsButton;
    private JButton m_undoButton;
    private JButton m_redoButton;
    private JTextField m_moduleNameTextField;
    private JTextField m_traverseTextTextField;
    private JTextField m_returnTextTextField;
    private JTextField m_moduleConstraintTextField;
    private JTextField m_returnPageIdTextField;
    private JCheckBox m_autoTraverseCheckBox;
    private JCheckBox m_autoReturnCheckBox;
    private JComboBox m_languageComboBox;
    private JButton m_setImageButton;
    private JLabel m_imageFileNameLabel;
    private JXImageView m_imageView;
    private JCheckBox m_autoInCheckBox;
    private JCheckBox m_autoOutCheckBox;
    private JCheckBox m_autowireCheckBox;
    private JTextField m_autowireInConstraintTextField;
    private JTextField m_autowireInTextTextField;
    private JTextField m_autowireOutTextTextField;
    private JLabel m_autowireInTextLabel;
    private JLabel m_autowireOutTextLabel;
    private JPanel m_autowireInTextPanel;
    private JPanel m_autowireOutTextPanel;
    private JLabel m_returnTextLabel;
    private JLabel m_traverseTextLabel;
    private JPanel m_returnTextPanel;
    private JPanel m_traverseTextPanel;
    private JTextField m_autowireOutConstraintTextField;
    private JButton m_setSoundButton;
    private JLabel m_soundFileNameLabel;
    private JCheckBox m_backgroundCheckBox;
    private JCheckBox m_useMPLCheckBox;
    private JTextField m_timerVariableTextField;
    private JCheckBox m_soundSFXCheckBox;
    private JButton m_buttonZoomIn;
    private JButton m_buttonZoomOut;
    private JCheckBox m_globalAutowireCheckBox;
    private JCheckBox m_animatedCheckBox;
    private JCheckBox m_externalCheckBox;
    private JTextField m_defaultTagTextField;
    private JComboBox m_themeComboBox;
    private JCheckBox m_noSaveCheckBox;
    private JCheckBox m_autosFirstCheckBox;

    public DialogPageProperties(final MainFrame mainFrame, final NonLinearBookFacade nlbFacade, final Page page) {
        this.$$$setupUI$$$();
        this.m_nlbFacade = nlbFacade;
        this.setPageProperties(page);
        this.setTitle("Page properties");
        this.setContentPane(this.contentPane);
        this.m_zoomer = new Zoomer(this.m_imageView);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPageProperties.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPageProperties.this.onCancel();
            }
        });
        this.m_editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPageProperties.this.onEditSelectedLink();
                DialogPageProperties.this.m_linksTable.updateUI();
            }
        });
        this.m_deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPageProperties.this.onDeleteSelectedLink();
                DialogPageProperties.this.m_linksTable.updateUI();
            }
        });
        this.m_moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPageProperties.this.onMoveUpSelectedLink();
                DialogPageProperties.this.m_linksTable.updateUI();
            }
        });
        this.m_moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPageProperties.this.onMoveDownSelectedLink();
                DialogPageProperties.this.m_linksTable.updateUI();
            }
        });
        this.m_modificationsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogModifications dialog = new DialogModifications(DialogPageProperties.this.m_nlbFacade, (ModifyingItem)page);
                dialog.showDialog();
            }
        });
        this.m_undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nlbFacade.undo(page.getId());
                DialogPageProperties.this.setPageProperties(page);
                DialogPageProperties.this.setPageImage(page.getImageFileName());
            }
        });
        this.m_redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nlbFacade.redo(page.getId());
                DialogPageProperties.this.setPageProperties(page);
                DialogPageProperties.this.setPageImage(page.getImageFileName());
            }
        });
        this.m_setSoundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String selectedFileName;
                DialogMediaLibrary dialog = new DialogMediaLibrary(mainFrame, DialogPageProperties.this.m_nlbFacade.getMainFacade(), MediaFile.Type.Sound, DialogPageProperties.this.m_soundFileName.split(";"));
                dialog.showDialog();
                if (!dialog.isCanceled() && (selectedFileName = dialog.getSelectedFileName()) != null) {
                    DialogPageProperties.this.m_soundFileName = selectedFileName;
                    DialogPageProperties.this.m_soundFileNameLabel.setText(DialogPageProperties.this.m_soundFileName);
                }
            }
        });
        this.m_setImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String selectedFileName;
                DialogMediaLibrary dialog = new DialogMediaLibrary(mainFrame, DialogPageProperties.this.m_nlbFacade.getMainFacade(), MediaFile.Type.Image, DialogPageProperties.this.m_imageFileName.split(";"));
                dialog.showDialog();
                if (!dialog.isCanceled() && (selectedFileName = dialog.getSelectedFileName()) != null) {
                    DialogPageProperties.this.m_imageFileName = selectedFileName;
                    DialogPageProperties.this.m_imageFileNameLabel.setText(DialogPageProperties.this.m_imageFileName);
                    DialogPageProperties.this.setPageImage(DialogPageProperties.this.m_imageFileName);
                }
            }
        });
        this.m_languageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                DialogPageProperties.this.refreshTextsForCurrentLanguage();
                String selectedLanguage = (String)cb.getSelectedItem();
                DialogPageProperties.this.m_pageCaptionTextField.setText(DialogPageProperties.this.m_pageCaptionTexts.get(selectedLanguage));
                DialogPageProperties.this.m_pageText.setText(DialogPageProperties.this.m_pageTexts.get(selectedLanguage));
                DialogPageProperties.this.m_traverseTextTextField.setText(DialogPageProperties.this.m_traverseTexts.get(selectedLanguage));
                DialogPageProperties.this.m_returnTextTextField.setText(DialogPageProperties.this.m_returnTexts.get(selectedLanguage));
                DialogPageProperties.this.m_autowireInTextTextField.setText(DialogPageProperties.this.m_autowireInTexts.get(selectedLanguage));
                DialogPageProperties.this.m_autowireOutTextTextField.setText(DialogPageProperties.this.m_autowireOutTexts.get(selectedLanguage));
                DialogPageProperties.this.m_selectedLanguage = selectedLanguage;
            }
        });
        this.m_buttonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPageProperties.this.m_zoomer.zoomIn();
            }
        });
        this.m_buttonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPageProperties.this.m_zoomer.zoomOut();
            }
        });
        this.m_imageView.addMouseWheelListener((MouseWheelListener)new WheelScaleListener(this.m_imageView));
        this.m_autowireCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DialogPageProperties.this.toggleAutowireTexts(e.getStateChange() == 1);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogPageProperties.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPageProperties.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.m_observerId = nlbFacade.addObserver((NLBObserver)this);
    }

    private void refreshTextsForCurrentLanguage() {
        this.m_pageCaptionTexts.put(this.m_selectedLanguage, this.m_pageCaptionTextField.getText());
        this.m_pageTexts.put(this.m_selectedLanguage, this.m_pageText.getText());
        this.m_traverseTexts.put(this.m_selectedLanguage, this.m_traverseTextTextField.getText());
        this.m_autowireInTexts.put(this.m_selectedLanguage, this.m_autowireInTextTextField.getText());
        this.m_autowireOutTexts.put(this.m_selectedLanguage, this.m_autowireOutTextTextField.getText());
        this.m_returnTexts.put(this.m_selectedLanguage, this.m_returnTextTextField.getText());
    }

    public void showDialog() {
        this.pack();
        this.updateView();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogPageProperties.this.setPageImage(DialogPageProperties.this.m_page.getImageFileName());
                DialogPageProperties.this.buttonOK.requestFocusInWindow();
            }
        });
        this.setVisible(true);
    }

    private void setPageProperties(Page page) {
        Theme[] possibleValues;
        this.m_page = page;
        this.m_imageFileName = page.getImageFileName();
        this.m_backgroundCheckBox.setSelected(page.isImageBackground());
        this.m_animatedCheckBox.setSelected(page.isImageAnimated());
        this.m_imageFileNameLabel.setText(this.m_imageFileName);
        this.m_soundFileName = page.getSoundFileName();
        this.m_soundSFXCheckBox.setSelected(page.isSoundSFX());
        this.m_soundFileNameLabel.setText(this.m_soundFileName);
        DefaultComboBoxModel<String> languageComboboxModel = new DefaultComboBoxModel<String>();
        languageComboboxModel.addElement("ru");
        languageComboboxModel.addElement("en");
        this.m_languageComboBox.setModel(languageComboboxModel);
        this.m_languageComboBox.setSelectedIndex(page.getCurrentNLB().getLanguage().equals("ru") ? 0 : 1);
        this.m_pageCaptionTexts = page.getCaptions();
        this.m_pageTexts = page.getTexts();
        this.m_traverseTexts = page.getTraverseTexts();
        this.m_returnTexts = page.getReturnTexts();
        this.m_selectedLanguage = (String)languageComboboxModel.getSelectedItem();
        Variable variable = this.m_nlbFacade.getNlb().getVariableById(page.getVarId());
        Variable timerVariable = this.m_nlbFacade.getNlb().getVariableById(page.getTimerVarId());
        Variable deftagVariable = this.m_nlbFacade.getNlb().getVariableById(page.getDefaultTagId());
        Variable moduleConstraint = this.m_nlbFacade.getNlb().getVariableById(page.getModuleConstrId());
        Variable autowireInConstraint = this.m_nlbFacade.getNlb().getVariableById(page.getAutowireInConstrId());
        Variable autowireOutConstraint = this.m_nlbFacade.getNlb().getVariableById(page.getAutowireOutConstrId());
        DefaultComboBoxModel<Theme> themeComboboxModel = new DefaultComboBoxModel<Theme>();
        for (Theme theme : possibleValues = (Theme[])page.getTheme().getDeclaringClass().getEnumConstants()) {
            themeComboboxModel.addElement(theme);
        }
        this.m_themeComboBox.setModel(themeComboboxModel);
        this.m_themeComboBox.setSelectedItem(page.getTheme());
        this.m_pageIdTextField.setText(page.getId());
        this.m_pageVariableTextField.setText(variable != null ? variable.getName() : "");
        this.m_timerVariableTextField.setText(timerVariable != null ? timerVariable.getName() : "");
        this.m_defaultTagTextField.setText(deftagVariable != null ? deftagVariable.getValue() : "");
        this.m_moduleConstraintTextField.setText(moduleConstraint != null ? moduleConstraint.getValue() : "");
        this.m_pageCaptionTextField.setText(this.m_page.getCaption());
        this.m_useCheckBox.setSelected(this.m_page.isUseCaption());
        this.m_useMPLCheckBox.setSelected(this.m_page.isUseMPL());
        this.m_globalAutowireCheckBox.setSelected(this.m_page.isGlobalAutowire());
        this.m_noSaveCheckBox.setSelected(this.m_page.isNoSave());
        this.m_autosFirstCheckBox.setSelected(this.m_page.isAutosFirst());
        this.m_pageText.setText(page.getText());
        this.m_moduleNameTextField.setText(page.getModuleName());
        this.m_externalCheckBox.setSelected(page.isModuleExternal());
        this.m_traverseTextTextField.setText(page.getTraverseText());
        this.m_autoTraverseCheckBox.setSelected(page.isAutoTraverse());
        this.m_autoReturnCheckBox.setSelected(page.isAutoReturn());
        this.m_returnTextTextField.setText(page.getReturnText());
        this.m_returnPageIdTextField.setText(page.getReturnPageId());
        this.m_autowireInTextTextField.setText(page.getAutowireInText());
        this.m_autowireOutTextTextField.setText(page.getAutowireOutText());
        this.m_linksTable.setModel((TableModel)new LinksTableModelSwing(this.m_page.getLinks()));
        this.m_autowireCheckBox.setSelected(page.isAutowire());
        this.m_autowireInTexts = page.getAutowireInTexts();
        this.m_autowireOutTexts = page.getAutowireOutTexts();
        this.m_autoInCheckBox.setSelected(page.isAutoIn());
        this.m_autoOutCheckBox.setSelected(page.isAutoOut());
        this.m_autowireInConstraintTextField.setText(autowireInConstraint != null ? autowireInConstraint.getValue() : "");
        this.m_autowireOutConstraintTextField.setText(autowireOutConstraint != null ? autowireOutConstraint.getValue() : "");
        this.toggleModuleTraversalTexts(!page.getModule().isEmpty());
        this.toggleAutowireTexts(page.isAutowire());
    }

    private void toggleModuleTraversalTexts(boolean visible) {
        this.m_traverseTextLabel.setVisible(visible);
        this.m_traverseTextPanel.setVisible(visible);
    }

    private void toggleAutowireTexts(boolean visible) {
        this.m_autowireInTextLabel.setVisible(visible);
        this.m_autowireInTextPanel.setVisible(visible);
        this.m_autowireOutTextLabel.setVisible(visible);
        this.m_autowireOutTextPanel.setVisible(visible);
    }

    private void setPageImage(String imageFileName) {
        try {
            if (StringHelper.isEmpty((String)this.m_imageFileName)) {
                this.m_imageView.setVisible(false);
            } else {
                File file = new File(this.m_nlbFacade.getMainFacade().getNlb().getImagesDir(), imageFileName);
                if (file.exists()) {
                    this.m_imageView.setImage(file);
                    this.m_imageView.setScale(ImageHelper.getScaleToFit((JPanel)this.m_imageView, file));
                    this.m_imageView.setVisible(true);
                } else {
                    this.m_imageView.setVisible(false);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void onOK() {
        this.refreshTextsForCurrentLanguage();
        this.m_nlbFacade.updatePage(this.m_page, this.m_imageFileName, this.m_backgroundCheckBox.isSelected(), this.m_animatedCheckBox.isSelected(), this.m_soundFileName, this.m_soundSFXCheckBox.isSelected(), this.m_pageVariableTextField.getText(), this.m_timerVariableTextField.getText(), this.m_defaultTagTextField.getText(), this.m_pageTexts, this.m_pageCaptionTexts, (Theme)this.m_themeComboBox.getSelectedItem(), this.m_useCheckBox.isSelected(), this.m_useMPLCheckBox.isSelected(), this.m_moduleNameTextField.getText(), this.m_externalCheckBox.isSelected(), this.m_traverseTexts, this.m_autoTraverseCheckBox.isSelected(), this.m_autoReturnCheckBox.isSelected(), this.m_returnTexts, this.m_returnPageIdTextField.getText(), this.m_moduleConstraintTextField.getText(), this.m_autowireCheckBox.isSelected(), this.m_autowireInTexts, this.m_autowireOutTexts, this.m_autoInCheckBox.isSelected(), this.m_autoOutCheckBox.isSelected(), this.m_autowireInConstraintTextField.getText(), this.m_autowireOutConstraintTextField.getText(), this.m_globalAutowireCheckBox.isSelected(), this.m_noSaveCheckBox.isSelected(), this.m_autosFirstCheckBox.isSelected(), ((LinksTableModelSwing)this.m_linksTable.getModel()).getTableModel());
        this.m_nlbFacade.removeObserver(this.m_observerId);
        this.dispose();
    }

    private void onCancel() {
        this.m_nlbFacade.redoAll(this.m_page.getId());
        this.m_nlbFacade.removeObserver(this.m_observerId);
        this.dispose();
    }

    private void onEditSelectedLink() {
        LinksTableModelSwing model = (LinksTableModelSwing)this.m_linksTable.getModel();
        DialogLinkProperties dialog = new DialogLinkProperties(this.m_nlbFacade, model.getLinkAt(this.m_linksTable.getSelectedRow()));
        dialog.showDialog();
    }

    private void onDeleteSelectedLink() {
        LinksTableModelSwing model = (LinksTableModelSwing)this.m_linksTable.getModel();
        model.deleteLinkAt(this.m_linksTable.getSelectedRow());
    }

    private void onMoveUpSelectedLink() {
        LinksTableModelSwing model = (LinksTableModelSwing)this.m_linksTable.getModel();
        int selectedRow = this.m_linksTable.getSelectedRow();
        if (selectedRow > 0) {
            model.moveUp(selectedRow);
            this.m_linksTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
        }
    }

    private void onMoveDownSelectedLink() {
        LinksTableModelSwing model = (LinksTableModelSwing)this.m_linksTable.getModel();
        int selectedRow = this.m_linksTable.getSelectedRow();
        if (selectedRow < this.m_linksTable.getRowCount() - 1) {
            model.moveDown(selectedRow);
            this.m_linksTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
        }
    }

    public void updateView() {
        this.m_undoButton.setEnabled(this.m_nlbFacade.canUndo(this.m_page.getId()));
        this.m_redoButton.setEnabled(this.m_nlbFacade.canRedo(this.m_page.getId()));
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel1, "Center");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel2, "South");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout(0, 0));
        panel2.add((Component)panel3, "Center");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel4, "East");
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridBagLayout());
        panel4.add((Component)panel5, "North");
        JPanel panel6 = new JPanel();
        panel6.setLayout(new FlowLayout(1, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel5.add((Component)panel6, gbc);
        this.buttonOK = new JButton();
        this.buttonOK.setMaximumSize(new Dimension(75, 25));
        this.buttonOK.setMinimumSize(new Dimension(75, 25));
        this.buttonOK.setPreferredSize(new Dimension(75, 25));
        this.buttonOK.setText("OK");
        panel6.add(this.buttonOK);
        JPanel panel7 = new JPanel();
        panel7.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        panel5.add((Component)panel7, gbc);
        this.buttonCancel = new JButton();
        this.buttonCancel.setMaximumSize(new Dimension(77, 25));
        this.buttonCancel.setMinimumSize(new Dimension(77, 25));
        this.buttonCancel.setPreferredSize(new Dimension(77, 25));
        this.buttonCancel.setText("Cancel");
        panel7.add(this.buttonCancel);
        JPanel panel8 = new JPanel();
        panel8.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel8, "Center");
        JTabbedPane tabbedPane1 = new JTabbedPane();
        panel8.add((Component)tabbedPane1, "Center");
        JPanel panel9 = new JPanel();
        panel9.setLayout(new BorderLayout(0, 0));
        tabbedPane1.addTab("Additional Text", panel9);
        JPanel panel10 = new JPanel();
        panel10.setLayout(new GridBagLayout());
        panel9.add((Component)panel10, "Center");
        this.m_traverseTextLabel = new JLabel();
        this.m_traverseTextLabel.setText("Traverse text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        panel10.add((Component)this.m_traverseTextLabel, gbc);
        JLabel label1 = new JLabel();
        label1.setText("Page caption");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel10.add((Component)label1, gbc);
        JPanel panel11 = new JPanel();
        panel11.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel10.add((Component)panel11, gbc);
        this.m_useCheckBox = new JCheckBox();
        this.m_useCheckBox.setHorizontalAlignment(2);
        this.m_useCheckBox.setText("Use");
        panel11.add((Component)this.m_useCheckBox, "Center");
        JPanel panel12 = new JPanel();
        panel12.setLayout(new GridBagLayout());
        panel12.setMinimumSize(new Dimension(143, 33));
        panel12.setPreferredSize(new Dimension(605, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel12, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setHorizontalScrollBarPolicy(31);
        scrollPane1.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel12.add((Component)scrollPane1, gbc);
        this.m_pageCaptionTextField = new JTextField();
        this.m_pageCaptionTextField.setColumns(32);
        this.m_pageCaptionTextField.setFocusAccelerator('C');
        this.m_pageCaptionTextField.setHorizontalAlignment(10);
        scrollPane1.setViewportView(this.m_pageCaptionTextField);
        this.m_traverseTextPanel = new JPanel();
        this.m_traverseTextPanel.setLayout(new GridBagLayout());
        this.m_traverseTextPanel.setMinimumSize(new Dimension(56, 33));
        this.m_traverseTextPanel.setPreferredSize(new Dimension(505, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)this.m_traverseTextPanel, gbc);
        JScrollPane scrollPane2 = new JScrollPane();
        scrollPane2.setHorizontalScrollBarPolicy(31);
        scrollPane2.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.m_traverseTextPanel.add((Component)scrollPane2, gbc);
        this.m_traverseTextTextField = new JTextField();
        this.m_traverseTextTextField.setColumns(32);
        scrollPane2.setViewportView(this.m_traverseTextTextField);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel10.add((Component)spacer1, gbc);
        this.m_autowireInTextPanel = new JPanel();
        this.m_autowireInTextPanel.setLayout(new GridBagLayout());
        this.m_autowireInTextPanel.setMinimumSize(new Dimension(56, 33));
        this.m_autowireInTextPanel.setPreferredSize(new Dimension(505, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)this.m_autowireInTextPanel, gbc);
        JScrollPane scrollPane3 = new JScrollPane();
        scrollPane3.setHorizontalScrollBarPolicy(31);
        scrollPane3.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.m_autowireInTextPanel.add((Component)scrollPane3, gbc);
        this.m_autowireInTextTextField = new JTextField();
        this.m_autowireInTextTextField.setColumns(32);
        scrollPane3.setViewportView(this.m_autowireInTextTextField);
        this.m_autowireOutTextPanel = new JPanel();
        this.m_autowireOutTextPanel.setLayout(new GridBagLayout());
        this.m_autowireOutTextPanel.setMinimumSize(new Dimension(56, 33));
        this.m_autowireOutTextPanel.setPreferredSize(new Dimension(505, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)this.m_autowireOutTextPanel, gbc);
        JScrollPane scrollPane4 = new JScrollPane();
        scrollPane4.setHorizontalScrollBarPolicy(31);
        scrollPane4.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.m_autowireOutTextPanel.add((Component)scrollPane4, gbc);
        this.m_autowireOutTextTextField = new JTextField();
        this.m_autowireOutTextTextField.setColumns(32);
        scrollPane4.setViewportView(this.m_autowireOutTextTextField);
        this.m_autowireInTextLabel = new JLabel();
        this.m_autowireInTextLabel.setText("Autowire in text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 13;
        panel10.add((Component)this.m_autowireInTextLabel, gbc);
        this.m_autowireOutTextLabel = new JLabel();
        this.m_autowireOutTextLabel.setText("Autowire out text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 13;
        panel10.add((Component)this.m_autowireOutTextLabel, gbc);
        this.m_returnTextPanel = new JPanel();
        this.m_returnTextPanel.setLayout(new GridBagLayout());
        this.m_returnTextPanel.setMinimumSize(new Dimension(56, 33));
        this.m_returnTextPanel.setPreferredSize(new Dimension(505, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)this.m_returnTextPanel, gbc);
        JScrollPane scrollPane5 = new JScrollPane();
        scrollPane5.setHorizontalScrollBarPolicy(31);
        scrollPane5.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.m_returnTextPanel.add((Component)scrollPane5, gbc);
        this.m_returnTextTextField = new JTextField();
        this.m_returnTextTextField.setColumns(32);
        scrollPane5.setViewportView(this.m_returnTextTextField);
        this.m_returnTextLabel = new JLabel();
        this.m_returnTextLabel.setText("Return text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        panel10.add((Component)this.m_returnTextLabel, gbc);
        JPanel panel13 = new JPanel();
        panel13.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 1;
        panel10.add((Component)panel13, gbc);
        this.m_useMPLCheckBox = new JCheckBox();
        this.m_useMPLCheckBox.setText("Use MPL");
        panel13.add((Component)this.m_useMPLCheckBox, "Center");
        JPanel panel14 = new JPanel();
        panel14.setLayout(new BorderLayout(0, 0));
        tabbedPane1.addTab("Properties", panel14);
        JPanel panel15 = new JPanel();
        panel15.setLayout(new BorderLayout(0, 0));
        panel14.add((Component)panel15, "Center");
        JPanel panel16 = new JPanel();
        panel16.setLayout(new GridBagLayout());
        panel15.add((Component)panel16, "Center");
        JPanel panel17 = new JPanel();
        panel17.setLayout(new GridBagLayout());
        panel17.setMinimumSize(new Dimension(143, 33));
        panel17.setPreferredSize(new Dimension(605, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel16.add((Component)panel17, gbc);
        JScrollPane scrollPane6 = new JScrollPane();
        scrollPane6.setEnabled(true);
        scrollPane6.setHorizontalScrollBarPolicy(31);
        scrollPane6.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel17.add((Component)scrollPane6, gbc);
        this.m_pageIdTextField = new JTextField();
        this.m_pageIdTextField.setEditable(false);
        this.m_pageIdTextField.setFocusAccelerator('I');
        scrollPane6.setViewportView(this.m_pageIdTextField);
        JLabel label2 = new JLabel();
        label2.setText("Page Id");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel16.add((Component)label2, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel16.add((Component)spacer2, gbc);
        JPanel panel18 = new JPanel();
        panel18.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel16.add((Component)panel18, gbc);
        JPanel panel19 = new JPanel();
        panel19.setLayout(new FlowLayout(0, 5, 5));
        panel18.add((Component)panel19, "West");
        this.m_setTextColorButton = new JButton();
        this.m_setTextColorButton.setEnabled(false);
        this.m_setTextColorButton.setText("Set text color");
        panel19.add(this.m_setTextColorButton);
        this.m_setPageColorButton = new JButton();
        this.m_setPageColorButton.setEnabled(false);
        this.m_setPageColorButton.setText("Set page color");
        panel19.add(this.m_setPageColorButton);
        this.m_setBorderColorButton = new JButton();
        this.m_setBorderColorButton.setEnabled(false);
        this.m_setBorderColorButton.setText("Set border color");
        panel19.add(this.m_setBorderColorButton);
        this.m_noSaveCheckBox = new JCheckBox();
        this.m_noSaveCheckBox.setText("No Save");
        panel19.add(this.m_noSaveCheckBox);
        this.m_autosFirstCheckBox = new JCheckBox();
        this.m_autosFirstCheckBox.setText("Autos First");
        panel19.add(this.m_autosFirstCheckBox);
        JPanel panel20 = new JPanel();
        panel20.setLayout(new GridBagLayout());
        panel20.setMinimumSize(new Dimension(56, 33));
        panel20.setPreferredSize(new Dimension(518, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel16.add((Component)panel20, gbc);
        JScrollPane scrollPane7 = new JScrollPane();
        scrollPane7.setHorizontalScrollBarPolicy(31);
        scrollPane7.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel20.add((Component)scrollPane7, gbc);
        this.m_pageVariableTextField = new JTextField();
        this.m_pageVariableTextField.setColumns(42);
        this.m_pageVariableTextField.setFocusAccelerator('V');
        scrollPane7.setViewportView(this.m_pageVariableTextField);
        JLabel label3 = new JLabel();
        label3.setHorizontalAlignment(10);
        label3.setHorizontalTextPosition(11);
        label3.setText("Page variable");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        panel16.add((Component)label3, gbc);
        JLabel label4 = new JLabel();
        label4.setHorizontalAlignment(10);
        label4.setHorizontalTextPosition(11);
        label4.setText("Timer variable");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        panel16.add((Component)label4, gbc);
        JPanel panel21 = new JPanel();
        panel21.setLayout(new GridBagLayout());
        panel21.setMinimumSize(new Dimension(56, 33));
        panel21.setPreferredSize(new Dimension(518, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel16.add((Component)panel21, gbc);
        JScrollPane scrollPane8 = new JScrollPane();
        scrollPane8.setHorizontalScrollBarPolicy(31);
        scrollPane8.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel21.add((Component)scrollPane8, gbc);
        this.m_timerVariableTextField = new JTextField();
        this.m_timerVariableTextField.setColumns(42);
        this.m_timerVariableTextField.setFocusAccelerator('V');
        scrollPane8.setViewportView(this.m_timerVariableTextField);
        JPanel panel22 = new JPanel();
        panel22.setLayout(new GridBagLayout());
        panel22.setMinimumSize(new Dimension(468, 33));
        panel22.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel16.add((Component)panel22, gbc);
        JScrollPane scrollPane9 = new JScrollPane();
        scrollPane9.setHorizontalScrollBarPolicy(31);
        scrollPane9.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel22.add((Component)scrollPane9, gbc);
        this.m_defaultTagTextField = new JTextField();
        this.m_defaultTagTextField.setColumns(40);
        scrollPane9.setViewportView(this.m_defaultTagTextField);
        JLabel label5 = new JLabel();
        label5.setText("Default tag");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 13;
        panel16.add((Component)label5, gbc);
        JPanel panel23 = new JPanel();
        panel23.setLayout(new GridBagLayout());
        panel23.setMinimumSize(new Dimension(468, 33));
        panel23.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel16.add((Component)panel23, gbc);
        JScrollPane scrollPane10 = new JScrollPane();
        scrollPane10.setHorizontalScrollBarPolicy(31);
        scrollPane10.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel23.add((Component)scrollPane10, gbc);
        this.m_themeComboBox = new JComboBox();
        scrollPane10.setViewportView(this.m_themeComboBox);
        JLabel label6 = new JLabel();
        label6.setText("Theme");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 13;
        panel16.add((Component)label6, gbc);
        JPanel panel24 = new JPanel();
        panel24.setLayout(new BorderLayout(0, 0));
        tabbedPane1.addTab("Links", panel24);
        JPanel panel25 = new JPanel();
        panel25.setLayout(new BorderLayout(0, 0));
        panel24.add((Component)panel25, "Center");
        JPanel panel26 = new JPanel();
        panel26.setLayout(new GridBagLayout());
        panel25.add((Component)panel26, "East");
        JPanel panel27 = new JPanel();
        panel27.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel26.add((Component)panel27, gbc);
        this.m_moveUpButton = new JButton();
        this.m_moveUpButton.setPreferredSize(new Dimension(98, 25));
        this.m_moveUpButton.setText("Move up");
        panel27.add(this.m_moveUpButton);
        JPanel panel28 = new JPanel();
        panel28.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        panel26.add((Component)panel28, gbc);
        this.m_moveDownButton = new JButton();
        this.m_moveDownButton.setPreferredSize(new Dimension(98, 25));
        this.m_moveDownButton.setText("Move down");
        panel28.add(this.m_moveDownButton);
        JPanel panel29 = new JPanel();
        panel29.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        panel26.add((Component)panel29, gbc);
        this.m_editButton = new JButton();
        this.m_editButton.setPreferredSize(new Dimension(98, 25));
        this.m_editButton.setText("Edit");
        panel29.add(this.m_editButton);
        JPanel panel30 = new JPanel();
        panel30.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 1;
        panel26.add((Component)panel30, gbc);
        this.m_deleteButton = new JButton();
        this.m_deleteButton.setPreferredSize(new Dimension(98, 25));
        this.m_deleteButton.setText("Delete");
        panel30.add(this.m_deleteButton);
        JPanel panel31 = new JPanel();
        panel31.setLayout(new BorderLayout(0, 0));
        panel25.add((Component)panel31, "Center");
        JScrollPane scrollPane11 = new JScrollPane();
        panel31.add((Component)scrollPane11, "Center");
        this.m_linksTable = new JXTable();
        this.m_linksTable.setSortable(false);
        this.m_linksTable.setVisibleRowCount(5);
        this.m_linksTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        scrollPane11.setViewportView((Component)this.m_linksTable);
        JPanel panel32 = new JPanel();
        panel32.setLayout(new BorderLayout(0, 0));
        tabbedPane1.addTab("Modifications", panel32);
        JPanel panel33 = new JPanel();
        panel33.setLayout(new BorderLayout(0, 0));
        panel32.add((Component)panel33, "Center");
        JPanel panel34 = new JPanel();
        panel34.setLayout(new BorderLayout(0, 0));
        panel32.add((Component)panel34, "East");
        JPanel panel35 = new JPanel();
        panel35.setLayout(new FlowLayout(1, 5, 5));
        panel34.add((Component)panel35, "Center");
        this.m_modificationsButton = new JButton();
        this.m_modificationsButton.setText("Modifications...");
        panel35.add(this.m_modificationsButton);
        JPanel panel36 = new JPanel();
        panel36.setLayout(new BorderLayout(0, 0));
        tabbedPane1.addTab("Module", panel36);
        JPanel panel37 = new JPanel();
        panel37.setLayout(new GridBagLayout());
        panel36.add((Component)panel37, "Center");
        JPanel panel38 = new JPanel();
        panel38.setLayout(new GridBagLayout());
        panel38.setMinimumSize(new Dimension(56, 33));
        panel38.setPreferredSize(new Dimension(505, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel37.add((Component)panel38, gbc);
        JScrollPane scrollPane12 = new JScrollPane();
        scrollPane12.setHorizontalScrollBarPolicy(31);
        scrollPane12.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel38.add((Component)scrollPane12, gbc);
        this.m_returnPageIdTextField = new JTextField();
        this.m_returnPageIdTextField.setColumns(42);
        scrollPane12.setViewportView(this.m_returnPageIdTextField);
        JLabel label7 = new JLabel();
        label7.setText("Return page Id");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        panel37.add((Component)label7, gbc);
        JPanel spacer3 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel37.add((Component)spacer3, gbc);
        JPanel panel39 = new JPanel();
        panel39.setLayout(new GridBagLayout());
        panel39.setMinimumSize(new Dimension(56, 33));
        panel39.setPreferredSize(new Dimension(505, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel37.add((Component)panel39, gbc);
        JScrollPane scrollPane13 = new JScrollPane();
        scrollPane13.setHorizontalScrollBarPolicy(31);
        scrollPane13.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel39.add((Component)scrollPane13, gbc);
        this.m_moduleNameTextField = new JTextField();
        this.m_moduleNameTextField.setColumns(42);
        scrollPane13.setViewportView(this.m_moduleNameTextField);
        JLabel label8 = new JLabel();
        label8.setHorizontalTextPosition(11);
        label8.setText("Module name");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel37.add((Component)label8, gbc);
        JPanel panel40 = new JPanel();
        panel40.setLayout(new GridBagLayout());
        panel40.setMinimumSize(new Dimension(56, 33));
        panel40.setPreferredSize(new Dimension(505, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel37.add((Component)panel40, gbc);
        JScrollPane scrollPane14 = new JScrollPane();
        scrollPane14.setHorizontalScrollBarPolicy(31);
        scrollPane14.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel40.add((Component)scrollPane14, gbc);
        this.m_moduleConstraintTextField = new JTextField();
        this.m_moduleConstraintTextField.setColumns(42);
        scrollPane14.setViewportView(this.m_moduleConstraintTextField);
        JLabel label9 = new JLabel();
        label9.setText("Module constraint");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        panel37.add((Component)label9, gbc);
        JPanel panel41 = new JPanel();
        panel41.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 1;
        panel37.add((Component)panel41, gbc);
        JPanel panel42 = new JPanel();
        panel42.setLayout(new FlowLayout(0, 5, 5));
        panel41.add((Component)panel42, "Center");
        this.m_autoTraverseCheckBox = new JCheckBox();
        this.m_autoTraverseCheckBox.setText("Auto Traverse");
        panel42.add(this.m_autoTraverseCheckBox);
        this.m_autoReturnCheckBox = new JCheckBox();
        this.m_autoReturnCheckBox.setText("Auto Return");
        panel42.add(this.m_autoReturnCheckBox);
        this.m_externalCheckBox = new JCheckBox();
        this.m_externalCheckBox.setText("External");
        panel42.add(this.m_externalCheckBox);
        JPanel panel43 = new JPanel();
        panel43.setLayout(new BorderLayout(0, 0));
        tabbedPane1.addTab("Autowire", panel43);
        JPanel panel44 = new JPanel();
        panel44.setLayout(new GridBagLayout());
        panel43.add((Component)panel44, "Center");
        JPanel spacer4 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel44.add((Component)spacer4, gbc);
        JPanel panel45 = new JPanel();
        panel45.setLayout(new GridBagLayout());
        panel45.setMinimumSize(new Dimension(56, 33));
        panel45.setPreferredSize(new Dimension(505, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel44.add((Component)panel45, gbc);
        JScrollPane scrollPane15 = new JScrollPane();
        scrollPane15.setHorizontalScrollBarPolicy(31);
        scrollPane15.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel45.add((Component)scrollPane15, gbc);
        this.m_autowireInConstraintTextField = new JTextField();
        this.m_autowireInConstraintTextField.setColumns(42);
        scrollPane15.setViewportView(this.m_autowireInConstraintTextField);
        JLabel label10 = new JLabel();
        label10.setHorizontalTextPosition(11);
        label10.setText("Autowire in constraint");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        panel44.add((Component)label10, gbc);
        JPanel panel46 = new JPanel();
        panel46.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 1;
        panel44.add((Component)panel46, gbc);
        JPanel panel47 = new JPanel();
        panel47.setLayout(new FlowLayout(0, 5, 5));
        panel46.add((Component)panel47, "Center");
        this.m_autoInCheckBox = new JCheckBox();
        this.m_autoInCheckBox.setText("Auto In");
        panel47.add(this.m_autoInCheckBox);
        this.m_autoOutCheckBox = new JCheckBox();
        this.m_autoOutCheckBox.setText("Auto Out");
        panel47.add(this.m_autoOutCheckBox);
        JPanel panel48 = new JPanel();
        panel48.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel44.add((Component)panel48, gbc);
        JPanel panel49 = new JPanel();
        panel49.setLayout(new FlowLayout(0, 5, 5));
        panel48.add((Component)panel49, "Center");
        this.m_autowireCheckBox = new JCheckBox();
        this.m_autowireCheckBox.setText("Autowire");
        panel49.add(this.m_autowireCheckBox);
        this.m_globalAutowireCheckBox = new JCheckBox();
        this.m_globalAutowireCheckBox.setText("Global Autowire");
        panel49.add(this.m_globalAutowireCheckBox);
        JPanel panel50 = new JPanel();
        panel50.setLayout(new GridBagLayout());
        panel50.setMinimumSize(new Dimension(56, 33));
        panel50.setPreferredSize(new Dimension(505, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel44.add((Component)panel50, gbc);
        JScrollPane scrollPane16 = new JScrollPane();
        scrollPane16.setHorizontalScrollBarPolicy(31);
        scrollPane16.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel50.add((Component)scrollPane16, gbc);
        this.m_autowireOutConstraintTextField = new JTextField();
        this.m_autowireOutConstraintTextField.setColumns(42);
        scrollPane16.setViewportView(this.m_autowireOutConstraintTextField);
        JLabel label11 = new JLabel();
        label11.setHorizontalTextPosition(11);
        label11.setText("Autowire out constraint");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        panel44.add((Component)label11, gbc);
        JPanel panel51 = new JPanel();
        panel51.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel51, "Center");
        JPanel panel52 = new JPanel();
        panel52.setLayout(new BorderLayout(0, 0));
        panel51.add((Component)panel52, "Center");
        JPanel panel53 = new JPanel();
        panel53.setLayout(new BorderLayout(0, 0));
        panel52.add((Component)panel53, "Center");
        JPanel panel54 = new JPanel();
        panel54.setLayout(new BorderLayout(0, 0));
        panel53.add((Component)panel54, "Center");
        JPanel panel55 = new JPanel();
        panel55.setLayout(new GridBagLayout());
        panel55.setMinimumSize(new Dimension(10, 250));
        panel54.add((Component)panel55, "Center");
        panel55.setBorder(BorderFactory.createTitledBorder("Page text"));
        JScrollPane scrollPane17 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel55.add((Component)scrollPane17, gbc);
        this.m_pageText = new JTextArea();
        this.m_pageText.setColumns(50);
        this.m_pageText.setFocusAccelerator('T');
        this.m_pageText.setLineWrap(true);
        this.m_pageText.setRows(10);
        this.m_pageText.setWrapStyleWord(true);
        scrollPane17.setViewportView(this.m_pageText);
        JPanel panel56 = new JPanel();
        panel56.setLayout(new BorderLayout(0, 0));
        panel54.add((Component)panel56, "East");
        JPanel panel57 = new JPanel();
        panel57.setLayout(new BorderLayout(0, 0));
        panel56.add((Component)panel57, "Center");
        JPanel panel58 = new JPanel();
        panel58.setLayout(new FlowLayout(1, 5, 5));
        panel57.add((Component)panel58, "North");
        this.m_setImageButton = new JButton();
        this.m_setImageButton.setMaximumSize(new Dimension(120, 36));
        this.m_setImageButton.setMinimumSize(new Dimension(120, 36));
        this.m_setImageButton.setPreferredSize(new Dimension(120, 36));
        this.m_setImageButton.setText("Set image...");
        panel58.add(this.m_setImageButton);
        JPanel panel59 = new JPanel();
        panel59.setLayout(new BorderLayout(0, 0));
        panel57.add((Component)panel59, "Center");
        JPanel panel60 = new JPanel();
        panel60.setLayout(new BorderLayout(0, 0));
        panel59.add((Component)panel60, "North");
        this.m_imageFileNameLabel = new JLabel();
        this.m_imageFileNameLabel.setHorizontalAlignment(0);
        this.m_imageFileNameLabel.setHorizontalTextPosition(0);
        this.m_imageFileNameLabel.setText("<NO IMAGE>");
        panel60.add((Component)this.m_imageFileNameLabel, "Center");
        JPanel panel61 = new JPanel();
        panel61.setLayout(new FlowLayout(1, 5, 5));
        panel60.add((Component)panel61, "South");
        this.m_buttonZoomIn = new JButton();
        this.m_buttonZoomIn.setText("+");
        panel61.add(this.m_buttonZoomIn);
        this.m_buttonZoomOut = new JButton();
        this.m_buttonZoomOut.setText("\u2015");
        panel61.add(this.m_buttonZoomOut);
        JPanel panel62 = new JPanel();
        panel62.setLayout(new BorderLayout(0, 0));
        panel60.add((Component)panel62, "North");
        this.m_backgroundCheckBox = new JCheckBox();
        this.m_backgroundCheckBox.setText("Background");
        panel62.add((Component)this.m_backgroundCheckBox, "West");
        this.m_animatedCheckBox = new JCheckBox();
        this.m_animatedCheckBox.setText("Animated");
        panel62.add((Component)this.m_animatedCheckBox, "East");
        this.m_imageView = new JXImageView();
        panel59.add((Component)this.m_imageView, "Center");
        JPanel panel63 = new JPanel();
        panel63.setLayout(new BorderLayout(0, 0));
        panel56.add((Component)panel63, "North");
        JPanel panel64 = new JPanel();
        panel64.setLayout(new FlowLayout(1, 5, 5));
        panel63.add((Component)panel64, "North");
        this.m_setSoundButton = new JButton();
        this.m_setSoundButton.setMaximumSize(new Dimension(120, 36));
        this.m_setSoundButton.setMinimumSize(new Dimension(120, 36));
        this.m_setSoundButton.setPreferredSize(new Dimension(120, 36));
        this.m_setSoundButton.setText("Set sound...");
        panel64.add(this.m_setSoundButton);
        JPanel panel65 = new JPanel();
        panel65.setLayout(new BorderLayout(0, 0));
        panel63.add((Component)panel65, "Center");
        JPanel panel66 = new JPanel();
        panel66.setLayout(new BorderLayout(0, 0));
        panel65.add((Component)panel66, "North");
        this.m_soundFileNameLabel = new JLabel();
        this.m_soundFileNameLabel.setHorizontalAlignment(0);
        this.m_soundFileNameLabel.setHorizontalTextPosition(0);
        this.m_soundFileNameLabel.setText("<NO_SOUND>");
        panel66.add((Component)this.m_soundFileNameLabel, "Center");
        this.m_soundSFXCheckBox = new JCheckBox();
        this.m_soundSFXCheckBox.setText("SFX");
        panel66.add((Component)this.m_soundSFXCheckBox, "North");
        JPanel panel67 = new JPanel();
        panel67.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel67, "North");
        JToolBar toolBar1 = new JToolBar();
        toolBar1.setBorderPainted(false);
        toolBar1.setFloatable(false);
        panel67.add((Component)toolBar1, "Center");
        this.m_undoButton = new JButton();
        this.m_undoButton.setIcon(new ImageIcon(this.getClass().getResource("/common/undo.png")));
        this.m_undoButton.setText("Undo");
        toolBar1.add(this.m_undoButton);
        this.m_redoButton = new JButton();
        this.m_redoButton.setIcon(new ImageIcon(this.getClass().getResource("/common/redo.png")));
        this.m_redoButton.setText("Redo");
        toolBar1.add(this.m_redoButton);
        this.m_languageComboBox = new JComboBox();
        panel67.add((Component)this.m_languageComboBox, "East");
        this.m_traverseTextLabel.setLabelFor(this.m_traverseTextTextField);
        label1.setLabelFor(this.m_pageCaptionTextField);
        this.m_autowireInTextLabel.setLabelFor(this.m_autowireInTextTextField);
        this.m_autowireOutTextLabel.setLabelFor(this.m_autowireOutTextTextField);
        this.m_returnTextLabel.setLabelFor(this.m_returnTextTextField);
        label2.setLabelFor(this.m_pageIdTextField);
        label3.setLabelFor(this.m_pageVariableTextField);
        label4.setLabelFor(this.m_pageVariableTextField);
        label5.setLabelFor(this.m_defaultTagTextField);
        label6.setLabelFor(this.m_themeComboBox);
        label7.setLabelFor(this.m_returnPageIdTextField);
        label8.setLabelFor(this.m_moduleNameTextField);
        label9.setLabelFor(this.m_moduleConstraintTextField);
        label10.setLabelFor(this.m_autowireInConstraintTextField);
        label11.setLabelFor(this.m_autowireOutConstraintTextField);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

