/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.form;

import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.PropertyManager;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.api.SearchResultTableModel;
import com.nlbhub.nlb.builder.form.MainFrame;
import com.nlbhub.nlb.builder.model.SearchResultsTableModelSwing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class DialogSearch
extends JDialog {
    private NonLinearBook m_nlb;
    private String m_modulePageId;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField m_searchText;
    private JCheckBox m_pagesCheckBox;
    private JCheckBox m_ignoreCaseCheckBox;
    private JCheckBox m_wholeWordsCheckBox;
    private JCheckBox m_objectsCheckBox;
    private JCheckBox m_linksCheckBox;
    private JButton m_goToButton;
    private JXTable m_searchResultsTable;
    private JCheckBox m_variablesCheckBox;
    private JCheckBox m_idsCheckBox;
    private SearchResultsTableModelSwing m_tableModel;

    public DialogSearch(final MainFrame mainFrame, NonLinearBook nlb, String modulePageId, String searchText) {
        this.$$$setupUI$$$();
        this.m_nlb = nlb;
        this.m_modulePageId = modulePageId;
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.setTitle("Search");
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.m_searchText.setText(searchText);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSearch.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSearch.this.onCancel();
            }
        });
        this.m_goToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mainFrame.goTo((String)DialogSearch.this.m_tableModel.getValueAt(DialogSearch.this.m_searchResultsTable.getSelectedRow(), 1), (String)DialogSearch.this.m_tableModel.getValueAt(DialogSearch.this.m_searchResultsTable.getSelectedRow(), 0));
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogSearch.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSearch.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onOK() {
        SearchResultTableModel searchResultTableModel = this.m_nlb.searchText(new SearchContract(this.m_searchText.getText(), this.m_idsCheckBox.isSelected(), this.m_pagesCheckBox.isSelected(), this.m_objectsCheckBox.isSelected(), this.m_linksCheckBox.isSelected(), this.m_variablesCheckBox.isSelected(), this.m_ignoreCaseCheckBox.isSelected(), this.m_wholeWordsCheckBox.isSelected(), PropertyManager.getSettings().getDefaultConfig().getGeneral().isFindUnusualQuotes()), this.m_modulePageId);
        this.m_tableModel = new SearchResultsTableModelSwing(searchResultTableModel);
        this.m_searchResultsTable.setModel((TableModel)this.m_tableModel);
    }

    private void onCancel() {
        this.dispose();
    }

    public void showDialog() {
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogSearch.this.buttonOK.requestFocusInWindow();
            }
        });
        this.setVisible(true);
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel1, "Center");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel2, "North");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout(0, 0));
        panel2.add((Component)panel3, "Center");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel4, "East");
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridBagLayout());
        panel4.add((Component)panel5, "North");
        JPanel panel6 = new JPanel();
        panel6.setLayout(new FlowLayout(1, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel5.add((Component)panel6, gbc);
        this.buttonOK = new JButton();
        this.buttonOK.setPreferredSize(new Dimension(95, 25));
        this.buttonOK.setText("Search...");
        panel6.add(this.buttonOK);
        JPanel panel7 = new JPanel();
        panel7.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        panel5.add((Component)panel7, gbc);
        this.buttonCancel = new JButton();
        this.buttonCancel.setPreferredSize(new Dimension(95, 25));
        this.buttonCancel.setText("Close");
        panel7.add(this.buttonCancel);
        JPanel panel8 = new JPanel();
        panel8.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel8, "Center");
        JPanel panel9 = new JPanel();
        panel9.setLayout(new GridBagLayout());
        panel8.add((Component)panel9, "Center");
        JLabel label1 = new JLabel();
        label1.setText("Search text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel9.add((Component)label1, gbc);
        JPanel panel10 = new JPanel();
        panel10.setLayout(new GridBagLayout());
        panel10.setMinimumSize(new Dimension(468, 33));
        panel10.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel9.add((Component)panel10, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setHorizontalScrollBarPolicy(31);
        scrollPane1.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel10.add((Component)scrollPane1, gbc);
        this.m_searchText = new JTextField();
        this.m_searchText.setColumns(40);
        this.m_searchText.setEditable(true);
        scrollPane1.setViewportView(this.m_searchText);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel9.add((Component)spacer1, gbc);
        JPanel panel11 = new JPanel();
        panel11.setLayout(new FlowLayout(0, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel9.add((Component)panel11, gbc);
        panel11.setBorder(BorderFactory.createTitledBorder("Find where?"));
        this.m_idsCheckBox = new JCheckBox();
        this.m_idsCheckBox.setSelected(true);
        this.m_idsCheckBox.setText("Ids");
        panel11.add(this.m_idsCheckBox);
        this.m_pagesCheckBox = new JCheckBox();
        this.m_pagesCheckBox.setSelected(true);
        this.m_pagesCheckBox.setText("Pages");
        panel11.add(this.m_pagesCheckBox);
        this.m_objectsCheckBox = new JCheckBox();
        this.m_objectsCheckBox.setSelected(true);
        this.m_objectsCheckBox.setText("Objects");
        panel11.add(this.m_objectsCheckBox);
        this.m_linksCheckBox = new JCheckBox();
        this.m_linksCheckBox.setSelected(true);
        this.m_linksCheckBox.setText("Links");
        panel11.add(this.m_linksCheckBox);
        this.m_variablesCheckBox = new JCheckBox();
        this.m_variablesCheckBox.setSelected(true);
        this.m_variablesCheckBox.setText("Variables");
        panel11.add(this.m_variablesCheckBox);
        JPanel panel12 = new JPanel();
        panel12.setLayout(new FlowLayout(0, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 1;
        panel9.add((Component)panel12, gbc);
        panel12.setBorder(BorderFactory.createTitledBorder("Find how?"));
        this.m_ignoreCaseCheckBox = new JCheckBox();
        this.m_ignoreCaseCheckBox.setText("Ignore case");
        panel12.add(this.m_ignoreCaseCheckBox);
        this.m_wholeWordsCheckBox = new JCheckBox();
        this.m_wholeWordsCheckBox.setText("Whole words");
        panel12.add(this.m_wholeWordsCheckBox);
        JPanel panel13 = new JPanel();
        panel13.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel13, "Center");
        JPanel panel14 = new JPanel();
        panel14.setLayout(new BorderLayout(0, 0));
        panel13.add((Component)panel14, "East");
        JPanel panel15 = new JPanel();
        panel15.setLayout(new BorderLayout(0, 0));
        panel14.add((Component)panel15, "Center");
        JPanel panel16 = new JPanel();
        panel16.setLayout(new GridBagLayout());
        panel15.add((Component)panel16, "North");
        JPanel panel17 = new JPanel();
        panel17.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel16.add((Component)panel17, gbc);
        this.m_goToButton = new JButton();
        this.m_goToButton.setPreferredSize(new Dimension(95, 25));
        this.m_goToButton.setText("Go to");
        panel17.add(this.m_goToButton);
        JPanel panel18 = new JPanel();
        panel18.setLayout(new BorderLayout(0, 0));
        panel13.add((Component)panel18, "Center");
        JScrollPane scrollPane2 = new JScrollPane();
        panel18.add((Component)scrollPane2, "Center");
        this.m_searchResultsTable = new JXTable();
        this.m_searchResultsTable.setSortable(false);
        this.m_searchResultsTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        scrollPane2.setViewportView((Component)this.m_searchResultsTable);
        label1.setLabelFor(this.m_searchText);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

