/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.form;

import com.camick.swing.layout.WrapLayout;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.ProgressData;
import com.nlbhub.nlb.builder.form.DialogBookProperties;
import com.nlbhub.nlb.builder.form.DialogCommit;
import com.nlbhub.nlb.builder.form.DialogPageProperties;
import com.nlbhub.nlb.builder.form.DialogPull;
import com.nlbhub.nlb.builder.form.DialogPush;
import com.nlbhub.nlb.builder.form.DialogSearch;
import com.nlbhub.nlb.builder.form.DialogSearchResults;
import com.nlbhub.nlb.builder.model.LinkSelectionData;
import com.nlbhub.nlb.builder.view.BulkSelectionHandler;
import com.nlbhub.nlb.builder.view.GraphEditor;
import com.nlbhub.nlb.builder.view.TabComponent;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.BareBonesBrowserLaunch;
import com.nlbhub.nlb.web.Launcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXStatusBar;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainFrame
implements PropertyChangeListener,
NLBObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainFrame.class);
    private static final String MAIN_PANE_KEY = "MAIN";
    private static final long START_SERVER_TIMEOUT = 500L;
    private static final String DEFAULT_BOOK_ID = "noname";
    private JPanel m_mainFramePanel;
    private JButton m_newFileButton;
    private JButton m_openFileButton;
    private JButton m_saveFileButton;
    private JButton m_saveFileAsButton;
    private JButton m_exportToQSPText;
    private JButton m_exportToURQText;
    private JButton m_cutButton;
    private JXStatusBar m_statusBar;
    private JPanel m_mainView;
    private JToggleButton m_addPageButton;
    private JToggleButton m_addLinkButton;
    private JButton m_undoButton;
    private JButton m_redoButton;
    private JButton m_copyButton;
    private JButton m_pasteButton;
    private JButton m_findButton;
    private JButton m_addStartPointButton;
    private JButton m_editAllPagesButton;
    private JButton m_showLeafsButton;
    private JButton m_zoomOutButton;
    private JButton m_zoomInButton;
    private JButton m_checkBookButton;
    private JButton m_exportToPDF;
    private JButton m_exportToHTML;
    private JButton m_editBookVarsButton;
    private JButton m_exportSTEAD;
    private JButton m_exportJSIQ;
    private JToggleButton m_addObjButton;
    private JButton m_commitButton;
    private JButton m_startServerButton;
    private JButton m_stopServerButton;
    private JTextArea m_bookInformationArea;
    private JTabbedPane m_graphEditorsPane;
    private JButton m_editModuleButton;
    private JToggleButton m_selectionModeButton;
    private JPanel m_toolbarPanel;
    private JButton m_exportASM;
    private JButton m_editPropertiesButton;
    private JButton m_editDeleteButton;
    private JButton m_editBookPropertiesButton;
    private JButton m_exportPNG;
    private JButton m_exportTXT;
    private JButton m_pushButton;
    private JButton m_pullButton;
    private JButton m_exportVNSTEAD;
    private JButton m_exportToChoiceScript;
    private final Launcher m_launcher;
    private final JFileChooser m_dirChooser;
    private final JFileChooser m_fileChooser;
    private Map<String, PaneEditorInfo> m_paneEditorInfoMap = new HashMap<String, PaneEditorInfo>();
    private final PaneEditorInfo m_mainEditorInfo;
    private ProgressMonitor m_progressMonitor;
    private Task m_task;

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.m_mainFramePanel = new JPanel();
        this.m_mainFramePanel.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane1 = new JSplitPane();
        this.m_mainFramePanel.add((Component)splitPane1, "Center");
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        panel1.setMinimumSize(new Dimension(200, 10));
        panel1.setPreferredSize(new Dimension(200, 100));
        splitPane1.setLeftComponent(panel1);
        this.m_bookInformationArea = new JTextArea();
        this.m_bookInformationArea.setEditable(false);
        this.m_bookInformationArea.setEnabled(true);
        this.m_bookInformationArea.setMinimumSize(new Dimension(200, 15));
        this.m_bookInformationArea.setPreferredSize(new Dimension(200, 15));
        panel1.add((Component)this.m_bookInformationArea, "Center");
        this.m_mainView = new JPanel();
        this.m_mainView.setLayout(new BorderLayout(0, 0));
        this.m_mainView.setMinimumSize(new Dimension(10, 10));
        this.m_mainView.setPreferredSize(new Dimension(400, 100));
        splitPane1.setRightComponent(this.m_mainView);
        this.m_graphEditorsPane = new JTabbedPane();
        this.m_mainView.add((Component)this.m_graphEditorsPane, "Center");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        this.m_graphEditorsPane.addTab("Untitled", panel2);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout(0, 5, 5));
        this.m_mainView.add((Component)panel3, "North");
        this.m_statusBar = new JXStatusBar();
        this.m_mainFramePanel.add((Component)this.m_statusBar, "South");
        this.m_toolbarPanel.setLayout(new FlowLayout(0, 5, 5));
        this.m_mainFramePanel.add((Component)this.m_toolbarPanel, "North");
        JToolBar toolBar1 = new JToolBar();
        toolBar1.setBorderPainted(false);
        toolBar1.setFloatable(true);
        toolBar1.setOrientation(0);
        this.m_toolbarPanel.add(toolBar1);
        this.m_newFileButton = new JButton();
        this.m_newFileButton.setBorderPainted(false);
        this.m_newFileButton.setContentAreaFilled(true);
        this.m_newFileButton.setFocusPainted(false);
        this.m_newFileButton.setIcon(new ImageIcon(this.getClass().getResource("/common/new.png")));
        this.m_newFileButton.setRolloverEnabled(true);
        this.m_newFileButton.setText("");
        this.m_newFileButton.setToolTipText("new file");
        toolBar1.add(this.m_newFileButton);
        this.m_openFileButton = new JButton();
        this.m_openFileButton.setBorderPainted(false);
        this.m_openFileButton.setFocusPainted(false);
        this.m_openFileButton.setIcon(new ImageIcon(this.getClass().getResource("/common/open.png")));
        this.m_openFileButton.setRolloverEnabled(true);
        this.m_openFileButton.setText("");
        toolBar1.add(this.m_openFileButton);
        this.m_saveFileButton = new JButton();
        this.m_saveFileButton.setBorderPainted(false);
        this.m_saveFileButton.setFocusPainted(false);
        this.m_saveFileButton.setIcon(new ImageIcon(this.getClass().getResource("/common/save.png")));
        this.m_saveFileButton.setRolloverEnabled(true);
        this.m_saveFileButton.setText("");
        toolBar1.add(this.m_saveFileButton);
        this.m_saveFileAsButton = new JButton();
        this.m_saveFileAsButton.setBorderPainted(false);
        this.m_saveFileAsButton.setFocusPainted(false);
        this.m_saveFileAsButton.setIcon(new ImageIcon(this.getClass().getResource("/common/saveas.png")));
        this.m_saveFileAsButton.setRolloverEnabled(true);
        this.m_saveFileAsButton.setText("");
        toolBar1.add(this.m_saveFileAsButton);
        this.m_pullButton = new JButton();
        this.m_pullButton.setBorderPainted(false);
        this.m_pullButton.setFocusPainted(false);
        this.m_pullButton.setIcon(new ImageIcon(this.getClass().getResource("/common/pull.png")));
        this.m_pullButton.setRolloverEnabled(true);
        this.m_pullButton.setText("");
        toolBar1.add(this.m_pullButton);
        this.m_commitButton = new JButton();
        this.m_commitButton.setBorderPainted(false);
        this.m_commitButton.setFocusPainted(false);
        this.m_commitButton.setIcon(new ImageIcon(this.getClass().getResource("/common/commit.png")));
        this.m_commitButton.setRolloverEnabled(true);
        this.m_commitButton.setText("");
        toolBar1.add(this.m_commitButton);
        this.m_pushButton = new JButton();
        this.m_pushButton.setBorderPainted(false);
        this.m_pushButton.setFocusPainted(false);
        this.m_pushButton.setIcon(new ImageIcon(this.getClass().getResource("/common/push.png")));
        this.m_pushButton.setRolloverEnabled(true);
        this.m_pushButton.setText("");
        toolBar1.add(this.m_pushButton);
        JToolBar toolBar2 = new JToolBar();
        toolBar2.setBorderPainted(false);
        this.m_toolbarPanel.add(toolBar2);
        this.m_undoButton = new JButton();
        this.m_undoButton.setBorderPainted(false);
        this.m_undoButton.setFocusPainted(false);
        this.m_undoButton.setIcon(new ImageIcon(this.getClass().getResource("/common/undo.png")));
        this.m_undoButton.setRolloverEnabled(true);
        this.m_undoButton.setText("");
        toolBar2.add(this.m_undoButton);
        this.m_redoButton = new JButton();
        this.m_redoButton.setBorderPainted(false);
        this.m_redoButton.setFocusPainted(false);
        this.m_redoButton.setIcon(new ImageIcon(this.getClass().getResource("/common/redo.png")));
        this.m_redoButton.setRolloverEnabled(true);
        this.m_redoButton.setText("");
        toolBar2.add(this.m_redoButton);
        this.m_cutButton = new JButton();
        this.m_cutButton.setBorderPainted(false);
        this.m_cutButton.setFocusPainted(false);
        this.m_cutButton.setIcon(new ImageIcon(this.getClass().getResource("/common/cut.png")));
        this.m_cutButton.setRolloverEnabled(true);
        this.m_cutButton.setText("");
        toolBar2.add(this.m_cutButton);
        this.m_copyButton = new JButton();
        this.m_copyButton.setBorderPainted(false);
        this.m_copyButton.setFocusPainted(false);
        this.m_copyButton.setIcon(new ImageIcon(this.getClass().getResource("/common/copy.png")));
        this.m_copyButton.setRolloverEnabled(true);
        this.m_copyButton.setText("");
        toolBar2.add(this.m_copyButton);
        this.m_pasteButton = new JButton();
        this.m_pasteButton.setBorderPainted(false);
        this.m_pasteButton.setFocusPainted(false);
        this.m_pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/common/paste.png")));
        this.m_pasteButton.setRolloverEnabled(true);
        this.m_pasteButton.setText("");
        toolBar2.add(this.m_pasteButton);
        JToolBar toolBar3 = new JToolBar();
        toolBar3.setBorderPainted(false);
        toolBar3.setFloatable(true);
        toolBar3.setRollover(true);
        toolBar3.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.m_toolbarPanel.add(toolBar3);
        this.m_editBookPropertiesButton = new JButton();
        this.m_editBookPropertiesButton.setBorderPainted(false);
        this.m_editBookPropertiesButton.setFocusPainted(false);
        this.m_editBookPropertiesButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditBookProperties.png")));
        this.m_editBookPropertiesButton.setRolloverEnabled(true);
        this.m_editBookPropertiesButton.setText("");
        toolBar3.add(this.m_editBookPropertiesButton);
        this.m_addStartPointButton = new JButton();
        this.m_addStartPointButton.setBorderPainted(false);
        this.m_addStartPointButton.setFocusPainted(false);
        this.m_addStartPointButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditAddStartPoint.png")));
        this.m_addStartPointButton.setRolloverEnabled(true);
        this.m_addStartPointButton.setText("");
        toolBar3.add(this.m_addStartPointButton);
        this.m_addPageButton = new JToggleButton();
        this.m_addPageButton.setBorderPainted(false);
        this.m_addPageButton.setFocusPainted(false);
        this.m_addPageButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditAddBookPage.png")));
        this.m_addPageButton.setRolloverEnabled(true);
        this.m_addPageButton.setText("");
        toolBar3.add(this.m_addPageButton);
        this.m_addObjButton = new JToggleButton();
        this.m_addObjButton.setBorderPainted(false);
        this.m_addObjButton.setFocusPainted(false);
        this.m_addObjButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditAddObj.png")));
        this.m_addObjButton.setRolloverEnabled(true);
        this.m_addObjButton.setText("");
        toolBar3.add(this.m_addObjButton);
        this.m_addLinkButton = new JToggleButton();
        this.m_addLinkButton.setBorderPainted(false);
        this.m_addLinkButton.setFocusPainted(false);
        this.m_addLinkButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditAddLink.png")));
        this.m_addLinkButton.setRolloverEnabled(true);
        this.m_addLinkButton.setSelected(false);
        this.m_addLinkButton.setText("");
        toolBar3.add(this.m_addLinkButton);
        this.m_selectionModeButton = new JToggleButton();
        this.m_selectionModeButton.setBorderPainted(false);
        this.m_selectionModeButton.setFocusPainted(false);
        this.m_selectionModeButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditSelectionMode.png")));
        this.m_selectionModeButton.setRolloverEnabled(true);
        this.m_selectionModeButton.setSelected(false);
        this.m_selectionModeButton.setText("");
        toolBar3.add(this.m_selectionModeButton);
        this.m_editModuleButton = new JButton();
        this.m_editModuleButton.setBorderPainted(false);
        this.m_editModuleButton.setFocusPainted(false);
        this.m_editModuleButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditModule.png")));
        this.m_editModuleButton.setRolloverEnabled(true);
        this.m_editModuleButton.setText("");
        toolBar3.add(this.m_editModuleButton);
        this.m_editAllPagesButton = new JButton();
        this.m_editAllPagesButton.setBorderPainted(false);
        this.m_editAllPagesButton.setFocusPainted(false);
        this.m_editAllPagesButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditChangeAllPages.png")));
        this.m_editAllPagesButton.setRolloverEnabled(true);
        this.m_editAllPagesButton.setText("");
        toolBar3.add(this.m_editAllPagesButton);
        this.m_editPropertiesButton = new JButton();
        this.m_editPropertiesButton.setBorderPainted(false);
        this.m_editPropertiesButton.setFocusPainted(false);
        this.m_editPropertiesButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditProperties.png")));
        this.m_editPropertiesButton.setRolloverEnabled(true);
        this.m_editPropertiesButton.setText("");
        toolBar3.add(this.m_editPropertiesButton);
        this.m_editDeleteButton = new JButton();
        this.m_editDeleteButton.setBorderPainted(false);
        this.m_editDeleteButton.setFocusPainted(false);
        this.m_editDeleteButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditDelete.png")));
        this.m_editDeleteButton.setRolloverEnabled(true);
        this.m_editDeleteButton.setText("");
        toolBar3.add(this.m_editDeleteButton);
        this.m_zoomOutButton = new JButton();
        this.m_zoomOutButton.setBorderPainted(false);
        this.m_zoomOutButton.setFocusPainted(false);
        this.m_zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/common/view_min.png")));
        this.m_zoomOutButton.setRolloverEnabled(true);
        this.m_zoomOutButton.setText("");
        toolBar3.add(this.m_zoomOutButton);
        this.m_zoomInButton = new JButton();
        this.m_zoomInButton.setBorderPainted(false);
        this.m_zoomInButton.setFocusPainted(false);
        this.m_zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/common/view_plus.png")));
        this.m_zoomInButton.setRolloverEnabled(true);
        this.m_zoomInButton.setText("");
        toolBar3.add(this.m_zoomInButton);
        JToolBar toolBar4 = new JToolBar();
        toolBar4.setBorderPainted(false);
        this.m_toolbarPanel.add(toolBar4);
        this.m_showLeafsButton = new JButton();
        this.m_showLeafsButton.setBorderPainted(false);
        this.m_showLeafsButton.setFocusPainted(false);
        this.m_showLeafsButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditLeafs.png")));
        this.m_showLeafsButton.setRolloverEnabled(true);
        this.m_showLeafsButton.setText("");
        toolBar4.add(this.m_showLeafsButton);
        this.m_editBookVarsButton = new JButton();
        this.m_editBookVarsButton.setBorderPainted(false);
        this.m_editBookVarsButton.setFocusPainted(false);
        this.m_editBookVarsButton.setIcon(new ImageIcon(this.getClass().getResource("/core/EditBookVars.png")));
        this.m_editBookVarsButton.setRolloverEnabled(true);
        this.m_editBookVarsButton.setText("");
        toolBar4.add(this.m_editBookVarsButton);
        this.m_checkBookButton = new JButton();
        this.m_checkBookButton.setBorderPainted(false);
        this.m_checkBookButton.setFocusPainted(false);
        this.m_checkBookButton.setIcon(new ImageIcon(this.getClass().getResource("/common/check.png")));
        this.m_checkBookButton.setRolloverEnabled(true);
        this.m_checkBookButton.setText("");
        toolBar4.add(this.m_checkBookButton);
        this.m_startServerButton = new JButton();
        this.m_startServerButton.setBorderPainted(false);
        this.m_startServerButton.setFocusPainted(false);
        this.m_startServerButton.setIcon(new ImageIcon(this.getClass().getResource("/common/server_run.png")));
        this.m_startServerButton.setRolloverEnabled(true);
        this.m_startServerButton.setText("");
        toolBar4.add(this.m_startServerButton);
        this.m_stopServerButton = new JButton();
        this.m_stopServerButton.setBorderPainted(false);
        this.m_stopServerButton.setEnabled(false);
        this.m_stopServerButton.setFocusPainted(false);
        this.m_stopServerButton.setIcon(new ImageIcon(this.getClass().getResource("/common/server_stop.png")));
        this.m_stopServerButton.setRolloverEnabled(true);
        this.m_stopServerButton.setText("");
        toolBar4.add(this.m_stopServerButton);
        this.m_findButton = new JButton();
        this.m_findButton.setBorderPainted(false);
        this.m_findButton.setFocusPainted(false);
        this.m_findButton.setIcon(new ImageIcon(this.getClass().getResource("/common/find.png")));
        this.m_findButton.setRolloverEnabled(true);
        this.m_findButton.setText("");
        toolBar4.add(this.m_findButton);
        JToolBar toolBar5 = new JToolBar();
        toolBar5.setBorderPainted(false);
        toolBar5.setFloatable(true);
        toolBar5.setOrientation(0);
        this.m_toolbarPanel.add(toolBar5);
        this.m_exportToChoiceScript = new JButton();
        this.m_exportToChoiceScript.setBorderPainted(false);
        this.m_exportToChoiceScript.setFocusPainted(false);
        this.m_exportToChoiceScript.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exportCS.png")));
        this.m_exportToChoiceScript.setRolloverEnabled(true);
        this.m_exportToChoiceScript.setText("");
        toolBar5.add(this.m_exportToChoiceScript);
        this.m_exportToQSPText = new JButton();
        this.m_exportToQSPText.setBorderPainted(false);
        this.m_exportToQSPText.setFocusPainted(false);
        this.m_exportToQSPText.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exportqsptxt.png")));
        this.m_exportToQSPText.setRolloverEnabled(true);
        this.m_exportToQSPText.setText("");
        toolBar5.add(this.m_exportToQSPText);
        this.m_exportToURQText = new JButton();
        this.m_exportToURQText.setBorderPainted(false);
        this.m_exportToURQText.setFocusPainted(false);
        this.m_exportToURQText.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exporturqtxt.png")));
        this.m_exportToURQText.setRolloverEnabled(true);
        this.m_exportToURQText.setText("");
        toolBar5.add(this.m_exportToURQText);
        this.m_exportToPDF = new JButton();
        this.m_exportToPDF.setBorderPainted(false);
        this.m_exportToPDF.setFocusPainted(false);
        this.m_exportToPDF.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exportpdf.png")));
        this.m_exportToPDF.setRolloverEnabled(true);
        this.m_exportToPDF.setText("");
        toolBar5.add(this.m_exportToPDF);
        this.m_exportToHTML = new JButton();
        this.m_exportToHTML.setBorderPainted(false);
        this.m_exportToHTML.setFocusPainted(false);
        this.m_exportToHTML.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exporthtml.png")));
        this.m_exportToHTML.setRolloverEnabled(true);
        this.m_exportToHTML.setText("");
        toolBar5.add(this.m_exportToHTML);
        this.m_exportJSIQ = new JButton();
        this.m_exportJSIQ.setBorderPainted(false);
        this.m_exportJSIQ.setFocusPainted(false);
        this.m_exportJSIQ.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exportJSIQ.png")));
        this.m_exportJSIQ.setRolloverEnabled(true);
        this.m_exportJSIQ.setText("");
        toolBar5.add(this.m_exportJSIQ);
        this.m_exportSTEAD = new JButton();
        this.m_exportSTEAD.setBorderPainted(false);
        this.m_exportSTEAD.setFocusPainted(false);
        this.m_exportSTEAD.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exportSTEAD.png")));
        this.m_exportSTEAD.setRolloverEnabled(true);
        this.m_exportSTEAD.setText("");
        toolBar5.add(this.m_exportSTEAD);
        this.m_exportVNSTEAD = new JButton();
        this.m_exportVNSTEAD.setBorderPainted(false);
        this.m_exportVNSTEAD.setFocusPainted(false);
        this.m_exportVNSTEAD.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exportVNSTEAD.png")));
        this.m_exportVNSTEAD.setRolloverEnabled(true);
        this.m_exportVNSTEAD.setText("");
        toolBar5.add(this.m_exportVNSTEAD);
        this.m_exportASM = new JButton();
        this.m_exportASM.setBorderPainted(false);
        this.m_exportASM.setEnabled(true);
        this.m_exportASM.setFocusPainted(false);
        this.m_exportASM.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exportASM.png")));
        this.m_exportASM.setRolloverEnabled(true);
        this.m_exportASM.setText("");
        toolBar5.add(this.m_exportASM);
        this.m_exportPNG = new JButton();
        this.m_exportPNG.setBorderPainted(false);
        this.m_exportPNG.setEnabled(true);
        this.m_exportPNG.setFocusPainted(false);
        this.m_exportPNG.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exportPNG.png")));
        this.m_exportPNG.setRolloverEnabled(true);
        this.m_exportPNG.setText("");
        toolBar5.add(this.m_exportPNG);
        this.m_exportTXT = new JButton();
        this.m_exportTXT.setBorderPainted(false);
        this.m_exportTXT.setEnabled(true);
        this.m_exportTXT.setFocusPainted(false);
        this.m_exportTXT.setIcon(new ImageIcon(this.getClass().getResource("/extras/export/exportTXT.png")));
        this.m_exportTXT.setRolloverEnabled(true);
        this.m_exportTXT.setText("");
        toolBar5.add(this.m_exportTXT);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.m_mainFramePanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            this.m_progressMonitor.setProgress(progress);
            if (this.m_progressMonitor.isCanceled() || this.m_task.isDone()) {
                Toolkit.getDefaultToolkit().beep();
                if (this.m_progressMonitor.isCanceled()) {
                    this.m_task.cancel(true);
                }
                this.m_saveFileButton.setEnabled(true);
                this.m_saveFileAsButton.setEnabled(true);
                this.m_openFileButton.setEnabled(true);
            }
        }
    }

    public MainFrame(@NotNull NonLinearBookFacade nlbFacade, @NotNull Launcher launcher) {
        final MainFrame mainFrame = this;
        this.m_mainEditorInfo = new PaneEditorInfo(MAIN_PANE_KEY, nlbFacade, new GraphEditor(this, nlbFacade), 0);
        this.m_paneEditorInfoMap.put(MAIN_PANE_KEY, this.m_mainEditorInfo);
        this.m_launcher = launcher;
        this.m_dirChooser = new JFileChooser();
        this.m_dirChooser.setFileSelectionMode(1);
        this.m_fileChooser = new JFileChooser();
        this.$$$setupUI$$$();
        this.rearrangeCustomComponents();
        this.m_graphEditorsPane.setTitleAt(0, "Main");
        this.m_graphEditorsPane.setComponentAt(0, (Component)((Object)this.m_mainEditorInfo.getPaneGraphEditor()));
        this.m_graphEditorsPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PaneEditorInfo editorInfo = MainFrame.this.getSelectedPaneInfo();
                MainFrame.this.m_undoButton.setEnabled(editorInfo.getPaneNlbFacade().canUndo());
                MainFrame.this.m_redoButton.setEnabled(editorInfo.getPaneNlbFacade().canRedo());
                NonLinearBook nlb = editorInfo.getPaneNlbFacade().getNlb();
                NonLinearBook.BookStatistics bookStats = nlb.getBookStatistics();
                NonLinearBook.VariableStatistics variableStats = nlb.getVariableStatistics();
                MainFrame.this.setBookInfoPaneData(bookStats, variableStats);
            }
        });
        this.m_newFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.clearAll();
            }
        });
        this.m_openFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int returnVal = MainFrame.this.m_dirChooser.showOpenDialog(MainFrame.this.m_mainFramePanel);
                    if (returnVal == 0) {
                        MainFrame.this.m_progressMonitor = new ProgressMonitor(MainFrame.this.$$$getRootComponent$$$(), "Opening Non-Linear Book", "Initializing...", 0, 100);
                        MainFrame.this.m_progressMonitor.setProgress(0);
                        MainFrame.this.m_progressMonitor.setMillisToDecideToPopup(200);
                        MainFrame.this.m_progressMonitor.setMillisToPopup(200);
                        MainFrame.this.m_task = new OpenTask(MainFrame.this.m_dirChooser.getSelectedFile());
                        MainFrame.this.m_task.addPropertyChangeListener(mainFrame);
                        MainFrame.this.m_openFileButton.setEnabled(false);
                        MainFrame.this.m_task.execute();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while loading: " + ex.toString());
                }
            }
        });
        this.m_saveFileButton.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PaneEditorInfo editorInfo = MainFrame.this.getMainPaneInfo();
                    if (editorInfo.getPaneNlbFacade().getNlb().getRootDir() == null) {
                        File saveDir = MainFrame.this.chooseSaveDir();
                        if (saveDir == null) return;
                        MainFrame.this.initSaveProgress();
                        MainFrame.this.m_task = new SaveAsTask(saveDir);
                    } else {
                        MainFrame.this.initSaveProgress();
                        MainFrame.this.m_task = new SaveTask();
                    }
                    MainFrame.this.m_task.addPropertyChangeListener(mainFrame);
                    MainFrame.this.m_saveFileButton.setEnabled(false);
                    MainFrame.this.m_saveFileAsButton.setEnabled(false);
                    MainFrame.this.m_task.execute();
                    return;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while saving: " + ex.toString());
                }
            }
        });
        this.m_saveFileAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File saveDir = MainFrame.this.chooseSaveDir();
                    if (saveDir != null) {
                        MainFrame.this.initSaveProgress();
                        MainFrame.this.m_task = new SaveAsTask(saveDir);
                        MainFrame.this.m_task.addPropertyChangeListener(mainFrame);
                        MainFrame.this.m_saveFileButton.setEnabled(false);
                        MainFrame.this.m_saveFileAsButton.setEnabled(false);
                        MainFrame.this.m_task.execute();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while saving: " + ex.toString());
                }
            }
        });
        this.m_pullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DialogPull dialog = new DialogPull();
                    dialog.showDialog();
                    if (dialog.isOk()) {
                        MainFrame.this.m_progressMonitor = new ProgressMonitor(MainFrame.this.$$$getRootComponent$$$(), "Pulling Non-Linear Book", "Initializing...", 0, 100);
                        MainFrame.this.m_progressMonitor.setProgress(0);
                        MainFrame.this.m_progressMonitor.setMillisToDecideToPopup(200);
                        MainFrame.this.m_progressMonitor.setMillisToPopup(200);
                        MainFrame.this.m_task = new PullTask(dialog.getUserName(), dialog.getPassword(), mainFrame);
                        MainFrame.this.m_task.addPropertyChangeListener(mainFrame);
                        MainFrame.this.m_pullButton.setEnabled(false);
                        MainFrame.this.m_task.execute();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while pulling: " + ex.toString());
                }
            }
        });
        this.m_commitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DialogCommit dialog = new DialogCommit();
                    dialog.showDialog();
                    if (dialog.isOk()) {
                        PaneEditorInfo editorInfo = MainFrame.this.getMainPaneInfo();
                        editorInfo.getPaneNlbFacade().commit(dialog.getCommitMessageText());
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while committing to VCS: " + ex.toString());
                }
            }
        });
        this.m_pushButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DialogPush dialog = new DialogPush();
                    dialog.showDialog();
                    if (dialog.isOk()) {
                        MainFrame.this.m_progressMonitor = new ProgressMonitor(MainFrame.this.$$$getRootComponent$$$(), "Pushing Non-Linear Book", "Initializing...", 0, 100);
                        MainFrame.this.m_progressMonitor.setProgress(0);
                        MainFrame.this.m_progressMonitor.setMillisToDecideToPopup(200);
                        MainFrame.this.m_progressMonitor.setMillisToPopup(200);
                        MainFrame.this.m_task = new PushTask(dialog.getUserName(), dialog.getPassword());
                        MainFrame.this.m_task.addPropertyChangeListener(mainFrame);
                        MainFrame.this.m_pushButton.setEnabled(false);
                        MainFrame.this.m_task.execute();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while pushing: " + ex.toString());
                }
            }
        });
        this.m_undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.getSelectedPaneInfo().getPaneNlbFacade().undo();
            }
        });
        this.m_redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.getSelectedPaneInfo().getPaneNlbFacade().redo();
            }
        });
        this.m_cutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneEditorInfo paneInfo = MainFrame.this.getSelectedPaneInfo();
                BulkSelectionHandler bulkSelectionHandler = paneInfo.getPaneGraphEditor().getBulkSelectionHandler();
                if (bulkSelectionHandler.hasSelection()) {
                    paneInfo.getPaneNlbFacade().cut(bulkSelectionHandler.getSelectedPagesIds(), bulkSelectionHandler.getSelectedObjsIds());
                }
            }
        });
        this.m_copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneEditorInfo paneInfo = MainFrame.this.getSelectedPaneInfo();
                BulkSelectionHandler bulkSelectionHandler = paneInfo.getPaneGraphEditor().getBulkSelectionHandler();
                if (bulkSelectionHandler.hasSelection()) {
                    paneInfo.getPaneNlbFacade().copy(bulkSelectionHandler.getSelectedPagesIds(), bulkSelectionHandler.getSelectedObjsIds());
                }
            }
        });
        this.m_pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneEditorInfo paneInfo = MainFrame.this.getSelectedPaneInfo();
                paneInfo.getPaneNlbFacade().paste();
                paneInfo.getPaneGraphEditor().init();
            }
        });
        this.m_findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneEditorInfo editorInfo = MainFrame.this.getSelectedPaneInfo();
                DialogSearch dialog = new DialogSearch(mainFrame, editorInfo.getPaneNlbFacade().getNlb(), editorInfo.getModulePageId(), "");
                dialog.showDialog();
            }
        });
        this.m_exportToChoiceScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File exportDir = MainFrame.this.chooseExportDir();
                    if (exportDir != null) {
                        MainFrame.this.getMainPaneInfo().getPaneNlbFacade().exportToChoiceScript(exportDir);
                    }
                }
                catch (NLBExportException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to Choice Script file: " + ex.toString());
                }
            }
        });
        this.m_exportToQSPText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File exportDir = MainFrame.this.chooseExportDir();
                    if (exportDir != null) {
                        MainFrame.this.getMainPaneInfo().getPaneNlbFacade().exportToQSPTextFile(exportDir);
                    }
                }
                catch (NLBExportException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to QSP text file: " + ex.toString());
                }
            }
        });
        this.m_exportToURQText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File exportDir = MainFrame.this.chooseExportDir();
                    if (exportDir != null) {
                        MainFrame.this.getMainPaneInfo().getPaneNlbFacade().exportToURQTextFile(exportDir);
                    }
                }
                catch (NLBExportException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to URQ file: " + ex.toString());
                }
            }
        });
        this.m_exportToPDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File exportFile = MainFrame.this.chooseExportFile("book.pdf");
                    if (exportFile != null) {
                        MainFrame.this.getMainPaneInfo().getPaneNlbFacade().exportToPDFFile(exportFile);
                    }
                }
                catch (NLBExportException ex) {
                    LOGGER.error("Error while exporting to PDF: ", (Throwable)ex);
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to PDF: " + ex.toString());
                }
            }
        });
        this.m_exportTXT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File exportDir = MainFrame.this.chooseExportDir();
                    if (exportDir != null) {
                        MainFrame.this.getMainPaneInfo().getPaneNlbFacade().exportToTXTFile(exportDir);
                    }
                }
                catch (NLBExportException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to TXT: " + ex.toString());
                }
            }
        });
        this.m_exportToHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File exportDir = MainFrame.this.chooseExportDir();
                    if (exportDir != null) {
                        MainFrame.this.getMainPaneInfo().getPaneNlbFacade().exportToHTMLFile(exportDir);
                    }
                }
                catch (NLBExportException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to HTML: " + ex.toString());
                }
            }
        });
        this.m_exportJSIQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File exportDir = MainFrame.this.chooseExportDir();
                    if (exportDir != null) {
                        MainFrame.this.getMainPaneInfo().getPaneNlbFacade().exportToJSIQFile(exportDir);
                    }
                }
                catch (NLBExportException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to HTML: " + ex.toString());
                }
            }
        });
        this.m_exportSTEAD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File exportDir = MainFrame.this.chooseExportDir();
                    if (exportDir != null) {
                        MainFrame.this.getMainPaneInfo().getPaneNlbFacade().exportToSTEADFile(exportDir);
                    }
                }
                catch (NLBExportException | NLBIOException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to STEAD: " + ex.toString());
                }
            }
        });
        this.m_exportVNSTEAD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File exportDir = MainFrame.this.chooseExportDir();
                    if (exportDir != null) {
                        MainFrame.this.getMainPaneInfo().getPaneNlbFacade().exportToVNSTEADFile(exportDir);
                    }
                }
                catch (NLBExportException | NLBIOException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to VNSTEAD: " + ex.toString());
                }
            }
        });
        this.m_exportASM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File exportDir = MainFrame.this.chooseExportDir();
                    if (exportDir != null) {
                        MainFrame.this.getMainPaneInfo().getPaneNlbFacade().exportToASMFile(exportDir);
                    }
                }
                catch (NLBExportException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to ASM: " + ex.toString());
                }
            }
        });
        this.m_exportPNG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File exportFile = MainFrame.this.chooseExportFile("book.png");
                if (exportFile != null) {
                    MainFrame.this.m_progressMonitor = new ProgressMonitor(MainFrame.this.$$$getRootComponent$$$(), "Exporting Non-Linear Book to PNG", "Initializing...", 0, 100);
                    MainFrame.this.m_progressMonitor.setProgress(0);
                    MainFrame.this.m_progressMonitor.setMillisToDecideToPopup(200);
                    MainFrame.this.m_progressMonitor.setMillisToPopup(200);
                    MainFrame.this.m_task = new SaveAsImageTask(exportFile);
                    MainFrame.this.m_task.addPropertyChangeListener(mainFrame);
                    MainFrame.this.m_exportPNG.setEnabled(false);
                    MainFrame.this.m_task.execute();
                }
            }
        });
        this.m_editBookPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneEditorInfo editorInfo = MainFrame.this.getSelectedPaneInfo();
                DialogBookProperties dialog = new DialogBookProperties(editorInfo.getPaneNlbFacade());
                dialog.showDialog();
            }
        });
        this.m_addStartPointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.getSelectedPaneInfo().getPaneGraphEditor().addStartPoint();
            }
        });
        this.m_addPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.enableLinkedButton(MainFrame.this.m_addPageButton, new JToggleButton[]{MainFrame.this.m_addLinkButton, MainFrame.this.m_addObjButton, MainFrame.this.m_selectionModeButton});
                GraphEditor paneGraphEditor = MainFrame.this.getSelectedPaneInfo().getPaneGraphEditor();
                paneGraphEditor.setAddPageMode(!paneGraphEditor.isAddPageMode());
            }
        });
        this.m_addObjButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.enableLinkedButton(MainFrame.this.m_addObjButton, new JToggleButton[]{MainFrame.this.m_addPageButton, MainFrame.this.m_addLinkButton, MainFrame.this.m_selectionModeButton});
                GraphEditor paneGraphEditor = MainFrame.this.getSelectedPaneInfo().getPaneGraphEditor();
                paneGraphEditor.setAddObjMode(!paneGraphEditor.isAddObjMode());
            }
        });
        this.m_addLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.enableLinkedButton(MainFrame.this.m_addLinkButton, new JToggleButton[]{MainFrame.this.m_addPageButton, MainFrame.this.m_addObjButton, MainFrame.this.m_selectionModeButton});
                GraphEditor paneGraphEditor = MainFrame.this.getSelectedPaneInfo().getPaneGraphEditor();
                paneGraphEditor.setAddLinkMode(!paneGraphEditor.isAddLinkMode());
            }
        });
        this.m_selectionModeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.enableLinkedButton(MainFrame.this.m_selectionModeButton, new JToggleButton[]{MainFrame.this.m_addLinkButton, MainFrame.this.m_addPageButton, MainFrame.this.m_addObjButton});
                GraphEditor paneGraphEditor = MainFrame.this.getSelectedPaneInfo().getPaneGraphEditor();
                paneGraphEditor.setSelectionMode(!paneGraphEditor.isSelectionMode());
            }
        });
        this.m_editModuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneEditorInfo editorInfo = MainFrame.this.getSelectedPaneInfo();
                Page page = editorInfo.getPaneGraphEditor().getSelectedPage();
                PaneEditorInfo paneEditorInfo = MainFrame.this.createGraphEditorPane(editorInfo, page);
                MainFrame.this.m_graphEditorsPane.setSelectedIndex(paneEditorInfo.getPaneIndex());
            }
        });
        this.m_editDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneEditorInfo editorInfo = MainFrame.this.getSelectedPaneInfo();
                GraphEditor paneGraphEditor = editorInfo.getPaneGraphEditor();
                Page selectedPage = paneGraphEditor.getSelectedPage();
                Obj selectedObj = paneGraphEditor.getSelectedObj();
                if (selectedPage != null) {
                    paneGraphEditor.deleteSelectedPage();
                } else if (selectedObj != null) {
                    paneGraphEditor.deleteSelectedObj();
                } else {
                    LinkSelectionData selectedLink = paneGraphEditor.getSelectedLink();
                    if (selectedLink != null && selectedLink.getLink() != null) {
                        paneGraphEditor.deleteSelectedLink();
                    }
                }
            }
        });
        this.m_editPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphEditor graphEditor = MainFrame.this.getSelectedPaneInfo().getPaneGraphEditor();
                graphEditor.editSelectedItemProperties(mainFrame);
            }
        });
        this.m_editAllPagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneEditorInfo editorInfo = MainFrame.this.getSelectedPaneInfo();
                for (Page page : editorInfo.getPaneNlbFacade().getNlb().getPages().values()) {
                    if (page.isDeleted()) continue;
                    DialogPageProperties dialog = new DialogPageProperties(mainFrame, editorInfo.getPaneNlbFacade(), page);
                    dialog.showDialog();
                    editorInfo.getPaneGraphEditor().updatePage(page);
                }
            }
        });
        this.m_showLeafsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PaneEditorInfo editorInfo = MainFrame.this.getSelectedPaneInfo();
                    DialogSearchResults dialog = new DialogSearchResults(mainFrame, editorInfo.getPaneNlbFacade().getNlb(), editorInfo.getModulePageId(), DialogSearchResults.SearchType.Leafs);
                    dialog.showDialog();
                }
                catch (NLBConsistencyException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while querying NLB leafs: " + ex.toString());
                }
            }
        });
        this.m_editBookVarsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PaneEditorInfo editorInfo = MainFrame.this.getSelectedPaneInfo();
                    DialogSearchResults dialog = new DialogSearchResults(mainFrame, editorInfo.getPaneNlbFacade().getNlb(), editorInfo.getModulePageId(), DialogSearchResults.SearchType.Variables);
                    dialog.showDialog();
                }
                catch (NLBConsistencyException ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while querying NLB variables: " + ex.toString());
                }
            }
        });
        this.m_zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.getSelectedPaneInfo().getPaneGraphEditor().zoomIn();
            }
        });
        this.m_zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.getSelectedPaneInfo().getPaneGraphEditor().zoomOut();
            }
        });
        this.m_checkBookButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PaneEditorInfo editorInfo = MainFrame.this.getMainPaneInfo();
                    DialogSearchResults dialog = new DialogSearchResults(mainFrame, editorInfo.getPaneNlbFacade().getNlb(), editorInfo.getModulePageId(), DialogSearchResults.SearchType.CheckBook);
                    dialog.showDialog();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while checking the NLB: " + ex.toString());
                }
            }
        });
        this.m_startServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!MainFrame.this.m_launcher.isRunning()) {
                        PaneEditorInfo editorInfo = MainFrame.this.getMainPaneInfo();
                        NonLinearBook mainNLB = editorInfo.getPaneNlbFacade().getNlb();
                        File rootDir = mainNLB.getRootDir();
                        if (rootDir != null) {
                            MainFrame.this.m_launcher.setNLBLibraryRoot(rootDir.getParent());
                        }
                        String bookId = rootDir != null ? rootDir.getName() : MainFrame.DEFAULT_BOOK_ID;
                        MainFrame.this.m_launcher.clearNLBCache();
                        MainFrame.this.m_launcher.putNLBInMemoryToCache(bookId, mainNLB);
                        Thread thread = new Thread((Runnable)MainFrame.this.m_launcher);
                        thread.start();
                        Thread.sleep(500L);
                        BareBonesBrowserLaunch.openURL((String)("http://localhost:8111/nlb/" + bookId + "/start"));
                        MainFrame.this.m_startServerButton.setEnabled(false);
                        MainFrame.this.m_stopServerButton.setEnabled(true);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while starting the server: " + ex.toString());
                }
            }
        });
        this.m_stopServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (MainFrame.this.m_launcher.isRunning()) {
                        MainFrame.this.m_launcher.stop();
                        MainFrame.this.m_startServerButton.setEnabled(true);
                        MainFrame.this.m_stopServerButton.setEnabled(false);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while stopping the server: " + ex.toString());
                }
            }
        });
        this.addListenerAndObserver(this.getMainPaneInfo());
        this.updateView();
    }

    private void initSaveProgress() {
        this.m_progressMonitor = new ProgressMonitor(this.$$$getRootComponent$$$(), "Saving Non-Linear Book", "Initializing...", 0, 100);
        this.m_progressMonitor.setProgress(0);
        this.m_progressMonitor.setMillisToDecideToPopup(200);
        this.m_progressMonitor.setMillisToPopup(200);
    }

    public void goTo(String modulePageId, String itemId) {
        PaneEditorInfo paneEditorInfo = this.m_paneEditorInfoMap.get(modulePageId);
        paneEditorInfo.getPaneGraphEditor().goTo(itemId);
        this.m_graphEditorsPane.setSelectedIndex(paneEditorInfo.getPaneIndex());
    }

    private void clearAll() {
        try {
            for (Map.Entry<String, PaneEditorInfo> entry : this.m_paneEditorInfoMap.entrySet()) {
                entry.getValue().getPaneGraphEditor().clear();
                entry.getValue().getPaneNlbFacade().clear();
            }
            this.m_paneEditorInfoMap.clear();
            this.m_paneEditorInfoMap.put(MAIN_PANE_KEY, this.m_mainEditorInfo);
            while (this.m_graphEditorsPane.getTabCount() > 1) {
                this.m_graphEditorsPane.remove(1);
            }
        }
        catch (NLBVCSException ex) {
            JOptionPane.showMessageDialog(this.m_mainFramePanel, "Error while NLB clear: " + ex.toString());
        }
    }

    private void openModulesPanes() {
        this.openModulesPanes(this.getMainPaneInfo());
    }

    private void openModulesPanes(PaneEditorInfo paneEditorInfo) {
        for (Page page : paneEditorInfo.getPaneNlbFacade().getNlb().getPages().values()) {
            if (page.isDeleted() || page.getModule().isEmpty()) continue;
            this.openModulesPanes(this.createGraphEditorPane(paneEditorInfo, page));
        }
    }

    private PaneEditorInfo createGraphEditorPane(PaneEditorInfo editorInfo, Page page) {
        PaneEditorInfo paneEditorInfo;
        if (this.m_paneEditorInfoMap.containsKey(page.getId())) {
            paneEditorInfo = this.m_paneEditorInfoMap.get(page.getId());
            if (paneEditorInfo.getPaneIndex() != -1) {
                return paneEditorInfo;
            }
        } else {
            NonLinearBookFacade paneNlbFacade = editorInfo.getPaneNlbFacade().createModuleFacade(page.getId());
            GraphEditor paneGraphEditor = new GraphEditor(this, paneNlbFacade);
            paneEditorInfo = new PaneEditorInfo(page.getId(), paneNlbFacade, paneGraphEditor, this.m_graphEditorsPane.getTabCount());
            this.m_paneEditorInfoMap.put(page.getId(), paneEditorInfo);
            this.addListenerAndObserver(paneEditorInfo);
        }
        paneEditorInfo.setClosedManually(false);
        this.addGraphEditorTab(page.getModuleName(), paneEditorInfo);
        return paneEditorInfo;
    }

    private void addGraphEditorTab(String title, final PaneEditorInfo paneEditorInfo) {
        int newTabIndex = this.m_graphEditorsPane.getTabCount();
        paneEditorInfo.setPaneIndex(newTabIndex);
        this.m_graphEditorsPane.addTab(title, (Component)((Object)paneEditorInfo.getPaneGraphEditor()));
        TabComponent tabComponent = new TabComponent(title, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int index = paneEditorInfo.getPaneIndex();
                for (Map.Entry entry : MainFrame.this.m_paneEditorInfoMap.entrySet()) {
                    if (((PaneEditorInfo)entry.getValue()).getPaneIndex() <= index) continue;
                    ((PaneEditorInfo)entry.getValue()).setPaneIndex(((PaneEditorInfo)entry.getValue()).getPaneIndex() - 1);
                }
                paneEditorInfo.setPaneIndex(-1);
                if (!"CLOSED_IN_CODE".equals(actionEvent.getActionCommand())) {
                    paneEditorInfo.setClosedManually(true);
                }
                MainFrame.this.m_graphEditorsPane.remove(index);
            }
        });
        paneEditorInfo.setTabComponent(tabComponent);
        this.m_graphEditorsPane.setTabComponentAt(newTabIndex, tabComponent.getPnlTab());
    }

    private void addListenerAndObserver(final PaneEditorInfo paneEditorInfo) {
        paneEditorInfo.getPaneGraphEditor().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                paneEditorInfo.getPaneGraphEditor().mouseMove(e.getPoint());
            }
        });
        paneEditorInfo.getPaneNlbFacade().addObserver((NLBObserver)this);
    }

    private File chooseSaveDir() {
        int returnVal = this.m_dirChooser.showSaveDialog(this.m_mainFramePanel);
        if (returnVal == 0) {
            return this.m_dirChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseExportDir() {
        int returnVal = this.m_dirChooser.showSaveDialog(this.m_mainFramePanel);
        if (returnVal == 0) {
            return this.m_dirChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseExportFile(String defaultName) {
        this.m_fileChooser.setSelectedFile(new File(defaultName));
        int returnVal = this.m_fileChooser.showSaveDialog(this.m_mainFramePanel);
        if (returnVal == 0) {
            return this.m_fileChooser.getSelectedFile();
        }
        return null;
    }

    private void enableLinkedButton(JToggleButton pressedButton, JToggleButton ... linkedButtons) {
        if (pressedButton.isSelected()) {
            for (JToggleButton linkedButton : linkedButtons) {
                linkedButton.setEnabled(false);
            }
        } else {
            for (JToggleButton linkedButton : linkedButtons) {
                linkedButton.setEnabled(true);
            }
        }
    }

    private void createUIComponents() {
        this.m_toolbarPanel = new JPanel();
    }

    private void rearrangeCustomComponents() {
        this.m_toolbarPanel.setLayout(new WrapLayout(0, 5, 5));
        this.m_toolbarPanel.setSize(new Dimension(300, 1));
    }

    public void serrext() {
        this.m_statusBar.setVisible(false);
        this.m_statusBar.setEnabled(false);
    }

    public void updateView() {
        PaneEditorInfo paneEditorInfo;
        PaneEditorInfo editorInfo = this.getSelectedPaneInfo();
        NonLinearBookFacade facade = editorInfo.getPaneNlbFacade();
        this.m_undoButton.setEnabled(facade.canUndo());
        this.m_redoButton.setEnabled(facade.canRedo());
        this.m_pullButton.setEnabled(!facade.hasChanges());
        NonLinearBook nlb = facade.getNlb();
        NonLinearBook.BookStatistics bookStats = nlb.getBookStatistics();
        NonLinearBook.VariableStatistics variableStats = nlb.getVariableStatistics();
        for (NonLinearBook.ModuleInfo info : bookStats.getModuleInfos()) {
            paneEditorInfo = this.m_paneEditorInfoMap.get(info.getModulePageId());
            if (paneEditorInfo == null) continue;
            if (paneEditorInfo.getPaneIndex() != -1) {
                paneEditorInfo.getTabComponent().setTabName(info.getModuleName());
                continue;
            }
            if (paneEditorInfo.isClosedManually()) continue;
            this.addGraphEditorTab(info.getModuleName(), paneEditorInfo);
        }
        for (NonLinearBook.ModuleInfo info : bookStats.getModulesToBeDeletedInfos()) {
            paneEditorInfo = this.m_paneEditorInfoMap.get(info.getModulePageId());
            if (paneEditorInfo == null || paneEditorInfo.getPaneIndex() == -1) continue;
            paneEditorInfo.getTabComponent().close();
        }
        this.setBookInfoPaneData(bookStats, variableStats);
    }

    private void setBookInfoPaneData(NonLinearBook.BookStatistics bookStats, NonLinearBook.VariableStatistics variableStats) {
        StringBuilder builder = new StringBuilder();
        builder.append("Pages count: ").append(bookStats.getPagesCount());
        builder.append("\r\n");
        builder.append("Objs count: ").append(bookStats.getObjsCount());
        builder.append("\r\n");
        builder.append("Unique endings: ").append(bookStats.getUniqueEndings());
        builder.append("\r\n");
        builder.append("Characters count: ").append(bookStats.getCharactersCount());
        builder.append("\r\n");
        builder.append("Modules count: ").append(bookStats.getModulesCount());
        builder.append("\r\n");
        builder.append("Modules: ");
        builder.append("\r\n");
        for (NonLinearBook.ModuleInfo info : bookStats.getModuleInfos()) {
            builder.append(info.toString());
            builder.append("\r\n");
        }
        builder.append("Modules to be deleted: ");
        builder.append("\r\n");
        for (NonLinearBook.ModuleInfo info : bookStats.getModulesToBeDeletedInfos()) {
            builder.append(info.toString());
            builder.append("\r\n");
        }
        builder.append("Page variable count: ").append(variableStats.getPageVariablesCount());
        builder.append("\r\n");
        builder.append("Page timer variable count: ").append(variableStats.getPageTimerVariablesCount());
        builder.append("\r\n");
        builder.append("Obj variable count: ").append(variableStats.getObjVariablesCount());
        builder.append("\r\n");
        builder.append("Obj constraints count: ").append(variableStats.getObjConstraintsCount());
        builder.append("\r\n");
        builder.append("Obj refs count: ").append(variableStats.getObjRefsCount());
        builder.append("\r\n");
        builder.append("Link variable count: ").append(variableStats.getLinkVariablesCount());
        builder.append("\r\n");
        builder.append("Link constraint count: ").append(variableStats.getLinkConstraintVariablesCount());
        builder.append("\r\n");
        builder.append("Plain variables count: ").append(variableStats.getPlainVariablesCount());
        builder.append("\r\n");
        builder.append("Expressions count: ").append(variableStats.getExpressionsCount());
        builder.append("\r\n");
        builder.append("Module constraint count: ").append(variableStats.getModuleConstraintCount());
        builder.append("\r\n");
        builder.append("Autowire constraint count: ").append(variableStats.getAutowireConstraintCount());
        builder.append("\r\n");
        this.m_bookInformationArea.setText(builder.toString());
    }

    private PaneEditorInfo getSelectedPaneInfo() {
        int selectedIndex = this.m_graphEditorsPane.getSelectedIndex();
        if (selectedIndex == -1) {
            return this.getMainPaneInfo();
        }
        for (Map.Entry<String, PaneEditorInfo> entry : this.m_paneEditorInfoMap.entrySet()) {
            if (entry.getValue().getPaneIndex() != selectedIndex) continue;
            return entry.getValue();
        }
        assert (false);
        return null;
    }

    private PaneEditorInfo getMainPaneInfo() {
        return this.m_paneEditorInfoMap.get(MAIN_PANE_KEY);
    }

    private class PaneEditorInfo {
        public static final int INDEX_UNDEFINED = -1;
        private TabComponent m_tabComponent;
        private final String m_modulePageId;
        private final NonLinearBookFacade m_paneNlbFacade;
        private final GraphEditor m_paneGraphEditor;
        private int m_paneIndex;
        private boolean m_closedManually = false;

        private PaneEditorInfo(String modulePageId, NonLinearBookFacade paneNlbFacade, GraphEditor paneGraphEditor, int paneIndex) {
            this.m_modulePageId = modulePageId;
            this.m_paneNlbFacade = paneNlbFacade;
            this.m_paneGraphEditor = paneGraphEditor;
            this.m_paneIndex = paneIndex;
        }

        private boolean isClosedManually() {
            return this.m_closedManually;
        }

        private void setClosedManually(boolean closedManually) {
            this.m_closedManually = closedManually;
        }

        private TabComponent getTabComponent() {
            return this.m_tabComponent;
        }

        private void setTabComponent(TabComponent tabComponent) {
            this.m_tabComponent = tabComponent;
        }

        private String getModulePageId() {
            return this.m_modulePageId;
        }

        private NonLinearBookFacade getPaneNlbFacade() {
            return this.m_paneNlbFacade;
        }

        private GraphEditor getPaneGraphEditor() {
            return this.m_paneGraphEditor;
        }

        private int getPaneIndex() {
            return this.m_paneIndex;
        }

        private void setPaneIndex(int paneIndex) {
            this.m_paneIndex = paneIndex;
        }
    }

    class SaveAsImageTask
    extends Task {
        File m_imageFile;

        SaveAsImageTask(File imageFile) {
            this.m_imageFile = imageFile;
        }

        @Override
        protected Void doInBackground() throws Exception {
            try {
                MainFrame.this.getSelectedPaneInfo().getPaneGraphEditor().saveAsImage(this.m_imageFile, this);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while exporting to PNG: " + ex.toString());
            }
            return null;
        }

        @Override
        public void done() {
            super.done();
            MainFrame.this.m_exportPNG.setEnabled(true);
        }
    }

    class SaveTask
    extends Task {
        SaveTask() {
        }

        @Override
        protected Void doInBackground() {
            try {
                PaneEditorInfo editorInfo = MainFrame.this.getMainPaneInfo();
                editorInfo.getPaneGraphEditor().save(this);
            }
            catch (NLBConsistencyException | NLBFileManipulationException | NLBIOException | NLBVCSException ex) {
                JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while saving: " + ex.toString());
            }
            return null;
        }

        @Override
        public void done() {
            super.done();
            MainFrame.this.m_saveFileButton.setEnabled(true);
            MainFrame.this.m_saveFileAsButton.setEnabled(true);
        }
    }

    class SaveAsTask
    extends Task {
        File m_saveDir;

        SaveAsTask(File saveDir) {
            this.m_saveDir = saveDir;
        }

        @Override
        protected Void doInBackground() {
            try {
                PaneEditorInfo editorInfo = MainFrame.this.getMainPaneInfo();
                editorInfo.getPaneGraphEditor().saveAs(this.m_saveDir, this);
            }
            catch (NLBConsistencyException | NLBFileManipulationException | NLBIOException | NLBVCSException ex) {
                JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while saving: " + ex.toString());
            }
            return null;
        }

        @Override
        public void done() {
            super.done();
            MainFrame.this.m_saveFileButton.setEnabled(true);
            MainFrame.this.m_saveFileAsButton.setEnabled(true);
        }
    }

    class OpenTask
    extends Task {
        private File m_file;

        OpenTask(File file) {
            this.m_file = file;
        }

        @Override
        public Void doInBackground() {
            this.setProgress(0);
            try {
                MainFrame.this.clearAll();
                PaneEditorInfo editorInfo = MainFrame.this.getMainPaneInfo();
                editorInfo.getPaneGraphEditor().load(this.m_file, this);
                this.setProgressValue(85);
                this.setNoteText("Opening panes...");
                MainFrame.this.openModulesPanes();
                this.setNoteText("All done!");
                this.setProgressValue(100);
            }
            catch (NLBConsistencyException | NLBIOException | NLBVCSException ex) {
                JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while loading: " + ex.toString());
            }
            return null;
        }

        @Override
        public void done() {
            super.done();
            MainFrame.this.m_openFileButton.setEnabled(true);
        }
    }

    class PushTask
    extends Task {
        private String m_userName;
        private String m_password;

        PushTask(String userName, String password) {
            this.m_userName = userName;
            this.m_password = password;
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.setProgress(0);
            try {
                PaneEditorInfo editorInfo = MainFrame.this.getMainPaneInfo();
                editorInfo.getPaneNlbFacade().push(this.m_userName, this.m_password, (ProgressData)this);
                this.setProgressValue(100);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while pushing: " + ex.toString());
            }
            return null;
        }

        @Override
        public void done() {
            super.done();
            MainFrame.this.m_pushButton.setEnabled(true);
        }
    }

    class PullTask
    extends Task {
        private String m_userName;
        private String m_password;
        private PropertyChangeListener m_listener;

        PullTask(String userName, String password, PropertyChangeListener listener) {
            this.m_userName = userName;
            this.m_password = password;
            this.m_listener = listener;
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.setProgress(0);
            try {
                PaneEditorInfo editorInfo = MainFrame.this.getMainPaneInfo();
                editorInfo.getPaneNlbFacade().pull(this.m_userName, this.m_password, (ProgressData)this);
                this.setProgressValue(100);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(MainFrame.this.m_mainFramePanel, "Error while pulling: " + ex.toString());
            }
            return null;
        }

        @Override
        public void done() {
            super.done();
            MainFrame.this.m_pullButton.setEnabled(true);
            MainFrame.this.m_task = new OpenTask(MainFrame.this.getMainPaneInfo().getPaneNlbFacade().getNlb().getRootDir());
            MainFrame.this.m_task.addPropertyChangeListener(this.m_listener);
            MainFrame.this.m_openFileButton.setEnabled(false);
            MainFrame.this.m_task.execute();
        }
    }

    abstract class Task
    extends SwingWorker<Void, Void>
    implements ProgressData {
        Task() {
        }

        public void setProgressValue(int progress) {
            this.setProgress(Math.min(progress, 100));
        }

        public void setNoteText(String text) {
            MainFrame.this.m_progressMonitor.setNote(text);
        }

        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
            MainFrame.this.m_progressMonitor.setProgress(100);
        }
    }
}

