/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.view;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.builder.view.NodePath;
import com.nlbhub.nlb.builder.view.NodeResizeExecutor;
import com.nlbhub.nlb.util.StringHelper;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

public class PagePath
extends NodePath {
    private static final int MAX_CAPTION_CHARS_IN_PAGE_TEXT = 330;
    private final PText m_startPointNode = new PText("<S>");

    public PagePath(NonLinearBook nonLinearBook, NodeResizeExecutor nodeResizeExecutor, Page page, Font font) {
        super(nodeResizeExecutor, (NodeItem)page, font);
        this.m_startPointNode.setVisible(page.getId().equals(nonLinearBook.getStartPoint()));
        this.addChild((PNode)this.m_startPointNode);
        this.m_startPointNode.setFont(font);
        this.m_startPointNode.setPickable(false);
        this.setPaint(Color.white);
        this.addAttribute("nlbpage", page);
        this.addAttribute("nlbmod", nonLinearBook);
        this.resizeNode(page.getCoords());
    }

    @Override
    public void updateView() {
        Page page = (Page)this.getAttribute("nlbpage");
        NonLinearBook nonLinearBook = (NonLinearBook)this.getAttribute("nlbmod");
        this.m_startPointNode.setVisible(page.getId().equals(nonLinearBook.getStartPoint()));
        super.updateView();
    }

    @Override
    protected void resizeNode(Coords coords) {
        super.resizeNode(coords);
        this.m_startPointNode.setBounds((Rectangle2D)this.getNodeRect());
    }

    @Override
    protected String buildText() {
        Page page = (Page)this.getAttribute("nlbpage");
        NonLinearBook nonLinearBook = (NonLinearBook)this.getAttribute("nlbmod");
        Variable variable = nonLinearBook.getVariableById(page.getVarId());
        StringBuilder text = new StringBuilder();
        if (!StringHelper.isEmpty((String)page.getCaption())) {
            int captionSize = page.getCaption().length();
            if (captionSize > 330) {
                text.append(page.getCaption().substring(0, 330));
                text.append("...");
            } else {
                text.append(page.getCaption());
            }
            if (variable != null) {
                text.append(": ");
            }
        }
        if (variable != null) {
            text.append("[").append(variable.getName()).append("]");
        }
        return text.toString();
    }
}

