/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.api;

import com.nlbhub.nlb.api.Modification;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.domain.ModificationImpl;
import com.nlbhub.nlb.domain.VariableImpl;
import com.nlbhub.nlb.util.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ModificationsTableModel {
    private NonLinearBook m_currentNLB;
    private List<ModificationImpl> m_modifications;
    private Map<String, VariableImpl> m_variableMap;

    public ModificationsTableModel(NonLinearBook nlb, List<Modification> modifications) {
        this.m_currentNLB = nlb;
        this.m_modifications = new ArrayList<ModificationImpl>();
        this.m_variableMap = new HashMap<String, VariableImpl>();
        for (Modification modification : modifications) {
            Variable expression;
            Variable variable = nlb.getVariableById(modification.getVarId());
            if (variable != null) {
                this.m_variableMap.put(modification.getVarId(), new VariableImpl(variable, this.m_currentNLB));
            }
            if ((expression = nlb.getVariableById(modification.getExprId())) != null) {
                this.m_variableMap.put(modification.getExprId(), new VariableImpl(expression, this.m_currentNLB));
            }
            this.m_modifications.add(new ModificationImpl(modification, this.m_currentNLB));
        }
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "External";
            }
            case 1: {
                return "Modification Id";
            }
            case 2: {
                return "DataType";
            }
            case 3: {
                return "Variable";
            }
            case 4: {
                return "Operation";
            }
            case 5: {
                return "Expression";
            }
        }
        return "N/A";
    }

    public int getRowCount() {
        int i = 0;
        for (Modification modification : this.m_modifications) {
            if (modification.isDeleted()) continue;
            ++i;
        }
        return i;
    }

    public int getColumnCount() {
        return 6;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ModificationImpl modification = this.getModificationAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return modification.isExternal();
            }
            case 1: {
                return modification.getId();
            }
            case 2: {
                VariableImpl expression = this.getExpression(modification);
                return expression != null ? expression.getDataType() : Variable.DEFAULT_DATATYPE;
            }
            case 3: {
                VariableImpl variable = this.getVariable(modification);
                return variable != null ? variable.getName() : "";
            }
            case 4: {
                return modification.getType();
            }
            case 5: {
                VariableImpl expression = this.getExpression(modification);
                return expression != null ? expression.getValue() : "";
            }
        }
        return "N/A";
    }

    private VariableImpl getVariable(Modification modification) {
        String varId = modification.getVarId();
        return this.m_variableMap.get(varId);
    }

    private VariableImpl getExpression(Modification modification) {
        String varId = modification.getExprId();
        return this.m_variableMap.get(varId);
    }

    public boolean setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ModificationImpl modification = this.getModificationAt(rowIndex);
        String cellValue = aValue.toString();
        switch (columnIndex) {
            case 0: {
                boolean externalFlag = (Boolean)aValue;
                modification.setExternal(externalFlag);
                break;
            }
            case 2: {
                this.setDataType(modification, cellValue);
                break;
            }
            case 3: {
                VariableImpl variable = this.getVariable(modification);
                if (variable != null) {
                    if (StringHelper.isEmpty(cellValue)) {
                        variable.setDeleted(true);
                        modification.setVarId("");
                        break;
                    }
                    variable.setName(cellValue);
                    break;
                }
                if (StringHelper.isEmpty(cellValue)) break;
                VariableImpl expression = this.getExpression(modification);
                variable = new VariableImpl(this.m_currentNLB, Variable.Type.VAR, expression != null ? expression.getDataType() : Variable.DEFAULT_DATATYPE, cellValue, "N/A", modification.getFullId());
                this.m_variableMap.put(variable.getId(), variable);
                modification.setVarId(variable.getId());
                break;
            }
            case 4: {
                modification.setType(cellValue);
                VariableImpl expr = this.getExpression(modification);
                if (expr == null) break;
                if (modification.getType() == Modification.Type.TAG) {
                    expr.setType(Variable.Type.TAG);
                    break;
                }
                expr.setType(Variable.Type.EXPRESSION);
                break;
            }
            case 5: {
                VariableImpl expression = this.getExpression(modification);
                if (expression != null) {
                    if (StringHelper.isEmpty(cellValue)) {
                        expression.setDeleted(true);
                        modification.setExprId("");
                        break;
                    }
                    expression.setValue(cellValue);
                    break;
                }
                if (StringHelper.isEmpty(cellValue)) break;
                expression = new VariableImpl(this.m_currentNLB, modification.getType() == Modification.Type.TAG ? Variable.Type.TAG : Variable.Type.EXPRESSION, Variable.DEFAULT_DATATYPE, "N/A", cellValue, modification.getFullId());
                this.m_variableMap.put(expression.getId(), expression);
                modification.setExprId(expression.getId());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void setDataType(ModificationImpl modification, String cellValue) {
        VariableImpl variable = this.getVariable(modification);
        VariableImpl expression = this.getExpression(modification);
        if (cellValue.equals(Variable.DataType.STRING.name())) {
            if (variable != null) {
                variable.setDataType(Variable.DataType.STRING);
            }
            if (expression != null) {
                expression.setDataType(Variable.DataType.STRING);
            }
        } else if (cellValue.equals(Variable.DataType.BOOLEAN.name())) {
            if (variable != null) {
                variable.setDataType(Variable.DataType.BOOLEAN);
            }
            if (expression != null) {
                expression.setDataType(Variable.DataType.BOOLEAN);
            }
        } else if (cellValue.equals(Variable.DataType.NUMBER.name())) {
            if (variable != null) {
                variable.setDataType(Variable.DataType.NUMBER);
            }
            if (expression != null) {
                expression.setDataType(Variable.DataType.NUMBER);
            }
        } else {
            if (variable != null) {
                variable.setDataType(Variable.DataType.AUTO);
            }
            if (expression != null) {
                expression.setDataType(Variable.DataType.AUTO);
            }
        }
    }

    private ModificationImpl getModificationAt(int rowIndex) {
        int i = 0;
        for (ModificationImpl modification : this.m_modifications) {
            if (modification.isDeleted()) continue;
            if (i == rowIndex) {
                return modification;
            }
            ++i;
        }
        return null;
    }

    public List<String> getModificationIdsAt(int[] rowIndexArray) {
        LinkedList<String> result = new LinkedList<String>();
        for (int rowIndex : rowIndexArray) {
            result.add(this.getModificationAt(rowIndex).getId());
        }
        return result;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 1;
    }

    public void add(ModifyingItem modifyingItem) {
        this.m_modifications.add(new ModificationImpl(modifyingItem));
    }

    public void remove(List<String> modificationIds) {
        for (ModificationImpl modification : this.m_modifications) {
            if (!modificationIds.contains(modification.getId())) continue;
            modification.setDeleted(true);
        }
    }

    public List<Modification> getModifications() {
        ArrayList<Modification> result = new ArrayList<Modification>();
        result.addAll(this.m_modifications);
        return result;
    }

    public Map<String, Variable> getVariableMap() {
        HashMap<String, Variable> result = new HashMap<String, Variable>();
        result.putAll(this.m_variableMap);
        return result;
    }

    public void moveUp(int rowIndex) {
        if (rowIndex > 0) {
            ModificationImpl item = this.m_modifications.remove(rowIndex - 1);
            this.m_modifications.add(rowIndex, item);
        }
    }

    public void moveDown(int rowIndex) {
        if (rowIndex < this.m_modifications.size() - 1) {
            ModificationImpl item = this.m_modifications.remove(rowIndex + 1);
            this.m_modifications.add(rowIndex, item);
        }
    }
}

