/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.api;

import com.nlbhub.nlb.api.MediaFile;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.ProgressData;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.api.SearchResultTableModel;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.domain.MediaExportParameters;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.user.domain.History;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptException;

public interface NonLinearBook {
    public static final String TRUE_VARID = "TRUE";
    public static final String FALSE_VARID = "FALSE";
    public static final String LC_VARID_PREFIX = "LC_";
    public static final String LC_VARID_SEPARATOR_OUT = "_OUT_";
    public static final String SOUND_DIR_NAME = "sound";
    public static final String IMAGES_DIR_NAME = "images";
    public static final String DEFAULT_STARTPOINT = "";
    public static final Theme DEFAULT_THEME = Theme.DEFAULT;
    public static final String DEFAULT_LANGUAGE = "ru";
    public static final String DEFAULT_LICENSE = "";
    public static final boolean DEFAULT_FULL_AUTOWIRE = false;
    public static final boolean DEFAULT_SUPPRESS_MEDIA = false;
    public static final boolean DEFAULT_SUPPRESS_SOUND = false;
    public static final String DEFAULT_TITLE = "";
    public static final String DEFAULT_AUTHOR = "";
    public static final String DEFAULT_VERSION = "";
    public static final String DEFAULT_PERFECT_GAME_ACHIEVEMENT_NAME = "";

    public Set<String> getAllAchievementNames(boolean var1);

    public String getPerfectGameAchievementName();

    public boolean isEmpty();

    public String getStartPoint();

    public String getLanguage();

    public String getLicense();

    public Theme getTheme();

    public boolean isFullAutowire();

    public boolean isSuppressMedia();

    public boolean isSuppressSound();

    public String getTitle();

    public String getAuthor();

    public String getVersion();

    public File getRootDir();

    public File getImagesDir();

    public Set<String> getUsedImages();

    public Set<String> getUsedSounds();

    public List<MediaFile> getImageFiles();

    public List<MediaFile> getSoundFiles();

    public void exportMedia(boolean var1, File var2, String var3, List<MediaFile> var4, MediaFile.Type var5) throws NLBExportException;

    public Map<String, Page> getPages();

    public Map<String, Page> getDownwardPagesHeirarchy();

    public Map<String, Page> getUpwardPagesHeirarchy();

    public List<String> getAutowiredPagesIds();

    public List<String> getParentGlobalAutowiredPagesIds();

    public boolean isAutowired(String var1);

    public Page getPageById(String var1);

    public Map<String, Obj> getObjs();

    public Obj getObjById(String var1);

    public Page createFilteredPage(String var1, History var2) throws ScriptException, NLBConsistencyException;

    public boolean load(String var1, ProgressData var2) throws NLBIOException, NLBConsistencyException, NLBVCSException;

    public Variable getVariableById(String var1);

    public List<Variable> getVariables();

    public SearchResultTableModel getLeafs(String var1);

    public SearchResultTableModel searchText(SearchContract var1, String var2);

    public SearchResultTableModel getVariables(String var1) throws NLBConsistencyException;

    public boolean findVariable(String var1) throws NLBConsistencyException;

    public SearchResultTableModel checkBook(String var1) throws NLBConsistencyException;

    public BookStatistics getBookStatistics();

    public VariableStatistics getVariableStatistics();

    public NonLinearBook getParentNLB();

    public boolean isDummy();

    public Page getParentPage();

    public Map<String, NonLinearBook> getExternalModules();

    public NonLinearBook findExternalModule(String var1);

    public Map<String, Variable.DataType> getVariableDataTypes() throws NLBConsistencyException;

    public Map<String, String> getMediaToConstraintMap();

    public Map<String, String> getMediaRedirectsMap();

    public Map<String, MediaExportParameters> getMediaExportParametersMap();

    public Map<String, Boolean> getMediaFlagsMap();

    public static class VariableStatistics {
        private int m_pageVariablesCount = 0;
        private int m_pageTimerVariablesCount = 0;
        private int m_objVariablesCount = 0;
        private int m_objConstraintsCount = 0;
        private int m_objRefsCount = 0;
        private int m_linkVariablesCount = 0;
        private int m_linkConstraintVariablesCount = 0;
        private int m_plainVariablesCount = 0;
        private int m_expressionsCount = 0;
        private int m_moduleConstraintCount = 0;
        private int m_autowireConstraintCount = 0;

        public int getPageVariablesCount() {
            return this.m_pageVariablesCount;
        }

        public void incPageVariablesCount() {
            ++this.m_pageVariablesCount;
        }

        public int getPageTimerVariablesCount() {
            return this.m_pageTimerVariablesCount;
        }

        public void incPageTimerVariablesCount() {
            ++this.m_pageTimerVariablesCount;
        }

        public int getObjVariablesCount() {
            return this.m_objVariablesCount;
        }

        public void incObjVariablesCount() {
            ++this.m_objVariablesCount;
        }

        public int getObjConstraintsCount() {
            return this.m_objConstraintsCount;
        }

        public int getObjRefsCount() {
            return this.m_objRefsCount;
        }

        public void incObjConstraintsCount() {
            ++this.m_objConstraintsCount;
        }

        public void incObjRefsCount() {
            ++this.m_objRefsCount;
        }

        public int getLinkVariablesCount() {
            return this.m_linkVariablesCount;
        }

        public void incLinkVariablesCount() {
            ++this.m_linkVariablesCount;
        }

        public int getLinkConstraintVariablesCount() {
            return this.m_linkConstraintVariablesCount;
        }

        public void incLinkConstraintVariablesCount() {
            ++this.m_linkConstraintVariablesCount;
        }

        public int getPlainVariablesCount() {
            return this.m_plainVariablesCount;
        }

        public void incPlainVariablesCount() {
            ++this.m_plainVariablesCount;
        }

        public int getExpressionsCount() {
            return this.m_expressionsCount;
        }

        public void incExpressionsCount() {
            ++this.m_expressionsCount;
        }

        public int getModuleConstraintCount() {
            return this.m_moduleConstraintCount;
        }

        public void incModuleConstraintCount() {
            ++this.m_moduleConstraintCount;
        }

        public int getAutowireConstraintCount() {
            return this.m_autowireConstraintCount;
        }

        public void incAutowireConstraintCount() {
            ++this.m_autowireConstraintCount;
        }
    }

    public static class BookStatistics {
        private int m_pagesCount = 0;
        private int m_objsCount = 0;
        private int m_uniqueEndings = 0;
        private int m_charactersCount = 0;
        private List<ModuleInfo> m_moduleInfos = new ArrayList<ModuleInfo>();
        private List<ModuleInfo> m_modulesToBeDeletedInfos = new ArrayList<ModuleInfo>();

        public List<ModuleInfo> getModuleInfos() {
            return this.m_moduleInfos;
        }

        public void addModuleInfo(ModuleInfo moduleInfo) {
            this.m_moduleInfos.add(moduleInfo);
        }

        public List<ModuleInfo> getModulesToBeDeletedInfos() {
            return this.m_modulesToBeDeletedInfos;
        }

        public void addModuleToBeDeletedInfo(ModuleInfo moduleInfo) {
            this.m_modulesToBeDeletedInfos.add(moduleInfo);
        }

        public int getPagesCount() {
            return this.m_pagesCount;
        }

        public void incPagesCount(int pagesCount) {
            this.m_pagesCount += pagesCount;
        }

        public int getObjsCount() {
            return this.m_objsCount;
        }

        public void incObjsCount(int objsCount) {
            this.m_objsCount += objsCount;
        }

        public int getUniqueEndings() {
            return this.m_uniqueEndings;
        }

        public void incUniqueEndings(int uniqueEndings) {
            this.m_uniqueEndings += uniqueEndings;
        }

        public int getCharactersCount() {
            return this.m_charactersCount;
        }

        public void incCharactersCount(int charactersCount) {
            this.m_charactersCount += charactersCount;
        }

        public void addBookStatistics(BookStatistics bookStatistics) {
            this.m_pagesCount += bookStatistics.m_pagesCount;
            this.m_objsCount += bookStatistics.m_objsCount;
            this.m_uniqueEndings += bookStatistics.m_uniqueEndings;
            this.m_charactersCount += bookStatistics.m_charactersCount;
            this.m_moduleInfos.addAll(bookStatistics.m_moduleInfos);
            this.addDeletedModulesFromBookStatistics(bookStatistics);
        }

        public void addDeletedModulesFromBookStatistics(BookStatistics bookStatistics) {
            this.m_modulesToBeDeletedInfos.addAll(bookStatistics.m_modulesToBeDeletedInfos);
        }

        public int getModulesCount() {
            return this.m_moduleInfos.size();
        }
    }

    public static class ModuleInfo {
        private String m_modulePageId;
        private String m_moduleName;
        private int m_depth;

        public ModuleInfo(String modulePageId, String moduleName, int depth) {
            this.m_modulePageId = modulePageId;
            this.m_moduleName = moduleName;
            this.m_depth = depth;
        }

        public String getModulePageId() {
            return this.m_modulePageId;
        }

        public String getModuleName() {
            return this.m_moduleName;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.m_depth - 1; ++i) {
                result.append("  ");
            }
            if (this.m_depth >= 1) {
                result.append("\u2570");
            }
            result.append(this.m_moduleName);
            return result.toString();
        }
    }
}

