/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.api;

import com.nlbhub.nlb.api.config.Config;
import com.nlbhub.nlb.api.config.Export;
import com.nlbhub.nlb.api.config.General;
import com.nlbhub.nlb.api.config.Settings;
import com.nlbhub.nlb.api.config.Text;
import com.nlbhub.nlb.exception.NLBJAXBException;
import com.nlbhub.nlb.util.JaxbMarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PropertyManager {
    private static final JaxbMarshaller CONFIGS_MARSHALLER = new JaxbMarshaller(Settings.class, Config.class, General.class, Export.class, Text.class);
    private static Settings m_settings;

    public static void init() throws IOException, NLBJAXBException {
        m_settings = PropertyManager.readSettings();
    }

    public static Settings getSettings() {
        return m_settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Settings readSettings() throws IOException, NLBJAXBException {
        try (InputStream input = null;){
            Settings settings;
            File configDir = new File("cfg");
            if (!configDir.exists()) {
                throw new IOException("Config dir 'cfg' does not exist!");
            }
            File configFile = new File(configDir, "config.xml");
            if (!configFile.exists()) {
                throw new IOException("Config file 'cfg/config.xml' does not exist!");
            }
            input = new FileInputStream(configFile);
            Settings settings2 = settings = (Settings)CONFIGS_MARSHALLER.unmarshal(input);
            return settings2;
        }
    }
}

