/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.Modification;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.domain.AbstractIdentifiableItem;
import com.nlbhub.nlb.domain.ModificationImpl;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.FileManipulator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.jetbrains.annotations.NotNull;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class AbstractModifyingItem
extends AbstractIdentifiableItem
implements ModifyingItem {
    private static final String MODIFICATIONS_DIR_NAME = "modifications";
    private static final String MODORDER_FILE_NAME = "modorder";
    private static final String MODORDER_SEPARATOR = "\n";
    private List<ModificationImpl> m_modifications = new ArrayList<ModificationImpl>();

    public AbstractModifyingItem() {
    }

    protected AbstractModifyingItem(NonLinearBook currentNLB) {
        super(currentNLB);
    }

    protected AbstractModifyingItem(ModifyingItem modifyingItem, NonLinearBook currentNLB) {
        super(modifyingItem, currentNLB);
        for (Modification modification : modifyingItem.getModifications()) {
            ModificationImpl modificationImpl = new ModificationImpl(modification, (ModifyingItem)this, currentNLB);
            this.m_modifications.add(modificationImpl);
        }
    }

    @Override
    public List<Modification> getModifications() {
        ArrayList<Modification> result = new ArrayList<Modification>();
        result.addAll(this.getModificationImpls());
        return result;
    }

    @Override
    public boolean hasNoModifications() {
        if (this.m_modifications.size() > 0) {
            for (ModificationImpl modification : this.m_modifications) {
                if (modification.isDeleted()) continue;
                return false;
            }
        }
        return true;
    }

    @XmlElement(name="modification")
    public List<ModificationImpl> getModificationImpls() {
        return this.m_modifications;
    }

    public void addModification(@NotNull ModificationImpl modification) {
        this.m_modifications.add(modification);
    }

    @Override
    public ModificationImpl getModificationById(@NotNull String modId) {
        for (ModificationImpl modification : this.m_modifications) {
            if (!modId.equals(modification.getId())) continue;
            return modification;
        }
        return null;
    }

    protected void writeModifications(FileManipulator fileManipulator, File itemDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        File modificationsDir = new File(itemDir, MODIFICATIONS_DIR_NAME);
        if (this.m_modifications.isEmpty()) {
            if (modificationsDir.exists()) {
                fileManipulator.deleteFileOrDir(modificationsDir);
            }
        } else {
            fileManipulator.createDir(modificationsDir, "Cannot create modifications directory for item with Id = " + this.getId());
            for (ModificationImpl modification : this.m_modifications) {
                modification.writeModification(fileManipulator, modificationsDir);
            }
        }
    }

    protected void readModifications(File itemDir) throws NLBIOException, NLBConsistencyException {
        String modOrderString = FileManipulator.getOptionalFileAsString(itemDir, MODORDER_FILE_NAME, "");
        File modsDir = new File(itemDir, MODIFICATIONS_DIR_NAME);
        if (!modsDir.exists() && !modOrderString.isEmpty()) {
            throw new NLBIOException("Invalid NLB structure: modifications directory does not exist for item with Id = " + this.getId() + ", but some modifications should be specified");
        }
        this.m_modifications.clear();
        File[] modDirs = modsDir.listFiles();
        if (modDirs == null) {
            if (modOrderString.isEmpty()) {
                modDirs = new File[]{};
            } else {
                throw new NLBIOException("Error when enumerating modifications' directory contents for item with Id = " + this.getId());
            }
        }
        if (modOrderString.isEmpty()) {
            if (modDirs.length > 0) {
                throw new NLBConsistencyException("Inconsistent NLB structure: 'modifications' directory should be empty for item with id = " + this.getId());
            }
        } else {
            List<String> modOrderList = Arrays.asList(modOrderString.split(MODORDER_SEPARATOR));
            List<File> modDirsSortedList = this.createSortedDirList(modDirs, modOrderList);
            for (int i = 0; i < modDirsSortedList.size(); ++i) {
                ModificationImpl modification = new ModificationImpl(this);
                modification.readModification(modDirsSortedList.get(i));
                this.m_modifications.add(modification);
            }
        }
    }

    protected void writeModOrderFile(FileManipulator fileManipulator, File itemDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        StringBuilder sb = new StringBuilder();
        int lastElemIndex = this.m_modifications.size() - 1;
        if (lastElemIndex >= 0) {
            for (int i = 0; i < lastElemIndex; ++i) {
                ModificationImpl modification = this.m_modifications.get(i);
                if (modification.isDeleted()) continue;
                sb.append(modification.getId()).append(MODORDER_SEPARATOR);
            }
            if (!this.m_modifications.get(lastElemIndex).isDeleted()) {
                sb.append(this.m_modifications.get(lastElemIndex).getId());
            }
            fileManipulator.writeOptionalString(itemDir, MODORDER_FILE_NAME, String.valueOf(sb.toString()), "");
        } else {
            fileManipulator.writeOptionalString(itemDir, MODORDER_FILE_NAME, "", "");
        }
    }
}

