/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.NLBCommand;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.domain.AbstractModifyingItem;
import com.nlbhub.nlb.domain.CoordsImpl;
import com.nlbhub.nlb.domain.LinkImpl;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.ObjImpl;
import com.nlbhub.nlb.domain.ObserverHandler;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.FileManipulator;
import com.nlbhub.nlb.util.StringHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.bind.annotation.XmlElement;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNodeItem
extends AbstractModifyingItem
implements NodeItem {
    private static final String COORDS_DIR_NAME = "coords";
    private static final String LINKS_DIR_NAME = "links";
    private static final String LNKORDER_FILE_NAME = "lnkorder";
    private static final String LNKORDER_SEPARATOR = "\n";
    private static final String CONTENT_FILE_NAME = "content";
    private static final String CONTENT_SEPARATOR = "\n";
    private static final String DEFTAGID_FILE_NAME = "deftagid";
    private static final String STROKE_FILE_NAME = "stroke";
    private static final String FILL_FILE_NAME = "fill";
    private static final String TEXTCOLOR_FILE_NAME = "txtcolor";
    private String m_defaultTagId = "";
    private String m_stroke = "000000";
    private String m_fill = "00FF00";
    private String m_textColor = "000000";
    private CoordsImpl m_coords = new CoordsImpl();
    private List<LinkImpl> m_links = new LinkedList<LinkImpl>();
    private List<String> m_containedObjIds = new ArrayList<String>();
    private ObserverHandler m_observerHandler = new ObserverHandler();

    private void applyLinkSortingOrder(List<String> sortingOrder) {
        LinkedList<LinkImpl> sortedLinks = new LinkedList<LinkImpl>();
        for (String linkId : sortingOrder) {
            ListIterator<LinkImpl> linksIterator = this.m_links.listIterator();
            while (linksIterator.hasNext()) {
                LinkImpl link = linksIterator.next();
                if (!link.getId().equals(linkId)) continue;
                linksIterator.remove();
                sortedLinks.add(link);
            }
        }
        sortedLinks.addAll(this.m_links);
        this.m_links = sortedLinks;
    }

    public AbstractNodeItem() {
    }

    public AbstractNodeItem(@NotNull NodeItem nodeItem, NonLinearBook currentNLB) {
        super(nodeItem, currentNLB);
        this.m_defaultTagId = nodeItem.getDefaultTagId();
        this.m_stroke = nodeItem.getStroke();
        this.m_fill = nodeItem.getFill();
        this.m_textColor = nodeItem.getTextColor();
        Coords coords = nodeItem.getCoords();
        this.m_coords.setHeight(coords.getHeight());
        this.m_coords.setWidth(coords.getWidth());
        this.m_coords.setLeft(coords.getLeft());
        this.m_coords.setTop(coords.getTop());
        for (Link link : nodeItem.getLinks()) {
            this.m_links.add(new LinkImpl((NodeItem)this, link));
        }
        for (String containedObjId : nodeItem.getContainedObjIds()) {
            this.m_containedObjIds.add(containedObjId);
        }
    }

    ResizeNodeCommand createResizeNodeCommand(NodeItem.Orientation orientation, double deltaX, double deltaY, List<Link> adjacentLinks) {
        return new ResizeNodeCommand(orientation, deltaX, deltaY, adjacentLinks);
    }

    ResizeNodeCommand createResizeNodeCommand(NodeItem.Orientation orientation, double deltaX, double deltaY) {
        return new ResizeNodeCommand(orientation, deltaX, deltaY, new ArrayList<Link>());
    }

    AddLinkCommand createAddLinkCommand(LinkImpl link) {
        return new AddLinkCommand(link);
    }

    DeleteLinkCommand createDeleteLinkCommand(Link link) {
        return new DeleteLinkCommand(link);
    }

    SortLinksCommand createSortLinksCommand(List<Link> newSortingOrder) {
        ArrayList<String> idsSortingOrder = new ArrayList<String>();
        for (Link link : newSortingOrder) {
            idsSortingOrder.add(link.getId());
        }
        return new SortLinksCommand(this, idsSortingOrder);
    }

    protected AbstractNodeItem(NonLinearBook currentNLB) {
        super(currentNLB);
    }

    public AbstractNodeItem(NonLinearBook currentNLB, float left, float top) {
        super(currentNLB);
        this.m_coords.setLeft(left);
        this.m_coords.setTop(top);
        this.m_coords.setWidth(100.0f);
        this.m_coords.setHeight(50.0f);
    }

    @Override
    @XmlElement(name="default-tag-id")
    public String getDefaultTagId() {
        return this.m_defaultTagId;
    }

    public void setDefaultTagId(String defaultTagId) {
        this.m_defaultTagId = defaultTagId;
    }

    @Override
    @XmlElement(name="stroke")
    public String getStroke() {
        return this.m_stroke;
    }

    public void setStroke(String stroke) {
        this.m_stroke = stroke;
    }

    @Override
    @XmlElement(name="fill")
    public String getFill() {
        return this.m_fill;
    }

    public void setFill(String fill) {
        this.m_fill = fill;
    }

    @Override
    @XmlElement(name="textColor")
    public String getTextColor() {
        return this.m_textColor;
    }

    public void setTextColor(String textColor) {
        this.m_textColor = textColor;
    }

    @Override
    @XmlElement(name="containedobj")
    public List<String> getContainedObjIds() {
        return this.m_containedObjIds;
    }

    public void addContainedObjId(@NotNull String containedObjId) {
        this.m_containedObjIds.add(containedObjId);
    }

    public void removeContainedObjId(@NotNull String containedObjId) {
        ListIterator<String> iterator = this.m_containedObjIds.listIterator();
        while (iterator.hasNext()) {
            String temp = iterator.next();
            if (!containedObjId.equals(temp)) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public CoordsImpl getCoords() {
        return this.m_coords;
    }

    @Override
    public List<Link> getLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        result.addAll(this.getLinkImpls());
        return result;
    }

    @XmlElement(name="link")
    public List<LinkImpl> getLinkImpls() {
        return this.m_links;
    }

    public int getLinkCount() {
        return this.m_links.size();
    }

    public void addLink(@NotNull LinkImpl link) {
        this.m_links.add(link);
    }

    public void writeNodeItemProperties(@NotNull FileManipulator fileManipulator, @NotNull File nodeDir, @NotNull NonLinearBookImpl nonLinearBook) throws IOException, NLBIOException, NLBFileManipulationException, NLBVCSException {
        fileManipulator.writeOptionalString(nodeDir, DEFTAGID_FILE_NAME, this.m_defaultTagId, "");
        fileManipulator.writeOptionalString(nodeDir, STROKE_FILE_NAME, this.m_stroke, "000000");
        fileManipulator.writeOptionalString(nodeDir, FILL_FILE_NAME, this.m_fill, "00FF00");
        fileManipulator.writeOptionalString(nodeDir, TEXTCOLOR_FILE_NAME, this.m_textColor, "000000");
        this.writeLinkOrderFile(fileManipulator, nodeDir);
        this.writeContent(fileManipulator, nodeDir, nonLinearBook);
        this.writeCoords(fileManipulator, nodeDir);
        this.writeLinks(fileManipulator, nodeDir);
    }

    public void readNodeItemProperties(File nodeDir) throws NLBIOException, NLBConsistencyException {
        this.m_defaultTagId = FileManipulator.getOptionalFileAsString(nodeDir, DEFTAGID_FILE_NAME, "");
        this.m_stroke = FileManipulator.getOptionalFileAsString(nodeDir, STROKE_FILE_NAME, "000000");
        this.m_fill = FileManipulator.getOptionalFileAsString(nodeDir, FILL_FILE_NAME, "00FF00");
        this.m_textColor = FileManipulator.getOptionalFileAsString(nodeDir, TEXTCOLOR_FILE_NAME, "000000");
        this.readContent(nodeDir);
        this.readCoords(nodeDir);
        this.readLinks(nodeDir);
    }

    private void readLinks(File nodeDir) throws NLBIOException, NLBConsistencyException {
        String linkOrderString = FileManipulator.getOptionalFileAsString(nodeDir, LNKORDER_FILE_NAME, "");
        File linksDir = new File(nodeDir, LINKS_DIR_NAME);
        if (!linksDir.exists() && !linkOrderString.isEmpty()) {
            throw new NLBIOException("Invalid NLB structure: links directory does not exist for node with Id = " + this.getId() + ", but this node has existent links");
        }
        this.m_links.clear();
        File[] linkDirs = linksDir.listFiles();
        if (linkDirs == null) {
            if (linkOrderString.isEmpty()) {
                linkDirs = new File[]{};
            } else {
                throw new NLBIOException("Error when enumerating links' directory contents for node with Id = " + this.getId());
            }
        }
        if (linkOrderString.isEmpty()) {
            if (linkDirs.length > 0) {
                throw new NLBConsistencyException("Inconsistent NLB structure: 'links' directory should be empty for node with id = " + this.getId());
            }
        } else {
            List<String> linkOrderList = Arrays.asList(linkOrderString.split("\n"));
            List<File> linkDirsSortedList = this.createSortedDirList(linkDirs, linkOrderList);
            for (int i = 0; i < linkDirsSortedList.size(); ++i) {
                LinkImpl link = new LinkImpl(this);
                link.readLink(linkDirsSortedList.get(i));
                this.m_links.add(link);
            }
        }
    }

    private void readCoords(File nodeDir) throws NLBIOException {
        File coordsDir = new File(nodeDir, COORDS_DIR_NAME);
        if (!coordsDir.exists()) {
            throw new NLBIOException("Invalid NLB structure: coords directory does not exist for node with Id = " + this.getId());
        }
        this.m_coords.read(coordsDir);
    }

    @Override
    public LinkImpl getLinkById(@NotNull String linkId) {
        for (LinkImpl link : this.m_links) {
            if (!linkId.equals(link.getId())) continue;
            return link;
        }
        return null;
    }

    private void writeLinks(FileManipulator fileManipulator, File nodeDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        File linksDir = new File(nodeDir, LINKS_DIR_NAME);
        if (this.m_links.isEmpty()) {
            if (linksDir.exists()) {
                fileManipulator.deleteFileOrDir(linksDir);
            }
        } else {
            fileManipulator.createDir(linksDir, "Cannot create node links directory for node with Id = " + this.getId());
            for (LinkImpl link : this.m_links) {
                link.writeLink(fileManipulator, linksDir);
            }
        }
    }

    private void writeLinkOrderFile(FileManipulator fileManipulator, File nodeDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        StringBuilder sb = new StringBuilder();
        int lastElemIndex = this.m_links.size() - 1;
        if (lastElemIndex >= 0) {
            for (int i = 0; i < lastElemIndex; ++i) {
                LinkImpl link = this.m_links.get(i);
                if (link.isDeleted()) continue;
                sb.append(link.getId()).append("\n");
            }
            if (!this.m_links.get(lastElemIndex).isDeleted()) {
                sb.append(this.m_links.get(lastElemIndex).getId());
            }
            fileManipulator.writeOptionalString(nodeDir, LNKORDER_FILE_NAME, String.valueOf(sb.toString()), "");
        } else {
            fileManipulator.writeOptionalString(nodeDir, LNKORDER_FILE_NAME, "", "");
        }
    }

    private void writeCoords(FileManipulator fileManipulator, File nodeDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        File coordsDir = new File(nodeDir, COORDS_DIR_NAME);
        fileManipulator.createDir(coordsDir, "Cannot create node coords directory for node with Id = " + this.getId());
        this.m_coords.writeCoords(fileManipulator, coordsDir);
    }

    private void writeContent(FileManipulator fileManipulator, File nodeDir, NonLinearBookImpl nonLinearBook) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        StringBuilder sb = new StringBuilder();
        int lastElemIndex = this.m_containedObjIds.size() - 1;
        if (lastElemIndex >= 0) {
            for (int i = 0; i < lastElemIndex; ++i) {
                String objId = this.m_containedObjIds.get(i);
                ObjImpl obj = nonLinearBook.getObjImplById(objId);
                if (obj == null || obj.isDeleted()) continue;
                sb.append(objId).append("\n");
            }
            ObjImpl obj = nonLinearBook.getObjImplById(this.m_containedObjIds.get(lastElemIndex));
            if (obj != null && !obj.isDeleted()) {
                sb.append(this.m_containedObjIds.get(lastElemIndex));
            }
            fileManipulator.writeOptionalString(nodeDir, CONTENT_FILE_NAME, String.valueOf(sb.toString()), "");
        } else {
            fileManipulator.writeOptionalString(nodeDir, CONTENT_FILE_NAME, "", "");
        }
    }

    private void readContent(File nodeDir) throws NLBIOException, NLBConsistencyException {
        this.m_containedObjIds.clear();
        String contentString = FileManipulator.getOptionalFileAsString(nodeDir, CONTENT_FILE_NAME, "");
        if (!StringHelper.isEmpty(contentString)) {
            this.m_containedObjIds.addAll(Arrays.asList(contentString.split("\n")));
        }
    }

    public static void filterTargetLinkList(AbstractNodeItem target, AbstractNodeItem source, List<String> linkIdsToBeExcluded) {
        target.m_links = new ArrayList<LinkImpl>();
        for (LinkImpl link : source.m_links) {
            if (linkIdsToBeExcluded.contains(link.getId())) continue;
            target.m_links.add(new LinkImpl((NodeItem)target, link));
        }
    }

    public void removeLinkById(String linkId) {
        ListIterator<LinkImpl> iterator = this.m_links.listIterator();
        while (iterator.hasNext()) {
            LinkImpl temp = iterator.next();
            if (!temp.getId().equals(linkId)) continue;
            iterator.remove();
            break;
        }
    }

    void resizeNode(NodeItem.Orientation orientation, double deltaX, double deltaY) {
        CoordsImpl coords = this.getCoords();
        float ignoredDistance = 0.0f;
        switch (orientation) {
            case RIGHT: {
                float width = coords.getWidth() + (float)deltaX;
                if (width < 70.0f) {
                    width = 70.0f;
                }
                coords.setWidth(width);
                break;
            }
            case BOTTOM: {
                float height = coords.getHeight() + (float)deltaY;
                if (height < 35.0f) {
                    height = 35.0f;
                }
                coords.setHeight(height);
                break;
            }
            case LEFT: {
                float width = coords.getWidth() - (float)deltaX;
                if (width < 70.0f) {
                    ignoredDistance = 70.0f - width;
                    width = 70.0f;
                }
                coords.setLeft(coords.getLeft() + (float)deltaX - ignoredDistance);
                coords.setWidth(width);
                break;
            }
            case TOP: {
                float height = coords.getHeight() - (float)deltaY;
                if (height < 35.0f) {
                    ignoredDistance = 35.0f - height;
                    height = 35.0f;
                }
                coords.setTop(coords.getTop() + (float)deltaY - ignoredDistance);
                coords.setHeight(height);
            }
        }
    }

    @Override
    public String addObserver(NLBObserver observer) {
        return this.m_observerHandler.addObserver(observer);
    }

    @Override
    public void removeObserver(String observerId) {
        this.m_observerHandler.removeObserver(observerId);
    }

    @Override
    public void notifyObservers() {
        this.m_observerHandler.notifyObservers();
    }

    @Override
    public String getExternalHierarchy() {
        Page parentPage;
        StringBuilder builder = new StringBuilder();
        NonLinearBook currentNLB = this.getCurrentNLB();
        ArrayList<String> hierarchy = new ArrayList<String>();
        do {
            if ((parentPage = currentNLB.getParentPage()) == null) continue;
            if (parentPage.isModuleExternal()) {
                hierarchy.add(parentPage.getModuleName());
            }
            currentNLB = parentPage.getCurrentNLB();
        } while (parentPage != null);
        for (int i = hierarchy.size() - 1; i >= 0; --i) {
            builder.append((String)hierarchy.get(i));
            if (i <= 0) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    class SortLinksCommand
    implements NLBCommand {
        private AbstractNodeItem m_nodeItem;
        private List<String> m_previousSortingOrder;
        private List<String> m_newSortingOrder;

        public SortLinksCommand(AbstractNodeItem nodeItem, List<String> newSortingOrder) {
            this.m_nodeItem = nodeItem;
            this.m_newSortingOrder = newSortingOrder;
            this.m_previousSortingOrder = new ArrayList<String>();
            for (Link link : AbstractNodeItem.this.m_links) {
                this.m_previousSortingOrder.add(link.getId());
            }
        }

        @Override
        public void execute() {
            this.m_nodeItem.applyLinkSortingOrder(this.m_newSortingOrder);
            this.m_nodeItem.notifyObservers();
        }

        @Override
        public void revert() {
            this.m_nodeItem.applyLinkSortingOrder(this.m_previousSortingOrder);
            this.m_nodeItem.notifyObservers();
        }
    }

    class DeleteLinkCommand
    implements NLBCommand {
        private LinkImpl m_link;
        private boolean m_previousDeletedState;

        public DeleteLinkCommand(Link link) {
            this.m_link = AbstractNodeItem.this.getLinkById(link.getId());
            this.m_previousDeletedState = this.m_link.isDeleted();
        }

        @Override
        public void execute() {
            this.m_link.setDeleted(true);
            this.m_link.notifyObservers();
        }

        @Override
        public void revert() {
            this.m_link.setDeleted(this.m_previousDeletedState);
            this.m_link.notifyObservers();
        }
    }

    class AddLinkCommand
    implements NLBCommand {
        LinkImpl m_link;

        public AddLinkCommand(LinkImpl link) {
            this.m_link = link;
        }

        @Override
        public void execute() {
            this.m_link.setDeleted(false);
            AbstractNodeItem.this.addLink(this.m_link);
            this.m_link.notifyObservers();
        }

        @Override
        public void revert() {
            this.m_link.setDeleted(true);
            ListIterator linksIterator = AbstractNodeItem.this.m_links.listIterator();
            while (linksIterator.hasNext()) {
                LinkImpl link = (LinkImpl)linksIterator.next();
                if (!link.getId().equals(this.m_link.getId())) continue;
                linksIterator.remove();
                break;
            }
            this.m_link.notifyObservers();
        }
    }

    class ResizeNodeCommand
    implements NLBCommand {
        private NodeItem.Orientation m_orientation;
        private double m_deltaX;
        private double m_deltaY;
        private List<Link> m_adjacentLinks = new ArrayList<Link>();

        public ResizeNodeCommand(NodeItem.Orientation orientation, double deltaX, double deltaY, List<Link> adjacentLinks) {
            this.m_orientation = orientation;
            this.m_deltaX = deltaX;
            this.m_deltaY = deltaY;
            this.m_adjacentLinks.addAll(adjacentLinks);
        }

        @Override
        public void execute() {
            AbstractNodeItem.this.resizeNode(this.m_orientation, this.m_deltaX, this.m_deltaY);
            AbstractNodeItem.this.notifyObservers();
            for (Link link : this.m_adjacentLinks) {
                link.notifyObservers();
            }
        }

        @Override
        public void revert() {
            AbstractNodeItem.this.resizeNode(this.m_orientation, -this.m_deltaX, -this.m_deltaY);
            AbstractNodeItem.this.notifyObservers();
            for (Link link : this.m_adjacentLinks) {
                link.notifyObservers();
            }
        }
    }
}

