/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.FileManipulator;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.NONE)
public class CoordsImpl
implements Coords {
    private static final String LEFT_FILE_NAME = "left";
    private static final String TOP_FILE_NAME = "top";
    private static final String WIDTH_FILE_NAME = "width";
    private static final String HEIGHT_FILE_NAME = "height";
    private float m_left = 0.0f;
    private float m_top = 0.0f;
    private float m_width = 0.0f;
    private float m_height = 0.0f;

    @Override
    public float getLeft() {
        return this.m_left;
    }

    public void setLeft(float left) {
        this.m_left = left;
    }

    @Override
    public float getTop() {
        return this.m_top;
    }

    public void setTop(float top) {
        this.m_top = top;
    }

    @Override
    public float getWidth() {
        return this.m_width;
    }

    public void setWidth(float width) {
        this.m_width = width;
    }

    @Override
    public float getHeight() {
        return this.m_height;
    }

    public void setHeight(float height) {
        this.m_height = height;
    }

    public void writeCoords(FileManipulator fileManipulator, File coordsDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        fileManipulator.writeRequiredString(coordsDir, LEFT_FILE_NAME, String.valueOf(this.m_left));
        fileManipulator.writeRequiredString(coordsDir, TOP_FILE_NAME, String.valueOf(this.m_top));
        fileManipulator.writeRequiredString(coordsDir, WIDTH_FILE_NAME, String.valueOf(this.m_width));
        fileManipulator.writeRequiredString(coordsDir, HEIGHT_FILE_NAME, String.valueOf(this.m_height));
    }

    public void read(File coordsDir) throws NLBIOException {
        try {
            String coordsDirPath = coordsDir.getCanonicalPath();
            this.m_left = Float.parseFloat(FileManipulator.getRequiredFileAsString(coordsDir, LEFT_FILE_NAME, "Error reading left coords file; dir = " + coordsDirPath));
            this.m_top = Float.parseFloat(FileManipulator.getRequiredFileAsString(coordsDir, TOP_FILE_NAME, "Error reading top coords file; dir = " + coordsDirPath));
            this.m_width = Float.parseFloat(FileManipulator.getRequiredFileAsString(coordsDir, WIDTH_FILE_NAME, "Error reading width coords file; dir = " + coordsDirPath));
            this.m_height = Float.parseFloat(FileManipulator.getRequiredFileAsString(coordsDir, HEIGHT_FILE_NAME, "Error reading height coords file; dir = " + coordsDirPath));
        }
        catch (IOException e) {
            throw new NLBIOException("IOException occurred", e);
        }
    }
}

