/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.Modification;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.domain.AbstractModifyingItem;
import com.nlbhub.nlb.domain.CoordsImpl;
import com.nlbhub.nlb.domain.ModificationImpl;
import com.nlbhub.nlb.domain.ObserverHandler;
import com.nlbhub.nlb.domain.SearchResult;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.FileManipulator;
import com.nlbhub.nlb.util.MultiLangString;
import java.io.File;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="link")
public class LinkImpl
extends AbstractModifyingItem
implements Link {
    private static final String COORDS_DIR_NAME = "coords";
    private static final String VARID_FILE_NAME = "varid";
    private static final String TARGET_FILE_NAME = "target";
    private static final String TEXT_SUBDIR_NAME = "text";
    private static final String ALT_TEXT_SUBDIR_NAME = "alt_text";
    private static final String CONSTRID_FILE_NAME = "constrid";
    private static final String STROKE_FILE_NAME = "stroke";
    private static final String AUTO_FILE_NAME = "auto";
    private static final String ONCE_FILE_NAME = "once";
    private String m_varId = "";
    private String m_target = "";
    private MultiLangString m_text = DEFAULT_TEXT;
    private MultiLangString m_altText = DEFAULT_ALT_TEXT;
    private String m_constrId = "";
    private String m_stroke = "0000FF";
    private CoordsImpl m_coords = new CoordsImpl();
    private boolean m_auto = false;
    private boolean m_once = false;
    private ObserverHandler m_observerHandler = new ObserverHandler();
    private boolean m_isPositiveConstraint = true;
    private boolean m_isObeyToModuleConstraint = true;
    private boolean m_isTraversalLink = false;
    private boolean m_isReturnLink = false;

    public LinkImpl() {
    }

    public LinkImpl(NodeItem parent) {
        super(parent.getCurrentNLB());
        this.setParent(parent);
    }

    public LinkImpl(NodeItem parent, Link sourceLink) {
        super(parent.getCurrentNLB());
        this.setId(sourceLink.getId());
        this.setDeleted(sourceLink.isDeleted());
        this.setParent(parent);
        for (Modification modification : sourceLink.getModifications()) {
            this.addModification(new ModificationImpl(modification, (ModifyingItem)this, parent.getCurrentNLB()));
        }
        this.m_varId = sourceLink.getVarId();
        this.m_target = sourceLink.getTarget();
        this.m_text = sourceLink.getTexts();
        this.m_altText = sourceLink.getAltTexts();
        this.m_constrId = sourceLink.getConstrId();
        this.m_stroke = sourceLink.getStroke();
        this.m_coords.setLeft(sourceLink.getCoords().getLeft());
        this.m_coords.setTop(sourceLink.getCoords().getTop());
        this.m_coords.setWidth(sourceLink.getCoords().getWidth());
        this.m_coords.setHeight(sourceLink.getCoords().getHeight());
        this.m_isPositiveConstraint = sourceLink.isPositiveConstraint();
        this.m_isObeyToModuleConstraint = sourceLink.isObeyToModuleConstraint();
        this.m_isTraversalLink = sourceLink.isTraversalLink();
        this.m_isReturnLink = sourceLink.isReturnLink();
        this.m_auto = sourceLink.isAuto();
        this.m_once = sourceLink.isOnce();
    }

    public LinkImpl(NodeItem parent, String target) {
        this(parent);
        this.m_target = target;
    }

    @Override
    public SearchResult searchText(SearchContract contract) {
        SearchResult result = super.searchText(contract);
        if (result != null) {
            return result;
        }
        if (this.textMatches(this.m_text, contract)) {
            result = new SearchResult();
            result.setId(this.getId());
            result.setInformation(this.getText());
            return result;
        }
        if (this.textMatches(this.m_altText, contract)) {
            result = new SearchResult();
            result.setId(this.getId());
            result.setInformation(this.getAltText());
            return result;
        }
        return null;
    }

    @Override
    @XmlElement(name="varid")
    public String getVarId() {
        return this.m_varId;
    }

    public void setVarId(String varId) {
        this.m_varId = varId;
    }

    @Override
    @XmlElement(name="target")
    public String getTarget() {
        return this.m_target;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    @Override
    @XmlElement(name="text")
    public String getText() {
        return this.m_text.get(this.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getTexts() {
        return MultiLangString.createCopy(this.m_text);
    }

    @Override
    @XmlElement(name="alt-text")
    public String getAltText() {
        return this.m_altText.get(this.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getAltTexts() {
        return MultiLangString.createCopy(this.m_altText);
    }

    public void setTexts(MultiLangString text) {
        this.m_text = text;
    }

    public void setText(String text) {
        this.m_text.put(this.getCurrentNLB().getLanguage(), text);
    }

    public void setAltTexts(MultiLangString altText) {
        this.m_altText = altText;
    }

    public void setAltText(String altText) {
        this.m_altText.put(this.getCurrentNLB().getLanguage(), altText);
    }

    @Override
    @XmlElement(name="constrid")
    public String getConstrId() {
        return this.m_constrId;
    }

    @Override
    @XmlElement(name="is-positive")
    public boolean isPositiveConstraint() {
        return this.m_isPositiveConstraint;
    }

    @Override
    @XmlElement(name="is-obey-to-module-constraint")
    public boolean isObeyToModuleConstraint() {
        return this.m_isObeyToModuleConstraint;
    }

    @Override
    @XmlElement(name="is-traversal")
    public boolean isTraversalLink() {
        return this.m_isTraversalLink;
    }

    @Override
    @XmlElement(name="is-return")
    public boolean isReturnLink() {
        return this.m_isReturnLink;
    }

    public void setConstrId(String constrId) {
        this.m_constrId = constrId;
    }

    @Override
    @XmlElement(name="stroke")
    public String getStroke() {
        return this.m_stroke;
    }

    public void setStroke(String stroke) {
        this.m_stroke = stroke;
    }

    @Override
    public CoordsImpl getCoords() {
        return this.m_coords;
    }

    @Override
    @XmlElement(name="is-auto")
    public boolean isAuto() {
        return this.m_auto;
    }

    public void setAuto(boolean auto) {
        this.m_auto = auto;
    }

    @Override
    @XmlElement(name="is-once")
    public boolean isOnce() {
        return this.m_once;
    }

    public void setOnce(boolean once) {
        this.m_once = once;
    }

    private void writeCoords(FileManipulator fileManipulator, File linkDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        File coordsDir = new File(linkDir, COORDS_DIR_NAME);
        fileManipulator.createDir(coordsDir, "Cannot create link text block coords directory for link with Id = " + this.getId());
        this.m_coords.writeCoords(fileManipulator, coordsDir);
    }

    private void readCoords(File linkDir) throws NLBIOException {
        File coordsDir = new File(linkDir, COORDS_DIR_NAME);
        if (!coordsDir.exists()) {
            throw new NLBIOException("Invalid NLB structure: coords directory does not exist for link with Id = " + this.getId());
        }
        this.m_coords.read(coordsDir);
    }

    public void writeLink(FileManipulator fileManipulator, File linksDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        File linkDir = new File(linksDir, this.getId());
        if (this.isDeleted()) {
            fileManipulator.deleteFileOrDir(linkDir);
        } else {
            fileManipulator.createDir(linkDir, "Cannot create NLB link directory for link with Id = " + this.getId());
            fileManipulator.writeOptionalString(linkDir, VARID_FILE_NAME, this.m_varId, "");
            fileManipulator.writeOptionalString(linkDir, TARGET_FILE_NAME, this.m_target, "");
            fileManipulator.writeOptionalMultiLangString(new File(linkDir, TEXT_SUBDIR_NAME), this.m_text, DEFAULT_TEXT);
            fileManipulator.writeOptionalMultiLangString(new File(linkDir, ALT_TEXT_SUBDIR_NAME), this.m_altText, DEFAULT_ALT_TEXT);
            fileManipulator.writeOptionalString(linkDir, CONSTRID_FILE_NAME, this.m_constrId, "");
            fileManipulator.writeOptionalString(linkDir, STROKE_FILE_NAME, this.m_stroke, "0000FF");
            fileManipulator.writeOptionalString(linkDir, AUTO_FILE_NAME, String.valueOf(this.m_auto), String.valueOf(false));
            fileManipulator.writeOptionalString(linkDir, ONCE_FILE_NAME, String.valueOf(this.m_once), String.valueOf(false));
            this.writeCoords(fileManipulator, linkDir);
            this.writeModOrderFile(fileManipulator, linkDir);
            this.writeModifications(fileManipulator, linkDir);
        }
    }

    public void readLink(File linkDir) throws NLBIOException, NLBConsistencyException {
        this.setId(linkDir.getName());
        this.m_varId = FileManipulator.getOptionalFileAsString(linkDir, VARID_FILE_NAME, "");
        this.m_target = FileManipulator.getRequiredFileAsString(linkDir, TARGET_FILE_NAME, "Error while reading link target for link with Id = " + this.getId());
        this.m_text = FileManipulator.readOptionalMultiLangString(new File(linkDir, TEXT_SUBDIR_NAME), DEFAULT_TEXT);
        this.m_altText = FileManipulator.readOptionalMultiLangString(new File(linkDir, ALT_TEXT_SUBDIR_NAME), DEFAULT_ALT_TEXT);
        this.m_constrId = FileManipulator.getOptionalFileAsString(linkDir, CONSTRID_FILE_NAME, "");
        this.m_stroke = FileManipulator.getOptionalFileAsString(linkDir, STROKE_FILE_NAME, "0000FF");
        this.m_auto = "true".equals(FileManipulator.getOptionalFileAsString(linkDir, AUTO_FILE_NAME, String.valueOf(false)));
        this.m_once = "true".equals(FileManipulator.getOptionalFileAsString(linkDir, ONCE_FILE_NAME, String.valueOf(false)));
        this.readCoords(linkDir);
        this.readModifications(linkDir);
    }

    @Override
    public String addObserver(NLBObserver observer) {
        return this.m_observerHandler.addObserver(observer);
    }

    @Override
    public void removeObserver(String observerId) {
        this.m_observerHandler.removeObserver(observerId);
    }

    @Override
    public void notifyObservers() {
        this.m_observerHandler.notifyObservers();
    }
}

