/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.PropertyManager;

public class MediaExportParameters {
    private static final MediaExportParameters NOCHANGE = new MediaExportParameters(Preset.NOCHANGE, false, 0);
    private static final MediaExportParameters COMPRESSED = new MediaExportParameters(Preset.COMPRESSED, true, 80);
    private static final MediaExportParameters DEFAULT = new MediaExportParameters(Preset.DEFAULT, PropertyManager.getSettings().getDefaultConfig().getExport().isConvertpng2jpg(), PropertyManager.getSettings().getDefaultConfig().getExport().getQuality());
    private Preset m_preset = Preset.CUSTOM;
    private boolean m_convertPNG2JPG;
    private int m_quality;

    public static MediaExportParameters fromPreset(Preset preset) {
        switch (preset) {
            case NOCHANGE: {
                return NOCHANGE;
            }
            case COMPRESSED: {
                return COMPRESSED;
            }
        }
        return DEFAULT;
    }

    public static MediaExportParameters getDefault() {
        return DEFAULT;
    }

    private MediaExportParameters(Preset preset, boolean convertPNG2JPG, int quality) {
        this.m_preset = preset;
        this.m_convertPNG2JPG = convertPNG2JPG;
        this.m_quality = quality;
    }

    public Preset getPreset() {
        return this.m_preset;
    }

    public boolean isConvertPNG2JPG() {
        return this.m_convertPNG2JPG;
    }

    public int getQuality() {
        return this.m_quality;
    }

    public static enum Preset {
        CUSTOM,
        DEFAULT,
        NOCHANGE,
        COMPRESSED;

    }
}

