/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.MediaFile;
import com.nlbhub.nlb.domain.MediaExportParameters;

public class MediaFileImpl
implements MediaFile {
    private String m_fileName;
    private String m_redirect;
    private String m_constrId;
    private boolean m_flagged;
    private MediaExportParameters.Preset m_preset = MediaExportParameters.Preset.DEFAULT;

    public MediaFileImpl(String fileName) {
        this.m_fileName = fileName;
    }

    @Override
    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    @Override
    public String getRedirect() {
        return this.m_redirect;
    }

    public void setRedirect(String redirect) {
        this.m_redirect = redirect;
    }

    @Override
    public String getConstrId() {
        return this.m_constrId;
    }

    public void setConstrId(String constrId) {
        this.m_constrId = constrId;
    }

    @Override
    public boolean isFlagged() {
        return this.m_flagged;
    }

    @Override
    public MediaExportParameters getMediaExportParameters() {
        return MediaExportParameters.fromPreset(this.m_preset);
    }

    public MediaExportParameters.Preset getPreset() {
        return this.m_preset;
    }

    public void setPreset(MediaExportParameters.Preset preset) {
        this.m_preset = preset;
    }

    public void setFlagged(boolean flagged) {
        this.m_flagged = flagged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaFileImpl mediaFile = (MediaFileImpl)o;
        if (this.m_flagged != mediaFile.m_flagged) {
            return false;
        }
        if (!this.m_fileName.equals(mediaFile.m_fileName)) {
            return false;
        }
        if (this.m_redirect != null ? !this.m_redirect.equals(mediaFile.m_redirect) : mediaFile.m_redirect != null) {
            return false;
        }
        if (this.m_constrId != null ? !this.m_constrId.equals(mediaFile.m_constrId) : mediaFile.m_constrId != null) {
            return false;
        }
        return this.m_preset == mediaFile.m_preset;
    }

    public int hashCode() {
        int result = this.m_fileName.hashCode();
        result = 31 * result + (this.m_redirect != null ? this.m_redirect.hashCode() : 0);
        result = 31 * result + (this.m_constrId != null ? this.m_constrId.hashCode() : 0);
        result = 31 * result + (this.m_flagged ? 1 : 0);
        result = 31 * result + (this.m_preset != null ? this.m_preset.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(MediaFile o) {
        return this.m_fileName.compareTo(o.getFileName());
    }
}

