/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.NLBCommand;
import java.util.Stack;

public class UndoManager {
    private Stack<NLBCommand> m_executedCommands = new Stack();
    private Stack<NLBCommand> m_revertedCommands = new Stack();

    public void clear() {
        this.m_executedCommands.clear();
        this.m_revertedCommands.clear();
    }

    public boolean canUndo() {
        return !this.m_executedCommands.empty();
    }

    public void undo() {
        NLBCommand lastCommand = this.m_executedCommands.pop();
        lastCommand.revert();
        this.m_revertedCommands.push(lastCommand);
    }

    public boolean canRedo() {
        return !this.m_revertedCommands.empty();
    }

    public void redo() {
        NLBCommand lastCommand = this.m_revertedCommands.pop();
        lastCommand.execute();
        this.m_executedCommands.push(lastCommand);
    }

    public void redoAll() {
        while (!this.m_revertedCommands.empty()) {
            this.redo();
        }
    }

    public void executeAndStore(NLBCommand command) {
        command.execute();
        this.m_executedCommands.add(command);
        this.clearRevertedCommands();
    }

    private void clearRevertedCommands() {
        this.m_revertedCommands.clear();
    }
}

