/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.IdentifiableItem;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.NLBCommand;
import com.nlbhub.nlb.domain.AbstractNodeItem;
import com.nlbhub.nlb.domain.CoordsImpl;
import com.nlbhub.nlb.domain.LinkImpl;
import com.nlbhub.nlb.domain.NonLinearBookImpl;

public class UpdateLinkCoordsCommand
implements NLBCommand {
    private LinkImpl m_linkImpl;
    private float m_left;
    private float m_top;
    private float m_height;
    private float m_leftPrev;
    private float m_topPrev;
    private float m_heightPrev;

    private UpdateLinkCoordsCommand(NonLinearBookImpl nonLinearBook, Link link) {
        IdentifiableItem parent = link.getParent();
        AbstractNodeItem nodeItem = nonLinearBook.getPageImplById(parent.getId());
        if (nodeItem == null) {
            nodeItem = nonLinearBook.getObjImplById(parent.getId());
        }
        this.m_linkImpl = nodeItem.getLinkById(link.getId());
        CoordsImpl coords = this.m_linkImpl.getCoords();
        this.m_leftPrev = coords.getLeft();
        this.m_topPrev = coords.getTop();
        this.m_heightPrev = coords.getHeight();
    }

    public UpdateLinkCoordsCommand(NonLinearBookImpl nonLinearBook, Link link, float left, float top) {
        this(nonLinearBook, link);
        this.m_height = this.m_heightPrev;
        this.m_left = left;
        this.m_top = top;
    }

    public UpdateLinkCoordsCommand(NonLinearBookImpl nonLinearBook, Link link, float height) {
        this(nonLinearBook, link);
        this.m_height = height;
        this.m_left = this.m_leftPrev;
        this.m_top = this.m_topPrev;
    }

    @Override
    public void execute() {
        CoordsImpl coords = this.m_linkImpl.getCoords();
        coords.setLeft(this.m_left);
        coords.setTop(this.m_top);
        coords.setHeight(this.m_height);
        this.m_linkImpl.notifyObservers();
    }

    @Override
    public void revert() {
        CoordsImpl coords = this.m_linkImpl.getCoords();
        coords.setLeft(this.m_leftPrev);
        coords.setTop(this.m_topPrev);
        coords.setHeight(this.m_heightPrev);
        this.m_linkImpl.notifyObservers();
    }
}

