/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.CoordsLw;
import com.nlbhub.nlb.api.IdentifiableItem;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.LinkLw;
import com.nlbhub.nlb.api.Modification;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.PropertyManager;
import com.nlbhub.nlb.api.RootModulePage;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.api.SpecialVariablesNameHelper;
import com.nlbhub.nlb.api.TextChunk;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.api.config.Export;
import com.nlbhub.nlb.api.config.Text;
import com.nlbhub.nlb.domain.MediaExportParameters;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.SearchResult;
import com.nlbhub.nlb.domain.export.ExpressionData;
import com.nlbhub.nlb.domain.export.ImagePathData;
import com.nlbhub.nlb.domain.export.LinkBuildingBlocks;
import com.nlbhub.nlb.domain.export.NLBBuildingBlocks;
import com.nlbhub.nlb.domain.export.ObjBuildingBlocks;
import com.nlbhub.nlb.domain.export.ObjType;
import com.nlbhub.nlb.domain.export.PageBuildingBlocks;
import com.nlbhub.nlb.domain.export.SoundPathData;
import com.nlbhub.nlb.domain.export.UseBuildingBlocks;
import com.nlbhub.nlb.domain.export.VNSTEADExportManager;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.util.MultiLangString;
import com.nlbhub.nlb.util.StringHelper;
import com.nlbhub.nlb.util.VarFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class ExportManager {
    private static final Logger LOG = Logger.getLogger(VNSTEADExportManager.class.getName());
    private static final List<Modification.Type> THEME_MODIFICATION_TYPES = new ArrayList<Modification.Type>(){
        {
            this.add(Modification.Type.WINGEOM);
            this.add(Modification.Type.INVGEOM);
            this.add(Modification.Type.WINCOLOR);
            this.add(Modification.Type.INVCOLOR);
        }
    };
    private static final String EQ_PLACEHOLDER = "000369f3-943a-4696-9c20-f6471b5c131d";
    private static final String NEQ_PLACEHOLDER = "211c47bf-dad2-49d1-9ab0-162082d2664c";
    private static final String GT_PLACEHOLDER = "74ea093d-1918-4e02-b2bd-a929d7db4b0c";
    private static final String GTE_PLACEHOLDER = "94e69065-f584-4d98-a6c9-667e2c6dc3ee";
    private static final String LT_PLACEHOLDER = "c5549d03-b258-4f77-b760-5d13bf981780";
    private static final String LTE_PLACEHOLDER = "17190e04-4537-414f-9c57-25676a99ad6e";
    private static final String NOT_PLACEHOLDER = "2164a414-ba30-45b4-baa3-c32e194304db";
    private static final String OR_PLACEHOLDER = "179ef88a-88b7-4ad2-8dfa-d2040debde73";
    private static final String AND_PLACEHOLDER = "f0e77ec8-a270-4a3f-8b8f-1ade38988f37";
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("(^.*\\D|^)(\\d*)(\\..*)$");
    private static final int NONEXISTING_PAGE = -1;
    public static final String NO_CONTAINER = "function() return nil; end";
    public static final String EMPTY_STRING = "";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String CP1251 = "CP1251";
    private static final String MAIN_DATA_KEY = "MAIN";
    private String m_encoding;
    private Map<String, ExportData> m_exportDataMap;
    private Map<String, Variable.DataType> m_dataTypeMap;
    private Map<String, String> m_mediaToConstraintMap;
    private Map<String, String> m_mediaRedirectsMap;
    private Map<String, MediaExportParameters> m_mediaExportParametersMap;
    private Map<String, Boolean> m_mediaFlagsMap;
    private static final boolean GOTO_PAGE_NUMBERS = false;

    protected ExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        try {
            this.m_encoding = encoding;
            ExportData mainExportData = new ExportData(nlb, new RootModulePage(nlb, MAIN_DATA_KEY), EMPTY_STRING, 0, null);
            this.m_exportDataMap = mainExportData.init();
            this.m_dataTypeMap = nlb.getVariableDataTypes();
            this.m_mediaToConstraintMap = nlb.getMediaToConstraintMap();
            this.m_mediaRedirectsMap = nlb.getMediaRedirectsMap();
            this.m_mediaExportParametersMap = nlb.getMediaExportParametersMap();
            this.m_mediaFlagsMap = nlb.getMediaFlagsMap();
        }
        catch (NLBConsistencyException e) {
            throw new NLBExportException("Export error", e);
        }
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public abstract void exportToFile(File var1) throws NLBExportException;

    private int getPageNumber(String pageId) {
        for (ExportData exportData : this.m_exportDataMap.values()) {
            if (!exportData.m_idToPageNumberMap.containsKey(pageId)) continue;
            return (Integer)exportData.m_idToPageNumberMap.get(pageId);
        }
        return -1;
    }

    private int checkedGetPageNumber(String pageId) throws NLBConsistencyException {
        int pageNumber = this.getPageNumber(pageId);
        if (pageNumber != -1) {
            return pageNumber;
        }
        throw new NLBConsistencyException("Page number cannot be determined for pageId = " + pageId);
    }

    private int getScreenWidth() {
        return 1920;
    }

    private int getScreenHeight() {
        return 1080;
    }

    private String getRelativeCoords(Obj obj) {
        Coords coords = obj.getRelativeCoords(true);
        double left = Math.floor(coords.getLeft() * (float)this.getScreenWidth() / coords.getWidth());
        double top = Math.floor(coords.getTop() * (float)this.getScreenHeight() / coords.getHeight());
        Coords transformedCoords = this.getTransformedCoords(obj, left, top);
        String x = String.valueOf((int)transformedCoords.getLeft());
        String y = String.valueOf((int)transformedCoords.getTop());
        return x + "," + y;
    }

    private Coords getTransformedCoords(Obj obj, double left, double top) {
        CoordsLw coords = new CoordsLw();
        coords.setLeft((float)left);
        coords.setTop((float)top);
        switch (obj.getCoordsOrigin()) {
            case LeftTop: {
                coords.setLeft((float)left);
                coords.setTop((float)top);
                break;
            }
            case MiddleTop: {
                coords.setLeft((float)left - (float)this.getScreenWidth() / 2.0f);
                coords.setTop((float)top);
                break;
            }
            case RightTop: {
                coords.setLeft((float)this.getScreenWidth() - (float)left);
                coords.setTop(0.0f);
                break;
            }
            case LeftMiddle: {
                coords.setLeft((float)left);
                coords.setTop((float)this.getScreenHeight() / 2.0f - (float)top);
                break;
            }
            case MiddleMiddle: {
                coords.setLeft((float)left - (float)this.getScreenWidth() / 2.0f);
                coords.setTop((float)this.getScreenHeight() / 2.0f - (float)top);
                break;
            }
            case RightMiddle: {
                coords.setLeft((float)this.getScreenWidth() - (float)left);
                coords.setTop((float)this.getScreenHeight() / 2.0f - (float)top);
                break;
            }
            case LeftBottom: {
                coords.setLeft((float)left);
                coords.setTop((float)this.getScreenHeight() - (float)top);
                break;
            }
            case MiddleBottom: {
                coords.setLeft((float)left - (float)this.getScreenWidth() / 2.0f);
                coords.setTop((float)this.getScreenHeight() - (float)top);
                break;
            }
            case RightBottom: {
                coords.setLeft((float)this.getScreenWidth() - (float)left);
                coords.setTop((float)this.getScreenHeight() - (float)top);
            }
        }
        return coords;
    }

    protected NLBBuildingBlocks createNLBBuildingBlocks() throws NLBConsistencyException, NLBExportException {
        return this.createNLBBuildingBlocks(this.m_exportDataMap.get(MAIN_DATA_KEY));
    }

    private NLBBuildingBlocks createNLBBuildingBlocks(ExportData exportData) throws NLBConsistencyException, NLBExportException {
        NonLinearBook nlb = exportData.getNlb();
        Export export = PropertyManager.getSettings().getDefaultConfig().getExport();
        Text text = export.getTextByLang(nlb.getLanguage());
        NLBBuildingBlocks blocks = new NLBBuildingBlocks(nlb.getTitle(), nlb.getAuthor(), nlb.getVersion(), nlb.getLanguage(), nlb.getAllAchievementNames(false), nlb.getPerfectGameAchievementName(), text.getGameAct(), text.getGameInv(), text.getGameNouse(), export.isGameForceDsc());
        for (Obj obj : exportData.getObjList()) {
            blocks.addObjBuildingBlocks(this.createObjBuildingBlocks(this.createPreprocessedObj(obj), exportData));
        }
        for (Page page : exportData.getPageList()) {
            if (page.getModule().isEmpty()) {
                blocks.addPageBuildingBlocks(this.createPageBuildingBlocks(this.createPreprocessedPage(page), exportData));
                continue;
            }
            blocks.addPageBuildingBlocks(this.createPageBuildingBlocks(this.createPreprocessedPage(page), exportData));
            NLBBuildingBlocks module = this.createNLBBuildingBlocks(this.m_exportDataMap.get(page.getId()));
            blocks.addAchievements(module.getAchievements());
            blocks.addNLBBuildingBlocks(module);
        }
        return blocks;
    }

    private boolean determineTrivialStatus(PageBuildingBlocks pageBuildingBlocks) {
        List<LinkBuildingBlocks> linkBlocks = pageBuildingBlocks.getLinksBuildingBlocks();
        if (linkBlocks.size() == 0) {
            return false;
        }
        for (LinkBuildingBlocks blocks : linkBlocks) {
            if (blocks.isTrivial()) continue;
            return false;
        }
        return true;
    }

    private boolean determineTrivialStatus(Link link) {
        return link.getTexts().equals(Link.DEFAULT_TEXT) && link.getAltTexts().equals(Link.DEFAULT_ALT_TEXT) || link.isAuto();
    }

    private PageBuildingBlocks createPageBuildingBlocks(Page page, ExportData exportData) throws NLBConsistencyException, NLBExportException {
        LinkBuildingBlocks linkBuildingBlocks;
        NonLinearBook nlb = exportData.getNlb();
        PageBuildingBlocks blocks = new PageBuildingBlocks();
        boolean hasPageText = StringHelper.notEmpty(page.getText());
        blocks.setHasPageText(hasPageText);
        Theme theme = page.getEffectiveTheme();
        blocks.setTheme(theme);
        Integer pageNumber = this.checkedGetPageNumber(page.getId());
        blocks.setAutowired(page.isAutowire());
        String pageName = this.decoratePageName(page.getId(), pageNumber);
        blocks.setPageName(pageName);
        blocks.setPageLabel(this.decoratePageLabel(page.getId(), pageNumber, theme));
        blocks.setPageNumber(this.decoratePageNumber(pageNumber));
        blocks.setPageComment(this.decoratePageComment(page.getCaption()));
        String title = this.getNonEmptyTitle(nlb);
        blocks.setPageCaption(this.decoratePageCaption(page.getCaption(), page.isUseCaption(), title, page.isNoSave()));
        blocks.setAutosFirst(page.isAutosFirst());
        blocks.setNotes(this.decoratePageNotes(page.getNotes()));
        blocks.setModuleTitle(title);
        String imageFileName = nlb.isSuppressMedia() ? EMPTY_STRING : page.getImageFileName();
        boolean isAnimatedImage = page.isImageAnimated();
        blocks.setHasAnimatedPageImage(isAnimatedImage);
        blocks.setImageBackground(page.isImageBackground());
        blocks.setPageImage(this.decoratePageImage(this.getImagePaths(page.getExternalHierarchy(), imageFileName, isAnimatedImage, false), page.isImageBackground(), theme));
        String soundFileName = nlb.isSuppressMedia() || nlb.isSuppressSound() ? EMPTY_STRING : page.getSoundFileName();
        blocks.setPageSound(this.decoratePageSound(pageName, this.getSoundPaths(page.getExternalHierarchy(), soundFileName), page.isSoundSFX(), theme));
        blocks.setPageTextStart(this.decoratePageTextStart(page.getId(), pageNumber, StringHelper.getTextChunks(page.getText()), theme));
        boolean hasChoicesOrLeaf = this.hasChoicesOrLeaf(page);
        blocks.setPageTextEnd(this.decoratePageTextEnd(page.getId(), pageNumber, theme, hasChoicesOrLeaf));
        if (!StringHelper.isEmpty(page.getVarId())) {
            Variable variable = nlb.getVariableById(page.getVarId());
            if (!variable.isDeleted()) {
                blocks.setPageVariable(this.decoratePageVariable(variable.getName()));
            } else {
                blocks.setPageVariable(EMPTY_STRING);
            }
        } else {
            blocks.setPageVariable(EMPTY_STRING);
        }
        if (!StringHelper.isEmpty(page.getDefaultTagId())) {
            Variable deftag = nlb.getVariableById(page.getDefaultTagId());
            if (!deftag.isDeleted()) {
                blocks.setPageDefaultTag(deftag.getValue());
            } else {
                blocks.setPageDefaultTag(EMPTY_STRING);
            }
        } else {
            blocks.setPageDefaultTag(EMPTY_STRING);
        }
        blocks.setHasPageTimer(false);
        if (!StringHelper.isEmpty(page.getTimerVarId())) {
            Variable timerVariable = nlb.getVariableById(page.getTimerVarId());
            if (!timerVariable.isDeleted()) {
                blocks.setHasPageTimer(true);
                blocks.setPageTimerVariableInit(this.decoratePageTimerVariableInit(timerVariable.getName()));
                blocks.setPageTimerVariable(this.decoratePageTimerVariable(timerVariable.getName()));
            } else {
                blocks.setPageTimerVariableInit(this.decoratePageTimerVariableInit(EMPTY_STRING));
                blocks.setPageTimerVariable(this.decoratePageTimerVariable(EMPTY_STRING));
            }
        } else {
            blocks.setPageTimerVariableInit(this.decoratePageTimerVariableInit(EMPTY_STRING));
            blocks.setPageTimerVariable(this.decoratePageTimerVariable(EMPTY_STRING));
        }
        blocks.setPageModifications(this.decoratePageModifications(this.buildModificationsText(EMPTY_STRING, this.getNonThemeModifications(page.getModifications()), exportData)));
        blocks.setPageThemeModifications(this.decoratePageThemeModifications(this.buildModificationsText(EMPTY_STRING, this.getThemeModifications(page.getModifications()), exportData)));
        blocks.setPageEnd(this.decoratePageEnd(page.isFinish()));
        List<String> containedObjIds = page.getContainedObjIds();
        boolean hasAnim = false;
        boolean hasGraphicalObjs = false;
        if (!containedObjIds.isEmpty()) {
            for (String string : containedObjIds) {
                Obj obj = nlb.getObjById(string);
                boolean bl = hasAnim = hasAnim || obj.isAnimatedImage();
                if (obj.isGraphical()) {
                    hasGraphicalObjs = true;
                    blocks.addContainedGraphicalObjId(this.decorateId(string));
                    continue;
                }
                blocks.addContainedObjId(this.decorateContainedObjId(string));
            }
        }
        blocks.setHasObjectsWithAnimatedImages(hasAnim);
        List<Link> links = page.getLinks();
        for (Link link : links) {
            if (link.isDeleted()) continue;
            LinkBuildingBlocks linkBuildingBlocks2 = this.createLinkBuildingBlocks(page, this.createPreprocessedLink(link), exportData);
            blocks.addLinkBuildingBlocks(linkBuildingBlocks2);
        }
        if (this.m_exportDataMap.containsKey(page.getId())) {
            Link link;
            ExportData exportData2 = this.m_exportDataMap.get(page.getId());
            link = new LinkLw(LinkLw.Type.Traverse, exportData2.getNlb().getStartPoint(), page, page.getTraverseTexts(), Link.DEFAULT_ALT_TEXT, page.getModuleConstrId(), EMPTY_STRING, page.isAutoTraverse(), false, true, false, EMPTY_STRING, null);
            LinkBuildingBlocks linkBuildingBlocks2 = this.createLinkBuildingBlocks(page, this.createPreprocessedLink(link), exportData);
            blocks.addLinkBuildingBlocks(linkBuildingBlocks2);
        }
        if (page.shouldReturn() && !exportData.getModulePage().getId().equals(MAIN_DATA_KEY)) {
            if (page.isUseMPL()) {
                for (Link link : page.getCurrentNLB().getParentPage().getLinks()) {
                    LinkLw linklw = new LinkLw(LinkLw.Type.Return, link.getTarget(), page, link.getTexts(), link.getAltTexts(), link.getConstrId(), link.getVarId(), link.isAuto(), link.isOnce(), link.isPositiveConstraint(), false, link.getId(), link.getModifications());
                    linkBuildingBlocks = this.createLinkBuildingBlocks(page, this.createPreprocessedLink(linklw), exportData);
                    blocks.addLinkBuildingBlocks(linkBuildingBlocks);
                }
            } else {
                LinkLw linkLw = new LinkLw(LinkLw.Type.Return, StringHelper.isEmpty(page.getReturnPageId()) ? exportData.getModulePage().getId() : page.getReturnPageId(), page, page.getReturnTexts(), Link.DEFAULT_ALT_TEXT, EMPTY_STRING, EMPTY_STRING, page.isAutoReturn(), false, StringHelper.isEmpty(exportData.getModulePage().getModuleConstrId()), !page.isLeaf(), EMPTY_STRING, null);
                LinkBuildingBlocks linkBuildingBlocks3 = this.createLinkBuildingBlocks(page, this.createPreprocessedLink(linkLw), exportData);
                blocks.addLinkBuildingBlocks(linkBuildingBlocks3);
            }
        }
        if (page.isAutowire()) {
            for (Page nlbPage : this.getPagesForAutowiredOutwardLinks(page, nlb)) {
                if (nlbPage.isAutowire()) continue;
                LinkLw link = new LinkLw(LinkLw.Type.AutowiredOut, nlbPage.getId(), page, page.getAutowireOutTexts(), Link.DEFAULT_ALT_TEXT, "LC_" + page.getId() + "_OUT_" + nlbPage.getId(), EMPTY_STRING, page.isAutoOut(), false, true, false, EMPTY_STRING, null);
                linkBuildingBlocks = this.createLinkBuildingBlocks(page, this.createPreprocessedLink(link), exportData);
                blocks.addLinkBuildingBlocks(linkBuildingBlocks);
            }
        }
        if (nlb.isFullAutowire() || !page.isAutowire()) {
            for (String autowiredPageId : this.getAllAutowiredPageIds(nlb)) {
                if (autowiredPageId.equals(page.getId())) continue;
                Page autowiredPage = nlb.getPageById(autowiredPageId);
                LinkLw link = new LinkLw(LinkLw.Type.AutowiredIn, autowiredPageId, page, autowiredPage.getAutowireInTexts(), Link.DEFAULT_ALT_TEXT, autowiredPage.getAutowireInConstrId(), EMPTY_STRING, autowiredPage.isAutoIn(), false, true, false, EMPTY_STRING, null);
                LinkBuildingBlocks linkBuildingBlocks4 = this.createLinkBuildingBlocks(page, this.createPreprocessedLink(link), exportData);
                blocks.addLinkBuildingBlocks(linkBuildingBlocks4);
            }
        }
        blocks.setHasTrivialLinks(this.determineTrivialStatus(blocks));
        if (!hasPageText && StringHelper.notEmpty(imageFileName) && !hasGraphicalObjs && !page.isLeaf()) {
            LOG.warning("Page " + page.getId() + " has empty text and non-empty image, and it is not leaf and not pure graphical page");
        }
        return blocks;
    }

    private List<Modification> getThemeModifications(List<Modification> modifications) {
        return modifications.stream().filter(modification -> THEME_MODIFICATION_TYPES.contains((Object)modification.getType())).collect(Collectors.toList());
    }

    private List<Modification> getNonThemeModifications(List<Modification> modifications) {
        return modifications.stream().filter(modification -> !THEME_MODIFICATION_TYPES.contains((Object)modification.getType())).collect(Collectors.toList());
    }

    private boolean hasChoicesOrLeaf(Page page) {
        List<Link> links = page.getLinks();
        if (links.isEmpty()) {
            return true;
        }
        for (Link link : links) {
            if (link.isAuto()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasChoicesOrLeaf(PageBuildingBlocks pageBuildingBlocks) {
        List<LinkBuildingBlocks> linksBuildingBlocks = pageBuildingBlocks.getLinksBuildingBlocks();
        if (linksBuildingBlocks.isEmpty()) {
            return true;
        }
        for (LinkBuildingBlocks linkBuildingBlocks : linksBuildingBlocks) {
            if (linkBuildingBlocks.isAuto()) continue;
            return true;
        }
        return false;
    }

    protected Map<String, String> getInitValuesMap() throws NLBConsistencyException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Variable.DataType> entry : this.m_dataTypeMap.entrySet()) {
            Variable.DataType dataType = entry.getValue();
            String defaultValue = this.getDefaultValue(dataType, entry.getKey());
            result.put(dataType == Variable.DataType.STRING ? this.decorateStringVar(entry.getKey()) : this.decorateAutoVar(entry.getKey()), defaultValue);
        }
        return result;
    }

    private String getDefaultValue(Variable.DataType datatype, String variableName) throws NLBConsistencyException {
        switch (datatype) {
            case NUMBER: {
                return "0";
            }
            case STRING: {
                return "\"\"";
            }
            case AUTO: 
            case BOOLEAN: {
                return this.decorateFalse();
            }
        }
        throw new NLBConsistencyException("Unsupported datatype '" + datatype.name() + "' for variable '" + variableName + "'");
    }

    private List<String> getAllAutowiredPageIds(NonLinearBook nlb) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(nlb.getAutowiredPagesIds());
        result.addAll(nlb.getParentGlobalAutowiredPagesIds());
        return result;
    }

    private List<Page> getPagesForAutowiredOutwardLinks(Page autowiredSourcePage, NonLinearBook nlb) {
        ArrayList<Page> result = new ArrayList<Page>();
        if (autowiredSourcePage.isGlobalAutowire()) {
            result.addAll(nlb.getDownwardPagesHeirarchy().values());
        } else {
            result.addAll(nlb.getPages().values());
        }
        return result;
    }

    private String getContainerRef(Obj obj, ExportData exportData) {
        String containerId = obj.getContainerId();
        if (EMPTY_STRING.equals(containerId)) {
            return NO_CONTAINER;
        }
        int pageNumber = this.getPageNumber(containerId);
        if (pageNumber != -1) {
            return "function() return " + this.decoratePageName(containerId, pageNumber) + "; end";
        }
        return "function() return " + this.decorateId(containerId) + "; end";
    }

    private List<String> getDecoratedContainedObjIds(Obj obj) {
        List<String> containedObjIds;
        ArrayList<String> result = new ArrayList<String>();
        if (obj != null && !(containedObjIds = obj.getContainedObjIds()).isEmpty()) {
            for (String containedObjId : containedObjIds) {
                result.add(this.decorateContainedObjId(containedObjId));
            }
        }
        return result;
    }

    private ObjBuildingBlocks createObjBuildingBlocks(Obj obj, ExportData exportData) throws NLBConsistencyException, NLBExportException {
        NonLinearBook nlb = obj.getCurrentNLB();
        ObjBuildingBlocks blocks = new ObjBuildingBlocks();
        if (!StringHelper.isEmpty(obj.getVarId())) {
            Variable variable = exportData.getNlb().getVariableById(obj.getVarId());
            if (!variable.isDeleted()) {
                blocks.setObjVariable(this.decorateObjVariable(variable.getName()));
            } else {
                blocks.setObjVariable(EMPTY_STRING);
            }
        } else {
            blocks.setObjVariable(EMPTY_STRING);
        }
        if (!StringHelper.isEmpty(obj.getDefaultTagId())) {
            Variable deftag = exportData.getNlb().getVariableById(obj.getDefaultTagId());
            if (!deftag.isDeleted()) {
                blocks.setObjDefaultTagVariable(deftag.getValue());
            } else {
                blocks.setObjDefaultTagVariable(EMPTY_STRING);
            }
        } else {
            blocks.setObjDefaultTagVariable(EMPTY_STRING);
        }
        if (!StringHelper.isEmpty(obj.getConstrId())) {
            Variable constraint = exportData.getNlb().getVariableById(obj.getConstrId());
            if (!constraint.isDeleted()) {
                blocks.setObjConstraint(this.decorateObjConstraint(this.translateConstraintBody(constraint.getValue(), true, false, EMPTY_STRING, EMPTY_STRING)));
            } else {
                blocks.setObjConstraint(EMPTY_STRING);
            }
        } else {
            blocks.setObjConstraint(EMPTY_STRING);
        }
        Obj commonToObj = obj.getCommonToObj(exportData.getNlb());
        if (commonToObj != null) {
            String containerId = obj.getContainerId();
            if (!commonToObj.getId().equalsIgnoreCase(containerId)) {
                List<String> decoratedContainedObjIds = this.getDecoratedContainedObjIds(commonToObj);
                for (String containedObjId : decoratedContainedObjIds) {
                    blocks.addContainedObjId(containedObjId);
                }
            }
        }
        blocks.setObjModifications(this.decorateObjModifications(this.buildModificationsText(EMPTY_STRING, obj.getModifications(), exportData)));
        ObjType objType = this.getObjType(obj, exportData);
        blocks.setObjLabel(this.decorateObjLabel(obj.getId()));
        blocks.setObjComment(this.decorateObjComment(obj.getName()));
        blocks.setObjStart(this.decorateObjStart(obj.getId(), this.getContainerRef(obj, exportData), objType, obj.isShowOnCursor(), obj.isPreserved(), obj.isLoadOnce(), obj.isClearUnderTooltip(), obj.isActOnKey(), obj.isCacheText(), obj.isLooped(), obj.isNoRedrawOnAct(), obj.isCollapsable(), blocks.getObjDefaultTagVariable(), obj.getPauseFrames()));
        blocks.setObjName(this.decorateObjName(obj.getName(), obj.getId()));
        blocks.setObjAlias(StringHelper.notEmpty(obj.getName()) ? this.decorateAutoVar(obj.getName()) : EMPTY_STRING);
        String imageFileName = nlb.isSuppressMedia() ? EMPTY_STRING : obj.getImageFileName();
        List<ImagePathData> imagePaths = this.getImagePaths(obj.getExternalHierarchy(), imageFileName, obj.isAnimatedImage(), obj.isAnimatedImage() && obj.isGraphical());
        int maxStep = imagePaths.size() > 0 && imagePaths.get(0).getMaxFrameNumber() > 0 ? imagePaths.get(0).getMaxFrameNumber() : obj.getMaxFrame();
        blocks.setObjPreload(this.decorateObjPreload(obj.getStartFrame(), maxStep, obj.getPreloadFrames()));
        String objImage = this.decorateObjImage(imagePaths, obj.isGraphical());
        boolean hasParentObj = obj.getContainerType() == Obj.ContainerType.Obj;
        int curStep = obj.getStartFrame() > 0 ? obj.getStartFrame() : this.getCurStep(obj.getEffect());
        String objEffect = this.decorateObjEffect(obj.getOffset(), hasParentObj ? "0,0" : this.getRelativeCoords(obj), obj.isGraphical(), hasParentObj, obj.getMovementDirection(), obj.getEffect(), obj.getCoordsOrigin(), obj.getStartFrame(), curStep, maxStep);
        blocks.setObjEffect(objEffect);
        Coords coords = this.getRelativeCoordsOrOffset(obj);
        blocks.setObjArm(obj.isGraphical() && hasParentObj ? this.decorateObjArm(coords.getLeft(), coords.getTop()) : EMPTY_STRING);
        Obj morphOverObj = obj.getMorphOverObj();
        blocks.setMorphOver(this.decorateMorphOver(morphOverObj != null ? morphOverObj.getId() : EMPTY_STRING, obj.isGraphical()));
        Obj morphOutObj = obj.getMorphOutObj();
        blocks.setMorphOut(this.decorateMorphOut(morphOutObj != null ? morphOutObj.getId() : EMPTY_STRING, obj.isGraphical()));
        boolean hasImage = StringHelper.notEmpty(imageFileName);
        blocks.setObjImage(objImage);
        blocks.setObjDisp(this.decorateObjDisp(this.expandVariables(StringHelper.getTextChunks(obj.getDisp())), hasImage && obj.isImageInInventory(), obj.isGraphical()));
        blocks.setObjText(this.decorateObjText(obj.getId(), obj.getName(), obj.isSuppressDsc(), this.expandVariables(StringHelper.getTextChunks(obj.getText())), hasImage && obj.isImageInScene(), obj.isGraphical()));
        blocks.setGraphical(obj.isGraphical());
        blocks.setTakable(obj.isTakable());
        String commonObjId = commonToObj != null ? commonToObj.getId() : EMPTY_STRING;
        blocks.setObjTak(this.decorateObjTak(obj.getName(), commonObjId));
        blocks.setObjInv(this.decorateObjInv(objType));
        blocks.setObjActStart(this.decorateObjActStart(this.expandVariables(StringHelper.getTextChunks(obj.getActText())), commonObjId));
        blocks.setObjNouse(this.decorateObjNouse(this.expandVariables(StringHelper.getTextChunks(obj.getNouseText()))));
        blocks.setObjActEnd(this.decorateObjActEnd(!obj.isShowOnCursor() && obj.isCollapsable()));
        blocks.setObjUseStart(this.decorateObjUseStart(commonObjId));
        blocks.setObjUseEnd(this.decorateObjUseEnd());
        blocks.setObjEnd(this.decorateObjEnd());
        blocks.setObjObjStart(this.decorateObjObjStart());
        List<String> decoratedContainedObjIds = this.getDecoratedContainedObjIds(obj);
        for (String containedObjId : decoratedContainedObjIds) {
            blocks.addContainedObjId(containedObjId);
        }
        blocks.setObjObjEnd(this.decorateObjObjEnd());
        String soundFileName = nlb.isSuppressMedia() || nlb.isSuppressSound() ? EMPTY_STRING : obj.getSoundFileName();
        blocks.setObjSound(this.decorateObjSound(this.getSoundPaths(obj.getExternalHierarchy(), soundFileName), obj.isSoundSFX()));
        List<Link> links = obj.getLinks();
        for (Link link : links) {
            if (link.isDeleted()) continue;
            UseBuildingBlocks useBuildingBlocks = this.createUseBuildingBlocks(obj, this.createPreprocessedLink(link), exportData);
            blocks.addUseBuildingBlocks(useBuildingBlocks);
        }
        return blocks;
    }

    private Coords getRelativeCoordsOrOffset(Obj obj) {
        String offset = obj.getOffset();
        if (StringHelper.isEmpty(offset)) {
            return obj.getRelativeCoords(true);
        }
        String[] offsets = offset.split(",");
        if (offsets.length == 2) {
            CoordsLw coords = new CoordsLw();
            coords.setLeft(Integer.parseInt(offsets[0].trim()));
            coords.setTop(Integer.parseInt(offsets[1].trim()));
            return coords;
        }
        return CoordsLw.ZERO_COORDS;
    }

    private int getCurStep(Obj.Effect effect) {
        switch (effect) {
            case FadeIn: 
            case FadeOut: 
            case None: {
                return 0;
            }
        }
        return 2;
    }

    private ObjType getObjType(Obj obj, ExportData exportData) {
        if (obj.isTakable() && obj.getLinks().size() == 0 && !exportData.hasInwardLinks(obj.getId()).booleanValue()) {
            if (obj.isGraphical()) {
                return ObjType.GMENU;
            }
            if (!obj.getDisps().isEmpty() && obj.getTexts().isEmpty() && obj.getActTexts().isEmpty() && obj.getNouseTexts().isEmpty() && obj.isTakable() && obj.hasNoModifications() && StringHelper.isEmpty(obj.getCommonToId())) {
                return ObjType.STAT;
            }
            return ObjType.MENU;
        }
        if (obj.isGraphical()) {
            return ObjType.GOBJ;
        }
        return ObjType.OBJ;
    }

    protected String escapeText(String text) {
        return text;
    }

    private MultiLangString escapeMultiLang(MultiLangString multiLangString) {
        MultiLangString result = MultiLangString.createEmptyText();
        Set<String> keySet = multiLangString.keySet();
        for (String key : keySet) {
            result.put(key, this.escapeText(multiLangString.get(key)));
        }
        return result;
    }

    private Link createPreprocessedLink(final Link link) {
        return new Link(){

            @Override
            public String getVarId() {
                return link.getVarId();
            }

            @Override
            public String getTarget() {
                return link.getTarget();
            }

            @Override
            public String getText() {
                return ExportManager.this.escapeText(link.getText());
            }

            @Override
            public MultiLangString getTexts() {
                return ExportManager.this.escapeMultiLang(link.getTexts());
            }

            @Override
            public String getAltText() {
                return ExportManager.this.escapeText(link.getAltText());
            }

            @Override
            public MultiLangString getAltTexts() {
                return ExportManager.this.escapeMultiLang(link.getAltTexts());
            }

            @Override
            public String getConstrId() {
                return link.getConstrId();
            }

            @Override
            public String getStroke() {
                return link.getStroke();
            }

            @Override
            public Coords getCoords() {
                return link.getCoords();
            }

            @Override
            public boolean isAuto() {
                return link.isAuto();
            }

            @Override
            public boolean isOnce() {
                return link.isOnce();
            }

            @Override
            public boolean isPositiveConstraint() {
                return link.isPositiveConstraint();
            }

            @Override
            public boolean isObeyToModuleConstraint() {
                return link.isObeyToModuleConstraint();
            }

            @Override
            public boolean isTraversalLink() {
                return link.isTraversalLink();
            }

            @Override
            public boolean isReturnLink() {
                return link.isReturnLink();
            }

            @Override
            public List<Modification> getModifications() {
                return link.getModifications();
            }

            @Override
            public boolean hasNoModifications() {
                return link.hasNoModifications();
            }

            @Override
            public Modification getModificationById(@NotNull String modId) {
                return link.getModificationById(modId);
            }

            @Override
            public String getId() {
                return link.getId();
            }

            @Override
            public String getFullId() {
                return link.getFullId();
            }

            @Override
            public boolean isDeleted() {
                return link.isDeleted();
            }

            @Override
            public IdentifiableItem getParent() {
                return link.getParent();
            }

            @Override
            public boolean hasDeletedParent() {
                return link.hasDeletedParent();
            }

            @Override
            public NonLinearBook getCurrentNLB() {
                return link.getCurrentNLB();
            }

            @Override
            public SearchResult searchText(SearchContract contract) {
                return link.searchText(contract);
            }

            @Override
            public String addObserver(NLBObserver observer) {
                throw new UnsupportedOperationException("Not supported during export");
            }

            @Override
            public void removeObserver(String observerId) {
                throw new UnsupportedOperationException("Not supported during export");
            }

            @Override
            public void notifyObservers() {
                throw new UnsupportedOperationException("Not supported during export");
            }
        };
    }

    private Page createPreprocessedPage(final Page page) {
        return new Page(){

            @Override
            public String getImageFileName() {
                return page.getImageFileName();
            }

            @Override
            public boolean isImageBackground() {
                return page.isImageBackground();
            }

            @Override
            public boolean isImageAnimated() {
                return page.isImageAnimated();
            }

            @Override
            public String getSoundFileName() {
                return page.getSoundFileName();
            }

            @Override
            public boolean isSoundSFX() {
                return page.isSoundSFX();
            }

            @Override
            public String getText() {
                return ExportManager.this.escapeText(page.getText());
            }

            @Override
            public MultiLangString getTexts() {
                return ExportManager.this.escapeMultiLang(page.getTexts());
            }

            @Override
            public Theme getTheme() {
                return page.getTheme();
            }

            @Override
            public Theme getEffectiveTheme() {
                return page.getEffectiveTheme();
            }

            @Override
            public String getVarId() {
                return page.getVarId();
            }

            @Override
            public String getTimerVarId() {
                return page.getTimerVarId();
            }

            @Override
            public String getCaption() {
                return ExportManager.this.escapeText(page.getCaption());
            }

            @Override
            public String getNotes() {
                return ExportManager.this.escapeText(page.getNotes());
            }

            @Override
            public MultiLangString getCaptions() {
                return ExportManager.this.escapeMultiLang(page.getCaptions());
            }

            @Override
            public boolean isUseCaption() {
                return page.isUseCaption();
            }

            @Override
            public boolean isUseMPL() {
                return page.isUseMPL();
            }

            @Override
            public boolean isLeaf() {
                return page.isLeaf();
            }

            @Override
            public boolean isFinish() {
                return page.isFinish();
            }

            @Override
            public String getTraverseText() {
                return page.getTraverseText();
            }

            @Override
            public MultiLangString getTraverseTexts() {
                return page.getTraverseTexts();
            }

            @Override
            public boolean isAutoTraverse() {
                return page.isAutoTraverse();
            }

            @Override
            public boolean isAutoReturn() {
                return page.isAutoReturn();
            }

            @Override
            public String getReturnText() {
                return page.getReturnText();
            }

            @Override
            public MultiLangString getReturnTexts() {
                return page.getReturnTexts();
            }

            @Override
            public String getReturnPageId() {
                return page.getReturnPageId();
            }

            @Override
            public boolean shouldReturn() {
                return page.shouldReturn();
            }

            @Override
            public String getModuleConstrId() {
                return page.getModuleConstrId();
            }

            @Override
            public String getModuleName() {
                return page.getModuleName();
            }

            @Override
            public boolean isModuleExternal() {
                return page.isModuleExternal();
            }

            @Override
            public String getExternalHierarchy() {
                return page.getExternalHierarchy();
            }

            @Override
            public NonLinearBook getModule() {
                return page.getModule();
            }

            @Override
            public boolean isAutowire() {
                return page.isAutowire();
            }

            @Override
            public boolean isGlobalAutowire() {
                return page.isGlobalAutowire();
            }

            @Override
            public boolean isNoSave() {
                return page.isNoSave();
            }

            @Override
            public boolean isAutosFirst() {
                return page.isAutosFirst();
            }

            @Override
            public String getAutowireInText() {
                return page.getAutowireInText();
            }

            @Override
            public MultiLangString getAutowireInTexts() {
                return page.getAutowireInTexts();
            }

            @Override
            public String getAutowireOutText() {
                return page.getAutowireOutText();
            }

            @Override
            public MultiLangString getAutowireOutTexts() {
                return page.getAutowireOutTexts();
            }

            @Override
            public boolean isAutoIn() {
                return page.isAutoIn();
            }

            @Override
            public boolean isAutoOut() {
                return page.isAutoOut();
            }

            @Override
            public String getAutowireInConstrId() {
                return page.getAutowireInConstrId();
            }

            @Override
            public String getAutowireOutConstrId() {
                return page.getAutowireOutConstrId();
            }

            @Override
            public String getDefaultTagId() {
                return page.getDefaultTagId();
            }

            @Override
            public String getStroke() {
                return page.getStroke();
            }

            @Override
            public String getFill() {
                return page.getFill();
            }

            @Override
            public String getTextColor() {
                return page.getTextColor();
            }

            @Override
            public List<String> getContainedObjIds() {
                return page.getContainedObjIds();
            }

            @Override
            public Coords getCoords() {
                return page.getCoords();
            }

            @Override
            public List<Link> getLinks() {
                return page.getLinks();
            }

            @Override
            public Link getLinkById(@NotNull String linkId) {
                return page.getLinkById(linkId);
            }

            @Override
            public List<Modification> getModifications() {
                return page.getModifications();
            }

            @Override
            public boolean hasNoModifications() {
                return page.hasNoModifications();
            }

            @Override
            public Modification getModificationById(@NotNull String modId) {
                return page.getModificationById(modId);
            }

            @Override
            public String getId() {
                return page.getId();
            }

            @Override
            public String getFullId() {
                return page.getFullId();
            }

            @Override
            public boolean isDeleted() {
                return page.isDeleted();
            }

            @Override
            public IdentifiableItem getParent() {
                return page.getParent();
            }

            @Override
            public boolean hasDeletedParent() {
                return page.hasDeletedParent();
            }

            @Override
            public NonLinearBook getCurrentNLB() {
                return page.getCurrentNLB();
            }

            @Override
            public SearchResult searchText(SearchContract contract) {
                return page.searchText(contract);
            }

            @Override
            public String addObserver(NLBObserver observer) {
                throw new UnsupportedOperationException("Not supported during export");
            }

            @Override
            public void removeObserver(String observerId) {
                throw new UnsupportedOperationException("Not supported during export");
            }

            @Override
            public void notifyObservers() {
                throw new UnsupportedOperationException("Not supported during export");
            }
        };
    }

    private Obj createPreprocessedObj(final Obj obj) {
        return new Obj(){

            @Override
            public String getText() {
                return ExportManager.this.escapeText(obj.getText());
            }

            @Override
            public String getActText() {
                return ExportManager.this.escapeText(obj.getActText());
            }

            @Override
            public String getNouseText() {
                return ExportManager.this.escapeText(obj.getNouseText());
            }

            @Override
            public MultiLangString getTexts() {
                return ExportManager.this.escapeMultiLang(obj.getTexts());
            }

            @Override
            public MultiLangString getActTexts() {
                return ExportManager.this.escapeMultiLang(obj.getActTexts());
            }

            @Override
            public MultiLangString getNouseTexts() {
                return ExportManager.this.escapeMultiLang(obj.getNouseTexts());
            }

            @Override
            public Theme getEffectiveTheme() {
                return obj.getEffectiveTheme();
            }

            @Override
            public String getVarId() {
                return obj.getVarId();
            }

            @Override
            public String getConstrId() {
                return obj.getConstrId();
            }

            @Override
            public String getCommonToId() {
                return obj.getCommonToId();
            }

            @Override
            public Obj getCommonToObj(NonLinearBook nonLinearBook) {
                return obj.getCommonToObj(nonLinearBook);
            }

            @Override
            public String getName() {
                return obj.getName();
            }

            @Override
            public String getImageFileName() {
                return obj.getImageFileName();
            }

            @Override
            public String getSoundFileName() {
                return obj.getSoundFileName();
            }

            @Override
            public boolean isSoundSFX() {
                return obj.isSoundSFX();
            }

            @Override
            public boolean isAnimatedImage() {
                return obj.isAnimatedImage();
            }

            @Override
            public boolean isSuppressDsc() {
                return obj.isSuppressDsc();
            }

            @Override
            public String getDisp() {
                return ExportManager.this.escapeText(obj.getDisp());
            }

            @Override
            public MultiLangString getDisps() {
                return ExportManager.this.escapeMultiLang(obj.getDisps());
            }

            @Override
            public boolean isGraphical() {
                return obj.isGraphical();
            }

            @Override
            public boolean isShowOnCursor() {
                return obj.isShowOnCursor();
            }

            @Override
            public boolean isPreserved() {
                return obj.isPreserved();
            }

            @Override
            public boolean isLoadOnce() {
                return obj.isLoadOnce();
            }

            @Override
            public boolean isCollapsable() {
                return obj.isCollapsable();
            }

            @Override
            public String getOffset() {
                return obj.getOffset();
            }

            @Override
            public Obj.MovementDirection getMovementDirection() {
                return obj.getMovementDirection();
            }

            @Override
            public Obj.Effect getEffect() {
                return obj.getEffect();
            }

            @Override
            public int getStartFrame() {
                return obj.getStartFrame();
            }

            @Override
            public int getMaxFrame() {
                return obj.getMaxFrame();
            }

            @Override
            public int getPreloadFrames() {
                return obj.getPreloadFrames();
            }

            @Override
            public int getPauseFrames() {
                return obj.getPauseFrames();
            }

            @Override
            public Obj.CoordsOrigin getCoordsOrigin() {
                return obj.getCoordsOrigin();
            }

            @Override
            public boolean isClearUnderTooltip() {
                return obj.isClearUnderTooltip();
            }

            @Override
            public boolean isActOnKey() {
                return obj.isActOnKey();
            }

            @Override
            public boolean isCacheText() {
                return obj.isCacheText();
            }

            @Override
            public boolean isLooped() {
                return obj.isLooped();
            }

            @Override
            public boolean isNoRedrawOnAct() {
                return obj.isNoRedrawOnAct();
            }

            @Override
            public String getMorphOverId() {
                return obj.getMorphOverId();
            }

            @Override
            public Obj getMorphOverObj() {
                return obj.getMorphOverObj();
            }

            @Override
            public String getMorphOutId() {
                return obj.getMorphOutId();
            }

            @Override
            public Obj getMorphOutObj() {
                return obj.getMorphOutObj();
            }

            @Override
            public Coords getRelativeCoords(boolean lookInMorphs) {
                return obj.getRelativeCoords(lookInMorphs);
            }

            @Override
            public boolean isTakable() {
                return obj.isTakable();
            }

            @Override
            public boolean isImageInScene() {
                return obj.isImageInScene();
            }

            @Override
            public boolean isImageInInventory() {
                return obj.isImageInInventory();
            }

            @Override
            public String getContainerId() {
                return obj.getContainerId();
            }

            @Override
            public Obj.ContainerType getContainerType() {
                return obj.getContainerType();
            }

            @Override
            public String getCumulativeText(List<String> objIdsToBeExcluded, Map<String, Object> visitedVars) {
                return obj.getCumulativeText(objIdsToBeExcluded, visitedVars);
            }

            @Override
            public String getDefaultTagId() {
                return obj.getDefaultTagId();
            }

            @Override
            public String getStroke() {
                return obj.getStroke();
            }

            @Override
            public String getFill() {
                return obj.getFill();
            }

            @Override
            public String getTextColor() {
                return obj.getTextColor();
            }

            @Override
            public List<String> getContainedObjIds() {
                return obj.getContainedObjIds();
            }

            @Override
            public Coords getCoords() {
                return obj.getCoords();
            }

            @Override
            public List<Link> getLinks() {
                return obj.getLinks();
            }

            @Override
            public Link getLinkById(@NotNull String linkId) {
                return obj.getLinkById(linkId);
            }

            @Override
            public String getExternalHierarchy() {
                return obj.getExternalHierarchy();
            }

            @Override
            public List<Modification> getModifications() {
                return obj.getModifications();
            }

            @Override
            public boolean hasNoModifications() {
                return obj.hasNoModifications();
            }

            @Override
            public Modification getModificationById(@NotNull String modId) {
                return obj.getModificationById(modId);
            }

            @Override
            public String getId() {
                return obj.getId();
            }

            @Override
            public String getFullId() {
                return obj.getFullId();
            }

            @Override
            public boolean isDeleted() {
                return obj.isDeleted();
            }

            @Override
            public IdentifiableItem getParent() {
                return obj.getParent();
            }

            @Override
            public boolean hasDeletedParent() {
                return obj.hasDeletedParent();
            }

            @Override
            public NonLinearBook getCurrentNLB() {
                return obj.getCurrentNLB();
            }

            @Override
            public SearchResult searchText(SearchContract contract) {
                return obj.searchText(contract);
            }

            @Override
            public String addObserver(NLBObserver observer) {
                throw new UnsupportedOperationException("Not supported during export");
            }

            @Override
            public void removeObserver(String observerId) {
                throw new UnsupportedOperationException("Not supported during export");
            }

            @Override
            public void notifyObservers() {
                throw new UnsupportedOperationException("Not supported during export");
            }
        };
    }

    protected String decorateObjLabel(String id) {
        return EMPTY_STRING;
    }

    protected String decorateObjComment(String name) {
        return EMPTY_STRING;
    }

    protected String decorateObjStart(String id, String containerRef, ObjType objType, boolean showOnCursor, boolean preserved, boolean loadOnce, boolean clearUnderTooltip, boolean actOnKey, boolean cacheText, boolean looped, boolean noRedrawOnAct, boolean collapsable, String objDefaultTag, int pauseFrames) {
        return EMPTY_STRING;
    }

    protected String decorateObjName(String name, String id) {
        return EMPTY_STRING;
    }

    protected String decorateObjEffect(String offsetString, String coordString, boolean graphicalObj, boolean hasParentObj, Obj.MovementDirection movementDirection, Obj.Effect effect, Obj.CoordsOrigin coordsOrigin, int startFrame, int curStep, int maxStep) {
        return EMPTY_STRING;
    }

    protected String decorateObjPreload(int startFrame, int maxFrames, int preloadFrames) {
        return EMPTY_STRING;
    }

    protected String decorateMorphOver(String morphOverId, boolean graphicalObj) {
        return EMPTY_STRING;
    }

    protected String decorateMorphOut(String morphOutId, boolean graphicalObj) {
        return EMPTY_STRING;
    }

    protected String decorateObjImage(List<ImagePathData> objImagePathDatas, boolean graphicalObj) {
        return EMPTY_STRING;
    }

    protected String decorateObjDisp(String dispText, boolean imageEnabled, boolean isGraphicalObj) {
        return EMPTY_STRING;
    }

    protected String decorateObjText(String objId, String objName, boolean suppressDsc, String objText, boolean imageEnabled, boolean isGraphicalObj) {
        return EMPTY_STRING;
    }

    protected String decorateObjTak(String objName, String commonObjId) {
        return EMPTY_STRING;
    }

    protected String decorateObjInv(ObjType objType) {
        return EMPTY_STRING;
    }

    protected String decorateObjVariable(String variableName) {
        return EMPTY_STRING;
    }

    protected String decorateObjConstraint(String constraintValue) {
        return EMPTY_STRING;
    }

    protected String decorateObjCommonTo(String commonObjId) {
        return EMPTY_STRING;
    }

    protected String decorateObjModifications(String modificationsText) {
        return EMPTY_STRING;
    }

    protected String decorateObjActStart(String actTextExpanded, String commonObjId) {
        return EMPTY_STRING;
    }

    protected String decorateObjNouse(String nouseTextExpanded) {
        return EMPTY_STRING;
    }

    protected String decorateObjActEnd(boolean collapsable) {
        return EMPTY_STRING;
    }

    protected String decorateObjUseStart(String commonObjId) {
        return EMPTY_STRING;
    }

    protected String decorateObjUseEnd() {
        return EMPTY_STRING;
    }

    protected String decorateObjObjStart() {
        return EMPTY_STRING;
    }

    protected String decorateObjObjEnd() {
        return EMPTY_STRING;
    }

    protected String decorateUseTarget(String targetId) {
        return EMPTY_STRING;
    }

    protected String decorateUseVariable(String variableName) {
        return EMPTY_STRING;
    }

    protected String decorateUseModifications(String modificationsText) {
        return EMPTY_STRING;
    }

    protected String decorateObjEnd() {
        return EMPTY_STRING;
    }

    protected String decorateContainedObjId(String containedObjId) {
        return EMPTY_STRING;
    }

    protected String decorateObjSound(List<SoundPathData> objSoundPathDatas, boolean soundSFX) {
        return EMPTY_STRING;
    }

    protected String decorateObjArm(float left, float top) {
        return EMPTY_STRING;
    }

    private boolean isInlineLink(Link link) {
        String text = link.getText();
        return StringHelper.notEmpty(text) && (text.startsWith(this.escapeText("-")) || text.startsWith(this.escapeText("\"")) || text.startsWith(this.escapeText("'")) || this.determineTrivialStatus(link));
    }

    private LinkBuildingBlocks createLinkBuildingBlocks(Page page, Link link, ExportData exportData) throws NLBConsistencyException {
        String additionalConstraintText;
        String variableName;
        LinkBuildingBlocks blocks = new LinkBuildingBlocks();
        Theme theme = page.getEffectiveTheme();
        blocks.setTheme(theme);
        boolean trivial = this.determineTrivialStatus(link);
        blocks.setAuto(link.isAuto());
        blocks.setInline(this.isInlineLink(link));
        String expandedLinkText = this.expandVariablesForLinks(StringHelper.getTextChunks(link.getText()), theme);
        blocks.setLinkText(expandedLinkText);
        blocks.setLinkAltText(this.decorateLinkAltText(this.expandVariablesForLinks(StringHelper.getTextChunks(link.getAltText()), theme)));
        blocks.setTrivial(trivial);
        blocks.setLinkLabel(this.decorateLinkLabel(link.getId(), expandedLinkText, theme));
        blocks.setLinkComment(this.decorateLinkComment(link.getText()));
        blocks.setLinkStart(this.decorateLinkStart(link.getId(), expandedLinkText, link.isAuto(), trivial, this.checkedGetPageNumber(link.getTarget()), theme));
        Variable variable = exportData.getNlb().getVariableById(link.getVarId());
        String linkVisitStateVariable = link.isOnce() ? SpecialVariablesNameHelper.decorateLinkVisitStateVar(link.getId()) : EMPTY_STRING;
        boolean variableExists = variable != null && !variable.isDeleted();
        String string = variableName = variableExists ? variable.getName() : EMPTY_STRING;
        if (variableExists) {
            blocks.setLinkVariable(this.decorateLinkVariable(variableName));
        } else {
            blocks.setLinkVariable(EMPTY_STRING);
        }
        if (link.isOnce()) {
            blocks.setLinkVisitStateVariable(this.decorateLinkVisitStateVariable(linkVisitStateVariable));
        } else {
            blocks.setLinkVisitStateVariable(EMPTY_STRING);
        }
        Variable constraint = exportData.getNlb().getVariableById(link.getConstrId());
        String string2 = additionalConstraintText = link.isOnce() ? "!" + SpecialVariablesNameHelper.decorateLinkVisitStateVar(link.getId()) : EMPTY_STRING;
        if (StringHelper.notEmpty(additionalConstraintText) || constraint != null && !constraint.isDeleted() || link.isObeyToModuleConstraint() && !StringHelper.isEmpty(exportData.getModuleConstraintText())) {
            blocks.setLinkConstraint(this.translateConstraintBody(constraint != null ? constraint.getValue().trim() : EMPTY_STRING, link.isPositiveConstraint(), link.isObeyToModuleConstraint(), exportData.getModuleConstraintText(), additionalConstraintText));
        } else {
            blocks.setLinkConstraint(EMPTY_STRING);
        }
        blocks.setLinkModifications(this.decorateLinkModifications(this.buildModificationsText(this.getIndentString(), link.getModifications(), exportData)));
        int targetPageNumber = this.checkedGetPageNumber(link.getTarget());
        blocks.setTargetPageNumber(targetPageNumber);
        blocks.setLinkGoTo(this.decorateLinkGoTo(link.getId(), expandedLinkText, page.getId(), this.checkedGetPageNumber(page.getId()), link.getTarget(), targetPageNumber, theme));
        blocks.setLinkEnd(this.decorateLinkEnd(theme));
        return blocks;
    }

    protected String getIndentString() {
        return "    ";
    }

    private UseBuildingBlocks createUseBuildingBlocks(Obj obj, Link link, ExportData exportData) throws NLBConsistencyException {
        UseBuildingBlocks blocks = new UseBuildingBlocks();
        blocks.setUseTarget(this.decorateUseTarget(link.getTarget()));
        blocks.setUseSuccessText(this.expandVariablesForLinks(StringHelper.getTextChunks(link.getText()), obj.getEffectiveTheme()));
        blocks.setUseFailureText(this.expandVariablesForLinks(StringHelper.getTextChunks(link.getAltText()), obj.getEffectiveTheme()));
        Variable variable = exportData.getNlb().getVariableById(link.getVarId());
        if (variable != null && !variable.isDeleted()) {
            blocks.setUseVariable(this.decorateUseVariable(variable.getName()));
        } else {
            blocks.setUseVariable(EMPTY_STRING);
        }
        Variable constraint = exportData.getNlb().getVariableById(link.getConstrId());
        if (constraint != null && !constraint.isDeleted() || link.isObeyToModuleConstraint() && !StringHelper.isEmpty(exportData.getModuleConstraintText())) {
            blocks.setUseConstraint(this.translateConstraintBody(constraint != null ? constraint.getValue().trim() : EMPTY_STRING, link.isPositiveConstraint(), link.isObeyToModuleConstraint(), exportData.getModuleConstraintText(), EMPTY_STRING));
        } else {
            blocks.setUseConstraint(EMPTY_STRING);
        }
        blocks.setUseModifications(this.decorateUseModifications(this.buildModificationsText("    ", link.getModifications(), exportData)));
        return blocks;
    }

    private String translateConstraintBody(String constraintText, boolean isPositiveConstraint, boolean shouldObeyToModuleConstraint, String moduleConstraintText, String additionalConstraintText) throws NLBConsistencyException {
        String constraintBody;
        String string = shouldObeyToModuleConstraint && !StringHelper.isEmpty(moduleConstraintText) ? (StringHelper.notEmpty(constraintText) ? "(" + moduleConstraintText + ")&&(" + constraintText + ")" : moduleConstraintText) : (constraintBody = constraintText);
        if (StringHelper.notEmpty(additionalConstraintText)) {
            constraintBody = StringHelper.isEmpty(constraintBody) ? additionalConstraintText : "(" + additionalConstraintText + ")&&(" + constraintBody + ")";
        }
        ExpressionData expressionData = this.translateExpressionBody(constraintBody);
        return isPositiveConstraint ? expressionData.getExistencePart() + "(" + expressionData.getExpressionPart() + ")" : expressionData.getExistencePart() + "(" + this.decorateNot() + "(" + expressionData.getExpressionPart() + "))";
    }

    private ExpressionData translateExpressionBody(String expressionText) throws NLBConsistencyException {
        StringBuilder existenceBuilder = new StringBuilder();
        String expression = expressionText;
        Collection<String> expressionVars = VarFinder.findVariableNames(expression);
        expression = expression.replaceAll("\\s*==\\s*", " 000369f3-943a-4696-9c20-f6471b5c131d ");
        expression = expression.replaceAll("\\s*!=\\s*", " 211c47bf-dad2-49d1-9ab0-162082d2664c ");
        expression = expression.replaceAll("\\s*>=\\s*", " 94e69065-f584-4d98-a6c9-667e2c6dc3ee ");
        expression = expression.replaceAll("\\s*<=\\s*", " 17190e04-4537-414f-9c57-25676a99ad6e ");
        expression = expression.replaceAll("\\s*>\\s*", " 74ea093d-1918-4e02-b2bd-a929d7db4b0c ");
        expression = expression.replaceAll("\\s*<\\s*", " c5549d03-b258-4f77-b760-5d13bf981780 ");
        expression = expression.replaceAll("\\s*&&\\s*", " f0e77ec8-a270-4a3f-8b8f-1ade38988f37 ");
        expression = expression.replaceAll("\\s*\\|\\|\\s*", " 179ef88a-88b7-4ad2-8dfa-d2040debde73 ");
        expression = expression.replaceAll("\\s*!\\s*", " 2164a414-ba30-45b4-baa3-c32e194304db ");
        expression = expression.replaceAll(EQ_PLACEHOLDER, this.decorateEq());
        expression = expression.replaceAll(NEQ_PLACEHOLDER, this.decorateNEq());
        expression = expression.replaceAll(GT_PLACEHOLDER, this.decorateGt());
        expression = expression.replaceAll(GTE_PLACEHOLDER, this.decorateGte());
        expression = expression.replaceAll(LT_PLACEHOLDER, this.decorateLt());
        expression = expression.replaceAll(LTE_PLACEHOLDER, this.decorateLte());
        expression = expression.replaceAll(AND_PLACEHOLDER, this.decorateAnd());
        expression = expression.replaceAll(OR_PLACEHOLDER, this.decorateOr());
        for (String expressionVar : expressionVars) {
            String existenceExpression;
            String decoratedVariable = this.decorateVariable(expressionVar);
            Variable.DataType dataType = this.m_dataTypeMap.get(expressionVar);
            if (dataType != Variable.DataType.BOOLEAN && !StringHelper.isEmpty(existenceExpression = this.decorateExistence(decoratedVariable))) {
                existenceBuilder.append(existenceExpression).append(" ").append(this.decorateAnd()).append(" ");
            }
            expression = expression.replaceAll("\\b" + expressionVar + "\\b", Matcher.quoteReplacement(decoratedVariable));
        }
        expression = expression.replaceAll("2164a414-ba30-45b4-baa3-c32e194304db ", this.decorateNot());
        expression = expression.replaceAll("\\b\\s*true\\s*\\b", " " + Matcher.quoteReplacement(this.decorateTrue()) + " ");
        expression = expression.replaceAll("\\b\\s*false\\s*\\b", " " + Matcher.quoteReplacement(this.decorateFalse()) + " ");
        return new ExpressionData(existenceBuilder.toString(), expression);
    }

    private String decorateVariable(String constraintVar) throws NLBConsistencyException {
        Variable.DataType dataType = this.m_dataTypeMap.get(constraintVar);
        if (dataType == null) {
            throw new NLBConsistencyException("Datatype of the variable " + constraintVar + " cannot be determined. Please verify that this variable is defined.");
        }
        switch (dataType) {
            case BOOLEAN: {
                return this.additionalDecorationForVariableInExpression(this.decorateBooleanVar(constraintVar));
            }
            case NUMBER: {
                return this.decorateNumberVar(constraintVar);
            }
            case STRING: {
                return this.decorateStringVar(constraintVar);
            }
        }
        return this.additionalDecorationForVariableInExpression(this.decorateAutoVar(constraintVar));
    }

    protected String additionalDecorationForVariableInExpression(String variable) {
        return variable;
    }

    private String decorateAutoVar(String constraintVar) {
        return this.decorateNumberVar(constraintVar);
    }

    private String buildModificationsText(String indentString, List<Modification> modifications, ExportData exportData) throws NLBConsistencyException {
        StringBuilder stringBuilder = new StringBuilder();
        Page modulePage = exportData.getModulePage();
        block62: for (Modification modification : modifications) {
            Variable variable;
            boolean shouldUse;
            boolean bl = shouldUse = !modification.isExternal() || modulePage != null && modulePage.isModuleExternal();
            if (modification.isDeleted() || !shouldUse) continue;
            stringBuilder.append(indentString);
            Variable variable2 = variable = StringHelper.isEmpty(modification.getVarId()) ? null : exportData.getNlb().getVariableById(modification.getVarId());
            if (modification.returnsValue() && (variable == null || variable.isDeleted())) {
                throw new NLBConsistencyException("Variable with id = " + modification.getVarId() + " cannot be found for modification " + modification.getFullId());
            }
            Variable expression = exportData.getNlb().getVariableById(modification.getExprId());
            if (modification.isParametrized() && (expression == null || expression.isDeleted())) {
                throw new NLBConsistencyException("Expression with id = " + modification.getExprId() + " cannot be found for modification " + modification.getFullId());
            }
            boolean unique = false;
            switch (modification.getType()) {
                case TAG: {
                    boolean hasName = variable != null;
                    String varName = variable != null ? variable.getName() : EMPTY_STRING;
                    String objIdToTag = hasName ? exportData.getObjId(varName) : null;
                    stringBuilder.append(this.decorateTag(hasName ? this.decorateAutoVar(varName) : EMPTY_STRING, objIdToTag, expression.getValue()));
                    continue block62;
                }
                case GETTAG: {
                    String resName = variable != null ? variable.getName() : EMPTY_STRING;
                    String gettagObjId = expression != null ? exportData.getObjId(expression.getValue()) : null;
                    stringBuilder.append(this.decorateGetTagOperation(this.decorateStringVar(resName), gettagObjId, expression != null && StringHelper.notEmpty(expression.getValue()) ? this.decorateAutoVar(expression.getValue()) : EMPTY_STRING));
                    continue block62;
                }
                case WHILE: {
                    stringBuilder.append(this.decorateWhile(this.translateConstraintBody(expression.getValue(), true, false, EMPTY_STRING, EMPTY_STRING)));
                    continue block62;
                }
                case IF: {
                    stringBuilder.append(this.decorateIf(this.translateConstraintBody(expression.getValue(), true, false, EMPTY_STRING, EMPTY_STRING)));
                    continue block62;
                }
                case IFHAVE: {
                    assert (variable != null);
                    String objIdForIfHave = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateIfHave(objIdForIfHave, this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case ELSE: {
                    stringBuilder.append(this.decorateElse());
                    continue block62;
                }
                case ELSEIF: {
                    stringBuilder.append(this.decorateElseIf(this.translateConstraintBody(expression.getValue(), true, false, EMPTY_STRING, EMPTY_STRING)));
                    continue block62;
                }
                case END: {
                    stringBuilder.append(this.decorateEnd());
                    continue block62;
                }
                case RETURN: {
                    String valueToReturn = expression != null && StringHelper.notEmpty(expression.getValue()) ? this.translateExpressionBody(expression.getValue()).getExpressionPart() : EMPTY_STRING;
                    stringBuilder.append(this.decorateReturn(valueToReturn));
                    continue block62;
                }
                case HAVE: {
                    assert (variable != null);
                    String objIdToCheck = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateHaveOperation(this.decorateBooleanVar(variable.getName()), objIdToCheck, this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case CLONE: {
                    assert (variable != null);
                    String cloneArg = expression != null ? this.decorateAutoVar(expression.getValue()) : null;
                    String objIdToClone = expression != null ? exportData.getObjId(expression.getValue()) : null;
                    stringBuilder.append(this.decorateCloneOperation(this.decorateAutoVar(variable.getName()), objIdToClone, cloneArg));
                    continue block62;
                }
                case CNTNR: {
                    assert (variable != null);
                    String containerArg = expression != null ? this.decorateAutoVar(expression.getValue()) : null;
                    String objIdToGetContainer = expression != null ? exportData.getObjId(expression.getValue()) : null;
                    stringBuilder.append(this.decorateContainerOperation(this.decorateAutoVar(variable.getName()), objIdToGetContainer, containerArg));
                    continue block62;
                }
                case ID: {
                    assert (variable != null);
                    String objIdToGetId = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateGetIdOperation(variable.getDataType() == Variable.DataType.STRING ? this.decorateStringVar(variable.getName()) : this.decorateAutoVar(variable.getName()), objIdToGetId, this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case ADDU: {
                    unique = true;
                }
                case ADD: {
                    String addDestinationId = variable != null ? exportData.getObjId(variable.getName()) : null;
                    String objIdToAdd = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateAddObj(addDestinationId, objIdToAdd, this.decorateAutoVar(expression.getValue()), expression.getValue(), objIdToAdd == null ? null : exportData.getNlb().getObjById(objIdToAdd).getDisp(), unique));
                    continue block62;
                }
                case ADDINV: {
                    String objIdToAddInv = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateAddInvObj(objIdToAddInv, this.decorateAutoVar(expression.getValue()), expression.getValue(), objIdToAddInv == null ? null : exportData.getNlb().getObjById(objIdToAddInv).getDisp()));
                    continue block62;
                }
                case ADDALLU: {
                    unique = true;
                }
                case ADDALL: {
                    String addAllDestinationId = variable != null ? exportData.getObjId(variable.getName()) : null;
                    stringBuilder.append(this.decorateAddAllOperation(addAllDestinationId, addAllDestinationId == null && variable != null ? this.decorateAutoVar(variable.getName()) : null, this.decorateAutoVar(expression.getValue()), unique));
                    continue block62;
                }
                case REMOVE: {
                    String removeDestinationId = variable != null ? exportData.getObjId(variable.getName()) : null;
                    String removeDestinationName = variable != null && removeDestinationId == null ? this.decorateAutoVar(variable.getName()) : null;
                    String objIdToRemove = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateDelObj(removeDestinationId, removeDestinationName, objIdToRemove, this.decorateAutoVar(expression.getValue()), expression.getValue(), objIdToRemove != null ? exportData.getNlb().getObjById(objIdToRemove).getDisp() : null));
                    continue block62;
                }
                case RMINV: {
                    String objIdToRmInv = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateDelInvObj(objIdToRmInv, this.decorateAutoVar(expression.getValue()), expression.getValue(), objIdToRmInv != null ? exportData.getNlb().getObjById(objIdToRmInv).getDisp() : null));
                    continue block62;
                }
                case CLEAR: {
                    String destinationId = expression != null ? exportData.getObjId(expression.getValue()) : null;
                    stringBuilder.append(this.decorateClearOperation(destinationId, expression != null ? this.decorateAutoVar(expression.getValue()) : null));
                    continue block62;
                }
                case CLRINV: {
                    stringBuilder.append(this.decorateClearInvOperation());
                    continue block62;
                }
                case OBJS: {
                    String srcObjId = exportData.getObjId(expression.getValue());
                    if (variable != null) {
                        stringBuilder.append(this.decorateObjsOperation(this.decorateAutoVar(variable.getName()), srcObjId, this.decorateAutoVar(expression.getValue())));
                        continue block62;
                    }
                    throw new NLBConsistencyException("Destination list variable name is not specified for objs operation");
                }
                case SSND: {
                    stringBuilder.append(this.decorateSSndOperation());
                    continue block62;
                }
                case WSND: {
                    stringBuilder.append(this.decorateWSndOperation());
                    continue block62;
                }
                case SND: {
                    String sndArgObjId = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateSndOperation(sndArgObjId, this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case SPUSH: {
                    stringBuilder.append(this.decorateSPushOperation(this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case WPUSH: {
                    stringBuilder.append(this.decorateWPushOperation(this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case PUSH: {
                    String objIdToPush = exportData.getObjId(expression.getValue());
                    if (variable != null) {
                        stringBuilder.append(this.decoratePushOperation(this.decorateAutoVar(variable.getName()), objIdToPush, this.decorateAutoVar(expression.getValue())));
                        continue block62;
                    }
                    throw new NLBConsistencyException("Destination list variable name is not specified for push operation");
                }
                case POP: {
                    assert (variable != null);
                    stringBuilder.append(this.decoratePopOperation(this.decorateAutoVar(variable.getName()), this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case SINJECT: {
                    stringBuilder.append(this.decorateSInjectOperation(this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case INJECT: {
                    String objIdToInject = exportData.getObjId(expression.getValue());
                    if (variable != null) {
                        stringBuilder.append(this.decorateInjectOperation(this.decorateAutoVar(variable.getName()), objIdToInject, this.decorateAutoVar(expression.getValue())));
                        continue block62;
                    }
                    throw new NLBConsistencyException("Destination list variable name is not specified for inject operation");
                }
                case EJECT: {
                    assert (variable != null);
                    stringBuilder.append(this.decorateEjectOperation(this.decorateAutoVar(variable.getName()), this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case SHUFFLE: {
                    stringBuilder.append(this.decorateShuffleOperation(this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case PRN: {
                    String prnArg;
                    switch (expression.getDataType()) {
                        case STRING: {
                            prnArg = this.decorateStringVar(expression.getValue());
                            break;
                        }
                        case BOOLEAN: {
                            prnArg = this.decorateBooleanVar(expression.getValue());
                            break;
                        }
                        case NUMBER: {
                            prnArg = this.decorateNumberVar(expression.getValue());
                            break;
                        }
                        default: {
                            prnArg = this.decorateAutoVar(expression.getValue());
                        }
                    }
                    stringBuilder.append(this.decoratePRNOperation(prnArg));
                    continue block62;
                }
                case DSC: {
                    assert (variable != null);
                    String dscObjId = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateDSCOperation(this.decorateStringVar(variable.getName()), this.decorateAutoVar(expression.getValue()), dscObjId));
                    continue block62;
                }
                case PDSC: {
                    stringBuilder.append(this.decoratePDscOperation(this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case PDSCS: {
                    String pdscsArg = expression != null ? this.decorateAutoVar(expression.getValue()) : null;
                    String objIdToPdscs = expression != null ? exportData.getObjId(expression.getValue()) : null;
                    stringBuilder.append(this.decoratePDscsOperation(objIdToPdscs, pdscsArg));
                    continue block62;
                }
                case ACT: {
                    String actingObjId = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateActOperation(this.decorateAutoVar(expression.getValue()), actingObjId));
                    continue block62;
                }
                case ACTT: {
                    assert (variable != null);
                    String actObjId = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateActtOperation(this.decorateStringVar(variable.getName()), this.decorateAutoVar(expression.getValue()), actObjId));
                    continue block62;
                }
                case ACTF: {
                    String actfingObjId = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateActfOperation(this.decorateAutoVar(expression.getValue()), actfingObjId));
                    continue block62;
                }
                case USE: {
                    assert (variable != null);
                    String sourceId = exportData.getObjId(variable.getName());
                    String targetId = exportData.getObjId(expression.getValue());
                    stringBuilder.append(this.decorateUseOperation(sourceId != null ? variable.getName() : this.decorateAutoVar(variable.getName()), sourceId, targetId != null ? expression.getValue() : this.decorateAutoVar(expression.getValue()), targetId));
                    continue block62;
                }
                case ASSIGN: {
                    assert (variable != null);
                    stringBuilder.append(this.decorateAssignment(variable.getDataType() == Variable.DataType.STRING ? this.decorateStringVar(variable.getName()) : this.decorateAutoVar(variable.getName()), this.translateExpressionBody(expression.getValue()).getExpressionPart()));
                    continue block62;
                }
                case SIZE: {
                    assert (variable != null);
                    stringBuilder.append(this.decorateSizeOperation(this.decorateNumberVar(variable.getName()), this.decorateAutoVar(expression.getValue())));
                    continue block62;
                }
                case RND: {
                    assert (variable != null);
                    stringBuilder.append(this.decorateRndOperation(this.decorateAutoVar(variable.getName()), this.translateExpressionBody(expression.getValue()).getExpressionPart()));
                    continue block62;
                }
                case ACHMAX: {
                    if (variable != null) {
                        stringBuilder.append(this.decorateAchMaxOperation(variable.getName(), Integer.parseInt(expression.getValue())));
                        continue block62;
                    }
                    throw new NLBConsistencyException("Destination achievement name is not specified for ACHMAX operation");
                }
                case ACHIEVE: {
                    stringBuilder.append(this.decorateAchieveOperation(expression.getValue(), modification.getId()));
                    continue block62;
                }
                case ACHIEVED: {
                    assert (variable != null);
                    stringBuilder.append(this.decorateAchievedOperation(this.decorateAutoVar(variable.getName()), expression.getValue()));
                    continue block62;
                }
                case GOTO: {
                    stringBuilder.append(this.decorateGoToOperation(expression.getValue()));
                    continue block62;
                }
                case SNAPSHOT: {
                    String snapshotId = expression != null && StringHelper.notEmpty(expression.getValue()) ? this.translateExpressionBody(expression.getValue()).getExpressionPart() : EMPTY_STRING;
                    stringBuilder.append(this.decorateSnapshotOperation(snapshotId));
                    continue block62;
                }
                case OPENURL: {
                    stringBuilder.append(this.decorateOpenURLOperation(expression.getValue()));
                    continue block62;
                }
                case WINGEOM: {
                    stringBuilder.append(this.decorateWinGeomOperation(expression.getValue()));
                    continue block62;
                }
                case INVGEOM: {
                    stringBuilder.append(this.decorateInvGeomOperation(expression.getValue()));
                    continue block62;
                }
                case WINCOLOR: {
                    stringBuilder.append(this.decorateWinColorOperation(expression.getValue()));
                    continue block62;
                }
                case INVCOLOR: {
                    stringBuilder.append(this.decorateInvColorOperation(expression.getValue()));
                    continue block62;
                }
            }
            throw new NLBConsistencyException("Operation has unknown type for modification with id = " + modification.getFullId());
        }
        return stringBuilder.toString();
    }

    protected abstract String decorateAssignment(String var1, String var2);

    protected abstract String decorateTag(String var1, String var2, String var3);

    protected abstract String decorateGetTagOperation(String var1, String var2, String var3);

    protected abstract String decorateWhile(String var1);

    protected abstract String decorateIf(String var1);

    protected abstract String decorateIfHave(String var1, String var2);

    protected abstract String decorateElse();

    protected abstract String decorateElseIf(String var1);

    protected abstract String decorateEnd();

    protected abstract String decorateReturn(String var1);

    protected abstract String decorateHaveOperation(String var1, String var2, String var3);

    protected abstract String decorateCloneOperation(String var1, String var2, String var3);

    protected abstract String decorateContainerOperation(String var1, String var2, String var3);

    protected abstract String decorateGetIdOperation(String var1, String var2, String var3);

    protected abstract String decorateDelObj(String var1, String var2, String var3, String var4, String var5, String var6);

    protected abstract String decorateDelInvObj(String var1, String var2, String var3, String var4);

    protected abstract String decorateAddObj(String var1, String var2, String var3, String var4, String var5, boolean var6);

    protected abstract String decorateAddInvObj(String var1, String var2, String var3, String var4);

    protected abstract String decorateAddAllOperation(String var1, String var2, String var3, boolean var4);

    protected abstract String decorateObjsOperation(String var1, String var2, String var3);

    protected abstract String decorateSSndOperation();

    protected abstract String decorateWSndOperation();

    protected abstract String decorateSndOperation(String var1, String var2);

    protected abstract String decorateSPushOperation(String var1);

    protected abstract String decorateWPushOperation(String var1);

    protected abstract String decoratePushOperation(String var1, String var2, String var3);

    protected abstract String decoratePopOperation(String var1, String var2);

    protected abstract String decorateSInjectOperation(String var1);

    protected abstract String decorateInjectOperation(String var1, String var2, String var3);

    protected abstract String decorateEjectOperation(String var1, String var2);

    protected abstract String decorateClearOperation(String var1, String var2);

    protected abstract String decorateClearInvOperation();

    protected abstract String decorateSizeOperation(String var1, String var2);

    protected abstract String decorateRndOperation(String var1, String var2);

    protected abstract String decorateAchMaxOperation(String var1, int var2);

    protected abstract String decorateAchieveOperation(String var1, String var2);

    protected abstract String decorateAchievedOperation(String var1, String var2);

    protected abstract String decorateGoToOperation(String var1);

    protected abstract String decorateSnapshotOperation(String var1);

    protected abstract String decorateOpenURLOperation(String var1);

    protected abstract String decorateWinGeomOperation(String var1);

    protected abstract String decorateInvGeomOperation(String var1);

    protected abstract String decorateWinColorOperation(String var1);

    protected abstract String decorateInvColorOperation(String var1);

    protected abstract String decorateShuffleOperation(String var1);

    protected abstract String decoratePRNOperation(String var1);

    protected abstract String decorateDSCOperation(String var1, String var2, String var3);

    protected abstract String decoratePDscOperation(String var1);

    protected abstract String decoratePDscsOperation(String var1, String var2);

    protected abstract String decorateActOperation(String var1, String var2);

    protected abstract String decorateActtOperation(String var1, String var2, String var3);

    protected abstract String decorateActfOperation(String var1, String var2);

    protected abstract String decorateUseOperation(String var1, String var2, String var3, String var4);

    protected abstract String decorateTrue();

    protected abstract String decorateFalse();

    protected abstract String decorateEq();

    protected abstract String decorateNEq();

    protected abstract String decorateGt();

    protected abstract String decorateGte();

    protected abstract String decorateLt();

    protected abstract String decorateLte();

    protected abstract String decorateNot();

    protected abstract String decorateOr();

    protected abstract String decorateAnd();

    protected abstract String decorateExistence(String var1);

    protected abstract String decorateBooleanVar(String var1);

    protected abstract String decorateStringVar(String var1);

    protected abstract String decorateNumberVar(String var1);

    protected String decorateLinkText(String text) {
        if (StringHelper.isEmpty(text)) {
            return EMPTY_STRING;
        }
        return text;
    }

    protected String decorateLinkAltText(String text) {
        if (StringHelper.isEmpty(text)) {
            return EMPTY_STRING;
        }
        return text;
    }

    protected abstract String decorateLinkLabel(String var1, String var2, Theme var3);

    protected abstract String decorateLinkComment(String var1);

    protected abstract String decorateLinkStart(String var1, String var2, boolean var3, boolean var4, int var5, Theme var6);

    protected abstract String decorateLinkGoTo(String var1, String var2, String var3, int var4, String var5, int var6, Theme var7);

    protected String decorateLinkEnd(Theme theme) {
        return EMPTY_STRING;
    }

    protected abstract String decoratePageEnd(boolean var1);

    protected abstract String decorateLinkVariable(String var1);

    protected abstract String decorateLinkVisitStateVariable(String var1);

    protected abstract String decoratePageVariable(String var1);

    protected abstract String decoratePageTimerVariableInit(String var1);

    protected abstract String decoratePageTimerVariable(String var1);

    protected abstract String decoratePageModifications(String var1);

    protected abstract String decoratePageThemeModifications(String var1);

    protected abstract String decorateLinkModifications(String var1);

    protected abstract String decoratePageCaption(String var1, boolean var2, String var3, boolean var4);

    protected abstract String decoratePageNotes(String var1);

    @NotNull
    protected String getNonEmptyTitle(String moduleTitle) {
        return StringHelper.notEmpty(moduleTitle) ? moduleTitle : "...";
    }

    private String getNonEmptyTitle(NonLinearBook module) {
        String title = module.getTitle();
        if (StringHelper.isEmpty(title) && module.getParentNLB() != null && !module.getParentNLB().isDummy()) {
            return this.getNonEmptyTitle(module.getParentNLB());
        }
        return this.getNonEmptyTitle(title);
    }

    protected abstract String decoratePageImage(List<ImagePathData> var1, boolean var2, Theme var3);

    protected abstract String decoratePageSound(String var1, List<SoundPathData> var2, boolean var3, Theme var4);

    private String getRedirectMediaOrSelf(String mediaFileName) {
        if (this.m_mediaRedirectsMap.containsKey(mediaFileName)) {
            return this.m_mediaRedirectsMap.get(mediaFileName);
        }
        return mediaFileName;
    }

    protected String expandVariables(List<TextChunk> textChunks, Theme theme) {
        return this.expandVariables(textChunks);
    }

    protected String expandVariablesForLinks(List<TextChunk> textChunks, Theme theme) {
        return this.expandVariables(textChunks, theme);
    }

    protected String expandVariables(List<TextChunk> textChunks) {
        StringBuilder result = new StringBuilder();
        for (TextChunk textChunk : textChunks) {
            switch (textChunk.getType()) {
                case TEXT: {
                    result.append(textChunk.getText());
                    break;
                }
                case ACTION_TEXT: 
                case VARIABLE: {
                    result.append("$").append(textChunk.getText()).append("$");
                    break;
                }
                case NEWLINE: {
                    result.append(this.getLineSeparator());
                }
            }
        }
        return result.toString();
    }

    protected List<ImagePathData> getImagePaths(String externalHierarchy, String imageFileNames, boolean animatedImage, boolean removeFrameNumber) throws NLBExportException {
        String[] fileNamesArr;
        if (StringHelper.isEmpty(imageFileNames)) {
            return new ArrayList<ImagePathData>(){
                {
                    this.add(ImagePathData.EMPTY);
                }
            };
        }
        ArrayList<ImagePathData> result = new ArrayList<ImagePathData>();
        for (String fileName : fileNamesArr = imageFileNames.split(";")) {
            MediaExportParameters mediaExportParameters = this.getMediaExportParameters(externalHierarchy, fileName);
            result.add(this.getImagePath(externalHierarchy, fileName, animatedImage, removeFrameNumber, mediaExportParameters));
        }
        return result;
    }

    private MediaExportParameters getMediaExportParameters(String externalHierarchy, String fileName) {
        String key = this.getMediaMapKeyWithRespectToHierarchy(externalHierarchy, fileName);
        MediaExportParameters result = this.m_mediaExportParametersMap.get(key);
        if (result != null) {
            return result;
        }
        return MediaExportParameters.getDefault();
    }

    protected ImagePathData getImagePath(String externalHierarchy, String imageFileName, boolean animatedImage, boolean removeFrameNumber, MediaExportParameters mediaExportParameters) throws NLBExportException {
        ImagePathData result = new ImagePathData();
        result.setRemoveFrameNumber(removeFrameNumber);
        Matcher matcher = FILE_NAME_PATTERN.matcher(this.getRedirectMediaOrSelf(imageFileName));
        if (matcher.find()) {
            if (StringHelper.isEmpty(externalHierarchy)) {
                result.setParentFolderPath("images");
            } else {
                result.setParentFolderPath("images/" + externalHierarchy);
            }
            if (animatedImage) {
                String fileName = matcher.group(1);
                int len = fileName.length();
                if (removeFrameNumber && fileName.endsWith(".") && len > 0) {
                    result.setFileName(fileName.substring(0, len - 1));
                } else {
                    result.setFileName(fileName);
                }
                result.setMaxFrameNumber(Integer.parseInt(matcher.group(2)));
            } else {
                result.setFileName(matcher.group(1) + matcher.group(2));
                result.setMaxFrameNumber(0);
            }
            String matchedExtension = matcher.group(3);
            if (mediaExportParameters.isConvertPNG2JPG() && ".png".equalsIgnoreCase(matchedExtension)) {
                result.setFileExtension(".jpg");
            } else {
                result.setFileExtension(matchedExtension);
            }
            String key = this.getMediaMapKeyWithRespectToHierarchy(externalHierarchy, imageFileName);
            if (this.m_mediaToConstraintMap.containsKey(key)) {
                result.setConstraint(this.m_mediaToConstraintMap.get(key));
            } else {
                result.setConstraint(EMPTY_STRING);
            }
            return result;
        }
        throw new NLBExportException("Filename " + imageFileName + " is bad, please rename");
    }

    private String getMediaMapKeyWithRespectToHierarchy(String externalHierarchy, String imageFileName) {
        return StringHelper.isEmpty(externalHierarchy) ? imageFileName : externalHierarchy + "/" + imageFileName;
    }

    protected List<SoundPathData> getSoundPaths(String externalHierarchy, String soundFileNames) {
        String[] fileNamesArr;
        if (StringHelper.isEmpty(soundFileNames)) {
            return new ArrayList<SoundPathData>(){
                {
                    this.add(SoundPathData.EMPTY);
                }
            };
        }
        ArrayList<SoundPathData> result = new ArrayList<SoundPathData>();
        for (String fileName : fileNamesArr = soundFileNames.split(";")) {
            result.add(this.getSoundPath(externalHierarchy, fileName));
        }
        return result;
    }

    protected SoundPathData getSoundPath(String externalHierarchy, String soundFileName) {
        if (StringHelper.isEmpty(soundFileName)) {
            return SoundPathData.EMPTY;
        }
        if ("VOID".equals(soundFileName)) {
            return SoundPathData.VOID;
        }
        SoundPathData result = new SoundPathData();
        if (StringHelper.isEmpty(externalHierarchy)) {
            result.setParentFolderPath("sound");
        } else {
            result.setParentFolderPath("sound/" + externalHierarchy);
        }
        result.setFileName(this.getRedirectMediaOrSelf(soundFileName));
        if (this.m_mediaToConstraintMap.containsKey(soundFileName)) {
            result.setConstraint(this.m_mediaToConstraintMap.get(soundFileName));
        } else {
            result.setConstraint(EMPTY_STRING);
        }
        if (StringHelper.isEmpty(externalHierarchy)) {
            result.setSfx(this.m_mediaFlagsMap.get(soundFileName));
        } else {
            result.setSfx(this.m_mediaFlagsMap.get(externalHierarchy + "/" + soundFileName));
        }
        return result;
    }

    protected String decoratePageTextStart(String labelText, int pageNumber, List<TextChunk> pageTextChunks, Theme theme) {
        return this.expandVariables(pageTextChunks, theme);
    }

    protected abstract String getLineSeparator();

    protected abstract String decoratePageTextEnd(String var1, int var2, Theme var3, boolean var4);

    protected boolean getGoToPageNumbers() {
        return false;
    }

    protected String decorateId(String id) {
        return "v_" + SpecialVariablesNameHelper.decorateId(id);
    }

    protected String decoratePageName(String labelText, int pageNumber) {
        return this.getGoToPageNumbers() ? this.decorateId(String.valueOf(pageNumber)) : this.decorateId(labelText);
    }

    protected abstract String decoratePageLabel(String var1, int var2, Theme var3);

    protected abstract String decoratePageNumber(int var1);

    protected abstract String decoratePageComment(String var1);

    private class ExportData {
        private NonLinearBook m_nlb;
        private Page m_modulePage;
        private String m_moduleConstraintText;
        private Integer m_modulePageNumber;
        private List<Page> m_pageList = new ArrayList<Page>();
        private List<Obj> m_objList = new ArrayList<Obj>();
        private Map<String, Integer> m_idToPageNumberMap = new HashMap<String, Integer>();
        private Map<String, String> m_objNamToIdMap = new HashMap<String, String>();
        private Map<String, Boolean> m_inwardLinksMap = new HashMap<String, Boolean>();
        private ExportData m_parentED;

        private ExportData(NonLinearBook nlb, Page modulePage, String moduleConstraintText, Integer modulePageNumber, ExportData parentED) {
            this.m_nlb = nlb;
            this.m_modulePage = modulePage;
            this.m_moduleConstraintText = moduleConstraintText;
            this.m_modulePageNumber = modulePageNumber;
            this.m_parentED = parentED;
        }

        private int size() {
            int result = 0;
            for (Page page : this.m_pageList) {
                if (page.getModule().isEmpty()) {
                    ++result;
                    continue;
                }
                NonLinearBook.BookStatistics stats = page.getModule().getBookStatistics();
                result += stats.getPagesCount() + 1;
            }
            return result;
        }

        private Map<String, ExportData> init() throws NLBConsistencyException {
            HashMap<String, ExportData> result = new HashMap<String, ExportData>();
            this.m_idToPageNumberMap.put(this.m_modulePage.getId(), this.m_modulePageNumber);
            result.put(this.m_modulePage.getId(), this);
            String startPoint = this.m_nlb.getStartPoint();
            Page startPage = this.m_nlb.getPageById(startPoint);
            if (startPage == null || startPage.isDeleted()) {
                throw new NLBConsistencyException("Startpoint error: start page is deleted or missing");
            }
            this.m_pageList.add(startPage);
            int pageNumber = this.m_modulePageNumber + 1;
            this.m_idToPageNumberMap.put(startPage.getId(), pageNumber);
            Variable modConstr = this.m_nlb.getVariableById(startPage.getModuleConstrId());
            if (startPage.getModule().isEmpty()) {
                ++pageNumber;
            } else {
                ExportData moduleED = new ExportData(startPage.getModule(), startPage, modConstr != null ? modConstr.getValue() : ExportManager.EMPTY_STRING, pageNumber, this);
                result.putAll(moduleED.init());
                this.m_idToPageNumberMap.put(moduleED.getNlb().getStartPoint(), pageNumber + 1);
                pageNumber += moduleED.size() + 1;
            }
            for (Page page : this.m_nlb.getPages().values()) {
                if (page.isDeleted() || page.getId().equals(startPoint)) continue;
                this.m_pageList.add(page);
                this.m_idToPageNumberMap.put(page.getId(), pageNumber);
                Variable pageModConstr = this.m_nlb.getVariableById(page.getModuleConstrId());
                if (page.getModule().isEmpty()) {
                    ++pageNumber;
                    continue;
                }
                ExportData moduleED = new ExportData(page.getModule(), page, pageModConstr != null ? pageModConstr.getValue() : ExportManager.EMPTY_STRING, pageNumber, this);
                result.putAll(moduleED.init());
                this.m_idToPageNumberMap.put(moduleED.getNlb().getStartPoint(), pageNumber + 1);
                pageNumber += moduleED.size() + 1;
            }
            for (Obj obj : this.m_nlb.getObjs().values()) {
                if (!obj.isDeleted()) {
                    this.m_objList.add(obj);
                    this.m_objNamToIdMap.put(obj.getName(), obj.getId());
                }
                for (Link link : obj.getLinks()) {
                    this.m_inwardLinksMap.put(link.getTarget(), true);
                }
            }
            return result;
        }

        private Page getModulePage() {
            return this.m_modulePage;
        }

        private String getModuleConstraintText() {
            return this.m_moduleConstraintText;
        }

        private NonLinearBook getNlb() {
            return this.m_nlb;
        }

        private List<Page> getPageList() {
            return this.m_pageList;
        }

        private List<Obj> getObjList() {
            return this.m_objList;
        }

        private Boolean hasInwardLinks(String objId) {
            if (this.m_inwardLinksMap.containsKey(objId)) {
                return this.m_inwardLinksMap.get(objId);
            }
            if (this.m_parentED != null) {
                return this.m_parentED.hasInwardLinks(objId);
            }
            return false;
        }

        private String getObjId(String objName) {
            if (this.m_objNamToIdMap.containsKey(objName)) {
                return this.m_objNamToIdMap.get(objName);
            }
            if (this.m_parentED != null) {
                return this.m_parentED.getObjId(objName);
            }
            return null;
        }

        private Map<String, String> getObjNamToIdMap() {
            return this.m_objNamToIdMap;
        }
    }
}

