/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export;

import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.TextChunk;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.export.ImagePathData;
import com.nlbhub.nlb.domain.export.LinkBuildingBlocks;
import com.nlbhub.nlb.domain.export.NLBBuildingBlocks;
import com.nlbhub.nlb.domain.export.ObjBuildingBlocks;
import com.nlbhub.nlb.domain.export.ObjType;
import com.nlbhub.nlb.domain.export.PageBuildingBlocks;
import com.nlbhub.nlb.domain.export.SoundPathData;
import com.nlbhub.nlb.domain.export.TextExportManager;
import com.nlbhub.nlb.domain.export.UseBuildingBlocks;
import com.nlbhub.nlb.domain.export.VNSTEADExportManager;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.util.StringHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class STEADExportManager
extends TextExportManager {
    private static final String GLOBAL_VAR_PREFIX = "_";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern STEAD_OBJ_PATTERN = Pattern.compile("\\{(.*)\\}");
    private static final boolean ENABLE_COMMENTS = true;
    private boolean m_technicalInstance = false;
    private STEADExportManager m_vnsteadExportManager;

    public STEADExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        super(nlb, encoding);
        this.m_vnsteadExportManager = new VNSTEADExportManager(nlb, encoding, true);
    }

    public STEADExportManager(NonLinearBookImpl nlb, String encoding, boolean technicalInstance) throws NLBExportException {
        super(nlb, encoding);
        this.m_technicalInstance = technicalInstance;
        this.m_vnsteadExportManager = null;
    }

    protected boolean isVN(Theme theme) {
        return !this.m_technicalInstance && theme == Theme.VN;
    }

    @Override
    protected String generatePreambleText(NLBBuildingBlocks nlbBuildingBlocks) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getGameFileHeader(nlbBuildingBlocks));
        stringBuilder.append("--package.cpath = './?.so'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'luapassing'").append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        stringBuilder.append("require 'prefs'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'xact'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'nouse'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'hideinv'").append(LINE_SEPARATOR);
        stringBuilder.append("--require 'para'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'dash'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'snapshots'").append(LINE_SEPARATOR);
        String lang = nlbBuildingBlocks.getLang();
        if ("ru".equalsIgnoreCase(lang)) {
            stringBuilder.append("require 'quotes'").append(LINE_SEPARATOR);
        }
        stringBuilder.append("require 'theme'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'timer'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'modules/nlb'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'modules/fonts'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'modules/paginator'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'modules/vn'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'modules/gobj'").append(LINE_SEPARATOR);
        stringBuilder.append("require 'dice/modules/big_pig'").append(LINE_SEPARATOR);
        stringBuilder.append("game.codepage='UTF-8';").append(LINE_SEPARATOR);
        stringBuilder.append("stead.scene_delim = '^';").append(LINE_SEPARATOR);
        stringBuilder.append(LINE_SEPARATOR);
        if (StringHelper.isEmpty(nlbBuildingBlocks.getGameActText())) {
            stringBuilder.append("game.act = function() return true; end;").append(LINE_SEPARATOR);
        } else {
            stringBuilder.append("game.act = function() nlb:curloc().lasttext = '").append(nlbBuildingBlocks.getGameActText()).append("'; p(nlb:curloc().lasttext); nlb:curloc().wastext = true; end;").append(LINE_SEPARATOR);
        }
        if (StringHelper.isEmpty(nlbBuildingBlocks.getGameInvText())) {
            stringBuilder.append("game.inv = function() return true; end;").append(LINE_SEPARATOR);
        } else {
            stringBuilder.append("game.inv = function() nlb:curloc().lasttext = '").append(nlbBuildingBlocks.getGameInvText()).append("'; p(nlb:curloc().lasttext); nlb:curloc().wastext = true; end;").append(LINE_SEPARATOR);
        }
        if (StringHelper.isEmpty(nlbBuildingBlocks.getGameNouseText())) {
            stringBuilder.append("game.nouse = function() return true; end;").append(LINE_SEPARATOR);
        } else {
            stringBuilder.append("game.nouse = function() nlb:curloc().lasttext = '").append(nlbBuildingBlocks.getGameNouseText()).append("'; p(nlb:curloc().lasttext); nlb:curloc().wastext = true; end;").append(LINE_SEPARATOR);
        }
        stringBuilder.append("game.forcedsc = ").append(String.valueOf(nlbBuildingBlocks.isGameForcedsc())).append(";").append(LINE_SEPARATOR);
        stringBuilder.append("paginator.delim = '\\n[ \\t]*\\n'").append(LINE_SEPARATOR);
        stringBuilder.append("function exec(s)").append(LINE_SEPARATOR);
        stringBuilder.append("    p('$'..s:gsub('\\n', '^')..'$^^')").append(LINE_SEPARATOR);
        stringBuilder.append("end").append(LINE_SEPARATOR);
        stringBuilder.append("function init()").append(LINE_SEPARATOR);
        stringBuilder.append("    statsAPI.init();").append(LINE_SEPARATOR);
        stringBuilder.append("    if dice then").append(LINE_SEPARATOR);
        stringBuilder.append("        paginator:set_onproceed(function()").append(LINE_SEPARATOR);
        stringBuilder.append("            dice:hide(true);").append(LINE_SEPARATOR);
        stringBuilder.append("            -- Use code below if you want smooth rollout animation and text change on next step").append(LINE_SEPARATOR);
        stringBuilder.append("            --if dice:hide() then").append(LINE_SEPARATOR);
        stringBuilder.append("            --    return").append(LINE_SEPARATOR);
        stringBuilder.append("            --end").append(LINE_SEPARATOR);
        stringBuilder.append("        end);").append(LINE_SEPARATOR);
        stringBuilder.append("    end").append(LINE_SEPARATOR);
        stringBuilder.append("    vn:scene(nil);").append(LINE_SEPARATOR);
        stringBuilder.append("    nlbticks = stead.ticks();").append(LINE_SEPARATOR);
        stringBuilder.append(this.generateVarsInitBlock(nlbBuildingBlocks));
        stringBuilder.append("end").append(LINE_SEPARATOR);
        stringBuilder.append(this.generateSysObjectsBlock(nlbBuildingBlocks));
        return stringBuilder.toString();
    }

    protected String getThemeInit() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("    if vn:in_vnr() then").append(this.getLineSeparator());
        stringBuilder.append("        vn:turnoff();").append(this.getLineSeparator());
        stringBuilder.append("        nlb:theme_switch(\"theme_vn.lua\");").append(this.getLineSeparator());
        stringBuilder.append("    else").append(this.getLineSeparator());
        stringBuilder.append("        vn:turnon();").append(this.getLineSeparator());
        stringBuilder.append("        nlb:theme_switch(\"theme_standard.lua\");").append(this.getLineSeparator());
        stringBuilder.append("    end").append(this.getLineSeparator());
        return stringBuilder.toString();
    }

    protected String generateSysObjectsBlock(NLBBuildingBlocks nlbBuildingBlocks) {
        String version = StringHelper.notEmpty(nlbBuildingBlocks.getVersion()) ? nlbBuildingBlocks.getVersion() : "0.1";
        StringBuilder result = new StringBuilder();
        result.append(LINE_SEPARATOR).append("_version_obj = gobj {").append(LINE_SEPARATOR).append("    nam = 'version_obj',").append(LINE_SEPARATOR).append("    system_type = true,").append(LINE_SEPARATOR).append("    pic = 'gfx/version.png',").append(LINE_SEPARATOR).append("    txtfn = function(s) return { [1] = {['text'] = '").append(version).append("', ['color'] = 'white' } }; end,").append(LINE_SEPARATOR).append("    eff = 'left-top@0,0',").append(LINE_SEPARATOR).append("    iarm = {[0] = {0, 16}}").append(LINE_SEPARATOR).append(LINE_SEPARATOR).append("}").append(LINE_SEPARATOR);
        return result.toString();
    }

    protected String getGameFileHeader(NLBBuildingBlocks nlbBuildingBlocks) {
        StringBuilder result = new StringBuilder();
        String title = StringHelper.notEmpty(nlbBuildingBlocks.getTitle()) ? nlbBuildingBlocks.getTitle() : "NLBB_" + new Date().toString();
        String version = StringHelper.notEmpty(nlbBuildingBlocks.getVersion()) ? nlbBuildingBlocks.getVersion() : "0.1";
        String author = StringHelper.notEmpty(nlbBuildingBlocks.getAuthor()) ? nlbBuildingBlocks.getAuthor() : "Unknown";
        result.append("--$Name:").append(title).append("$").append(LINE_SEPARATOR);
        result.append("--$Version:").append(version).append("$").append(LINE_SEPARATOR);
        result.append("--$Author:").append(author).append("$").append(LINE_SEPARATOR);
        result.append("instead_version '2.3.0'").append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        return result.toString();
    }

    protected String generateVarsInitBlock(NLBBuildingBlocks nlbBuildingBlocks) {
        StringBuilder stringBuilder = new StringBuilder();
        String lang = nlbBuildingBlocks.getLang();
        stringBuilder.append("    _export_lang = '").append(lang).append("';").append(LINE_SEPARATOR);
        stringBuilder.append("    _syscall_showmenubtn:act();").append(LINE_SEPARATOR);
        if ("ru".equalsIgnoreCase(lang)) {
            stringBuilder.append("    format.quotes = true;").append(LINE_SEPARATOR);
        } else {
            stringBuilder.append("    format.quotes = false;").append(LINE_SEPARATOR);
        }
        stringBuilder.append("    if not prefs.achievements_max then").append(LINE_SEPARATOR);
        stringBuilder.append("        prefs.achievements_max = {};").append(LINE_SEPARATOR);
        stringBuilder.append("    end").append(LINE_SEPARATOR);
        stringBuilder.append("    if not prefs.achievements_ids then").append(LINE_SEPARATOR);
        stringBuilder.append("        prefs.achievements_ids = {};").append(LINE_SEPARATOR);
        stringBuilder.append("    end").append(LINE_SEPARATOR);
        stringBuilder.append(this.initBlockAchievements(nlbBuildingBlocks));
        String perfectGame = nlbBuildingBlocks.getAchievementNamePerfectGame();
        if (StringHelper.notEmpty(perfectGame)) {
            String achievementItemPerfectGame = "prefs.achievements_ids['" + perfectGame + "']";
            stringBuilder.append("    if not ").append(achievementItemPerfectGame).append(" then ").append(achievementItemPerfectGame).append(" = {}; end;").append(LINE_SEPARATOR);
            stringBuilder.append("    if not prefs.achievementNamePerfectGame then prefs.achievementNamePerfectGame = '").append(perfectGame).append("'; end;").append(LINE_SEPARATOR);
        }
        stringBuilder.append("    prefs:store();").append(LINE_SEPARATOR);
        stringBuilder.append("    nlb:resendAchievements(statsAPI);").append(LINE_SEPARATOR);
        stringBuilder.append("    initializeVariables();").append(LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private String initBlockAchievements(NLBBuildingBlocks nlbBuildingBlocks) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String achievement : nlbBuildingBlocks.getAchievements()) {
            String achievementItem = "prefs.achievements_ids['" + achievement + "']";
            stringBuilder.append("    if not ").append(achievementItem).append(" then ").append(achievementItem).append(" = {}; end;").append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    private String getContainerExpression(String containerRef) {
        if ("function() return nil; end".equals(containerRef)) {
            return "container = function() return nil; end;";
        }
        return "container = " + containerRef + ";";
    }

    @Override
    protected String generateObjText(ObjBuildingBlocks objBlocks) {
        boolean hasUses;
        boolean varsOrModsPresent;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(objBlocks.getObjComment());
        stringBuilder.append(objBlocks.getObjLabel()).append(objBlocks.getObjStart());
        stringBuilder.append(objBlocks.getObjName());
        stringBuilder.append(objBlocks.getObjEffect());
        stringBuilder.append(objBlocks.getMorphOver());
        stringBuilder.append(objBlocks.getMorphOut());
        stringBuilder.append(objBlocks.getObjArm());
        stringBuilder.append(objBlocks.getObjSound());
        stringBuilder.append(objBlocks.getObjDisp());
        stringBuilder.append(objBlocks.getObjText());
        if (objBlocks.isTakable()) {
            stringBuilder.append(objBlocks.getObjTak());
            stringBuilder.append(objBlocks.getObjInv());
        }
        stringBuilder.append(objBlocks.getObjConstraint());
        stringBuilder.append(objBlocks.getObjActStart());
        boolean bl = varsOrModsPresent = StringHelper.notEmpty(objBlocks.getObjVariable()) || StringHelper.notEmpty(objBlocks.getObjModifications());
        if (varsOrModsPresent) {
            stringBuilder.append(objBlocks.getObjModifications());
            stringBuilder.append(objBlocks.getObjVariable());
        }
        stringBuilder.append(objBlocks.getObjActEnd());
        List<UseBuildingBlocks> usesBuildingBlocks = objBlocks.getUseBuildingBlocks();
        boolean bl2 = hasUses = usesBuildingBlocks.size() != 0;
        if (!objBlocks.isTakable() && hasUses) {
            stringBuilder.append("    scene_use = true,").append(LINE_SEPARATOR);
        }
        stringBuilder.append(objBlocks.getObjImage());
        stringBuilder.append(objBlocks.getObjPreload());
        if (hasUses) {
            stringBuilder.append(objBlocks.getObjUseStart());
        }
        if (hasUses) {
            StringBuilder usepBuilder = new StringBuilder();
            usepBuilder.append("    usep = function(s, w, ww)").append(LINE_SEPARATOR);
            usepBuilder.append("        local prevt = nlb:curloc().lasttext;").append(LINE_SEPARATOR);
            usepBuilder.append("        local wasnouses = true;").append(LINE_SEPARATOR);
            usepBuilder.append("        nlb:curloc().lasttext = \"\";").append(LINE_SEPARATOR);
            for (int i = 0; i < usesBuildingBlocks.size(); ++i) {
                String extraPadding;
                StringBuilder usesStartBuilder = new StringBuilder();
                StringBuilder usesEndBuilder = new StringBuilder();
                UseBuildingBlocks useBuildingBlocks = usesBuildingBlocks.get(i);
                String padding = "        ";
                if (i == 0) {
                    usesStartBuilder.append(padding).append("if ");
                    usesStartBuilder.append(useBuildingBlocks.getUseTarget());
                    usesStartBuilder.append(" then").append(LINE_SEPARATOR);
                } else {
                    usesStartBuilder.append(padding).append("end;").append(LINE_SEPARATOR);
                    usesStartBuilder.append(padding).append("if ").append(LINE_SEPARATOR);
                    usesStartBuilder.append(useBuildingBlocks.getUseTarget());
                    usesStartBuilder.append(" then").append(LINE_SEPARATOR);
                }
                boolean constrained = !StringHelper.isEmpty(useBuildingBlocks.getUseConstraint());
                String string = extraPadding = constrained ? "    " : "";
                if (constrained) {
                    usesStartBuilder.append(padding).append("    if ").append(useBuildingBlocks.getUseConstraint());
                    usesStartBuilder.append(" then").append(LINE_SEPARATOR);
                }
                stringBuilder.append((CharSequence)usesStartBuilder).append(padding).append(extraPadding);
                stringBuilder.append(useBuildingBlocks.getUseModifications()).append(LINE_SEPARATOR);
                stringBuilder.append(useBuildingBlocks.getUseVariable()).append(LINE_SEPARATOR);
                if (constrained) {
                    usesEndBuilder.append(padding).append("    end;").append(LINE_SEPARATOR);
                    stringBuilder.append((CharSequence)usesEndBuilder);
                }
                usepBuilder.append((CharSequence)usesStartBuilder);
                String useSuccessText = useBuildingBlocks.getUseSuccessText();
                String useFailureText = useBuildingBlocks.getUseFailureText();
                if (StringHelper.notEmpty(useSuccessText)) {
                    usepBuilder.append("local t = \"").append(useSuccessText).append(" \"; nlb:curloc().lasttext = nlb:lasttext()..t; p(t); nlb:curloc().wastext = true; wasnouses = false;").append(LINE_SEPARATOR);
                    if (StringHelper.notEmpty(useFailureText)) {
                        usepBuilder.append(padding).append("    else").append(LINE_SEPARATOR);
                        usepBuilder.append("local t = \"").append(useFailureText).append(" \"; nlb:curloc().lasttext = nlb:lasttext()..t; p(t); nlb:curloc().wastext = true; wasnouses = false;").append(LINE_SEPARATOR);
                    }
                }
                usepBuilder.append((CharSequence)usesEndBuilder);
            }
            usepBuilder.append("        if wasnouses then nlb:curloc().lasttext = prevt; end;").append(LINE_SEPARATOR);
            usepBuilder.append("        end;").append(LINE_SEPARATOR);
            usepBuilder.append("        return not wasnouses;").append(LINE_SEPARATOR);
            usepBuilder.append(objBlocks.getObjUseEnd());
            stringBuilder.append("        end;").append(LINE_SEPARATOR);
            stringBuilder.append("        if w.useda then").append(LINE_SEPARATOR);
            stringBuilder.append("            w.useda(w, s, s);").append(LINE_SEPARATOR);
            stringBuilder.append("        end;").append(LINE_SEPARATOR);
            stringBuilder.append(objBlocks.getObjUseEnd());
            stringBuilder.append((CharSequence)usepBuilder);
        }
        stringBuilder.append(objBlocks.getObjNouse());
        List<String> containedObjIds = objBlocks.getContainedObjIds();
        if (containedObjIds.size() != 0) {
            stringBuilder.append(objBlocks.getObjObjStart());
            for (String objString : containedObjIds) {
                stringBuilder.append(objString);
            }
            stringBuilder.append(objBlocks.getObjObjEnd());
        }
        stringBuilder.append(objBlocks.getObjEnd());
        if (StringHelper.notEmpty(objBlocks.getObjConstraint())) {
            stringBuilder.append("lifeon('").append(objBlocks.getObjLabel()).append("');").append(LINE_SEPARATOR);
        }
        if (StringHelper.notEmpty(objBlocks.getObjAlias())) {
            stringBuilder.append(objBlocks.getObjAlias()).append(" = ").append(objBlocks.getObjLabel()).append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    @Override
    protected String generatePageText(PageBuildingBlocks pageBlocks) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder autosBuilder = new StringBuilder();
        stringBuilder.append(pageBlocks.getPageComment());
        stringBuilder.append(pageBlocks.getPageLabel());
        stringBuilder.append(pageBlocks.getPageCaption());
        stringBuilder.append(pageBlocks.getNotes());
        stringBuilder.append(pageBlocks.getPageImage());
        boolean hasAnim = pageBlocks.isHasObjectsWithAnimatedImages();
        boolean hasPageAnim = pageBlocks.isHasAnimatedPageImage();
        boolean hasFastAnim = hasAnim || hasPageAnim;
        boolean timerSet = (hasFastAnim || pageBlocks.isHasPageTimer()) && !pageBlocks.isHasGraphicalObjects();
        stringBuilder.append("    var { time = 0; wastext = false; lasttext = nil; tag = '").append(pageBlocks.getPageDefaultTag()).append("'; ");
        stringBuilder.append("autowired = ").append(pageBlocks.isAutowired() ? "true" : "false").append("; ");
        stringBuilder.append("},").append(LINE_SEPARATOR);
        if (timerSet) {
            stringBuilder.append("    timer = function(s)").append(LINE_SEPARATOR);
            if (hasFastAnim) {
                stringBuilder.append("        if (nlb._fps * (get_ticks() - nlbticks) <= 1000) then").append(LINE_SEPARATOR);
                stringBuilder.append("            return;").append(LINE_SEPARATOR);
                stringBuilder.append("        end").append(LINE_SEPARATOR);
                stringBuilder.append("        nlbticks = get_ticks();").append(LINE_SEPARATOR);
            }
            stringBuilder.append("        if not s.wastext then").append(LINE_SEPARATOR);
            stringBuilder.append("        ").append(pageBlocks.getPageTimerVariable()).append(LINE_SEPARATOR);
            stringBuilder.append("        end; ").append(LINE_SEPARATOR);
            if (hasPageAnim) {
                stringBuilder.append("        vn:scene(s:bgimg()); ").append(LINE_SEPARATOR);
            }
            stringBuilder.append("        local afl = s.autos(s); ").append(LINE_SEPARATOR);
            stringBuilder.append("        if (s.lasttext ~= nil) and not s.wastext then return s.lasttext; elseif afl and not s.wastext then return true; end; ").append(LINE_SEPARATOR);
            stringBuilder.append("        s.wastext = false; ").append(LINE_SEPARATOR);
            stringBuilder.append("    end,").append(LINE_SEPARATOR);
        }
        stringBuilder.append(pageBlocks.getPageTextStart());
        autosBuilder.append("    autos = function(s)").append(LINE_SEPARATOR);
        autosBuilder.append("        nlb:revive();").append(LINE_SEPARATOR);
        autosBuilder.append("        nlb:ways_chk(s);").append(LINE_SEPARATOR);
        List<LinkBuildingBlocks> linksBlocks = pageBlocks.getLinksBuildingBlocks();
        for (LinkBuildingBlocks linkBlocks : linksBlocks) {
            if (!linkBlocks.isAuto()) continue;
            autosBuilder.append(this.generateAutoLinkCode(linkBlocks));
        }
        if (!this.isVN(pageBlocks.getTheme())) {
            autosBuilder.append("        vn:standard_renew();").append(LINE_SEPARATOR);
        }
        autosBuilder.append("        return true;").append(LINE_SEPARATOR);
        autosBuilder.append("    end,").append(LINE_SEPARATOR);
        boolean varsOrModsPresent = !StringHelper.isEmpty(pageBlocks.getPageVariable()) || !StringHelper.isEmpty(pageBlocks.getPageModifications());
        stringBuilder.append(this.generateOrdinaryLinkTextInsideRoom(pageBlocks));
        stringBuilder.append(pageBlocks.getPageTextEnd());
        stringBuilder.append(autosBuilder.toString());
        stringBuilder.append("    nextsnd = function(s)").append(LINE_SEPARATOR);
        stringBuilder.append("        local sndfile = nlb:pop('").append(pageBlocks.getPageName()).append("_snds');").append(LINE_SEPARATOR);
        stringBuilder.append("        if sndfile ~= nil then").append(LINE_SEPARATOR);
        stringBuilder.append("            s.sndout(s);").append(LINE_SEPARATOR);
        stringBuilder.append("            add_sound(sndfile);").append(LINE_SEPARATOR);
        stringBuilder.append("        end;").append(LINE_SEPARATOR);
        stringBuilder.append("    end,").append(LINE_SEPARATOR);
        stringBuilder.append("    theme_file = function(s)").append(LINE_SEPARATOR);
        if (pageBlocks.getTheme() == Theme.STANDARD) {
            stringBuilder.append("        return 'theme_standard.lua';").append(LINE_SEPARATOR);
        } else if (pageBlocks.getTheme() == Theme.VN) {
            stringBuilder.append("        return 'theme_vn.lua';").append(LINE_SEPARATOR);
        } else {
            stringBuilder.append(this.getDefaultThemeSwitchExpression());
        }
        stringBuilder.append("    end,").append(LINE_SEPARATOR);
        stringBuilder.append("    enter = function(s, f)").append(LINE_SEPARATOR);
        stringBuilder.append("        nlb:theme_switch(s:theme_file());").append(LINE_SEPARATOR);
        stringBuilder.append("        s.lasttext = nil;").append(LINE_SEPARATOR);
        stringBuilder.append("        s.wastext = false;").append(LINE_SEPARATOR);
        stringBuilder.append("        if not (f.autowired) then").append(LINE_SEPARATOR);
        if (varsOrModsPresent) {
            stringBuilder.append(pageBlocks.getPageModifications());
            stringBuilder.append(pageBlocks.getPageVariable());
        }
        stringBuilder.append("        end;").append(LINE_SEPARATOR);
        stringBuilder.append("        s:initf();").append(LINE_SEPARATOR);
        stringBuilder.append("    end,").append(LINE_SEPARATOR);
        stringBuilder.append("    initf = function(s)").append(LINE_SEPARATOR);
        if (!StringHelper.isEmpty(pageBlocks.getPageThemeModifications())) {
            stringBuilder.append(pageBlocks.getPageThemeModifications()).append(LINE_SEPARATOR);
        }
        if (hasFastAnim) {
            stringBuilder.append("        nlbticks = stead.ticks();").append(LINE_SEPARATOR);
        }
        if (timerSet) {
            stringBuilder.append("        ").append(pageBlocks.getPageTimerVariableInit()).append(LINE_SEPARATOR);
            int timerRate = hasFastAnim ? 1 : 200;
            stringBuilder.append("        ").append(pageBlocks.getPageTimerVariable()).append(LINE_SEPARATOR);
            stringBuilder.append("        timer:set(").append(timerRate).append(");").append(LINE_SEPARATOR);
        }
        stringBuilder.append("        s.snd(s);").append(LINE_SEPARATOR);
        stringBuilder.append(this.generateDirectModeStartText(pageBlocks));
        stringBuilder.append(this.getGraphicalObjectAppendingExpression(pageBlocks, timerSet));
        stringBuilder.append("    end,").append(LINE_SEPARATOR);
        stringBuilder.append("    exit = function(s, t)").append(LINE_SEPARATOR);
        stringBuilder.append("        s.sndout(s);").append(LINE_SEPARATOR);
        if (timerSet) {
            stringBuilder.append("        timer:stop();").append(LINE_SEPARATOR);
        }
        stringBuilder.append("        s.wastext = false;").append(LINE_SEPARATOR);
        stringBuilder.append("        s.lasttext = nil;").append(LINE_SEPARATOR);
        stringBuilder.append(this.generateDirectModeStopText(pageBlocks));
        stringBuilder.append("    end,").append(LINE_SEPARATOR);
        stringBuilder.append("    life = function(s)").append(LINE_SEPARATOR);
        if (!timerSet) {
            stringBuilder.append("        if vn.stopped then s.autos(s); end;").append(LINE_SEPARATOR);
        }
        stringBuilder.append("    end,").append(LINE_SEPARATOR);
        stringBuilder.append(pageBlocks.getPageSound());
        stringBuilder.append(this.generateObjsCollection(pageBlocks, linksBlocks));
        stringBuilder.append(pageBlocks.getPageEnd());
        return stringBuilder.toString();
    }

    protected boolean isDirectMode(PageBuildingBlocks pageBlocks) {
        return pageBlocks.isDirectMode() && pageBlocks.getTheme() == Theme.VN;
    }

    protected String generateDirectModeStartText(PageBuildingBlocks pageBlocks) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isDirectMode(pageBlocks)) {
            stringBuilder.append("        vn:request_full_clear();").append(LINE_SEPARATOR);
            stringBuilder.append("        vn:lock_direct();").append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    protected String generateDirectModeStopText(PageBuildingBlocks pageBlocks) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isDirectMode(pageBlocks)) {
            stringBuilder.append("        vn:request_full_clear();").append(LINE_SEPARATOR);
            stringBuilder.append("        vn:unlock_direct();").append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    protected String getGraphicalObjectAppendingExpression(PageBuildingBlocks pageBuildingBlocks, boolean timerSet) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("        local bg_img = s.bgimg(s);").append(this.getLineSeparator());
        stringBuilder.append("        nlb:revive();").append(this.getLineSeparator());
        stringBuilder.append("        nlb:ways_chk(s);").append(LINE_SEPARATOR);
        stringBuilder.append("        vn:scene(bg_img);").append(this.getLineSeparator());
        if (timerSet) {
            stringBuilder.append("        return vn:get_win_coords();").append(this.getLineSeparator());
        } else {
            stringBuilder.append("        local geomFuncNeedToCall = true;").append(this.getLineSeparator());
            if (pageBuildingBlocks.isHasGraphicalObjects()) {
                for (String graphicalObjId : pageBuildingBlocks.getContainedGraphicalObjIds()) {
                    stringBuilder.append("        if " + graphicalObjId + ".preload then").append(this.getLineSeparator());
                    stringBuilder.append("            geomFuncNeedToCall = false;").append(this.getLineSeparator());
                    stringBuilder.append("            " + graphicalObjId + ":preload(s);").append(this.getLineSeparator());
                    stringBuilder.append("        else").append(this.getLineSeparator());
                    stringBuilder.append("            vn:gshow(" + graphicalObjId + ");").append(this.getLineSeparator());
                    stringBuilder.append("        end").append(this.getLineSeparator());
                }
            }
            stringBuilder.append("        if geomFuncNeedToCall then").append(this.getLineSeparator());
            if (pageBuildingBlocks.isAutosFirst()) {
                stringBuilder.append("            if s:autos() then vn:auto_geom('dissolve'); end;").append(this.getLineSeparator());
            } else {
                stringBuilder.append("            vn:auto_geom('dissolve', function() s.autos(s); end);").append(this.getLineSeparator());
            }
            stringBuilder.append("        end;").append(this.getLineSeparator());
            if (this.isDirectMode(pageBuildingBlocks)) {
                stringBuilder.append("        return 0, 0, vn.scr_w, vn.scr_h;").append(this.getLineSeparator());
            } else {
                stringBuilder.append("        return vn:get_win_coords();").append(this.getLineSeparator());
            }
        }
        return stringBuilder.toString();
    }

    protected String getDefaultThemeSwitchExpression() {
        return "        return 'theme_standard.lua';" + LINE_SEPARATOR;
    }

    protected String generateOrdinaryLinkTextInsideRoom(PageBuildingBlocks pageBuildingBlocks) {
        if (this.isVN(pageBuildingBlocks.getTheme())) {
            return this.m_vnsteadExportManager.generateOrdinaryLinkTextInsideRoom(pageBuildingBlocks);
        }
        StringBuilder wayBuilder = new StringBuilder("    way = {" + LINE_SEPARATOR);
        StringBuilder xdscBuilder = new StringBuilder("    xdsc = function(s)" + LINE_SEPARATOR);
        if (!pageBuildingBlocks.getContainedObjIds().isEmpty()) {
            xdscBuilder.append("        p \"^\";").append(LINE_SEPARATOR);
        }
        xdscBuilder.append("        p(nlb:alts_txt(s));").append(LINE_SEPARATOR);
        StringBuilder wcnsBuilder = new StringBuilder("    wcns = {" + LINE_SEPARATOR);
        StringBuilder altsBuilder = new StringBuilder("    alts = {" + LINE_SEPARATOR);
        for (LinkBuildingBlocks linkBlocks : pageBuildingBlocks.getLinksBuildingBlocks()) {
            boolean constrained;
            if (linkBlocks.isAuto()) continue;
            if (linkBlocks.isInline()) {
                xdscBuilder.append(this.generateOrdinaryLinkCode(linkBlocks));
            } else {
                wayBuilder.append("        '").append(linkBlocks.getLinkLabel()).append("',").append(LINE_SEPARATOR);
            }
            if (!(constrained = !StringHelper.isEmpty(linkBlocks.getLinkConstraint()))) continue;
            wcnsBuilder.append("        ").append("['").append(linkBlocks.getLinkLabel()).append("'] = function() return ").append(linkBlocks.getLinkConstraint()).append("; end,").append(LINE_SEPARATOR);
            String altText = linkBlocks.getLinkAltText();
            if (!StringHelper.notEmpty(altText)) continue;
            altsBuilder.append("        ").append("['").append(linkBlocks.getLinkLabel()).append("'] = function() return \"").append(altText).append("\"; end,").append(LINE_SEPARATOR);
        }
        wayBuilder.append("    },").append(LINE_SEPARATOR);
        xdscBuilder.append("    end,").append(LINE_SEPARATOR);
        wcnsBuilder.append("    },").append(LINE_SEPARATOR);
        altsBuilder.append("    },").append(LINE_SEPARATOR);
        return wayBuilder.toString() + xdscBuilder.toString() + wcnsBuilder.toString() + altsBuilder.toString();
    }

    @Override
    protected String generatePostPageText(PageBuildingBlocks pageBlocks) {
        if (this.isVN(pageBlocks.getTheme())) {
            return this.m_vnsteadExportManager.generatePostPageText(pageBlocks);
        }
        List<LinkBuildingBlocks> linksBuildingBlocks = pageBlocks.getLinksBuildingBlocks();
        if (!this.hasChoicesOrLeaf(pageBlocks)) {
            return "";
        }
        StringBuilder linksBuilder = new StringBuilder();
        for (LinkBuildingBlocks linkBlocks : linksBuildingBlocks) {
            if (linkBlocks.isAuto()) continue;
            linksBuilder.append(linkBlocks.getLinkComment());
            linksBuilder.append(linkBlocks.getLinkStart());
            linksBuilder.append(linkBlocks.getLinkModifications());
            linksBuilder.append(linkBlocks.getLinkVariable());
            linksBuilder.append(linkBlocks.getLinkVisitStateVariable());
            linksBuilder.append(linkBlocks.getLinkGoTo());
            linksBuilder.append(linkBlocks.getLinkEnd()).append(LINE_SEPARATOR);
        }
        return linksBuilder.toString();
    }

    protected String generateObjsCollection(PageBuildingBlocks pageBlocks, List<LinkBuildingBlocks> linksBlocks) {
        if (this.isVN(pageBlocks.getTheme())) {
            return this.m_vnsteadExportManager.generateObjsCollection(pageBlocks, linksBlocks);
        }
        StringBuilder result = new StringBuilder();
        boolean containedObjIdsIsEmpty = pageBlocks.getContainedObjIds().isEmpty();
        result.append("    obj = { ").append(LINE_SEPARATOR);
        if (!containedObjIdsIsEmpty) {
            for (String containedObjId : pageBlocks.getContainedObjIds()) {
                result.append(containedObjId);
            }
        }
        result.append("        xdsc()").append(LINE_SEPARATOR);
        result.append("    },").append(LINE_SEPARATOR);
        return result.toString();
    }

    protected String generateOrdinaryLinkCode(LinkBuildingBlocks linkBlocks) {
        if (this.isVN(linkBlocks.getTheme())) {
            return this.m_vnsteadExportManager.generateOrdinaryLinkCode(linkBlocks);
        }
        boolean constrained = !StringHelper.isEmpty(linkBlocks.getLinkConstraint());
        StringBuilder result = new StringBuilder();
        result.append("        p(");
        if (constrained) {
            result.append("(not s.wcns['").append(linkBlocks.getLinkLabel()).append("'] or s.wcns['").append(linkBlocks.getLinkLabel()).append("']()) and ");
        }
        result.append("\"{").append(linkBlocks.getLinkLabel()).append("_XLnk|").append(linkBlocks.getLinkText()).append("}^\"");
        if (constrained) {
            result.append(" or \"\"");
        }
        result.append(");").append(LINE_SEPARATOR);
        return result.toString();
    }

    protected String generateAutoLinkCode(LinkBuildingBlocks linkBlocks) {
        boolean constrained = !StringHelper.isEmpty(linkBlocks.getLinkConstraint());
        StringBuilder result = new StringBuilder();
        result.append("        ");
        result.append("if (").append(constrained ? linkBlocks.getLinkConstraint() : "true").append(") then ");
        result.append(linkBlocks.getLinkModifications());
        result.append(linkBlocks.getLinkVariable());
        result.append(linkBlocks.getLinkVisitStateVariable());
        result.append(linkBlocks.getLinkGoTo());
        result.append(LINE_SEPARATOR).append("        return false;").append(LINE_SEPARATOR);
        result.append(" end;");
        result.append(LINE_SEPARATOR);
        return result.toString();
    }

    @Override
    protected String generateVariableInitializationText(Map<String, String> initValuesMap) {
        StringBuilder result = new StringBuilder(LINE_SEPARATOR);
        result.append("-- In INSTEAD, when using the snapshots module, you will run into unpredictable behaviour if the variable is not initialized yet.").append(LINE_SEPARATOR);
        result.append("-- More specifically, if the value is nil, it won't be included in the snapshot & therefore will not be overwritten when the snapshot is loaded.").append(LINE_SEPARATOR);
        result.append("-- So, for example, if the flag was initially nil, then you make snapshot, then you walked into location which sets this flag to true,").append(LINE_SEPARATOR);
        result.append("-- than when loading the snapshot the value of the flag will NOT change back to nil.").append(LINE_SEPARATOR);
        result.append("-- That's why we should initialize all nil variables on start (so that they equal false or 0 or '', but not nil).").append(LINE_SEPARATOR);
        result.append("function initializeVariables()").append(LINE_SEPARATOR);
        for (Map.Entry<String, String> entry : initValuesMap.entrySet()) {
            result.append("    if ").append(entry.getKey()).append(" == nil then").append(LINE_SEPARATOR);
            result.append("        ").append(entry.getKey()).append(" = ").append(entry.getValue()).append(";").append(LINE_SEPARATOR);
            result.append("    end").append(LINE_SEPARATOR);
        }
        result.append("end").append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        return result.toString();
    }

    @Override
    protected String escapeText(String text) {
        return text.replaceAll("\\\\", Matcher.quoteReplacement("\\\\")).replaceAll("'", Matcher.quoteReplacement("\\'")).replaceAll("\"", Matcher.quoteReplacement("\\\"")).replaceAll("\\[", Matcher.quoteReplacement("\\91")).replaceAll("\\]", Matcher.quoteReplacement("\\93"));
    }

    @Override
    protected String decorateObjLabel(String id) {
        return this.decorateId(id);
    }

    @Override
    protected String decorateObjComment(String name) {
        return "-- " + name + LINE_SEPARATOR;
    }

    @Override
    protected String decorateObjStart(String id, String containerRef, ObjType objType, boolean showOnCursor, boolean preserved, boolean loadOnce, boolean clearUnderTooltip, boolean actOnKey, boolean cacheText, boolean looped, boolean noRedrawOnAct, boolean collapsable, String objDefaultTag, int pauseFrames) {
        StringBuilder result = new StringBuilder();
        switch (objType) {
            case STAT: {
                result.append(" = nlbstat {").append(LINE_SEPARATOR);
                break;
            }
            case MENU: {
                result.append(" = nlbmenu {").append(LINE_SEPARATOR);
                break;
            }
            case GOBJ: {
                result.append(" = gobj {").append(LINE_SEPARATOR);
                if (clearUnderTooltip) {
                    result.append("clear_under_tooltip = true,").append(LINE_SEPARATOR);
                }
                if (showOnCursor) {
                    result.append("showoncur = true,").append(LINE_SEPARATOR);
                }
                if (preserved) {
                    result.append("preserved = true,").append(LINE_SEPARATOR);
                }
                if (loadOnce) {
                    result.append("load_once = true,").append(LINE_SEPARATOR);
                }
                if (cacheText) {
                    result.append("cache_text = true,").append(LINE_SEPARATOR);
                }
                if (looped) {
                    result.append("looped = true,").append(LINE_SEPARATOR);
                }
                if (noRedrawOnAct) {
                    result.append("noactredraw = true,").append(LINE_SEPARATOR);
                }
                if (!collapsable) break;
                result.append("collapsable = true,").append(LINE_SEPARATOR);
                break;
            }
            case GMENU: {
                result.append(" = gmenu {").append(LINE_SEPARATOR);
                if (clearUnderTooltip) {
                    result.append("clear_under_tooltip = true,").append(LINE_SEPARATOR);
                }
                if (showOnCursor) {
                    result.append("showoncur = true,").append(LINE_SEPARATOR);
                }
                if (preserved) {
                    result.append("preserved = true,").append(LINE_SEPARATOR);
                }
                if (loadOnce) {
                    result.append("load_once = true,").append(LINE_SEPARATOR);
                }
                if (cacheText) {
                    result.append("cache_text = true,").append(LINE_SEPARATOR);
                }
                if (looped) {
                    result.append("looped = true,").append(LINE_SEPARATOR);
                }
                if (noRedrawOnAct) {
                    result.append("noactredraw = true,").append(LINE_SEPARATOR);
                }
                if (!collapsable) break;
                result.append("collapsable = true,").append(LINE_SEPARATOR);
                break;
            }
            default: {
                result.append(" = nlbobj {").append(LINE_SEPARATOR);
            }
        }
        result.append("    var { tag = '").append(objDefaultTag).append("'; ").append(this.getContainerExpression(containerRef));
        result.append(" },").append(LINE_SEPARATOR);
        if (pauseFrames > 0) {
            result.append("    pause = ").append(pauseFrames).append(";").append(LINE_SEPARATOR);
        }
        result.append("    nlbid = '").append(id).append("',").append(LINE_SEPARATOR);
        if (actOnKey) {
            result.append("    actonkey = function(s, down, key)").append(LINE_SEPARATOR);
            result.append("        if down then").append(LINE_SEPARATOR);
            result.append("            s:actf();").append(LINE_SEPARATOR);
            result.append("        end").append(LINE_SEPARATOR);
            result.append("        return down;").append(LINE_SEPARATOR);
            result.append("    end,").append(LINE_SEPARATOR);
        }
        result.append("    deref = function(s) return stead.deref(").append(this.decorateObjLabel(id)).append("); end,").append(LINE_SEPARATOR);
        return result.toString();
    }

    @Override
    protected String decorateObjName(String name, String id) {
        return "    nam = '" + (StringHelper.notEmpty(name) ? name : this.decorateId(id)) + "'," + LINE_SEPARATOR;
    }

    @Override
    protected String decorateObjImage(List<ImagePathData> objImagePathDatas, boolean graphicalObj) {
        StringBuilder resultBuilder = new StringBuilder();
        boolean notFirst = false;
        String ifTermination = "";
        for (ImagePathData objImagePathData : objImagePathDatas) {
            String objImagePath = objImagePathData.getImagePath();
            StringBuilder tempBuilder = new StringBuilder();
            tempBuilder.append("        ").append(notFirst ? "else" : "").append("if (");
            String constraint = objImagePathData.getConstraint();
            tempBuilder.append(StringHelper.notEmpty(constraint) ? "s.tag == '" + constraint + "'" : "true").append(") then");
            tempBuilder.append(LINE_SEPARATOR);
            if (objImagePathData.getMaxFrameNumber() == 0 || objImagePathData.isRemoveFrameNumber()) {
                if (StringHelper.notEmpty(objImagePath)) {
                    ifTermination = "        end" + LINE_SEPARATOR;
                    resultBuilder.append((CharSequence)tempBuilder).append("            ");
                    resultBuilder.append("return '").append(objImagePath).append("';").append(LINE_SEPARATOR);
                }
            } else {
                ifTermination = "        end" + LINE_SEPARATOR;
                resultBuilder.append((CharSequence)tempBuilder).append("            ");
                resultBuilder.append("return string.format('").append(objImagePath).append("', nlb:curloc().time % ");
                resultBuilder.append(objImagePathData.getMaxFrameNumber()).append(" + 1); ").append(LINE_SEPARATOR);
            }
            notFirst = true;
        }
        String funbody = resultBuilder.toString();
        if (StringHelper.isEmpty(funbody)) {
            return "";
        }
        String result = "    pic = function(s)" + LINE_SEPARATOR + funbody + LINE_SEPARATOR + ifTermination + "end," + LINE_SEPARATOR;
        return result + "    imgv = function(s) return img(s.pic(s)); end," + LINE_SEPARATOR;
    }

    @Override
    protected String decorateObjEffect(String offsetString, String coordString, boolean graphicalObj, boolean hasParentObj, Obj.MovementDirection movementDirection, Obj.Effect effect, Obj.CoordsOrigin coordsOrigin, int startFrame, int curStep, int maxStep) {
        String steps;
        boolean hasDefinedOffset = StringHelper.notEmpty(offsetString);
        String offset = hasDefinedOffset && !hasParentObj ? offsetString : "0,0";
        String pos = this.getPos(coordsOrigin, offset);
        String string = steps = effect == Obj.Effect.None ? "" : "    maxStep = " + maxStep + "," + LINE_SEPARATOR + "    startFrame = " + startFrame + "," + LINE_SEPARATOR + "    curStep = " + curStep + "," + LINE_SEPARATOR;
        if (effect != Obj.Effect.None) {
            String eff = effect.name().toLowerCase();
            switch (movementDirection) {
                case Top: {
                    pos = eff + "top-" + pos;
                    break;
                }
                case Left: {
                    pos = eff + "left-" + pos;
                    break;
                }
                case Right: {
                    pos = eff + "right-" + pos;
                    break;
                }
                case Bottom: {
                    pos = eff + "bottom-" + pos;
                    break;
                }
                default: {
                    pos = eff + "-" + pos;
                }
            }
        }
        if (graphicalObj) {
            return "    eff = '" + pos + "'," + LINE_SEPARATOR + steps + (hasDefinedOffset ? "" : "    arm = { [0] = { " + coordString + " } }," + LINE_SEPARATOR);
        }
        return "";
    }

    @Override
    protected String decorateObjPreload(int startFrame, int maxFrames, int preloadFrames) {
        if (preloadFrames > 0) {
            return "    preload = function(s, room)" + LINE_SEPARATOR + "        vn.hz = vn.hz_preloaded;" + LINE_SEPARATOR + "        vn:preload_effect(s:pic(), " + startFrame + ", " + maxFrames + ", " + startFrame + ", " + preloadFrames + ", function()" + LINE_SEPARATOR + "            vn:gshow(s);" + LINE_SEPARATOR + "            if room then vn:geom(8, 864, 1904, 184, 'dissolve', 240, function() room.autos(room); vn.hz = vn.hz_onthefly; end); end;" + LINE_SEPARATOR + "        end, false, s.load_once);" + LINE_SEPARATOR + "    end," + LINE_SEPARATOR;
        }
        return "";
    }

    @NotNull
    private String getPos(Obj.CoordsOrigin coordsOrigin, String offset) {
        String pos = "left-top";
        switch (coordsOrigin) {
            case LeftTop: {
                pos = "left-top";
                break;
            }
            case MiddleTop: {
                pos = "middle-top";
                break;
            }
            case RightTop: {
                pos = "right-top";
                break;
            }
            case LeftMiddle: {
                pos = "left-middle";
                break;
            }
            case MiddleMiddle: {
                pos = "middle-middle";
                break;
            }
            case RightMiddle: {
                pos = "right-middle";
                break;
            }
            case LeftBottom: {
                pos = "left-bottom";
                break;
            }
            case MiddleBottom: {
                pos = "middle-bottom";
                break;
            }
            case RightBottom: {
                pos = "right-bottom";
            }
        }
        return pos + "@" + offset;
    }

    @Override
    protected String decorateMorphOver(String morphOverId, boolean graphicalObj) {
        if (graphicalObj && StringHelper.notEmpty(morphOverId)) {
            return "    morphover = function(s) return " + this.decorateId(morphOverId) + ":deref(); end," + LINE_SEPARATOR;
        }
        return "";
    }

    @Override
    protected String decorateMorphOut(String morphOutId, boolean graphicalObj) {
        if (graphicalObj && StringHelper.notEmpty(morphOutId)) {
            return "    morphout = function(s) return " + this.decorateId(morphOutId) + ":deref(); end," + LINE_SEPARATOR;
        }
        return "";
    }

    @Override
    protected String decorateObjDisp(String dispText, boolean imageEnabled, boolean isGraphicalObj) {
        if (imageEnabled && !isGraphicalObj) {
            return "    disp = function(s) return s.imgv(s)..\"" + dispText + "\" end," + LINE_SEPARATOR;
        }
        if (StringHelper.notEmpty(dispText)) {
            return "    disp = function(s) return \"" + dispText + "\" end," + LINE_SEPARATOR;
        }
        return "    disp = function(s) return false; end," + LINE_SEPARATOR;
    }

    private String expandInteractionMarks(String objId, String objName, boolean useReference, String text, boolean withImage, boolean isGraphicalObj) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = STEAD_OBJ_PATTERN.matcher(text);
        int start = 0;
        while (matcher.find()) {
            result.append(text.substring(start, matcher.start())).append("{");
            if (useReference) {
                result.append(StringHelper.isEmpty(objName) ? this.decorateId(objId) : objName).append("|");
            }
            if (withImage && !isGraphicalObj) {
                result.append("\"..s.imgv(s)..\"");
            }
            result.append(matcher.group(1)).append("}");
            start = matcher.end();
        }
        result.append(text.substring(start, text.length()));
        return result.toString();
    }

    @Override
    protected String decorateObjText(String objId, String objName, boolean suppressDsc, String objText, boolean imageEnabled, boolean isGraphicalObj) {
        StringBuilder stringBuilder = new StringBuilder();
        if (suppressDsc) {
            stringBuilder.append("    suppress_dsc = true,").append(LINE_SEPARATOR);
        }
        stringBuilder.append("    dscf = function(s) ");
        if (StringHelper.notEmpty(objText)) {
            stringBuilder.append("return \"");
            stringBuilder.append(this.expandInteractionMarks(objId, objName, suppressDsc, objText, imageEnabled, isGraphicalObj));
            stringBuilder.append("\"; ");
        }
        stringBuilder.append("end,").append(LINE_SEPARATOR);
        stringBuilder.append("    dsc = function(s) ");
        if (isGraphicalObj) {
            stringBuilder.append("return s.dscf(s); ");
        } else if (!suppressDsc) {
            stringBuilder.append("p(s.dscf(s)); ");
        }
        stringBuilder.append("end,").append(LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    @Override
    protected String decorateObjTak(String objName, String commonObjId) {
        boolean hasCmn = StringHelper.notEmpty(commonObjId);
        StringBuilder returnExpression = new StringBuilder();
        if (hasCmn) {
            returnExpression.append("        local hasCmnTak = (").append(this.decorateId(commonObjId)).append(".tak ~= nil").append(");").append(LINE_SEPARATOR);
            returnExpression.append("        if hasCmnTak then").append(LINE_SEPARATOR);
            returnExpression.append("            nlb:addf(nil, ").append(this.decorateId(commonObjId)).append(", false);").append(LINE_SEPARATOR);
            returnExpression.append("        end").append(LINE_SEPARATOR);
            returnExpression.append("        return not hasCmnTak;").append(LINE_SEPARATOR);
        } else {
            returnExpression.append("        return true;").append(LINE_SEPARATOR);
        }
        return "    tak = function(s)" + LINE_SEPARATOR + "        s.act(s);" + LINE_SEPARATOR + returnExpression.toString() + "    end," + LINE_SEPARATOR;
    }

    @Override
    protected String decorateObjInv(ObjType objType) {
        switch (objType) {
            case MENU: {
                return "    menu = function(s)" + LINE_SEPARATOR + "        return s.act(s);" + LINE_SEPARATOR + "    end," + LINE_SEPARATOR;
            }
            case OBJ: {
                return "    inv = function(s)" + LINE_SEPARATOR + "        if s.use then s.use(s, s); end;" + LINE_SEPARATOR + "    end," + LINE_SEPARATOR;
            }
        }
        return "";
    }

    @Override
    protected String decorateObjActStart(String actTextExpanded, String commonObjId) {
        String id;
        boolean actTextNotEmpty = StringHelper.notEmpty(actTextExpanded);
        String returnStatement = actTextNotEmpty ? "" : "        return true;" + LINE_SEPARATOR;
        String actText = this.getActText(actTextNotEmpty);
        StringBuilder result = new StringBuilder();
        boolean hasCmn = StringHelper.notEmpty(commonObjId);
        result.append("    used = function(s, w)").append(LINE_SEPARATOR);
        String string = id = hasCmn ? this.decorateId(commonObjId) : "";
        if (hasCmn) {
            result.append("        ").append("if w.usea then w:usea(").append(id).append(", s); end;").append(LINE_SEPARATOR);
        }
        result.append("    end,").append(LINE_SEPARATOR);
        result.append("    act = function(s)").append(LINE_SEPARATOR);
        result.append("        s:acta();").append(LINE_SEPARATOR);
        result.append(returnStatement);
        result.append("    end,").append(LINE_SEPARATOR);
        result.append("    actt = function(s)").append(LINE_SEPARATOR);
        result.append("        return \"").append(actTextExpanded).append("\";").append(LINE_SEPARATOR);
        result.append("    end,").append(LINE_SEPARATOR);
        result.append("    actp = function(s)").append(LINE_SEPARATOR);
        result.append(actText);
        result.append("    end,").append(LINE_SEPARATOR);
        result.append("    acta = function(s)").append(LINE_SEPARATOR);
        result.append("        s:actp();").append(LINE_SEPARATOR);
        result.append("        s:actf();").append(LINE_SEPARATOR);
        if (hasCmn) {
            if (actTextNotEmpty) {
                result.append("        ").append(id).append(".actf(s);").append(LINE_SEPARATOR);
            } else {
                result.append("        ").append(id).append(":actp();").append(LINE_SEPARATOR);
                result.append("        ").append(id).append(".actf(s);").append(LINE_SEPARATOR);
            }
        }
        result.append("    end,").append(LINE_SEPARATOR);
        result.append("    actf = function(s)").append(LINE_SEPARATOR);
        return result.toString();
    }

    @Override
    protected String decorateObjNouse(String nouseTextExpanded) {
        boolean nouseTextEmpty = StringHelper.isEmpty(nouseTextExpanded);
        if (nouseTextEmpty) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("    nouse = function(s)").append(LINE_SEPARATOR);
        result.append("        nlb:curloc().lasttext = \"").append(nouseTextExpanded).append("\"; nlb:curloc().wastext = true;").append(LINE_SEPARATOR);
        result.append("        return nlb:curloc().lasttext;").append(LINE_SEPARATOR);
        result.append("    end,").append(LINE_SEPARATOR);
        return result.toString();
    }

    protected String getActText(boolean actTextNotEmpty) {
        return actTextNotEmpty ? "        nlb:curloc().lasttext = s.actt(s); p(nlb:curloc().lasttext); nlb:curloc().wastext = true;" + LINE_SEPARATOR : "";
    }

    @Override
    protected String decorateObjActEnd(boolean collapseOnAct) {
        String prefix = collapseOnAct ? "        local v = vn:glookup(stead.deref(s));" + LINE_SEPARATOR + "        if s.is_paused then" + LINE_SEPARATOR + "            vn:vpause(v, false);" + LINE_SEPARATOR + "        else" + LINE_SEPARATOR + "            vn:set_step(v, nil, not v.forward);" + LINE_SEPARATOR + "        end" + LINE_SEPARATOR + "        vn:start();" + LINE_SEPARATOR : "";
        return prefix + "    end," + LINE_SEPARATOR;
    }

    @Override
    protected String decorateObjUseStart(String commonObjId) {
        boolean hasCmn = StringHelper.notEmpty(commonObjId);
        String cmnId = this.decorateId(commonObjId);
        String template = "        if was_nonempty_usetext then" + LINE_SEPARATOR + "            if %s.usef then %s:usef(w, w); end;" + LINE_SEPARATOR + "        else" + LINE_SEPARATOR + "            if %s.usea then %s:usea(w, w); end;" + LINE_SEPARATOR + "        end;" + LINE_SEPARATOR;
        String cmnUse = hasCmn ? String.format(template, cmnId, cmnId, cmnId, cmnId) : "";
        return "    use = function(s, w)" + LINE_SEPARATOR + "        local was_nonempty_usetext = s:usea(w, w);" + LINE_SEPARATOR + cmnUse + "    end," + LINE_SEPARATOR + "    usea = function(s, w, ww)" + LINE_SEPARATOR + "        local was_nonempty_usetext = s:usep(w, ww);" + LINE_SEPARATOR + "        s:usef(w, ww);" + LINE_SEPARATOR + "        return was_nonempty_usetext;" + LINE_SEPARATOR + "    end," + LINE_SEPARATOR + "    usef = function(s, w, ww)" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateObjUseEnd() {
        return "    end," + LINE_SEPARATOR;
    }

    @Override
    protected String decorateObjObjStart() {
        return "    obj = {" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateObjObjEnd() {
        return "    }," + LINE_SEPARATOR;
    }

    @Override
    protected String decorateUseTarget(String targetId) {
        return "w.nlbid == " + this.decorateId(targetId) + ".nlbid";
    }

    @Override
    protected String decorateUseVariable(String variableName) {
        String globalVar = GLOBAL_VAR_PREFIX + variableName;
        return globalVar + " = true;" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateUseModifications(String modificationsText) {
        return modificationsText;
    }

    @Override
    protected String decorateObjVariable(String variableName) {
        String globalVar = GLOBAL_VAR_PREFIX + variableName;
        return globalVar + " = true;" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateObjConstraint(String constraintValue) {
        StringBuilder result = new StringBuilder();
        if (StringHelper.notEmpty(constraintValue)) {
            result.append("    alive = function(s)").append(LINE_SEPARATOR);
            result.append("        return ").append(constraintValue).append(" and s:cont_alive();").append(LINE_SEPARATOR);
            result.append("    end,").append(LINE_SEPARATOR);
        }
        return result.toString();
    }

    @Override
    protected String decorateObjCommonTo(String commonObjId) {
        String id;
        StringBuilder result = new StringBuilder();
        boolean hasCmn = StringHelper.notEmpty(commonObjId);
        result.append("    used = function(s, w)").append(LINE_SEPARATOR);
        String string = id = hasCmn ? this.decorateId(commonObjId) : "";
        if (hasCmn) {
            result.append("        ").append("if w.usea then w:usea(").append(id).append(", s); end;").append(LINE_SEPARATOR);
        }
        result.append("    end,").append(LINE_SEPARATOR);
        result.append("    actcmn = function(s)").append(LINE_SEPARATOR);
        if (hasCmn) {
            result.append("        ").append(id).append(".actf(s);").append(LINE_SEPARATOR);
        }
        result.append("    end,").append(LINE_SEPARATOR);
        return result.toString();
    }

    @Override
    protected String decorateObjModifications(String modificationsText) {
        return modificationsText;
    }

    @Override
    protected String decorateObjEnd() {
        return "};" + LINE_SEPARATOR + LINE_SEPARATOR;
    }

    @Override
    protected String decorateContainedObjId(String containedObjId) {
        return "        '" + this.decorateId(containedObjId) + "'," + LINE_SEPARATOR;
    }

    @Override
    protected String generateTrailingText() {
        return "";
    }

    @Override
    protected String decorateAssignment(String variableName, String variableValue) {
        return variableName + " = " + variableValue + ";" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateTag(String variable, String objId, String tag) {
        StringBuilder result = new StringBuilder();
        if (StringHelper.isEmpty(variable) && objId == null) {
            result.append("s.tag = ");
        } else if (objId != null) {
            result.append(this.decorateId(objId)).append(".tag = ");
        } else {
            result.append(variable).append(".tag = ");
        }
        result.append("'").append(tag).append("';").append(LINE_SEPARATOR);
        return result.toString();
    }

    @Override
    protected String decorateGetTagOperation(String resultingVariable, String objId, String objVariableName) {
        StringBuilder result = new StringBuilder();
        if (StringHelper.notEmpty(resultingVariable)) {
            result.append(resultingVariable).append(" = ");
            if (StringHelper.notEmpty(objVariableName)) {
                result.append(objVariableName);
            } else if (objId != null) {
                result.append(this.decorateId(objId));
            } else {
                result.append("s");
            }
            result.append(".tag;").append(LINE_SEPARATOR);
        }
        return result.toString();
    }

    @Override
    protected String decorateWhile(String constraint) {
        return "while (" + constraint + ") do" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateIf(String constraint) {
        return "if (" + constraint + ") then" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateIfHave(String objId, String objVar) {
        if (objId != null) {
            return "if have(" + this.decorateId(objId) + ") then" + LINE_SEPARATOR;
        }
        return "if have(stead.deref(" + objVar + ")) then" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateElse() {
        return "else" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateElseIf(String constraint) {
        return "elseif (" + constraint + ") then" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateEnd() {
        return "end;" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateReturn(String returnValue) {
        String valueToReturn = StringHelper.isEmpty(returnValue) ? "" : returnValue;
        return "if true then return " + valueToReturn + "; end;" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateHaveOperation(String variableName, String objId, String objVar) {
        if (objId != null) {
            return variableName + " = have(" + this.decorateId(objId) + ");" + LINE_SEPARATOR;
        }
        return variableName + " = have(stead.deref(" + objVar + "));" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateCloneOperation(String variableName, String objId, String objVar) {
        if (objId != null) {
            return variableName + " = nlb:clone(" + this.decorateId(objId) + ");" + LINE_SEPARATOR;
        }
        if (objVar != null) {
            return variableName + " = nlb:clone(" + objVar + ");" + LINE_SEPARATOR;
        }
        return variableName + " = nlb:clone(s);" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateContainerOperation(String variableName, String objId, String objVar) {
        if (objId != null) {
            return variableName + " = " + this.decorateId(objId) + ".container();" + LINE_SEPARATOR;
        }
        if (objVar != null) {
            return variableName + " = " + objVar + ".container();" + LINE_SEPARATOR;
        }
        return variableName + " = s.container();" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateGetIdOperation(String variableName, String objId, String objVar) {
        if (objId != null) {
            return variableName + " = '" + objId + "';" + LINE_SEPARATOR;
        }
        if (objVar != null) {
            return variableName + " = " + objVar + ".nlbid;" + LINE_SEPARATOR;
        }
        return variableName + " = s.nlbid;" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateDelObj(String destinationId, String destinationName, String objectId, String objectVar, String objectName, String objectDisplayName) {
        String objToDel;
        String string = objToDel = objectId != null ? this.decorateId(objectId) : objectVar;
        if (destinationId == null) {
            if (destinationName != null) {
                return "            nlb:rmv(\"" + destinationName + "\", " + objToDel + "); " + this.getClearContainerStatement(objToDel) + LINE_SEPARATOR;
            }
            return "            objs():del(" + objToDel + "); " + this.getClearContainerStatement(objToDel) + LINE_SEPARATOR;
        }
        return "            objs(" + this.decorateId(destinationId) + "):del(" + objToDel + "); " + this.getClearContainerStatement(objToDel) + LINE_SEPARATOR;
    }

    private String getClearContainerStatement(String objVar) {
        return objVar + ".container = " + "function() return nil; end" + "; ";
    }

    @Override
    protected String decorateDelInvObj(String objectId, String objectVar, String objectName, String objectDisplayName) {
        return "            if have(stead.deref(" + objectVar + ")) then remove(stead.deref(" + objectVar + "), inv()); end;" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateAddObj(String destinationId, String objectId, String objectVar, String objectName, String objectDisplayName, boolean unique) {
        return "            nlb:addf(" + (destinationId != null ? this.decorateId(destinationId) : "s") + ", " + (objectId != null ? this.decorateId(objectId) : objectVar) + (unique ? ", true" : ", false") + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateAddInvObj(String objectId, String objectVar, String objectName, String objectDisplayName) {
        return "            nlb:addf(nil, " + (objectId != null ? this.decorateId(objectId) : objectVar) + ", false);" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateAddAllOperation(String destinationId, String destinationListVariableName, String sourceListVariableName, boolean unique) {
        return this.createListObj(destinationListVariableName) + this.createListObj(sourceListVariableName) + "        nlb:addAll(s, " + (destinationId != null ? this.decorateId(destinationId) : "nil") + ", " + (destinationListVariableName != null ? destinationListVariableName + " and " + destinationListVariableName + ".listnam or \"\"" : "nil") + ", " + sourceListVariableName + " and " + sourceListVariableName + ".listnam or \"\"" + (unique ? ", true" : ", false") + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateObjsOperation(String listVariableName, String srcObjId, String objectVar) {
        return this.createListObj(listVariableName) + "        nlb:pushObjs(" + listVariableName + ".listnam, " + (srcObjId != null ? this.decorateId(srcObjId) : objectVar) + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateSSndOperation() {
        return "        s:snd();" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateWSndOperation() {
        return "        ww:snd();" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateSndOperation(String objectId, String objectVar) {
        if (objectId != null) {
            return "        " + this.decorateId(objectId) + ":snd();" + LINE_SEPARATOR;
        }
        if (objectVar != null) {
            return "        " + objectVar + ":snd();" + LINE_SEPARATOR;
        }
        return this.decorateSSndOperation();
    }

    @Override
    protected String decorateSPushOperation(String listVariableName) {
        return this.createListObj(listVariableName) + "        nlb:push(" + listVariableName + ".listnam, s);" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateWPushOperation(String listVariableName) {
        return this.createListObj(listVariableName) + "        nlb:push(" + listVariableName + ".listnam, ww);  -- will push nil if undef" + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePushOperation(String listVariableName, String objectId, String objectVar) {
        return this.createListObj(listVariableName) + "        nlb:push(" + listVariableName + ".listnam, " + (objectId != null ? this.decorateId(objectId) : objectVar) + ");" + LINE_SEPARATOR;
    }

    private String createListObj(String listVariableName) {
        if (listVariableName != null) {
            return "        if not " + listVariableName + " then" + LINE_SEPARATOR + "            stead.add_var { " + listVariableName + " = nlb:clonelst(listobj, \"" + listVariableName + "\"); }" + LINE_SEPARATOR + "        end;" + LINE_SEPARATOR;
        }
        return "";
    }

    @Override
    protected String decoratePopOperation(String variableName, String listVariableName) {
        return variableName + " = nlb:pop(" + listVariableName + ".listnam);" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateSInjectOperation(String listVariableName) {
        return this.createListObj(listVariableName) + "        nlb:inject(" + listVariableName + ".listnam, s);" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateInjectOperation(String listVariableName, String objectId, String objectVar) {
        return this.createListObj(listVariableName) + "        nlb:inject(" + listVariableName + ".listnam, " + (objectId != null ? this.decorateId(objectId) : objectVar) + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateEjectOperation(String variableName, String listVariableName) {
        return variableName + " = nlb:eject(" + listVariableName + ".listnam);" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateClearOperation(String destinationId, String destinationVar) {
        if (destinationId != null) {
            return "nlb:clrcntnr(objs(" + this.decorateId(destinationId) + ")); objs(" + this.decorateId(destinationId) + "):zap();" + LINE_SEPARATOR;
        }
        if (destinationVar != null) {
            return "nlb:clear(" + destinationVar + ");" + LINE_SEPARATOR;
        }
        return "nlb:clrcntnr(objs()); objs():zap();" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateClearInvOperation() {
        return "inv():zap();" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateSizeOperation(String variableName, String listVariableName) {
        return "if " + listVariableName + " then " + variableName + " = nlb:size(" + listVariableName + ".listnam) else " + variableName + " = 0 end;" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateRndOperation(String variableName, String maxValue) {
        return variableName + " = rnd(" + maxValue + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateAchMaxOperation(String achievementName, int max) {
        return "nlb:setAchievementMax(statsAPI, '" + achievementName + "', " + max + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateAchieveOperation(String achievementName, String modificationId) {
        return "nlb:setAchievement(statsAPI, '" + achievementName + "', '" + modificationId + "');" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateAchievedOperation(String variableName, String achievementName) {
        return variableName + " = nlb:getAchievement(statsAPI, '" + achievementName + "');" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateGoToOperation(String locationId) {
        return "nlb:nlbwalk(nil, " + this.decorateId(locationId) + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateSnapshotOperation(String snapshotId) {
        return "nlb:snapshot();" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateOpenURLOperation(String url) {
        return "statsAPI.openURL(\"" + url + "\");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateWinGeomOperation(String arg) {
        return "theme.win.geom(" + arg + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateInvGeomOperation(String arg) {
        return "theme.inv.geom(" + arg + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateWinColorOperation(String arg) {
        return "theme.win.color(" + arg + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateInvColorOperation(String arg) {
        return "theme.inv.color(" + arg + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateShuffleOperation(String listVariableName) {
        return "        if " + listVariableName + " then" + LINE_SEPARATOR + "            nlb:shuffle(" + listVariableName + ".listnam);" + LINE_SEPARATOR + "        end;" + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePRNOperation(String variableName) {
        return "nlb:curloc().lasttext = nlb:lasttext().." + variableName + "; p(" + variableName + "); nlb:curloc().wastext = true;" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateDSCOperation(String resultVariableName, String dscObjVariable, String dscObjId) {
        return resultVariableName + " = " + (dscObjId != null ? this.decorateId(dscObjId) : dscObjVariable) + ":dscf();" + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePDscOperation(String objVariableName) {
        return "nlb:pdscf(" + objVariableName + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePDscsOperation(String objId, String objVar) {
        if (objId != null) {
            return "nlb:pdscs(" + this.decorateId(objId) + ");" + LINE_SEPARATOR;
        }
        if (objVar != null) {
            return "nlb:pdscs(" + objVar + ");" + LINE_SEPARATOR;
        }
        return "nlb:pdscs(s);" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateActOperation(String actingObjVariable, String actingObjId) {
        String source = actingObjId != null ? this.decorateId(actingObjId) : actingObjVariable;
        return "nlb:acta(" + source + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateActtOperation(String resultVariableName, String actObjVariable, String actObjId) {
        return resultVariableName + " = " + (actObjId != null ? this.decorateId(actObjId) : actObjVariable) + ":actt();" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateActfOperation(String actingObjVariable, String actingObjId) {
        String source = actingObjId != null ? this.decorateId(actingObjId) : actingObjVariable;
        return "nlb:actf(" + source + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateUseOperation(String sourceVariable, String sourceId, String targetVariable, String targetId) {
        String source = sourceId != null ? this.decorateId(sourceId) : sourceVariable;
        String target = targetId != null ? this.decorateId(targetId) : targetVariable;
        return "nlb:usea(" + source + ", " + target + ");" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateTrue() {
        return "true";
    }

    @Override
    protected String decorateFalse() {
        return "false";
    }

    @Override
    protected String decorateEq() {
        return "==";
    }

    @Override
    protected String decorateNEq() {
        return "~=";
    }

    @Override
    protected String decorateGt() {
        return ">";
    }

    @Override
    protected String decorateGte() {
        return ">=";
    }

    @Override
    protected String decorateLt() {
        return "<";
    }

    @Override
    protected String decorateLte() {
        return "<=";
    }

    @Override
    protected String decorateNot() {
        return "not ";
    }

    @Override
    protected String decorateOr() {
        return "or";
    }

    @Override
    protected String decorateAnd() {
        return "and";
    }

    @Override
    protected String decorateExistence(String decoratedVariable) {
        return "(" + decoratedVariable + " ~= nil)";
    }

    @Override
    protected String decorateBooleanVar(String constraintVar) {
        return GLOBAL_VAR_PREFIX + constraintVar;
    }

    @Override
    protected String decorateStringVar(String constraintVar) {
        return GLOBAL_VAR_PREFIX + constraintVar;
    }

    @Override
    protected String decorateNumberVar(String constraintVar) {
        return GLOBAL_VAR_PREFIX + constraintVar;
    }

    @Override
    protected String decorateLinkLabel(String linkId, String linkText, Theme theme) {
        if (this.isVN(theme)) {
            return this.m_vnsteadExportManager.decorateLinkLabel(linkId, linkText, theme);
        }
        return this.decorateId(linkId);
    }

    @Override
    protected String decorateLinkComment(String comment) {
        return "--" + comment + LINE_SEPARATOR;
    }

    @Override
    protected String decorateLinkStart(String linkId, String linkText, boolean isAuto, boolean isTrivial, int pageNumber, Theme theme) {
        if (this.isVN(theme)) {
            return this.m_vnsteadExportManager.decorateLinkStart(linkId, linkText, isAuto, isTrivial, pageNumber, theme);
        }
        String id = this.decorateId(linkId);
        return id + "_XLnk = xact(" + LINE_SEPARATOR + "'" + id + "_XLnk'," + LINE_SEPARATOR + "function() walk('" + id + "'); end" + LINE_SEPARATOR + ");" + LINE_SEPARATOR + LINE_SEPARATOR + id + " = room {" + LINE_SEPARATOR + "    nam = '" + id + "'," + LINE_SEPARATOR + "    disp = function(s)" + LINE_SEPARATOR + "        return \"" + linkText + "\";" + LINE_SEPARATOR + "    end," + LINE_SEPARATOR + "    enter = function(s, f)" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateLinkGoTo(String linkId, String linkText, String linkSource, int sourcePageNumber, String linkTarget, int targetPageNumber, Theme theme) {
        if (this.isVN(theme)) {
            return this.m_vnsteadExportManager.decorateLinkGoTo(linkId, linkText, linkSource, sourcePageNumber, linkTarget, targetPageNumber, theme);
        }
        return "        nlb:nlbwalk(" + this.decoratePageName(linkSource, sourcePageNumber) + ", " + this.decoratePageName(linkTarget, targetPageNumber) + "); ";
    }

    @Override
    protected String decorateLinkEnd(Theme theme) {
        if (this.isVN(theme)) {
            return this.m_vnsteadExportManager.decorateLinkEnd(theme);
        }
        return LINE_SEPARATOR + "    end" + LINE_SEPARATOR + "}" + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageEnd(boolean isFinish) {
        return "};" + LINE_SEPARATOR + LINE_SEPARATOR;
    }

    @Override
    protected String decorateLinkVariable(String variableName) {
        String globalVar = GLOBAL_VAR_PREFIX + variableName;
        return globalVar + " = true;" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateLinkVisitStateVariable(String linkVisitStateVariable) {
        String globalVar = GLOBAL_VAR_PREFIX + linkVisitStateVariable;
        return globalVar + " = true;" + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageVariable(String variableName) {
        String globalVar = GLOBAL_VAR_PREFIX + variableName;
        return globalVar + " = true;" + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageTimerVariableInit(String variableName) {
        if (StringHelper.isEmpty(variableName)) {
            return "s.time = 0; ";
        }
        String timerVar = this.decorateNumberVar(variableName);
        return timerVar + " = 0; s.time = " + timerVar + "; ";
    }

    @Override
    protected String decoratePageTimerVariable(String variableName) {
        if (StringHelper.isEmpty(variableName)) {
            return "s.time = s.time + 1; ";
        }
        String timerVar = this.decorateNumberVar(variableName);
        return timerVar + " = " + timerVar + " + 1; s.time = " + timerVar + "; ";
    }

    @Override
    protected String decoratePageModifications(String modificationsText) {
        return modificationsText;
    }

    @Override
    protected String decoratePageThemeModifications(String modificationsText) {
        return modificationsText;
    }

    @Override
    protected String decorateLinkModifications(String modificationsText) {
        return modificationsText;
    }

    @Override
    protected String decoratePageCaption(String caption, boolean useCaption, String moduleTitle, boolean noSave) {
        StringBuilder result = new StringBuilder();
        String title = this.getNonEmptyTitle(moduleTitle);
        if (StringHelper.notEmpty(caption) && useCaption) {
            result.append("    nam = \"").append(caption).append("\",").append(LINE_SEPARATOR);
        } else {
            result.append("    nam = '").append(title).append("',").append(LINE_SEPARATOR);
        }
        if (noSave) {
            result.append("    nosave = true,").append(LINE_SEPARATOR);
        }
        return result.toString();
    }

    @Override
    protected String decoratePageNotes(String notes) {
        return "    notes = '" + notes + "'," + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageImage(List<ImagePathData> pageImagePathDatas, boolean imageBackground, Theme theme) {
        if (this.isVN(theme)) {
            return this.m_vnsteadExportManager.decoratePageImage(pageImagePathDatas, imageBackground, theme);
        }
        StringBuilder bgimgBuilder = new StringBuilder("    bgimg = function(s)" + LINE_SEPARATOR);
        StringBuilder picBuilder = new StringBuilder("    pic = function(s)" + LINE_SEPARATOR);
        boolean notFirst = false;
        String bgimgIfTermination = "";
        String picIfTermination = "";
        for (ImagePathData pageImagePathData : pageImagePathDatas) {
            String pageImagePath = pageImagePathData.getImagePath();
            if (StringHelper.notEmpty(pageImagePath)) {
                StringBuilder tempBuilder = new StringBuilder();
                tempBuilder.append("        ").append(notFirst ? "else" : "").append("if (");
                String constraint = pageImagePathData.getConstraint();
                tempBuilder.append(StringHelper.notEmpty(constraint) ? "s.tag == '" + constraint + "'" : "true").append(") then");
                tempBuilder.append(LINE_SEPARATOR);
                String img = this.decorateImagePath(pageImagePath, pageImagePathData.getMaxFrameNumber());
                if (imageBackground) {
                    bgimgIfTermination = "        end" + LINE_SEPARATOR;
                    bgimgBuilder.append((CharSequence)tempBuilder).append("            ");
                    bgimgBuilder.append("return ").append(img).append(";").append(LINE_SEPARATOR);
                } else {
                    picIfTermination = "        end" + LINE_SEPARATOR;
                    picBuilder.append((CharSequence)tempBuilder).append("            ");
                    picBuilder.append("return ").append(img).append(";").append(LINE_SEPARATOR);
                }
            }
            notFirst = true;
        }
        bgimgBuilder.append(bgimgIfTermination).append("return nlb:std_bg();").append(LINE_SEPARATOR).append("    end,").append(LINE_SEPARATOR);
        picBuilder.append(picIfTermination).append("    end,").append(LINE_SEPARATOR);
        return bgimgBuilder.toString() + picBuilder.toString();
    }

    private String decorateImagePath(String imagePath, int maxFrameNumber) {
        if (maxFrameNumber > 0) {
            return "string.format('" + imagePath + "', nlb:curloc().time % " + maxFrameNumber + " + 1)";
        }
        return "'" + imagePath + "'";
    }

    @Override
    protected String decorateObjSound(List<SoundPathData> objSoundPathDatas, boolean soundSFX) {
        StringBuilder result = new StringBuilder("    snd = function(s) " + LINE_SEPARATOR);
        boolean notFirst = false;
        String ifTermination = "";
        for (SoundPathData objSoundPathData : objSoundPathDatas) {
            String objSoundPath = objSoundPathData.getSoundPath();
            if (StringHelper.notEmpty(objSoundPath)) {
                String constraint = objSoundPathData.getConstraint();
                boolean hasConstraint = StringHelper.notEmpty(constraint);
                if (hasConstraint) {
                    ifTermination = "        end" + LINE_SEPARATOR;
                    result.append("        ").append(notFirst ? "else" : "").append("if (");
                    result.append("s.tag == '").append(constraint).append("'").append(") then");
                    result.append(LINE_SEPARATOR);
                } else {
                    result.append(ifTermination);
                }
                if ("VOID".equals(objSoundPath)) {
                    result.append("            stop_music();").append(LINE_SEPARATOR);
                } else if (soundSFX || objSoundPathData.isSfx()) {
                    result.append("            add_sound('").append(objSoundPath).append("');").append(LINE_SEPARATOR);
                } else {
                    result.append("            set_music('").append(objSoundPath).append("', 0);").append(LINE_SEPARATOR);
                }
            }
            notFirst = true;
        }
        result.append(ifTermination);
        result.append("    end,").append(LINE_SEPARATOR);
        return result.toString();
    }

    @Override
    protected String decorateObjArm(float left, float top) {
        return "    iarm = { [0] = { " + left + ", " + top + " } };" + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageSound(String pageName, List<SoundPathData> pageSoundPathDatas, boolean soundSFX, Theme theme) {
        StringBuilder result = new StringBuilder("    snd = function(s) " + LINE_SEPARATOR);
        boolean notFirst = false;
        boolean hasSFX = false;
        String ifTermination = "";
        for (SoundPathData pageSoundPathData : pageSoundPathDatas) {
            String pageSoundPath = pageSoundPathData.getSoundPath();
            if (StringHelper.notEmpty(pageSoundPath)) {
                String constraint = pageSoundPathData.getConstraint();
                boolean hasConstraint = StringHelper.notEmpty(constraint);
                if (hasConstraint) {
                    ifTermination = "        end" + LINE_SEPARATOR;
                    result.append("        ").append(notFirst ? "else" : "").append("if (");
                    result.append("s.tag == '").append(constraint).append("'").append(") then");
                    result.append(LINE_SEPARATOR);
                } else {
                    result.append(ifTermination);
                }
                if ("VOID".equals(pageSoundPath)) {
                    result.append("            stop_music();").append(LINE_SEPARATOR);
                } else if (soundSFX || pageSoundPathData.isSfx()) {
                    hasSFX = true;
                    result.append("            nlb:push('").append(pageName).append("_snds").append("', '").append(pageSoundPath).append("');").append(LINE_SEPARATOR);
                } else {
                    result.append("            set_music('").append(pageSoundPath).append("', 0);").append(LINE_SEPARATOR);
                }
            }
            notFirst = true;
        }
        result.append(ifTermination);
        if (!this.isVN(theme)) {
            result.append("        s.nextsnd(s);").append(LINE_SEPARATOR);
        }
        result.append("    end,").append(LINE_SEPARATOR);
        result.append("    sndout = function(s) ");
        if (hasSFX) {
            result.append("stop_sound(); ");
        }
        result.append("end,").append(LINE_SEPARATOR);
        return result.toString();
    }

    @Override
    protected String expandVariables(List<TextChunk> textChunks) {
        StringBuilder result = new StringBuilder();
        for (TextChunk textChunk : textChunks) {
            switch (textChunk.getType()) {
                case TEXT: {
                    result.append(textChunk.getText());
                    break;
                }
                case ACTION_TEXT: {
                    result.append("\"..nlb:lasttext()..\"");
                    break;
                }
                case VARIABLE: {
                    result.append("\"..");
                    result.append("tostring(").append(GLOBAL_VAR_PREFIX).append(textChunk.getText()).append(")");
                    result.append("..\"");
                    break;
                }
                case NEWLINE: {
                    result.append("^\"..").append(this.getLineSeparator()).append("\"");
                }
            }
        }
        return result.toString();
    }

    @Override
    protected String expandVariables(List<TextChunk> textChunks, Theme theme) {
        if (this.isVN(theme)) {
            return this.m_vnsteadExportManager.expandVariables(textChunks, theme);
        }
        return this.expandVariables(textChunks);
    }

    @Override
    protected String expandVariablesForLinks(List<TextChunk> textChunks, Theme theme) {
        return this.expandVariables(textChunks);
    }

    protected String getGlobalVarPrefix() {
        return GLOBAL_VAR_PREFIX;
    }

    @Override
    protected String decoratePageTextStart(String labelText, int pageNumber, List<TextChunk> pageTextChunks, Theme theme) {
        if (this.isVN(theme)) {
            return this.m_vnsteadExportManager.decoratePageTextStart(labelText, pageNumber, pageTextChunks, theme);
        }
        StringBuilder pageText = new StringBuilder();
        if (pageTextChunks.size() > 0) {
            pageText.append("    dsc = function(s)").append(LINE_SEPARATOR);
            pageText.append("        p(\"");
            pageText.append(this.expandVariables(pageTextChunks, theme));
            pageText.append("\");").append(LINE_SEPARATOR);
            pageText.append("    end,").append(LINE_SEPARATOR);
        } else {
            pageText.append("    dsc = true,").append(LINE_SEPARATOR);
        }
        return pageText.toString();
    }

    @Override
    protected String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageTextEnd(String labelText, int pageNumber, Theme theme, boolean hasChoicesOrLeaf) {
        if (this.isVN(theme)) {
            return this.m_vnsteadExportManager.decoratePageTextEnd(labelText, pageNumber, theme, hasChoicesOrLeaf);
        }
        return "";
    }

    @Override
    protected String decoratePageLabel(String labelText, int pageNumber, Theme theme) {
        if (this.isVN(theme)) {
            return this.m_vnsteadExportManager.decoratePageLabel(labelText, pageNumber, theme);
        }
        return this.generatePageBeginningCode(labelText, pageNumber) + "room {" + LINE_SEPARATOR;
    }

    protected String generatePageBeginningCode(String labelText, int pageNumber) {
        StringBuilder roomBeginning = new StringBuilder();
        String roomName = this.decoratePageName(labelText, pageNumber);
        if (pageNumber == 1) {
            roomBeginning.append("main, ").append(roomName);
            roomBeginning.append(" = room { nam = 'main', enter = function(s) nlb:nlbwalk(s, ").append(roomName).append("); end }, ");
        } else {
            roomBeginning.append(roomName).append(" = ");
        }
        return roomBeginning.toString();
    }

    @Override
    protected String decoratePageNumber(int pageNumber) {
        return "-- PageNo. " + String.valueOf(pageNumber);
    }

    @Override
    protected String decoratePageComment(String comment) {
        return "-- " + comment + LINE_SEPARATOR;
    }
}

