/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export;

import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.export.ExportManager;
import com.nlbhub.nlb.domain.export.NLBBuildingBlocks;
import com.nlbhub.nlb.domain.export.ObjBuildingBlocks;
import com.nlbhub.nlb.domain.export.PageBuildingBlocks;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBExportException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

public abstract class TextExportManager
extends ExportManager {
    protected TextExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        super(nlb, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportToFile(File targetFile) throws NLBExportException {
        OutputStream outputStream = null;
        try {
            try {
                NLBBuildingBlocks nlbBlocks = this.createNLBBuildingBlocks();
                byte[] bytes = this.generateNLBText(nlbBlocks).getBytes(this.getEncoding());
                outputStream = new FileOutputStream(targetFile);
                outputStream.write(bytes);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (NLBConsistencyException | FileNotFoundException | UnsupportedEncodingException e) {
            throw new NLBExportException("Error while exporting NLB: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new NLBExportException("Error while exporting NLB: " + e.getMessage(), e);
        }
    }

    protected String generateNLBText(NLBBuildingBlocks nlbBlocks) throws NLBConsistencyException {
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        List<ObjBuildingBlocks> objsBlocks = nlbBlocks.getObjsBuildingBlocks();
        List<PageBuildingBlocks> pagesBlocks = nlbBlocks.getPagesBuildingBlocks();
        stringBuilder.append(this.generatePreambleText(nlbBlocks));
        stringBuilder.append(this.generateVariableInitializationText(this.getInitValuesMap()));
        for (i = 0; i < objsBlocks.size(); ++i) {
            stringBuilder.append(this.generateObjText(objsBlocks.get(i)));
        }
        for (i = 0; i < pagesBlocks.size(); ++i) {
            PageBuildingBlocks pageBlocks = pagesBlocks.get(i);
            stringBuilder.append(this.generatePageText(pageBlocks));
            stringBuilder.append(this.generatePostPageText(pageBlocks));
        }
        stringBuilder.append(this.generateTrailingText());
        return stringBuilder.toString();
    }

    protected abstract String generatePreambleText(NLBBuildingBlocks var1);

    protected String generateVariableInitializationText(Map<String, String> initValuesMap) {
        return "";
    }

    protected abstract String generateObjText(ObjBuildingBlocks var1);

    protected abstract String generatePageText(PageBuildingBlocks var1);

    protected abstract String generatePostPageText(PageBuildingBlocks var1);

    protected abstract String generateTrailingText();
}

