/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export.hypertext;

import com.nlbhub.nlb.api.TextChunk;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.export.ImagePathData;
import com.nlbhub.nlb.domain.export.SoundPathData;
import com.nlbhub.nlb.domain.export.hypertext.HypertextExportManager;
import com.nlbhub.nlb.domain.export.hypertext.document.HTDocument;
import com.nlbhub.nlb.domain.export.hypertext.document.HTMLAnchor;
import com.nlbhub.nlb.domain.export.hypertext.document.HTMLDocument;
import com.nlbhub.nlb.domain.export.hypertext.document.HTMLFont;
import com.nlbhub.nlb.domain.export.hypertext.document.HTMLParagraph;
import com.nlbhub.nlb.exception.HTDocumentException;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.util.StringHelper;
import java.util.List;

public class HTMLExportManager
extends HypertextExportManager<HTMLParagraph, HTMLAnchor, HTMLFont> {
    public HTMLExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        super(nlb, encoding);
    }

    @Override
    protected String decorateExistence(String decoratedVariable) {
        return "";
    }

    @Override
    protected String getLineSeparator() {
        return "<br/>" + System.getProperty("line.separator");
    }

    @Override
    protected HTDocument<HTMLParagraph> createDocument(String encoding, String lineSeparator) {
        return new HTMLDocument(encoding, lineSeparator);
    }

    @Override
    protected HTMLFont createParaFont() throws HTDocumentException {
        return new HTMLFont();
    }

    @Override
    protected HTMLFont createLinkFont() throws HTDocumentException {
        return new HTMLFont();
    }

    @Override
    protected HTMLParagraph createHTParagraph(String text, HTMLFont font) throws HTDocumentException {
        return new HTMLParagraph(text, font);
    }

    @Override
    protected HTMLAnchor createHTAnchor(boolean decapitalize, String text, HTMLFont font) throws HTDocumentException {
        return new HTMLAnchor(decapitalize, text, font);
    }

    @Override
    protected String decoratePageTextStart(String labelText, int pageNumber, List<TextChunk> pageTextChunks, Theme theme) {
        StringBuilder result = new StringBuilder();
        result.append(super.decoratePageTextStart(labelText, pageNumber, pageTextChunks, theme));
        result.append(this.getLineSeparator());
        return result.toString();
    }

    @Override
    protected String decoratePageImage(List<ImagePathData> pageImagePathDatas, boolean imageBackground, Theme theme) {
        ImagePathData pageImagePathData = pageImagePathDatas.get(0);
        if (pageImagePathData.getMaxFrameNumber() == 0) {
            String pageImagePath = pageImagePathData.getImagePath();
            if (StringHelper.isEmpty(pageImagePath)) {
                return "";
            }
            return "<img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"" + pageImagePath + "\">" + this.getLineSeparator();
        }
        return "";
    }

    @Override
    protected String decoratePageSound(String pageName, List<SoundPathData> pageSoundPathDatas, boolean soundSFX, Theme theme) {
        return "";
    }
}

