/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export.hypertext.document;

import com.nlbhub.nlb.domain.export.hypertext.document.HTDocument;
import com.nlbhub.nlb.domain.export.hypertext.document.HTMLParagraph;
import com.nlbhub.nlb.exception.HTDocumentException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class HTMLDocument
implements HTDocument<HTMLParagraph> {
    private String m_encoding;
    private StringBuilder m_textBuilder = new StringBuilder();
    private FileOutputStream m_fileOutputStream;
    private String m_lineSeparator;
    private static final String SYSTEM_SEPARATOR = System.getProperty("line.separator");

    public HTMLDocument(String encoding, String lineSeparator) {
        this.m_encoding = encoding;
        this.m_lineSeparator = lineSeparator;
    }

    @Override
    public void initWriter(File targetFile) throws FileNotFoundException, HTDocumentException {
        this.m_fileOutputStream = new FileOutputStream(targetFile);
    }

    @Override
    public void open() {
        this.m_textBuilder.append("<html>").append(SYSTEM_SEPARATOR);
        this.m_textBuilder.append("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head>");
        this.m_textBuilder.append(SYSTEM_SEPARATOR).append("<body>").append(SYSTEM_SEPARATOR);
    }

    @Override
    public void close() throws IOException {
        this.m_textBuilder.append(this.m_lineSeparator).append("</body>").append(SYSTEM_SEPARATOR);
        this.m_textBuilder.append("</html>");
        byte[] bytes = this.m_textBuilder.toString().getBytes(this.m_encoding);
        this.m_fileOutputStream.write(bytes);
    }

    @Override
    public void add(HTMLParagraph paragraph) throws HTDocumentException {
        this.m_textBuilder.append(paragraph.toString()).append(SYSTEM_SEPARATOR);
    }
}

