/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export.hypertext.document;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.BaseFont;
import com.nlbhub.nlb.domain.export.hypertext.document.HTFont;
import com.nlbhub.nlb.domain.export.hypertext.document.RGBColor;
import com.nlbhub.nlb.exception.HTDocumentException;
import java.io.IOException;

public class PDFFont
implements HTFont {
    private Font m_font;

    public PDFFont(float size, HTFont.Style style, RGBColor color) throws HTDocumentException {
        try {
            int iStyle;
            BaseFont baseFont = BaseFont.createFont((String)"fonts/ttf/dejavu/DejaVuSans.ttf", (String)"cp1251", (boolean)true);
            switch (style) {
                case BOLD: {
                    iStyle = 1;
                    break;
                }
                case ITALIC: {
                    iStyle = 2;
                    break;
                }
                case UNDERLINE: {
                    iStyle = 4;
                    break;
                }
                default: {
                    iStyle = 0;
                }
            }
            this.m_font = new Font(baseFont, size, iStyle, new BaseColor(color.getRed(), color.getGreen(), color.getBlue()));
        }
        catch (DocumentException | IOException e) {
            throw new HTDocumentException("Error while creating PDF font", e);
        }
    }

    public Font getFont() {
        return this.m_font;
    }
}

