/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export.hypertext.document;

import com.nlbhub.nlb.domain.export.hypertext.document.HTDocument;
import com.nlbhub.nlb.domain.export.hypertext.document.TXTParagraph;
import com.nlbhub.nlb.exception.HTDocumentException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class TXTDocument
implements HTDocument<TXTParagraph> {
    private String m_encoding;
    private StringBuilder m_textBuilder = new StringBuilder();
    private FileOutputStream m_fileOutputStream;
    private String m_lineSeparator;

    public TXTDocument(String encoding, String lineSeparator) {
        this.m_encoding = encoding;
        this.m_lineSeparator = lineSeparator;
    }

    @Override
    public void initWriter(File targetFile) throws FileNotFoundException, HTDocumentException {
        this.m_fileOutputStream = new FileOutputStream(targetFile);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() throws IOException {
        byte[] bytes = this.m_textBuilder.toString().getBytes(this.m_encoding);
        this.m_fileOutputStream.write(bytes);
    }

    @Override
    public void add(TXTParagraph paragraph) throws HTDocumentException {
        this.m_textBuilder.append(paragraph.toString()).append(this.m_lineSeparator);
    }
}

