/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export.xml;

import com.nlbhub.nlb.api.TextChunk;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.export.ImagePathData;
import com.nlbhub.nlb.domain.export.LinkBuildingBlocks;
import com.nlbhub.nlb.domain.export.NLBBuildingBlocks;
import com.nlbhub.nlb.domain.export.ObjBuildingBlocks;
import com.nlbhub.nlb.domain.export.PageBuildingBlocks;
import com.nlbhub.nlb.domain.export.SoundPathData;
import com.nlbhub.nlb.domain.export.xml.XMLExportManager;
import com.nlbhub.nlb.domain.export.xml.beans.jsiq2.Action;
import com.nlbhub.nlb.domain.export.xml.beans.jsiq2.Article;
import com.nlbhub.nlb.domain.export.xml.beans.jsiq2.Book;
import com.nlbhub.nlb.domain.export.xml.beans.jsiq2.Css;
import com.nlbhub.nlb.domain.export.xml.beans.jsiq2.CssData;
import com.nlbhub.nlb.domain.export.xml.beans.jsiq2.Metadata;
import com.nlbhub.nlb.domain.export.xml.beans.jsiq2.Script;
import com.nlbhub.nlb.domain.export.xml.beans.jsiq2.Style;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.util.JaxbMarshaller;
import com.nlbhub.nlb.util.StringHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class JSIQ2ExportManager
extends XMLExportManager {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public JSIQ2ExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        super(nlb, encoding);
    }

    @Override
    protected String getCDataSectionElements() {
        return "script text action cssdata css style";
    }

    @Override
    protected JaxbMarshaller createMarshaller() {
        return new JaxbMarshaller(Action.class, Article.class, Book.class, Metadata.class, Script.class, Css.class, CssData.class, Style.class);
    }

    @Override
    protected Object createRootObject(NLBBuildingBlocks nlbBlocks) {
        Book book = new Book();
        String lastSaveString = new Date().toString();
        boolean first = true;
        for (PageBuildingBlocks pageBuildingBlocks : nlbBlocks.getPagesBuildingBlocks()) {
            book.addArticle(this.createArticle(pageBuildingBlocks, lastSaveString, nlbBlocks.getObjsBuildingBlocks(), first));
            first = false;
        }
        book.addArticle(this.createCharsheetArticle(lastSaveString));
        CssData cssData = new CssData();
        Css css = new Css();
        css.setName("default");
        css.setValue(".atril-game td{border: 2px solid gray; border-radius: 8px;}");
        Style style = new Style();
        style.setName("default");
        style.setValue("td {border: 2px solid gray; border-radius: 8px;}");
        cssData.setCss(css);
        cssData.setStyle(style);
        book.setCssData(cssData);
        return book;
    }

    private Article createArticle(PageBuildingBlocks pageBlocks, String lastSaveString, List<ObjBuildingBlocks> objsBlocks, boolean first) {
        boolean hasPageVariable;
        boolean hasPageModifications;
        Article article = new Article();
        Metadata metadata = new Metadata();
        metadata.setLastSave(lastSaveString);
        article.setId(pageBlocks.getPageNumber());
        article.setMetadata(metadata);
        article.setText(pageBlocks.getPageTextStart());
        if (first) {
            List<Script> inventoryScripts = this.createInventoryScripts(objsBlocks);
            for (Script script : inventoryScripts) {
                article.addScript(script);
            }
        }
        boolean bl = hasPageModifications = !StringHelper.isEmpty(pageBlocks.getPageModifications());
        if (hasPageModifications) {
            Script pageModificationsScript = new Script();
            pageModificationsScript.setType("pmod");
            pageModificationsScript.setValue(pageBlocks.getPageModifications());
            article.addScript(pageModificationsScript);
        }
        boolean bl2 = hasPageVariable = !StringHelper.isEmpty(pageBlocks.getPageVariable());
        if (hasPageVariable) {
            Script pageVariableScript = new Script();
            pageVariableScript.setType("pvar");
            pageVariableScript.setValue(pageBlocks.getPageVariable());
            article.addScript(pageVariableScript);
        }
        boolean hasAutoLinks = false;
        StringBuilder autosStringBuilder = new StringBuilder();
        List<LinkBuildingBlocks> linksBlocks = pageBlocks.getLinksBuildingBlocks();
        for (int i = 0; i < linksBlocks.size(); ++i) {
            boolean hasLinkVisitStateVariable;
            boolean hasLinkVariable;
            boolean hasLinkModifications;
            boolean hasConstraint;
            LinkBuildingBlocks linkBlocks = linksBlocks.get(i);
            boolean bl3 = hasConstraint = !StringHelper.isEmpty(linkBlocks.getLinkConstraint());
            if (linkBlocks.isAuto()) {
                hasAutoLinks = true;
                if (hasConstraint) {
                    autosStringBuilder.append("if (").append(linkBlocks.getLinkConstraint()).append(") {");
                }
                autosStringBuilder.append("go(").append(linkBlocks.getTargetPageNumber() - 1).append("); ");
                if (!hasConstraint) continue;
                autosStringBuilder.append("}; ");
                continue;
            }
            Action action = new Action();
            if (hasConstraint) {
                Script actionConditionScript = new Script();
                actionConditionScript.setType("condition_" + i);
                actionConditionScript.setValue("return (" + linkBlocks.getLinkConstraint() + ");");
                article.addScript(actionConditionScript);
                action.setIf("condition_" + i);
            }
            action.setGoto(linkBlocks.getLinkGoTo());
            action.setValue(linkBlocks.getLinkStart());
            boolean bl4 = hasLinkModifications = !StringHelper.isEmpty(linkBlocks.getLinkModifications());
            if (hasLinkModifications) {
                Script actionModificationScript = new Script();
                actionModificationScript.setType("mod_" + i);
                actionModificationScript.setValue(linkBlocks.getLinkModifications());
                article.addScript(actionModificationScript);
            }
            boolean bl5 = hasLinkVariable = !StringHelper.isEmpty(linkBlocks.getLinkVariable());
            if (hasLinkVariable) {
                Script actionVariableScript = new Script();
                actionVariableScript.setType("var_" + i);
                actionVariableScript.setValue(linkBlocks.getLinkVariable());
                article.addScript(actionVariableScript);
            }
            boolean bl6 = hasLinkVisitStateVariable = !StringHelper.isEmpty(linkBlocks.getLinkVisitStateVariable());
            if (hasLinkVisitStateVariable) {
                Script actionVisitStateVariableScript = new Script();
                actionVisitStateVariableScript.setType("lvs_var_" + i);
                actionVisitStateVariableScript.setValue(linkBlocks.getLinkVisitStateVariable());
                article.addScript(actionVisitStateVariableScript);
            }
            if (hasLinkVariable || hasLinkModifications || hasLinkVisitStateVariable) {
                Script actionDoScript = new Script();
                actionDoScript.setType("do_" + i);
                actionDoScript.setValue((hasLinkModifications ? "mod_" + i + "(); " : "") + (hasLinkVariable ? "var_" + i + "(); " : "") + (hasLinkVisitStateVariable ? "lvs_var_" + i + "(); " : ""));
                article.addScript(actionDoScript);
                action.setDo("do_" + i);
            }
            article.addAction(action);
        }
        if (hasAutoLinks) {
            Script autoLinkScript = new Script();
            autoLinkScript.setType("autos");
            autoLinkScript.setValue(autosStringBuilder.toString());
            article.addScript(autoLinkScript);
        }
        if (hasPageVariable || hasPageModifications || hasAutoLinks) {
            Script onLoadScript = new Script();
            onLoadScript.setType("onload");
            onLoadScript.setValue((hasPageModifications ? "pmod(); " : "") + (hasPageVariable ? "pvar(); " : "") + (hasAutoLinks ? "autos(); " : ""));
            article.addScript(onLoadScript);
        }
        return article;
    }

    private Article createCharsheetArticle(String lastSaveString) {
        Article article = new Article();
        Metadata metadata = new Metadata();
        metadata.setLastSave(lastSaveString);
        article.setId("charsheet");
        article.setMetadata(metadata);
        article.setText("CHARACTER SHEET<br/> <span class=\"linked\" name=\"inventory\"></span>");
        return article;
    }

    private List<Script> createInventoryScripts(List<ObjBuildingBlocks> objsBlocks) {
        ArrayList<Script> result = new ArrayList<Script>();
        Script preload = new Script();
        preload.setType("preload");
        String preloadValue = "vars.inventory = {}; " + LINE_SEPARATOR + this.createObjsMap(objsBlocks) + "; " + LINE_SEPARATOR + this.createInventoryLinkedVariable();
        preload.setValue(preloadValue);
        result.add(preload);
        Script getItemList = new Script();
        getItemList.setInfo("getting the list of items");
        getItemList.setType("getItemList");
        getItemList.setIsGlobal("true");
        getItemList.setValue("var list = [];" + LINE_SEPARATOR + "for (var name in vars.inventory){" + LINE_SEPARATOR + "    if (!vars.inventory.hasOwnProperty(name)){   continue;   }" + LINE_SEPARATOR + "    " + LINE_SEPARATOR + "    if (vars.inventory[name] > 0){" + LINE_SEPARATOR + "        list.push( vars.itemNames[name] );" + LINE_SEPARATOR + "    }" + LINE_SEPARATOR + "}" + LINE_SEPARATOR + "return list;");
        result.add(getItemList);
        Script checkItem = new Script();
        checkItem.setInfo("checking item existence");
        checkItem.setType("checkItem");
        checkItem.setIsGlobal("true");
        checkItem.setValue("var name = arg.name;" + LINE_SEPARATOR + "if (name === undefined && name === '') {" + LINE_SEPARATOR + "    triggerError('checkItem: \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e',{});" + LINE_SEPARATOR + "    return;" + LINE_SEPARATOR + "}" + LINE_SEPARATOR + "return (vars.inventory[name] == true);");
        result.add(checkItem);
        Script addItem = new Script();
        addItem.setInfo("adding item");
        addItem.setType("addItem");
        addItem.setIsGlobal("true");
        addItem.setValue("var name = arg.name;" + LINE_SEPARATOR + "if (name === undefined && name === '') {" + LINE_SEPARATOR + "    triggerError('checkItem: \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e',{});" + LINE_SEPARATOR + "    return;" + LINE_SEPARATOR + "}" + LINE_SEPARATOR + "vars.inventory[name] = true;");
        result.add(addItem);
        Script removeItem = new Script();
        removeItem.setInfo("removing item");
        removeItem.setType("removeItem");
        removeItem.setIsGlobal("true");
        removeItem.setValue("var name = arg.name;" + LINE_SEPARATOR + "if (name === undefined && name === '') {" + LINE_SEPARATOR + "    triggerError('removeItem: \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e',{});" + LINE_SEPARATOR + "    return;" + LINE_SEPARATOR + "}" + LINE_SEPARATOR + "delete vars.inventory[name];");
        result.add(removeItem);
        return result;
    }

    private String createInventoryLinkedVariable() {
        return "jsIQ.linkValue('inventory', function(){" + LINE_SEPARATOR + "   if (!vars.inventory) return '';" + LINE_SEPARATOR + "   var list = $('<ul></ul>');" + LINE_SEPARATOR + "   for (var name in vars.inventory){" + LINE_SEPARATOR + "       if (!vars.inventory.hasOwnProperty(name)){   continue;   }       " + LINE_SEPARATOR + "       if (vars.inventory[name] > 0){" + LINE_SEPARATOR + "           list.append('<li>' + vars.itemNames[name] + '</li>');" + LINE_SEPARATOR + "       }" + LINE_SEPARATOR + "   }" + LINE_SEPARATOR + "   return list.html();" + LINE_SEPARATOR + "});";
    }

    private String createObjsMap(List<ObjBuildingBlocks> objsBlocks) {
        StringBuilder builder = new StringBuilder();
        builder.append("vars.itemNames = {").append(LINE_SEPARATOR);
        for (ObjBuildingBlocks objBlocks : objsBlocks) {
            builder.append("'").append(objBlocks.getObjLabel()).append("': ");
            builder.append("'").append(objBlocks.getObjDisp()).append("',").append(LINE_SEPARATOR);
        }
        builder.append("'dummy': 'dummy'").append(LINE_SEPARATOR).append("}");
        return builder.toString();
    }

    @Override
    protected String decorateObjDisp(String dispText, boolean imageEnabled, boolean isGraphicalObj) {
        return dispText;
    }

    @Override
    protected String decorateObjLabel(String id) {
        return this.decorateId(id);
    }

    @Override
    protected String decorateObjName(String name, String id) {
        return name;
    }

    @Override
    protected String decorateAssignment(String variableName, String variableValue) {
        return variableName + " = " + variableValue + "; ";
    }

    @Override
    protected String decorateTag(String variable, String objId, String tag) {
        return "";
    }

    @Override
    protected String decorateGetTagOperation(String resultingVariable, String objId, String objVariableName) {
        return "";
    }

    @Override
    protected String decorateWhile(String constraint) {
        return "";
    }

    @Override
    protected String decorateIf(String constraint) {
        return "";
    }

    @Override
    protected String decorateIfHave(String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateElse() {
        return "";
    }

    @Override
    protected String decorateElseIf(String constraint) {
        return "";
    }

    @Override
    protected String decorateEnd() {
        return "";
    }

    @Override
    protected String decorateReturn(String returnValue) {
        return "";
    }

    @Override
    protected String decorateHaveOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateCloneOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateContainerOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateGetIdOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateDelObj(String destinationId, String destinationName, String objectId, String objectVar, String objectName, String objectDisplayName) {
        return "";
    }

    @Override
    protected String decorateDelInvObj(String objectId, String objectVar, String objectName, String objectDisplayName) {
        String id = this.decorateId(objectId);
        return "if (checkItem({'name': '" + id + "'})) { removeItem({'name': '" + id + "'}); }; ";
    }

    @Override
    protected String decorateAddObj(String destinationId, String objectId, String objectVar, String objectName, String objectDisplayName, boolean unique) {
        return "";
    }

    @Override
    protected String decorateAddInvObj(String objectId, String objectVar, String objectName, String objectDisplayName) {
        String id = this.decorateId(objectId);
        return "if (!checkItem({'name': '" + id + "'})) { addItem({'name': '" + id + "'}); }; ";
    }

    @Override
    protected String decorateAddAllOperation(String destinationId, String destinationListVariableName, String sourceListVariableName, boolean unique) {
        return "";
    }

    @Override
    protected String decorateObjsOperation(String listVariableName, String srcObjId, String objectVar) {
        return "";
    }

    @Override
    protected String decorateSSndOperation() {
        return "";
    }

    @Override
    protected String decorateWSndOperation() {
        return "";
    }

    @Override
    protected String decorateSndOperation(String objectId, String objectVar) {
        return "";
    }

    @Override
    protected String decorateSPushOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decorateWPushOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decoratePushOperation(String listVariableName, String objectId, String objectVar) {
        return "";
    }

    @Override
    protected String decoratePopOperation(String variableName, String listVariableName) {
        return "";
    }

    @Override
    protected String decorateSInjectOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decorateInjectOperation(String listVariableName, String objectId, String objectVar) {
        return "";
    }

    @Override
    protected String decorateEjectOperation(String variableName, String listVariableName) {
        return "";
    }

    @Override
    protected String decorateClearOperation(String destinationId, String destinationVar) {
        return "";
    }

    @Override
    protected String decorateClearInvOperation() {
        return "";
    }

    @Override
    protected String decorateSizeOperation(String variableName, String listVariableName) {
        return "";
    }

    @Override
    protected String decorateRndOperation(String variableName, String maxValue) {
        return "";
    }

    @Override
    protected String decorateAchMaxOperation(String achievementName, int max) {
        return "";
    }

    @Override
    protected String decorateAchieveOperation(String achievementName, String modificationId) {
        return "";
    }

    @Override
    protected String decorateAchievedOperation(String variableName, String achievementName) {
        return "";
    }

    @Override
    protected String decorateGoToOperation(String locationId) {
        return "";
    }

    @Override
    protected String decorateSnapshotOperation(String snapshotId) {
        return "";
    }

    @Override
    protected String decorateOpenURLOperation(String url) {
        return "";
    }

    @Override
    protected String decorateWinGeomOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateInvGeomOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateWinColorOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateInvColorOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateShuffleOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decoratePRNOperation(String variableName) {
        return "";
    }

    @Override
    protected String decorateDSCOperation(String resultVariableName, String dscObjVariable, String dscObjId) {
        return "";
    }

    @Override
    protected String decoratePDscOperation(String objVariableName) {
        return "";
    }

    @Override
    protected String decoratePDscsOperation(String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateActOperation(String actingObjVariable, String actingObjId) {
        return "";
    }

    @Override
    protected String decorateActtOperation(String resultVariableName, String actObjVariable, String actObjId) {
        return "";
    }

    @Override
    protected String decorateActfOperation(String actingObjVariable, String actingObjId) {
        return "";
    }

    @Override
    protected String decorateUseOperation(String sourceVariable, String sourceId, String targetVariable, String targetId) {
        return "";
    }

    @Override
    protected String decorateTrue() {
        return "true";
    }

    @Override
    protected String decorateFalse() {
        return "false";
    }

    @Override
    protected String decorateEq() {
        return "==";
    }

    @Override
    protected String decorateNEq() {
        return "!=";
    }

    @Override
    protected String decorateGt() {
        return ">";
    }

    @Override
    protected String decorateGte() {
        return ">=";
    }

    @Override
    protected String decorateLt() {
        return "<";
    }

    @Override
    protected String decorateLte() {
        return "<=";
    }

    @Override
    protected String decorateNot() {
        return "!";
    }

    @Override
    protected String decorateOr() {
        return "||";
    }

    @Override
    protected String decorateAnd() {
        return "&&";
    }

    @Override
    protected String decorateExistence(String decoratedVariable) {
        return "";
    }

    @Override
    protected String decorateBooleanVar(String constraintVar) {
        return "vars." + constraintVar;
    }

    @Override
    protected String decorateStringVar(String constraintVar) {
        return "vars." + constraintVar;
    }

    @Override
    protected String decorateNumberVar(String constraintVar) {
        return "vars." + constraintVar;
    }

    @Override
    protected String decorateLinkLabel(String linkId, String linkText, Theme theme) {
        return "";
    }

    @Override
    protected String decorateLinkComment(String comment) {
        return "";
    }

    @Override
    protected String decorateLinkStart(String linkId, String linkText, boolean isAuto, boolean isTrivial, int pageNumber, Theme theme) {
        return linkText;
    }

    @Override
    protected String decorateLinkGoTo(String linkId, String linkText, String linkSource, int sourcePageNumber, String linkTarget, int targetPageNumber, Theme theme) {
        return Integer.toString(targetPageNumber - 1);
    }

    @Override
    protected String decoratePageEnd(boolean isFinish) {
        return "";
    }

    @Override
    protected String decorateLinkVariable(String variableName) {
        return "vars." + variableName + " = true; ";
    }

    @Override
    protected String decorateLinkVisitStateVariable(String linkVisitStateVariable) {
        return "vars." + linkVisitStateVariable + " = true; ";
    }

    @Override
    protected String decoratePageVariable(String variableName) {
        return "vars." + variableName + " = true; ";
    }

    @Override
    protected String decoratePageTimerVariableInit(String variableName) {
        return "";
    }

    @Override
    protected String decoratePageTimerVariable(String variableName) {
        return "";
    }

    @Override
    protected String decoratePageModifications(String modificationsText) {
        return modificationsText;
    }

    @Override
    protected String decoratePageThemeModifications(String modificationsText) {
        return "";
    }

    @Override
    protected String decorateLinkModifications(String modificationsText) {
        return modificationsText;
    }

    @Override
    protected String decoratePageCaption(String caption, boolean useCaption, String moduleTitle, boolean noSave) {
        if (StringHelper.notEmpty(caption) && useCaption) {
            return caption;
        }
        return "";
    }

    @Override
    protected String decoratePageNotes(String notes) {
        return "";
    }

    @Override
    protected String decoratePageImage(List<ImagePathData> pageImagePathDatas, boolean imageBackground, Theme theme) {
        return "";
    }

    @Override
    protected String decoratePageSound(String pageName, List<SoundPathData> pageSoundPathDatas, boolean soundSFX, Theme theme) {
        return "";
    }

    @Override
    protected String expandVariables(List<TextChunk> textChunks, Theme theme) {
        StringBuilder result = new StringBuilder();
        for (TextChunk textChunk : textChunks) {
            switch (textChunk.getType()) {
                case TEXT: {
                    result.append(textChunk.getText());
                    break;
                }
                case ACTION_TEXT: 
                case VARIABLE: {
                    result.append("$").append(textChunk.getText()).append("$");
                    break;
                }
                case NEWLINE: {
                    result.append(" <br/>").append(this.getLineSeparator());
                }
            }
        }
        return result.toString();
    }

    @Override
    protected String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageTextEnd(String labelText, int pageNumber, Theme theme, boolean hasChoicesOrLeaf) {
        return "";
    }

    @Override
    protected String decoratePageLabel(String labelText, int pageNumber, Theme theme) {
        return "";
    }

    @Override
    protected String decoratePageNumber(int pageNumber) {
        return Integer.toString(pageNumber - 1);
    }

    @Override
    protected String decoratePageComment(String comment) {
        return "";
    }
}

