/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.util;

import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.MultiLangString;
import com.nlbhub.nlb.util.StringHelper;
import com.nlbhub.nlb.vcs.VCSAdapter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileManipulator {
    private static final int BLOCK_SIZE = 1024;
    private VCSAdapter m_vcsAdapter;
    private File m_mainRoot;

    public FileManipulator(VCSAdapter vcsAdapter, File mainRoot) {
        this.m_vcsAdapter = vcsAdapter;
        this.m_mainRoot = mainRoot;
    }

    public boolean deleteFileOrDir(File file) throws NLBFileManipulationException, NLBIOException {
        try {
            boolean ret = true;
            if (file.isDirectory()) {
                String[] children = file.list();
                for (int i = 0; i < children.length; ++i) {
                    if (this.deleteFileOrDir(new File(file, children[i]))) continue;
                    ret = false;
                }
            }
            String path = this.getPathRelativeToMainRoot(file);
            VCSAdapter.Status status = this.m_vcsAdapter.getStatus(path);
            boolean removed = false;
            switch (status) {
                case Modified: 
                case Clean: {
                    removed = this.m_vcsAdapter.remove(path);
                    break;
                }
                case Added: {
                    this.m_vcsAdapter.reset(path);
                    break;
                }
                case Removed: 
                case Unknown: 
                case VCS_Undefined: {
                    break;
                }
                case Missing: 
                case Ignored: {
                    throw new NLBFileManipulationException("Incorrect file status while deleting file with path = " + path + " from VCS: " + (Object)((Object)status));
                }
            }
            if (!removed) {
                removed = file.delete();
            }
            return removed && ret;
        }
        catch (NLBVCSException e) {
            throw new NLBFileManipulationException("Error while deleting directory", e);
        }
        catch (IOException e) {
            throw new NLBIOException("Error while deleting directory", e);
        }
    }

    private static String getFileAsString(String fName) {
        InputStream strm = FileManipulator.class.getClassLoader().getResourceAsStream(fName);
        return FileManipulator.getFileAsString(strm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRequiredFileAsString(File rootDir, String fileName, String errorMessage) throws NLBIOException {
        String string;
        block7: {
            InputStream fis = null;
            try {
                File file = new File(rootDir, fileName);
                if (!file.exists()) {
                    throw new NLBIOException(errorMessage);
                }
                fis = new FileInputStream(file);
                string = FileManipulator.getFileAsString(fis);
                if (fis == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NLBIOException("IOException occured", e);
                }
            }
            fis.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOptionalFileAsString(File rootDir, String fileName, String defaultValue) throws NLBIOException {
        try (InputStream fis = null;){
            File file = new File(rootDir, fileName);
            if (!file.exists()) {
                String string2 = defaultValue;
                return string2;
            }
            fis = new FileInputStream(file);
            String string = FileManipulator.getFileAsString(fis);
            return string;
        }
        catch (IOException e) {
            throw new NLBIOException("IOException occured", e);
        }
    }

    private static String getFileAsString(InputStream strm) {
        if (strm != null) {
            StringBuilder sb = new StringBuilder();
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(strm, "UTF-8"));
                String str = in.readLine();
                if (str != null) {
                    sb.append(str);
                }
                while ((str = in.readLine()) != null) {
                    sb.append("\n").append(str);
                }
            }
            catch (IOException e) {
                return null;
            }
            return sb.toString();
        }
        return null;
    }

    public static void transfer(File source, File target) throws IOException {
        try (FileInputStream sourceStream = new FileInputStream(source);){
            FileManipulator.writeFile(target, sourceStream);
        }
    }

    private static void transfer(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }

    public static void writeFile(File file, InputStream input) throws IOException {
        try (FileOutputStream output = new FileOutputStream(file);){
            FileManipulator.transfer(input, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequiredString(File rootDir, String fileName, String content) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        ByteArrayInputStream inputStream = null;
        try {
            try {
                boolean newFile;
                File file = new File(rootDir, fileName);
                boolean bl = newFile = !file.exists();
                if (content != null) {
                    inputStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
                    FileManipulator.writeFile(file, inputStream);
                    this.addToVCS(file, newFile);
                } else {
                    this.createFile(file, "Cannot create file with name " + fileName);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new NLBIOException("IOException occured", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOptionalString(File rootDir, String fileName, String content, String defaultContent) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        ByteArrayInputStream inputStream = null;
        try {
            try {
                boolean newFile;
                File file = new File(rootDir, fileName);
                boolean bl = newFile = !file.exists();
                if (content != null) {
                    if (content.equals(defaultContent)) {
                        if (!newFile) {
                            this.deleteFileOrDir(file);
                        }
                    } else {
                        inputStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
                        FileManipulator.writeFile(file, inputStream);
                        this.addToVCS(file, newFile);
                    }
                } else if (!StringHelper.isEmpty(defaultContent)) {
                    this.createFile(file, "Cannot create file with name " + fileName);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new NLBIOException("IOException occured", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOptionalMultiLangString(File mlsRootDir, MultiLangString content, MultiLangString defaultContent) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        block11: {
            ByteArrayInputStream inputStream = null;
            try {
                boolean isSubsetOfDefault;
                boolean rootDirExists = mlsRootDir.exists();
                if (rootDirExists && !mlsRootDir.isDirectory()) {
                    this.deleteFileOrDir(mlsRootDir);
                    rootDirExists = false;
                }
                if (isSubsetOfDefault = content.isSubsetOf(defaultContent)) {
                    if (rootDirExists) {
                        this.deleteFileOrDir(mlsRootDir);
                    }
                    break block11;
                }
                if (!rootDirExists) {
                    this.createDir(mlsRootDir, "Cannot create MultiLangString root: " + mlsRootDir.getCanonicalPath());
                }
                for (String key : content.keySet()) {
                    try {
                        boolean newFile;
                        File file = new File(mlsRootDir, key);
                        boolean bl = newFile = !file.exists();
                        if (content.equalsAs(key, defaultContent)) {
                            if (newFile) continue;
                            this.deleteFileOrDir(file);
                            continue;
                        }
                        inputStream = new ByteArrayInputStream(content.get(key).getBytes("UTF-8"));
                        FileManipulator.writeFile(file, inputStream);
                        this.addToVCS(file, newFile);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new NLBIOException("IOException occured", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiLangString readOptionalMultiLangString(File mlsRootDir, MultiLangString defaultValue) throws NLBIOException {
        MultiLangString result;
        block14: {
            if (!mlsRootDir.exists()) {
                return MultiLangString.createCopy(defaultValue);
            }
            result = MultiLangString.createCopy(defaultValue);
            try {
                if (mlsRootDir.isDirectory()) {
                    String[] langKeys = mlsRootDir.list();
                    if (langKeys != null) {
                        for (String langKey : langKeys) {
                            try (InputStream fis = null;){
                                File file = new File(mlsRootDir, langKey);
                                fis = new FileInputStream(file);
                                result.put(langKey, FileManipulator.getFileAsString(fis));
                            }
                        }
                        break block14;
                    }
                    throw new NLBIOException("Error while listing directory");
                }
                try (FileInputStream fis = null;){
                    fis = new FileInputStream(mlsRootDir);
                    result.put("ru", FileManipulator.getFileAsString(fis));
                }
            }
            catch (IOException e) {
                throw new NLBIOException("IOException occured", e);
            }
        }
        return result;
    }

    public void createDir(File dir, String errorMessage) throws NLBIOException, NLBFileManipulationException {
        try {
            if (!dir.exists()) {
                if (!dir.mkdir()) {
                    throw new NLBIOException(errorMessage);
                }
                this.addToVCS(dir, true);
            }
        }
        catch (NLBVCSException e) {
            throw new NLBFileManipulationException("Error while creating directory", e);
        }
        catch (IOException e) {
            throw new NLBIOException("Error while creating directory", e);
        }
    }

    public void copyFile(File target, File source, String errorMessage) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        try {
            boolean exists = target.exists();
            if (!exists) {
                target.createNewFile();
            }
            FileManipulator.writeFile(target, new FileInputStream(source));
            this.addToVCS(target, exists);
        }
        catch (IOException e) {
            throw new NLBIOException(errorMessage, e);
        }
    }

    private void createFile(File file, String errorMessage) throws NLBIOException, NLBFileManipulationException {
        try {
            if (!file.exists()) {
                file.createNewFile();
                this.addToVCS(file, true);
            }
        }
        catch (IOException e) {
            throw new NLBIOException(errorMessage, e);
        }
        catch (NLBVCSException e) {
            throw new NLBFileManipulationException("Error while creating file", e);
        }
    }

    private void addToVCS(File file, boolean isNewFile) throws IOException, NLBVCSException, NLBFileManipulationException {
        if (file.isDirectory() && !this.m_vcsAdapter.getDirAddFlag()) {
            return;
        }
        String path = this.getPathRelativeToMainRoot(file);
        if (isNewFile) {
            VCSAdapter.Status status = this.m_vcsAdapter.getStatus(path);
            switch (status) {
                case Unknown: 
                case VCS_Undefined: {
                    this.m_vcsAdapter.add(path);
                    break;
                }
                case Added: {
                    break;
                }
                case Modified: 
                case Clean: 
                case Removed: 
                case Missing: 
                case Ignored: {
                    throw new NLBFileManipulationException("Incorrect file status while adding file with path = " + path + " to VCS: " + (Object)((Object)status));
                }
            }
        } else if (this.m_vcsAdapter.getAddModifiedFilesFlag()) {
            this.m_vcsAdapter.add(path);
        }
    }

    private String getPathRelativeToMainRoot(File file) throws IOException {
        Path pathAbsolute = Paths.get(file.getCanonicalPath(), new String[0]);
        Path pathBase = Paths.get(this.m_mainRoot.getCanonicalPath(), new String[0]);
        Path pathRelative = pathBase.relativize(pathAbsolute);
        return pathRelative.toString();
    }
}

