/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.util;

import com.nlbhub.nlb.exception.NLBJAXBException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JaxbMarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaxbMarshaller.class);
    private Marshaller m_jaxbMarshaller;
    private Unmarshaller m_jaxbUnmarshaller;

    public JaxbMarshaller(Class ... classes) {
        if (classes == null) {
            LOGGER.error("An attempt were made to create JaxbMarshaller with classes = null");
            throw new IllegalArgumentException("Parameter 'classes' cannot be null");
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])classes);
            this.m_jaxbMarshaller = jaxbContext.createMarshaller();
            this.m_jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            this.m_jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        catch (JAXBException e) {
            StringBuilder sb = new StringBuilder();
            for (Class c : classes) {
                sb.append(c.getName()).append("; ");
            }
            LOGGER.error("Error creating javax.xml.bind.Marshaller instance for the following list of classes: " + sb.toString(), (Throwable)e);
        }
    }

    public void marshal(Object objectToMarshal, OutputStream outputStream, boolean isFragment) throws NLBJAXBException {
        try {
            this.m_jaxbMarshaller.setProperty("jaxb.fragment", (Object)isFragment);
            this.m_jaxbMarshaller.marshal(objectToMarshal, outputStream);
        }
        catch (JAXBException e) {
            throw new NLBJAXBException("Exception when marshalling", e);
        }
    }

    public Object unmarshal(InputStream inputStream) throws NLBJAXBException {
        try {
            return this.m_jaxbUnmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            throw new NLBJAXBException("Exception when unmarshalling", e);
        }
    }

    public Document getAsDocument(Object object, boolean isFragment) throws NLBJAXBException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            this.m_jaxbMarshaller.setProperty("jaxb.fragment", (Object)isFragment);
            this.m_jaxbMarshaller.marshal(object, (Node)document);
            return document;
        }
        catch (JAXBException | ParserConfigurationException e) {
            throw new NLBJAXBException("Exception when marshalling", e);
        }
    }
}

