/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.util;

import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.util.FileManipulator;
import com.nlbhub.nlb.util.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceManager {
    private static final String VNSTEAD = "vnstead";

    public static void exportBundledFiles(File targetDir) throws NLBIOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Map<String, List<File>> resourceFolderFiles = ResourceManager.getResourceFolderFiles(loader);
        for (Map.Entry<String, List<File>> resourceFileEntry : resourceFolderFiles.entrySet()) {
            ResourceManager.exportBundledFiles(resourceFileEntry, targetDir);
        }
    }

    private static Map<String, List<File>> getResourceFolderFiles(ClassLoader loader) throws NLBIOException {
        File resDir = new File("res");
        if (!resDir.exists()) {
            throw new NLBIOException("Resources dir 'res' does not exist!");
        }
        return ResourceManager.getAllChildren(new File(resDir, VNSTEAD), "");
    }

    private static Map<String, List<File>> getAllChildren(File parent, String parentPath) {
        File[] files;
        HashMap<String, List<File>> result = new HashMap<String, List<File>>();
        for (File file : files = parent.listFiles()) {
            if (file.isDirectory()) {
                String key = StringHelper.notEmpty(parentPath) ? parentPath + "/" + file.getName() : file.getName();
                result.putAll(ResourceManager.getAllChildren(file, key));
                continue;
            }
            ArrayList<File> filesList = (ArrayList<File>)result.get(parentPath);
            if (filesList == null) {
                filesList = new ArrayList<File>();
                result.put(parentPath, filesList);
            }
            filesList.add(file);
        }
        return result;
    }

    private static void exportBundledFiles(Map.Entry<String, List<File>> resourceFileEntry, File targetDir) throws NLBIOException {
        File resourceFileParent;
        String key = resourceFileEntry.getKey();
        boolean hasParentFolder = StringHelper.notEmpty(key);
        File file = resourceFileParent = hasParentFolder ? new File(targetDir, key) : targetDir;
        if (hasParentFolder) {
            resourceFileParent.mkdirs();
        }
        for (File resourceFile : resourceFileEntry.getValue()) {
            ResourceManager.exportBundledFile(resourceFileParent, resourceFile);
        }
    }

    private static void exportBundledFile(File resourceFileParent, File resourceFile) throws NLBIOException {
        File file = new File(resourceFileParent, resourceFile.getName());
        try (FileInputStream is = new FileInputStream(resourceFile);){
            FileManipulator.writeFile(file, is);
        }
        catch (IOException e) {
            throw new NLBIOException("Error exporting bundled file", e);
        }
    }
}

