/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.util;

import com.nlbhub.nlb.api.TextChunk;
import com.nlbhub.nlb.util.MultiLangString;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringHelper {
    private static final Pattern LINE_PATTERN = Pattern.compile("(?m)^.*$");
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$([^\\s\\$]*)\\$");
    private static final String DELIMITER = ";";

    public static String replaceVariables(String pageText, Map<String, Object> visitedVars) {
        StringBuilder result = new StringBuilder();
        List<TextChunk> textChunks = StringHelper.getTextChunks(pageText);
        for (TextChunk textChunk : textChunks) {
            switch (textChunk.getType()) {
                case TEXT: {
                    result.append(textChunk.getText());
                    break;
                }
                case ACTION_TEXT: {
                    break;
                }
                case VARIABLE: {
                    Object mappedItem = visitedVars.get(textChunk.getText());
                    if (mappedItem != null) {
                        if (mappedItem instanceof Number) {
                            result.append(new DecimalFormat("#.###").format(mappedItem));
                            break;
                        }
                        result.append(String.valueOf(mappedItem));
                        break;
                    }
                    result.append("UNDEFINED");
                    break;
                }
                case NEWLINE: {
                    result.append("\n");
                }
            }
        }
        return result.toString();
    }

    public static List<TextChunk> getTextChunks(String text) {
        ArrayList<TextChunk> result = new ArrayList<TextChunk>();
        Matcher matcher = LINE_PATTERN.matcher(text);
        boolean notFirst = false;
        while (matcher.find()) {
            if (notFirst) {
                TextChunk newlineChunk = new TextChunk();
                newlineChunk.setText("");
                newlineChunk.setType(TextChunk.ChunkType.NEWLINE);
                result.add(newlineChunk);
            } else {
                notFirst = true;
            }
            String line = matcher.group().trim();
            int start = 0;
            Matcher variableMatcher = VAR_PATTERN.matcher(line);
            while (variableMatcher.find()) {
                TextChunk textChunk = new TextChunk();
                String variable = variableMatcher.group(1);
                textChunk.setText(line.substring(start, variableMatcher.start()));
                textChunk.setType(TextChunk.ChunkType.TEXT);
                result.add(textChunk);
                TextChunk variableChunk = new TextChunk();
                variableChunk.setText(variable);
                variableChunk.setType("^".equals(variable) ? TextChunk.ChunkType.ACTION_TEXT : TextChunk.ChunkType.VARIABLE);
                result.add(variableChunk);
                start = variableMatcher.end();
            }
            int length = line.length();
            if (start >= length) continue;
            TextChunk textChunk = new TextChunk();
            textChunk.setText(line.substring(start, length));
            textChunk.setType(TextChunk.ChunkType.TEXT);
            result.add(textChunk);
        }
        return result;
    }

    public static boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    public static boolean notEmpty(String string) {
        return !StringHelper.isEmpty(string);
    }

    public static boolean isEmpty(MultiLangString multiLangString) {
        for (String text : multiLangString.values()) {
            if (StringHelper.isEmpty(text)) continue;
            return false;
        }
        return true;
    }

    public static String formatSequence(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        int lastElemIndex = strings.size() - 1;
        if (lastElemIndex >= 0) {
            for (int i = 0; i < lastElemIndex; ++i) {
                sb.append(strings.get(i)).append(DELIMITER);
            }
            sb.append(strings.get(lastElemIndex));
        }
        return sb.toString();
    }

    public static String[] getItems(String sequenceString) {
        if (sequenceString == null) {
            return new String[0];
        }
        return sequenceString.split(DELIMITER);
    }

    public static String createRepeatedString(int length, String fill) {
        return new String(new char[length]).replace("\u0000", fill);
    }
}

