/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.vcs;

import com.nlbhub.nlb.api.ProgressData;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.vcs.Author;
import com.nlbhub.nlb.vcs.GitAdapter;
import com.nlbhub.nlb.vcs.VCSAdapter;

public class GitAdapterWithPathDecoration
implements VCSAdapter {
    GitAdapter m_gitAdapter;

    public GitAdapterWithPathDecoration(Author author) {
        this.m_gitAdapter = new GitAdapter(author);
    }

    @Override
    public void initRepo(String path) throws NLBVCSException {
        this.m_gitAdapter.initRepo(this.decoratePath(path));
    }

    @Override
    public void openRepo(String path) throws NLBVCSException {
        this.m_gitAdapter.openRepo(this.decoratePath(path));
    }

    @Override
    public void closeAdapter() throws NLBVCSException {
        this.m_gitAdapter.closeAdapter();
    }

    @Override
    public boolean getDirAddFlag() {
        return this.m_gitAdapter.getDirAddFlag();
    }

    @Override
    public boolean getAddModifiedFilesFlag() {
        return this.m_gitAdapter.getAddModifiedFilesFlag();
    }

    @Override
    public VCSAdapter.Status getStatus(String path) throws NLBVCSException {
        return this.m_gitAdapter.getStatus(this.decoratePath(path));
    }

    @Override
    public void add(String path) throws NLBVCSException {
        this.m_gitAdapter.add(this.decoratePath(path));
    }

    @Override
    public boolean remove(String path) throws NLBVCSException {
        return this.m_gitAdapter.remove(this.decoratePath(path));
    }

    @Override
    public void reset(String path) throws NLBVCSException {
        this.m_gitAdapter.reset(this.decoratePath(path));
    }

    @Override
    public void commit(String message) throws NLBVCSException {
        this.m_gitAdapter.commit(message);
    }

    @Override
    public void pull(String userName, String password, ProgressData progressData) throws NLBVCSException {
        this.m_gitAdapter.pull(userName, password, progressData);
    }

    @Override
    public void push(String userName, String password, ProgressData progressData) throws NLBVCSException {
        this.m_gitAdapter.push(userName, password, progressData);
    }

    private String decoratePath(String path) {
        return path.replaceAll("\\\\", "/");
    }
}

