/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.user.domain;

import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.exception.DecisionException;
import com.nlbhub.user.domain.DecisionPoint;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="history")
public class History {
    public static final int DO_NOT_USE_VISIT_COUNT = -1;
    private List<DecisionPoint> m_decisionPoints = new LinkedList<DecisionPoint>();
    private DecisionPoint m_decisionPointToBeMade = null;
    private String m_decisionPointToBeMadeText;

    public void clear() {
        this.m_decisionPoints.clear();
        this.m_decisionPointToBeMade = null;
    }

    @XmlElement(name="decision-point")
    public List<DecisionPoint> getDecisionPoints() {
        return this.m_decisionPoints;
    }

    public void setDecisionPoints(List<DecisionPoint> decisionPoints) {
        this.m_decisionPoints = decisionPoints;
    }

    public void setDecisionPointToBeMadeText(String decisionPointToBeMadeText) {
        this.m_decisionPointToBeMadeText = decisionPointToBeMadeText;
    }

    public void makeDecision() {
        if (this.m_decisionPointToBeMade != null) {
            this.m_decisionPointToBeMade.setText(this.m_decisionPointToBeMadeText);
            for (DecisionPoint decisionPoint : this.m_decisionPoints) {
                if (!decisionPoint.equals(this.m_decisionPointToBeMade)) continue;
                this.m_decisionPointToBeMade.incVisitCount();
            }
            this.m_decisionPoints.add(this.m_decisionPointToBeMade);
            this.m_decisionPointToBeMade = null;
        }
    }

    public int predictDecisionCount(DecisionPoint decisionPoint) {
        int count = 1;
        for (DecisionPoint currentDecisionPoint : this.m_decisionPoints) {
            if (!currentDecisionPoint.equals(decisionPoint)) continue;
            ++count;
        }
        return count;
    }

    public DecisionPoint getDecisionPointToBeMade() {
        return this.m_decisionPointToBeMade;
    }

    public void suggestDecisionPointToBeMade(DecisionPoint decisionPointToBeMade, boolean rollback, int visitCount) throws DecisionException {
        if (decisionPointToBeMade != null && !this.m_decisionPoints.isEmpty()) {
            boolean suggestedOK = false;
            if (!rollback) {
                DecisionPoint tailDecisionPoint = this.m_decisionPoints.get(this.m_decisionPoints.size() - 1);
                for (DecisionPoint decisionPoint : tailDecisionPoint.getPossibleNextDecisionPoints()) {
                    if (!decisionPoint.equals(decisionPointToBeMade)) continue;
                    suggestedOK = true;
                }
            }
            if (!suggestedOK || rollback) {
                for (int i = this.m_decisionPoints.size() - 1; i >= 0; --i) {
                    DecisionPoint curDecisionPoint = this.m_decisionPoints.get(i);
                    if (!curDecisionPoint.equals(decisionPointToBeMade) || visitCount != -1 && visitCount != curDecisionPoint.getVisitCount()) continue;
                    this.m_decisionPointToBeMade = curDecisionPoint;
                    this.m_decisionPointToBeMade.clearPossibleNextDecisionPoints();
                    this.m_decisionPointToBeMade.setVisitCount(1);
                    this.m_decisionPoints = this.m_decisionPoints.subList(0, i);
                    return;
                }
                throw new DecisionException("Suggested decision cannot be found, please specify correct decision or restart");
            }
        }
        this.m_decisionPointToBeMade = decisionPointToBeMade;
    }

    public boolean containsLink(Link link) {
        for (DecisionPoint decisionPoint : this.m_decisionPoints) {
            if (!link.getId().equals(decisionPoint.getLinkId())) continue;
            return true;
        }
        return false;
    }
}

