/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.api;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.CoordsLw;
import com.nlbhub.nlb.api.IdentifiableItem;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.Modification;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.domain.ModificationImpl;
import com.nlbhub.nlb.domain.SearchResult;
import com.nlbhub.nlb.util.MultiLangString;
import com.nlbhub.nlb.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="link")
public class LinkLw
implements Link {
    private Type m_type;
    private String m_target;
    private String m_mplLinkId;
    private IdentifiableItem m_parent;
    private MultiLangString m_text;
    private MultiLangString m_altText;
    private String m_constrId;
    private String m_varId;
    private boolean m_auto;
    private boolean m_once;
    private boolean m_positiveConstraint;
    private boolean m_shouldObeyToModuleConstraint;
    private List<Modification> m_modifications = new ArrayList<Modification>();

    public LinkLw(Type type, String target, Page parent, MultiLangString text, MultiLangString altText, String constrId, String varId, boolean auto, boolean once, boolean positiveConstraint, boolean shouldObeyToModuleConstraint, String mplLinkId, List<Modification> modifications) {
        this.m_type = type;
        this.m_target = target;
        this.m_parent = parent;
        this.m_text = text;
        this.m_altText = altText;
        this.m_constrId = constrId;
        this.m_varId = varId;
        this.m_auto = auto;
        this.m_once = once;
        this.m_positiveConstraint = positiveConstraint;
        this.m_shouldObeyToModuleConstraint = shouldObeyToModuleConstraint;
        boolean mplLink = StringHelper.notEmpty(mplLinkId);
        if (mplLink) {
            this.m_mplLinkId = mplLinkId;
            if (modifications != null) {
                for (Modification modification : modifications) {
                    this.m_modifications.add(modification);
                }
            }
        } else {
            this.m_mplLinkId = "";
            if (this.m_type == Type.AutowiredOut || this.m_type == Type.AutowiredIn && !parent.isAutowire()) {
                ModificationImpl modification = new ModificationImpl();
                modification.setType(Modification.Type.ASSIGN.name());
                modification.setParent(this);
                modification.setVarId(this.m_type == Type.AutowiredIn ? target + "_" + parent.getId() : parent.getId() + "_" + target);
                modification.setExprId(this.m_type == Type.AutowiredIn ? "TRUE" : "FALSE");
                this.m_modifications.add(modification);
            }
        }
    }

    @Override
    @XmlElement(name="varid")
    public String getVarId() {
        return this.m_varId;
    }

    @Override
    @XmlElement(name="target")
    public String getTarget() {
        return this.m_target;
    }

    @Override
    @XmlElement(name="text")
    public String getText() {
        return this.m_text.get(this.m_parent.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getTexts() {
        return MultiLangString.createCopy(this.m_text);
    }

    @Override
    public String getAltText() {
        return this.m_altText.get(this.m_parent.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getAltTexts() {
        return MultiLangString.createCopy(this.m_altText);
    }

    @Override
    @XmlElement(name="constrid")
    public String getConstrId() {
        return this.m_constrId;
    }

    @Override
    @XmlElement(name="is-positive")
    public boolean isPositiveConstraint() {
        return this.m_positiveConstraint;
    }

    @Override
    @XmlElement(name="is-obey-to-module-constraint")
    public boolean isObeyToModuleConstraint() {
        return this.m_shouldObeyToModuleConstraint;
    }

    @Override
    @XmlElement(name="is-traversal")
    public boolean isTraversalLink() {
        return this.m_type == Type.Traverse;
    }

    @Override
    @XmlElement(name="is-return")
    public boolean isReturnLink() {
        return this.m_type == Type.Return;
    }

    @Override
    @XmlElement(name="stroke")
    public String getStroke() {
        return "";
    }

    @Override
    public Coords getCoords() {
        return new CoordsLw();
    }

    @Override
    @XmlElement(name="is-auto")
    public boolean isAuto() {
        return this.m_auto;
    }

    @Override
    @XmlElement(name="is-once")
    public boolean isOnce() {
        return this.m_once;
    }

    @Override
    public List<Modification> getModifications() {
        return this.m_modifications;
    }

    @Override
    public boolean hasNoModifications() {
        if (this.m_modifications.size() > 0) {
            for (Modification modification : this.m_modifications) {
                if (modification.isDeleted()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Modification getModificationById(@NotNull String modId) {
        for (Modification modification : this.m_modifications) {
            if (!modification.getId().equals(modId)) continue;
            return modification;
        }
        return null;
    }

    @Override
    public String getId() {
        return this.m_parent.getId() + "_" + this.m_target + "_" + this.m_mplLinkId + "_" + this.m_type.name();
    }

    @Override
    public String getFullId() {
        String[] temp = new String[]{this.m_parent.getId(), this.getId()};
        return StringHelper.formatSequence(Arrays.asList(temp));
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public IdentifiableItem getParent() {
        return this.m_parent;
    }

    @Override
    public boolean hasDeletedParent() {
        IdentifiableItem item = this;
        while ((item = item.getParent()) != null) {
            if (!item.isDeleted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NonLinearBook getCurrentNLB() {
        return this.m_parent.getCurrentNLB();
    }

    @Override
    public SearchResult searchText(SearchContract contract) {
        return null;
    }

    @Override
    public String addObserver(NLBObserver observer) {
        return "";
    }

    @Override
    public void removeObserver(String observerId) {
    }

    @Override
    public void notifyObservers() {
    }

    public static enum Type {
        Traverse,
        Return,
        AutowiredIn,
        AutowiredOut;

    }
}

