/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.api;

import com.nlbhub.nlb.api.Link;
import java.util.LinkedList;
import java.util.List;

public class LinksTableModel {
    private List<Link> m_links = new LinkedList<Link>();

    public LinksTableModel(List<Link> links) {
        for (Link link : links) {
            if (link.isDeleted()) continue;
            this.m_links.add(link);
        }
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Link Id";
            }
            case 1: {
                return "Link text";
            }
        }
        return "N/A";
    }

    public int getRowCount() {
        return this.m_links.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Link link = this.getLinkAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return link.getId();
            }
            case 1: {
                return link.getText();
            }
        }
        return "N/A";
    }

    public Link getLinkAt(int rowIndex) {
        return this.m_links.get(rowIndex);
    }

    public void deleteLinkAt(int rowIndex) {
        this.m_links.remove(rowIndex);
    }

    public List<Link> getLinks() {
        return this.m_links;
    }

    public void moveUp(int rowIndex) {
        if (rowIndex > 0) {
            Link item = this.m_links.remove(rowIndex - 1);
            this.m_links.add(rowIndex, item);
        }
    }

    public void moveDown(int rowIndex) {
        if (rowIndex < this.m_links.size() - 1) {
            Link item = this.m_links.remove(rowIndex + 1);
            this.m_links.add(rowIndex, item);
        }
    }
}

