/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.api;

import com.nlbhub.nlb.domain.SearchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchResultTableModel {
    private static String NA = "N/A";
    private Map<String, List<SearchResult>> m_searchResultMap = new HashMap<String, List<SearchResult>>();
    private List<String> m_columnNames = new ArrayList<String>();
    private int m_columnCount;

    public SearchResultTableModel() {
        this.m_columnNames.add("Information");
        this.m_columnCount = 3;
    }

    public SearchResultTableModel(List<String> columnNames) {
        this.m_columnNames.addAll(columnNames);
        this.m_columnCount = columnNames.size() + 2;
    }

    public SearchResultTableModel(String ... columnNames) {
        this(Arrays.asList(columnNames));
    }

    public void addSearchResult(SearchResult searchResult) {
        if (searchResult != null) {
            List<SearchResult> searchResults = this.m_searchResultMap.get(searchResult.getId());
            if (searchResults == null) {
                searchResults = new ArrayList<SearchResult>();
                this.m_searchResultMap.put(searchResult.getId(), searchResults);
            }
            searchResults.add(searchResult);
        }
    }

    public void addSearchResults(List<SearchResult> searchResults) {
        for (SearchResult searchResult : searchResults) {
            this.addSearchResult(searchResult);
        }
    }

    public void addSearchResultTableModel(SearchResultTableModel searchResultTableModel) {
        if (searchResultTableModel != null && searchResultTableModel.m_columnCount == this.m_columnCount) {
            this.m_searchResultMap.putAll(searchResultTableModel.m_searchResultMap);
        }
    }

    public int getRowCount() {
        int result = 0;
        for (Map.Entry<String, List<SearchResult>> entry : this.m_searchResultMap.entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        int i = 0;
        for (Map.Entry<String, List<SearchResult>> entry : this.m_searchResultMap.entrySet()) {
            for (SearchResult searchResult : entry.getValue()) {
                if (i == rowIndex) {
                    if (columnIndex == 0) {
                        return entry.getKey();
                    }
                    if (columnIndex == 1) {
                        return searchResult.getModulePageId();
                    }
                    if (columnIndex >= this.m_columnCount) {
                        return NA;
                    }
                    return searchResult.getInformationByPosition(columnIndex - 2);
                }
                ++i;
            }
        }
        return NA;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Id";
        }
        if (column == 1) {
            return "Module Page Id";
        }
        if (column >= this.m_columnCount) {
            return NA;
        }
        return this.m_columnNames.get(column - 2);
    }
}

