/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.DummyNLB;
import com.nlbhub.nlb.api.IdentifiableItem;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.domain.SearchResult;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.util.MultiLangString;
import com.nlbhub.nlb.util.QuotationHelper;
import com.nlbhub.nlb.util.StringHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class AbstractIdentifiableItem
implements IdentifiableItem {
    private String m_id = UUID.randomUUID().toString();
    private boolean m_isDeleted = false;
    private NonLinearBook m_currentNLB = DummyNLB.singleton();
    private IdentifiableItem m_parent = null;

    public AbstractIdentifiableItem() {
    }

    public AbstractIdentifiableItem(NonLinearBook currentNLB) {
        this();
        this.m_currentNLB = currentNLB;
    }

    public AbstractIdentifiableItem(IdentifiableItem identifiableItem, NonLinearBook currentNLB) {
        this(currentNLB);
        this.m_id = identifiableItem.getId();
        this.m_isDeleted = identifiableItem.isDeleted();
        this.m_parent = identifiableItem.getParent();
    }

    public AbstractIdentifiableItem(IdentifiableItem identifiableItem, ModifyingItem parent, NonLinearBook currentNLB) {
        this(currentNLB);
        this.m_id = identifiableItem.getId();
        this.m_isDeleted = identifiableItem.isDeleted();
        this.m_parent = parent;
    }

    public void copy(IdentifiableItem identifiableItem) {
        this.m_id = identifiableItem.getId();
        this.m_isDeleted = identifiableItem.isDeleted();
        this.m_parent = identifiableItem.getParent();
        this.m_currentNLB = identifiableItem.getCurrentNLB();
    }

    public void setId(String id) {
        this.m_id = id;
    }

    @Override
    @XmlElement(name="id")
    public String getId() {
        return this.m_id;
    }

    @Override
    public IdentifiableItem getParent() {
        return this.m_parent;
    }

    public void setParent(IdentifiableItem parent) {
        this.m_parent = parent;
    }

    @Override
    public boolean hasDeletedParent() {
        IdentifiableItem item = this;
        while ((item = item.getParent()) != null) {
            if (!item.isDeleted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFullId() {
        LinkedList<String> ids = new LinkedList<String>();
        for (IdentifiableItem item = this; item != null; item = item.getParent()) {
            ids.add(0, item.getId());
        }
        return StringHelper.formatSequence(ids);
    }

    public void setDeleted(boolean deleted) {
        this.m_isDeleted = deleted;
    }

    @Override
    public boolean isDeleted() {
        return this.m_isDeleted;
    }

    @Override
    public NonLinearBook getCurrentNLB() {
        return this.m_currentNLB;
    }

    @Override
    public SearchResult searchText(SearchContract contract) {
        if (contract.isSearchInIds() && this.textMatches(this.m_id, contract)) {
            SearchResult result = new SearchResult();
            result.setId(this.m_id);
            result.setInformation(this.m_id);
            return result;
        }
        return null;
    }

    protected boolean textMatches(MultiLangString mlsToTest, SearchContract contract) {
        for (String text : mlsToTest.values()) {
            if (!this.textMatches(text, contract)) continue;
            return true;
        }
        return false;
    }

    protected boolean textMatches(String stringToTest, SearchContract contract) {
        StringBuilder patternText = new StringBuilder();
        if (contract.isWholeWords()) {
            patternText.append("\\b");
        }
        patternText.append(contract.getSearchText());
        if (contract.isWholeWords()) {
            patternText.append("\\b");
        }
        Pattern pattern = contract.isIgnoreCase() ? Pattern.compile(patternText.toString(), 66) : Pattern.compile(patternText.toString());
        Matcher matcher = pattern.matcher(stringToTest);
        boolean result = matcher.find();
        if (contract.isFindUnusualQuotes()) {
            return result || QuotationHelper.find(stringToTest);
        }
        return result;
    }

    protected List<File> createSortedDirList(File[] dirs, List<String> orderList) throws NLBConsistencyException {
        LinkedList<File> dirsList = new LinkedList<File>();
        for (File file : dirs) {
            dirsList.add(file);
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String dirName : orderList) {
            ListIterator iterator = dirsList.listIterator();
            boolean found = false;
            while (iterator.hasNext()) {
                File dir = (File)iterator.next();
                if (!dir.getName().equals(dirName)) continue;
                found = true;
                result.add(dir);
                iterator.remove();
                break;
            }
            if (found) continue;
            throw new NLBConsistencyException("Inconsistent NLB structure: cannot locate directory with name = " + dirName + " for item with id = " + this.m_id);
        }
        if (!dirsList.isEmpty()) {
            throw new NLBConsistencyException("Inconsistent NLB structure: directories with names = " + orderList.toString() + " for item with id = " + this.m_id + " cannot be located in the order file");
        }
        return result;
    }
}

