/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.NLBCommand;
import com.nlbhub.nlb.domain.AbstractNodeItem;
import com.nlbhub.nlb.domain.ObjImpl;

public class ChangeContainerCommand
implements NLBCommand {
    private AbstractNodeItem m_prevContainer;
    private AbstractNodeItem m_newContainer;
    private ObjImpl m_obj;

    public ChangeContainerCommand(AbstractNodeItem prevContainer, AbstractNodeItem newContainer, ObjImpl obj) {
        this.m_prevContainer = prevContainer;
        this.m_newContainer = newContainer;
        this.m_obj = obj;
    }

    @Override
    public void execute() {
        if (this.m_prevContainer != null) {
            this.m_prevContainer.removeContainedObjId(this.m_obj.getId());
        }
        if (this.m_newContainer != null) {
            this.m_newContainer.addContainedObjId(this.m_obj.getId());
            this.m_obj.setContainerId(this.m_newContainer.getId());
        } else {
            this.m_obj.setContainerId("");
        }
        this.m_obj.notifyObservers();
    }

    @Override
    public void revert() {
        if (this.m_newContainer != null) {
            this.m_newContainer.removeContainedObjId(this.m_obj.getId());
        }
        if (this.m_prevContainer != null) {
            this.m_prevContainer.addContainedObjId(this.m_obj.getId());
            this.m_obj.setContainerId(this.m_prevContainer.getId());
        } else {
            this.m_obj.setContainerId("");
        }
        this.m_obj.notifyObservers();
    }
}

