/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.IdentifiableItem;
import com.nlbhub.nlb.api.Modification;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.domain.AbstractIdentifiableItem;
import com.nlbhub.nlb.domain.SearchResult;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.FileManipulator;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ModificationImpl
extends AbstractIdentifiableItem
implements Modification {
    private static final String EXTERNAL_FILE_NAME = "external";
    private static final String VARID_FILE_NAME = "varid";
    private static final String TYPE_FILE_NAME = "type";
    private static final String EXPRID_FILE_NAME = "exprid";
    private static final Set<Modification.Type> UNPARAMETRIZED_TYPES = new HashSet<Modification.Type>(){
        {
            this.add(Modification.Type.CNTNR);
            this.add(Modification.Type.CLONE);
            this.add(Modification.Type.PDSCS);
            this.add(Modification.Type.SSND);
            this.add(Modification.Type.WSND);
            this.add(Modification.Type.GETTAG);
            this.add(Modification.Type.CLEAR);
            this.add(Modification.Type.CLRINV);
            this.add(Modification.Type.ELSE);
            this.add(Modification.Type.END);
            this.add(Modification.Type.RETURN);
            this.add(Modification.Type.SNAPSHOT);
        }
    };
    private boolean m_external;
    private Modification.Type m_type = Modification.Type.ASSIGN;
    private String m_varId;
    private String m_exprId;

    public ModificationImpl(Modification modification, NonLinearBook currentNLB) {
        super(modification, currentNLB);
        this.m_external = modification.isExternal();
        this.m_type = modification.getType();
        this.m_varId = modification.getVarId();
        this.m_exprId = modification.getExprId();
    }

    public ModificationImpl(Modification modification, ModifyingItem parent, NonLinearBook currentNLB) {
        super(modification, parent, currentNLB);
        this.m_external = modification.isExternal();
        this.m_type = modification.getType();
        this.m_varId = modification.getVarId();
        this.m_exprId = modification.getExprId();
    }

    public ModificationImpl() {
    }

    public ModificationImpl(ModifyingItem parent) {
        super(parent.getCurrentNLB());
        this.setParent(parent);
    }

    public void copy(Modification modification) {
        super.copy(modification);
        this.m_external = modification.isExternal();
        this.m_type = modification.getType();
        this.m_varId = modification.getVarId();
        this.m_exprId = modification.getExprId();
    }

    @Override
    public String getVarId() {
        return this.m_varId;
    }

    public void setVarId(String varId) {
        this.m_varId = varId;
    }

    @Override
    public String getExprId() {
        return this.m_exprId;
    }

    public void setExprId(String exprId) {
        this.m_exprId = exprId;
    }

    @Override
    public Modification.Type getType() {
        return this.m_type;
    }

    @Override
    public boolean isExternal() {
        return this.m_external;
    }

    public void setExternal(boolean external) {
        this.m_external = external;
    }

    @Override
    public boolean returnsValue() {
        switch (this.m_type) {
            case CNTNR: 
            case CLONE: 
            case GETTAG: 
            case ID: 
            case ASSIGN: 
            case HAVE: 
            case POP: 
            case EJECT: 
            case SIZE: 
            case RND: 
            case DSC: 
            case ACTT: 
            case OBJS: 
            case ACHIEVED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isParametrized() {
        return !UNPARAMETRIZED_TYPES.contains((Object)this.m_type);
    }

    @Override
    public SearchResult searchText(SearchContract contract) {
        SearchResult result = super.searchText(contract);
        if (result != null) {
            return result;
        }
        if (!this.isDeleted()) {
            SearchResult resultE;
            SearchResult resultV;
            IdentifiableItem parent = this.getParent();
            Variable variable = this.getCurrentNLB().getVariableById(this.m_varId);
            SearchResult searchResult = resultV = variable != null ? variable.searchText(contract) : null;
            if (resultV != null) {
                if (parent != null) {
                    resultV.setId(parent.getId());
                    resultV.setModulePageId(parent.getCurrentNLB().getParentPage().getId());
                }
                return resultV;
            }
            Variable expression = this.getCurrentNLB().getVariableById(this.m_exprId);
            SearchResult searchResult2 = resultE = expression != null ? expression.searchText(contract) : null;
            if (resultE != null) {
                if (parent != null) {
                    resultE.setId(parent.getId());
                    resultE.setModulePageId(parent.getCurrentNLB().getParentPage().getId());
                }
                return resultE;
            }
        }
        return null;
    }

    public void setType(String type) {
        this.m_type = type.equals(Modification.Type.WHILE.name()) ? Modification.Type.WHILE : (type.equals(Modification.Type.TAG.name()) ? Modification.Type.TAG : (type.equals(Modification.Type.GETTAG.name()) ? Modification.Type.GETTAG : (type.equals(Modification.Type.IF.name()) ? Modification.Type.IF : (type.equals(Modification.Type.IFHAVE.name()) ? Modification.Type.IFHAVE : (type.equals(Modification.Type.ELSE.name()) ? Modification.Type.ELSE : (type.equals(Modification.Type.ELSEIF.name()) ? Modification.Type.ELSEIF : (type.equals(Modification.Type.END.name()) ? Modification.Type.END : (type.equals(Modification.Type.RETURN.name()) ? Modification.Type.RETURN : (type.equals(Modification.Type.HAVE.name()) ? Modification.Type.HAVE : (type.equals(Modification.Type.CLONE.name()) ? Modification.Type.CLONE : (type.equals(Modification.Type.CNTNR.name()) ? Modification.Type.CNTNR : (type.equals(Modification.Type.ID.name()) ? Modification.Type.ID : (type.equals(Modification.Type.ADD.name()) ? Modification.Type.ADD : (type.equals(Modification.Type.ADDU.name()) ? Modification.Type.ADDU : (type.equals(Modification.Type.ADDINV.name()) ? Modification.Type.ADDINV : (type.equals(Modification.Type.ADDALL.name()) ? Modification.Type.ADDALL : (type.equals(Modification.Type.ADDALLU.name()) ? Modification.Type.ADDALLU : (type.equals(Modification.Type.REMOVE.name()) ? Modification.Type.REMOVE : (type.equals(Modification.Type.RMINV.name()) ? Modification.Type.RMINV : (type.equals(Modification.Type.CLEAR.name()) ? Modification.Type.CLEAR : (type.equals(Modification.Type.CLRINV.name()) ? Modification.Type.CLRINV : (type.equals(Modification.Type.OBJS.name()) ? Modification.Type.OBJS : (type.equals(Modification.Type.SSND.name()) ? Modification.Type.SSND : (type.equals(Modification.Type.WSND.name()) ? Modification.Type.WSND : (type.equals(Modification.Type.SND.name()) ? Modification.Type.SND : (type.equals(Modification.Type.SPUSH.name()) ? Modification.Type.SPUSH : (type.equals(Modification.Type.WPUSH.name()) ? Modification.Type.WPUSH : (type.equals(Modification.Type.PUSH.name()) ? Modification.Type.PUSH : (type.equals(Modification.Type.POP.name()) ? Modification.Type.POP : (type.equals(Modification.Type.SINJECT.name()) ? Modification.Type.SINJECT : (type.equals(Modification.Type.INJECT.name()) ? Modification.Type.INJECT : (type.equals(Modification.Type.EJECT.name()) ? Modification.Type.EJECT : (type.equals(Modification.Type.SHUFFLE.name()) ? Modification.Type.SHUFFLE : (type.equals(Modification.Type.PRN.name()) ? Modification.Type.PRN : (type.equals(Modification.Type.DSC.name()) ? Modification.Type.DSC : (type.equals(Modification.Type.PDSC.name()) ? Modification.Type.PDSC : (type.equals(Modification.Type.PDSCS.name()) ? Modification.Type.PDSCS : (type.equals(Modification.Type.ACT.name()) ? Modification.Type.ACT : (type.equals(Modification.Type.ACTT.name()) ? Modification.Type.ACTT : (type.equals(Modification.Type.ACTF.name()) ? Modification.Type.ACTF : (type.equals(Modification.Type.USE.name()) ? Modification.Type.USE : (type.equals(Modification.Type.SIZE.name()) ? Modification.Type.SIZE : (type.equals(Modification.Type.RND.name()) ? Modification.Type.RND : (type.equals(Modification.Type.ACHMAX.name()) ? Modification.Type.ACHMAX : (type.equals(Modification.Type.ACHIEVE.name()) ? Modification.Type.ACHIEVE : (type.equals(Modification.Type.ACHIEVED.name()) ? Modification.Type.ACHIEVED : (type.equals(Modification.Type.GOTO.name()) ? Modification.Type.GOTO : (type.equals(Modification.Type.SNAPSHOT.name()) ? Modification.Type.SNAPSHOT : (type.equals(Modification.Type.OPENURL.name()) ? Modification.Type.OPENURL : (type.equals(Modification.Type.WINGEOM.name()) ? Modification.Type.WINGEOM : (type.equals(Modification.Type.INVGEOM.name()) ? Modification.Type.INVGEOM : (type.equals(Modification.Type.WINCOLOR.name()) ? Modification.Type.WINCOLOR : (type.equals(Modification.Type.INVCOLOR.name()) ? Modification.Type.INVCOLOR : Modification.Type.ASSIGN)))))))))))))))))))))))))))))))))))))))))))))))))))));
    }

    public void writeModification(FileManipulator fileManipulator, File modificationsDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        File modificationDir = new File(modificationsDir, this.getId());
        if (this.isDeleted()) {
            fileManipulator.deleteFileOrDir(modificationDir);
        } else {
            fileManipulator.createDir(modificationDir, "Cannot create NLB modification directory for modification with Id = " + this.getId());
            fileManipulator.writeOptionalString(modificationDir, EXTERNAL_FILE_NAME, String.valueOf(this.m_external), String.valueOf(false));
            fileManipulator.writeRequiredString(modificationDir, VARID_FILE_NAME, this.m_varId);
            fileManipulator.writeRequiredString(modificationDir, TYPE_FILE_NAME, this.m_type.name());
            fileManipulator.writeRequiredString(modificationDir, EXPRID_FILE_NAME, this.m_exprId);
        }
    }

    public void readModification(File modificationDir) throws NLBIOException, NLBConsistencyException {
        String type;
        this.setId(modificationDir.getName());
        this.m_external = "true".equals(FileManipulator.getOptionalFileAsString(modificationDir, EXTERNAL_FILE_NAME, String.valueOf(false)));
        this.m_varId = FileManipulator.getRequiredFileAsString(modificationDir, VARID_FILE_NAME, "Error while reading modification variable Id for modification with Id = " + this.getId());
        switch (type = FileManipulator.getRequiredFileAsString(modificationDir, TYPE_FILE_NAME, "Error while reading modification type for modification with Id = " + this.getId())) {
            case "ASSIGN": {
                this.m_type = Modification.Type.ASSIGN;
                break;
            }
            case "TAG": {
                this.m_type = Modification.Type.TAG;
                break;
            }
            case "GETTAG": {
                this.m_type = Modification.Type.GETTAG;
                break;
            }
            case "WHILE": {
                this.m_type = Modification.Type.WHILE;
                break;
            }
            case "IF": {
                this.m_type = Modification.Type.IF;
                break;
            }
            case "IFHAVE": {
                this.m_type = Modification.Type.IFHAVE;
                break;
            }
            case "ELSE": {
                this.m_type = Modification.Type.ELSE;
                break;
            }
            case "ELSEIF": {
                this.m_type = Modification.Type.ELSEIF;
                break;
            }
            case "END": {
                this.m_type = Modification.Type.END;
                break;
            }
            case "RETURN": {
                this.m_type = Modification.Type.RETURN;
                break;
            }
            case "HAVE": {
                this.m_type = Modification.Type.HAVE;
                break;
            }
            case "CLONE": {
                this.m_type = Modification.Type.CLONE;
                break;
            }
            case "CNTNR": {
                this.m_type = Modification.Type.CNTNR;
                break;
            }
            case "ID": {
                this.m_type = Modification.Type.ID;
                break;
            }
            case "ADD": {
                this.m_type = Modification.Type.ADD;
                break;
            }
            case "ADDU": {
                this.m_type = Modification.Type.ADDU;
                break;
            }
            case "ADDINV": {
                this.m_type = Modification.Type.ADDINV;
                break;
            }
            case "ADDALL": {
                this.m_type = Modification.Type.ADDALL;
                break;
            }
            case "ADDALLU": {
                this.m_type = Modification.Type.ADDALLU;
                break;
            }
            case "REMOVE": {
                this.m_type = Modification.Type.REMOVE;
                break;
            }
            case "RMINV": {
                this.m_type = Modification.Type.RMINV;
                break;
            }
            case "CLEAR": {
                this.m_type = Modification.Type.CLEAR;
                break;
            }
            case "CLRINV": {
                this.m_type = Modification.Type.CLRINV;
                break;
            }
            case "OBJS": {
                this.m_type = Modification.Type.OBJS;
                break;
            }
            case "SSND": {
                this.m_type = Modification.Type.SSND;
                break;
            }
            case "WSND": {
                this.m_type = Modification.Type.WSND;
                break;
            }
            case "SND": {
                this.m_type = Modification.Type.SND;
                break;
            }
            case "SPUSH": {
                this.m_type = Modification.Type.SPUSH;
                break;
            }
            case "WPUSH": {
                this.m_type = Modification.Type.WPUSH;
                break;
            }
            case "PUSH": {
                this.m_type = Modification.Type.PUSH;
                break;
            }
            case "POP": {
                this.m_type = Modification.Type.POP;
                break;
            }
            case "SINJECT": {
                this.m_type = Modification.Type.SINJECT;
                break;
            }
            case "INJECT": {
                this.m_type = Modification.Type.INJECT;
                break;
            }
            case "EJECT": {
                this.m_type = Modification.Type.EJECT;
                break;
            }
            case "SHUFFLE": {
                this.m_type = Modification.Type.SHUFFLE;
                break;
            }
            case "PRN": {
                this.m_type = Modification.Type.PRN;
                break;
            }
            case "DSC": {
                this.m_type = Modification.Type.DSC;
                break;
            }
            case "PDSC": {
                this.m_type = Modification.Type.PDSC;
                break;
            }
            case "PDSCS": {
                this.m_type = Modification.Type.PDSCS;
                break;
            }
            case "ACT": {
                this.m_type = Modification.Type.ACT;
                break;
            }
            case "ACTT": {
                this.m_type = Modification.Type.ACTT;
                break;
            }
            case "ACTF": {
                this.m_type = Modification.Type.ACTF;
                break;
            }
            case "USE": {
                this.m_type = Modification.Type.USE;
                break;
            }
            case "SIZE": {
                this.m_type = Modification.Type.SIZE;
                break;
            }
            case "RND": {
                this.m_type = Modification.Type.RND;
                break;
            }
            case "ACHMAX": {
                this.m_type = Modification.Type.ACHMAX;
                break;
            }
            case "ACHIEVE": {
                this.m_type = Modification.Type.ACHIEVE;
                break;
            }
            case "ACHIEVED": {
                this.m_type = Modification.Type.ACHIEVED;
                break;
            }
            case "GOTO": {
                this.m_type = Modification.Type.GOTO;
                break;
            }
            case "SNAPSHOT": {
                this.m_type = Modification.Type.SNAPSHOT;
                break;
            }
            case "OPENURL": {
                this.m_type = Modification.Type.OPENURL;
                break;
            }
            case "WINGEOM": {
                this.m_type = Modification.Type.WINGEOM;
                break;
            }
            case "INVGEOM": {
                this.m_type = Modification.Type.INVGEOM;
                break;
            }
            case "WINCOLOR": {
                this.m_type = Modification.Type.WINCOLOR;
                break;
            }
            case "INVCOLOR": {
                this.m_type = Modification.Type.INVCOLOR;
                break;
            }
            default: {
                throw new NLBConsistencyException("Modification type '" + type + "' cannot be determined for modification with Id = " + this.getId());
            }
        }
        this.m_exprId = FileManipulator.getRequiredFileAsString(modificationDir, EXPRID_FILE_NAME, "Error while reading modification expression Id for modification with Id = " + this.getId());
    }
}

