/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.DummyNLB;
import com.nlbhub.nlb.api.IdentifiableItem;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.LinksTableModel;
import com.nlbhub.nlb.api.MediaFile;
import com.nlbhub.nlb.api.ModificationsTableModel;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NLBObservable;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.PartialProgressData;
import com.nlbhub.nlb.api.ProgressData;
import com.nlbhub.nlb.api.RootModulePage;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.AbstractNodeItem;
import com.nlbhub.nlb.domain.ChangeContainerCommand;
import com.nlbhub.nlb.domain.Clipboard;
import com.nlbhub.nlb.domain.CommandChainCommand;
import com.nlbhub.nlb.domain.LinkImpl;
import com.nlbhub.nlb.domain.MediaExportParameters;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.ObjImpl;
import com.nlbhub.nlb.domain.ObserverHandler;
import com.nlbhub.nlb.domain.PageImpl;
import com.nlbhub.nlb.domain.UndoManager;
import com.nlbhub.nlb.domain.UpdateLinkCoordsCommand;
import com.nlbhub.nlb.domain.UpdateNodeCoordsCommand;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.FileManipulator;
import com.nlbhub.nlb.util.MultiLangString;
import com.nlbhub.nlb.util.ResourceManager;
import com.nlbhub.nlb.util.StringHelper;
import com.nlbhub.nlb.vcs.Author;
import com.nlbhub.nlb.vcs.VCSAdapter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonLinearBookFacade
implements NLBObservable {
    private NonLinearBookImpl m_nlb;
    private Map<String, PageImpl> m_newPagesPool = new HashMap<String, PageImpl>();
    private Map<String, ObjImpl> m_newObjsPool = new HashMap<String, ObjImpl>();
    private Map<String, LinkImpl> m_newLinksPool = new HashMap<String, LinkImpl>();
    private UndoManager m_undoManager = new UndoManager();
    private Map<String, UndoManager> m_undoManagersMap = new HashMap<String, UndoManager>();
    private ObserverHandler m_observerHandler = new ObserverHandler();
    private VCSAdapter m_vcsAdapter;
    private Author m_author;
    private boolean m_rootFacade;
    private NonLinearBookFacade m_parentFacade;
    private List<NonLinearBookFacade> m_moduleFacades = new ArrayList<NonLinearBookFacade>();

    public NonLinearBookFacade(Author author, VCSAdapter vcsAdapter) {
        this.m_rootFacade = true;
        this.m_parentFacade = null;
        this.m_author = author;
        this.m_vcsAdapter = vcsAdapter;
    }

    private NonLinearBookFacade(NonLinearBookFacade parentFacade, Author author, VCSAdapter vcsAdapter, NonLinearBookImpl nlb) {
        this.m_rootFacade = false;
        this.m_parentFacade = parentFacade;
        this.m_author = author;
        this.m_vcsAdapter = vcsAdapter;
        this.m_nlb = nlb;
    }

    public void createNewBook() {
        DummyNLB parentNLB = DummyNLB.singleton();
        this.m_nlb = new NonLinearBookImpl(parentNLB, new RootModulePage(parentNLB, "MAIN"));
        this.notifyObservers();
    }

    public NonLinearBookFacade createModuleFacade(String modulePageId) {
        PageImpl page = this.m_nlb.getPageImplById(modulePageId);
        NonLinearBookFacade facade = new NonLinearBookFacade(this, this.m_author, this.m_vcsAdapter, page.getModuleImpl());
        this.m_moduleFacades.add(facade);
        this.notifyObservers();
        return facade;
    }

    public NonLinearBookFacade getMainFacade() {
        NonLinearBookFacade result = this;
        while (result.getParentFacade() != null) {
            result = result.getParentFacade();
        }
        return result;
    }

    public NonLinearBookFacade getParentFacade() {
        return this.m_parentFacade;
    }

    public NonLinearBook getNlb() {
        return this.m_nlb;
    }

    public void clear() throws NLBVCSException {
        this.m_nlb.clear();
        if (this.m_rootFacade) {
            this.m_vcsAdapter.closeAdapter();
        }
        this.clearUndosAndPools();
    }

    public void clearUndosAndPools() throws NLBVCSException {
        this.clearUndos();
        this.clearPools();
        for (NonLinearBookFacade facade : this.m_moduleFacades) {
            facade.clearUndosAndPools();
        }
        this.notifyObservers();
    }

    private void clearUndos() {
        this.m_undoManager.clear();
        for (Map.Entry<String, UndoManager> entry : this.m_undoManagersMap.entrySet()) {
            entry.getValue().clear();
        }
    }

    public void commit(String commitMessageText) throws NLBVCSException {
        this.m_vcsAdapter.commit(commitMessageText);
        this.notifyObservers();
    }

    public void pull(String userName, String password, ProgressData progressData) throws NLBVCSException {
        this.m_vcsAdapter.pull(userName, password, progressData);
        this.notifyObservers();
    }

    public void push(String userName, String password, ProgressData progressData) throws NLBVCSException {
        this.m_vcsAdapter.push(userName, password, progressData);
        this.notifyObservers();
    }

    public void exportToChoiceScript(File exportDir) throws NLBExportException {
        this.m_nlb.exportToChoiceScript(new File(exportDir, "startup.txt"));
        File imagesExportDir = new File(exportDir, "images");
        this.m_nlb.exportImages(true, imagesExportDir);
    }

    public void exportToQSPTextFile(File exportDir) throws NLBExportException {
        this.m_nlb.exportToQSPTextFile(new File(exportDir, "book.txt"));
        File imagesExportDir = new File(exportDir, "images");
        this.m_nlb.exportImages(true, imagesExportDir);
    }

    public void exportToURQTextFile(File exportDir) throws NLBExportException {
        this.m_nlb.exportToURQTextFile(new File(exportDir, "book.qst"));
    }

    public void exportToPDFFile(File exportFile) throws NLBExportException {
        this.m_nlb.exportToPDFFile(exportFile);
    }

    public void exportToTXTFile(File exportDir) throws NLBExportException {
        this.m_nlb.exportToTXTFile(new File(exportDir, "book.txt"));
    }

    public void exportToHTMLFile(File exportDir) throws NLBExportException {
        this.m_nlb.exportToHTMLFile(new File(exportDir, "index.html"));
        File imagesExportDir = new File(exportDir, "images");
        this.m_nlb.exportImages(true, imagesExportDir);
    }

    public void exportToJSIQFile(File exportDir) throws NLBExportException {
        this.m_nlb.exportToJSIQFile(new File(exportDir, "example.xml"));
    }

    public void exportToSTEADFile(File exportDir) throws NLBExportException, NLBIOException {
        this.m_nlb.exportToSTEADFile(new File(exportDir, "main.lua"));
        this.exportMedia(exportDir);
        this.exportAdditionalMedia(exportDir);
    }

    public void exportToVNSTEADFile(File exportDir) throws NLBExportException, NLBIOException {
        this.m_nlb.exportToVNSTEADFile(new File(exportDir, "main.lua"));
        this.exportMedia(exportDir);
        this.exportAdditionalMedia(exportDir);
    }

    private void exportAdditionalMedia(File exportDir) throws NLBIOException {
        ResourceManager.exportBundledFiles(exportDir);
    }

    private void exportMedia(File exportDir) throws NLBExportException {
        File imagesExportDir = new File(exportDir, "images");
        this.m_nlb.exportImages(true, imagesExportDir);
        File soundExportDir = new File(exportDir, "sound");
        this.m_nlb.exportSound(true, soundExportDir);
    }

    public void exportToASMFile(File exportDir) throws NLBExportException {
        this.m_nlb.exportToASMFile(new File(exportDir, "book.sm"));
    }

    public void updateModifications(ModifyingItem modifyingItem, ModificationsTableModel modificationsTableModel) {
        NonLinearBookImpl.UpdateModificationsCommand command = this.m_nlb.createUpdateModificationsCommand(modifyingItem, modificationsTableModel);
        this.getUndoManagerByItemId(modifyingItem.getId() + "_m").executeAndStore(command);
        this.notifyObservers();
    }

    public void setMediaFileConstrId(MediaFile.Type mediaType, String fileName, String constrId) {
        this.m_nlb.setMediaFileConstrId(mediaType, fileName, constrId);
    }

    public void setMediaFileRedirect(MediaFile.Type mediaType, String fileName, String redirect) {
        this.m_nlb.setMediaFileRedirect(mediaType, fileName, redirect);
    }

    public void setMediaFileFlag(MediaFile.Type mediaType, String fileName, boolean flag) {
        this.m_nlb.setMediaFileFlag(mediaType, fileName, flag);
    }

    public void setMediaFileExportParametersPreset(MediaFile.Type mediaType, String fileName, MediaExportParameters.Preset preset) {
        this.m_nlb.setMediaFileExportParametersPreset(mediaType, fileName, preset);
    }

    public void updateBookProperties(String license, Theme theme, String language, String title, String author, String version, String perfectGameAchievementName, boolean fullAutowire, boolean suppressMedia, boolean suppressSound, boolean propagateToSubmodules) {
        NonLinearBookImpl.UpdateBookPropertiesCommand command = this.m_nlb.createUpdateBookPropertiesCommand(license, theme, language, title, author, version, perfectGameAchievementName, fullAutowire, suppressMedia, suppressSound, propagateToSubmodules);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public void updatePage(Page page, String imageFileName, boolean imageBackground, boolean imageAnimated, String soundFileName, boolean soundSFX, String pageVariableName, String pageTimerVariableName, String pageDefTagVariableValue, MultiLangString pageText, MultiLangString pageCaptionText, Theme theme, boolean useCaption, boolean useMPL, String moduleName, boolean moduleExternal, MultiLangString traverseText, boolean autoTraverse, boolean autoReturn, MultiLangString returnText, String returnPageId, String moduleConsraintVariableName, boolean autowire, MultiLangString autowireInText, MultiLangString autowireOutText, boolean autoIn, boolean autoOut, String autowireInConstraint, String autowireOutConstraint, boolean globalAutowire, boolean noSave, boolean autosFirst, LinksTableModel linksTableModel) {
        NonLinearBookImpl.UpdatePageCommand command = this.m_nlb.createUpdatePageCommand(page, imageFileName, imageBackground, imageAnimated, soundFileName, soundSFX, pageVariableName, pageTimerVariableName, pageDefTagVariableValue, pageText, pageCaptionText, theme, useCaption, useMPL, moduleName, moduleExternal, traverseText, autoTraverse, autoReturn, returnText, returnPageId, moduleConsraintVariableName, autowire, autowireInText, autowireOutText, autoIn, autoOut, autowireInConstraint, autowireOutConstraint, globalAutowire, noSave, autosFirst, linksTableModel);
        this.getUndoManagerByItemId(page.getId()).executeAndStore(command);
        this.notifyObservers();
    }

    public void updateLink(Link link, String linkVariableName, String linkConstraintValue, MultiLangString linkText, MultiLangString linkAltText, boolean auto, boolean once) {
        NonLinearBookImpl.UpdateLinkCommand command = this.m_nlb.createUpdateLinkCommand(link, linkVariableName, linkConstraintValue, linkText, linkAltText, auto, once);
        this.getUndoManagerByItemId(link.getId()).executeAndStore(command);
        this.notifyObservers();
    }

    public void updateNode(NodeItem nodeToUpdate) {
        nodeToUpdate.notifyObservers();
        List<Link> adjacentLinks = this.m_nlb.getAssociatedLinks(nodeToUpdate);
        for (Link link : adjacentLinks) {
            link.notifyObservers();
        }
    }

    public void updateLink(Link linkToUpdate) {
        linkToUpdate.notifyObservers();
    }

    public void updateObj(Obj obj, String objVariableName, String objDefTagVariableValue, String objConstraintValue, String objCommonToName, String objName, String imageFileName, String soundFileName, boolean soundSFX, boolean animatedImage, boolean suppressDsc, MultiLangString objDisp, MultiLangString objText, MultiLangString objActText, MultiLangString objNouseText, boolean objIsGraphical, boolean objIsShowOnCursor, boolean objIsPreserved, boolean objIsLoadOnce, boolean objIsCollapsable, String offset, Obj.MovementDirection movementDirection, Obj.Effect effect, int startFrame, int maxFrame, int preloadFrames, int pauseFrames, Obj.CoordsOrigin coordsOrigin, boolean objIsClearUnderTooltip, boolean objIsActOnKey, boolean objIsCacheText, boolean objIsLooped, boolean objIsNoRedrawOnAct, String objMorphOver, String objMorphOut, boolean objIsTakable, boolean imageInScene, boolean imageInInventory) {
        NonLinearBookImpl.UpdateObjCommand command = this.m_nlb.createUpdateObjCommand(obj, objVariableName, objDefTagVariableValue, objConstraintValue, objCommonToName, objName, imageFileName, soundFileName, soundSFX, animatedImage, suppressDsc, objDisp, objText, objActText, objNouseText, objIsGraphical, objIsShowOnCursor, objIsPreserved, objIsLoadOnce, objIsCollapsable, offset, movementDirection, effect, startFrame, maxFrame, preloadFrames, pauseFrames, coordsOrigin, objIsClearUnderTooltip, objIsActOnKey, objIsCacheText, objIsLooped, objIsNoRedrawOnAct, objMorphOver, objMorphOut, objIsTakable, imageInScene, imageInInventory);
        this.getUndoManagerByItemId(obj.getId()).executeAndStore(command);
        this.notifyObservers();
    }

    public void updateLinkCoords(Link link, float left, float top) {
        UpdateLinkCoordsCommand command = new UpdateLinkCoordsCommand(this.m_nlb, link, left, top);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public void updateLinkCoords(Link link, float height) {
        UpdateLinkCoordsCommand command = new UpdateLinkCoordsCommand(this.m_nlb, link, height);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public void addImageFile(@NotNull File imageFile, @Nullable String imageFileName) throws NLBFileManipulationException, NLBIOException, NLBConsistencyException, NLBVCSException {
        File rootDir = this.m_nlb.getRootDir();
        if (rootDir == null) {
            throw new NLBConsistencyException("NLB root dir is undefined");
        }
        FileManipulator fileManipulator = new FileManipulator(this.m_vcsAdapter, rootDir);
        this.m_nlb.copyAndAddImageFile(fileManipulator, imageFile, imageFileName);
    }

    public void addSoundFile(@NotNull File soundFile, @Nullable String soundFileName) throws NLBFileManipulationException, NLBIOException, NLBConsistencyException, NLBVCSException {
        File rootDir = this.m_nlb.getRootDir();
        if (rootDir == null) {
            throw new NLBConsistencyException("NLB root dir is undefined");
        }
        FileManipulator fileManipulator = new FileManipulator(this.m_vcsAdapter, rootDir);
        this.m_nlb.copyAndAddSoundFile(fileManipulator, soundFile, soundFileName);
    }

    public void removeImageFile(String imageFileName) throws NLBFileManipulationException, NLBIOException, NLBConsistencyException {
        File rootDir = this.m_nlb.getRootDir();
        if (rootDir == null) {
            throw new NLBConsistencyException("NLB root dir is undefined");
        }
        FileManipulator fileManipulator = new FileManipulator(this.m_vcsAdapter, rootDir);
        this.m_nlb.removeImageFile(fileManipulator, imageFileName);
    }

    public void removeSoundFile(String soundFileName) throws NLBFileManipulationException, NLBIOException, NLBConsistencyException {
        File rootDir = this.m_nlb.getRootDir();
        if (rootDir == null) {
            throw new NLBConsistencyException("NLB root dir is undefined");
        }
        FileManipulator fileManipulator = new FileManipulator(this.m_vcsAdapter, rootDir);
        this.m_nlb.removeSoundFile(fileManipulator, soundFileName);
    }

    public void resizeNode(NodeItem nodeItem, NodeItem.Orientation orientation, double deltaX, double deltaY) {
        AbstractNodeItem node = this.m_nlb.getPageImplById(nodeItem.getId());
        if (node == null) {
            node = this.m_nlb.getObjImplById(nodeItem.getId());
        }
        List<Link> adjacentLinks = this.m_nlb.getAssociatedLinks(nodeItem);
        AbstractNodeItem.ResizeNodeCommand command = node.createResizeNodeCommand(orientation, deltaX, deltaY, adjacentLinks);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public void updateNodeCoords(NodeItem nodeItem, Set<NodeItem> additionallyMovedItems, float deltaX, float deltaY) {
        CommandChainCommand commandChain = new CommandChainCommand();
        this.updateNodeCoords(commandChain, nodeItem, deltaX, deltaY);
        for (NodeItem additionalNodeItem : additionallyMovedItems) {
            this.updateNodeCoords(commandChain, additionalNodeItem, deltaX, deltaY);
        }
        this.m_undoManager.executeAndStore(commandChain);
        this.notifyObservers();
    }

    private void updateNodeCoords(CommandChainCommand commandChain, NodeItem nodeItem, float deltaX, float deltaY) {
        UpdateNodeCoordsCommand command = new UpdateNodeCoordsCommand(this.m_nlb, nodeItem, deltaX, deltaY);
        commandChain.addCommand(command);
        this.offsetContainedObjects(commandChain, nodeItem, deltaX, deltaY);
    }

    private void offsetContainedObjects(CommandChainCommand commandChain, NodeItem container, float deltaX, float deltaY) {
        for (String nodeId : container.getContainedObjIds()) {
            Obj node = this.m_nlb.getObjById(nodeId);
            Coords nodeCoords = node.getCoords();
            this.updateNodeCoords(commandChain, node, deltaX, deltaY);
            this.offsetContainedObjects(commandChain, node, deltaX, deltaY);
        }
    }

    public void changeContainer(String previousContainerId, String newContainerId, String objId) {
        AbstractNodeItem prevContainer = null;
        if (!StringHelper.isEmpty(previousContainerId) && (prevContainer = this.m_nlb.getPageImplById(previousContainerId)) == null) {
            prevContainer = this.m_nlb.getObjImplById(previousContainerId);
        }
        AbstractNodeItem newContainer = null;
        if (!StringHelper.isEmpty(newContainerId) && (newContainer = this.m_nlb.getPageImplById(newContainerId)) == null) {
            newContainer = this.m_nlb.getObjImplById(newContainerId);
        }
        if (prevContainer == null && newContainer != null || prevContainer != null && newContainer == null || prevContainer != null && !prevContainer.getId().equals(newContainer.getId())) {
            ObjImpl obj = this.m_nlb.getObjImplById(objId);
            ChangeContainerCommand command = new ChangeContainerCommand(prevContainer, newContainer, obj);
            this.m_undoManager.executeAndStore(command);
            this.notifyObservers();
        }
    }

    public void changeStartPoint(String startPoint) {
        NonLinearBookImpl.ChangeStartPointCommand command = this.m_nlb.createChangeStartPointCommand(startPoint);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public void cut(Collection<String> pageIds, Collection<String> objIds) {
        CommandChainCommand command = new CommandChainCommand();
        command.addCommand(this.m_nlb.createCopyCommand(pageIds, objIds));
        command.addCommand(this.m_nlb.createDeleteCommand(pageIds, objIds));
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public void copy(Collection<String> pageIds, Collection<String> objIds) {
        NonLinearBookImpl.CopyCommand command = this.m_nlb.createCopyCommand(pageIds, objIds);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public void paste() {
        NonLinearBookImpl nlbToPaste = Clipboard.singleton().getNonLinearBook();
        if (nlbToPaste != null) {
            NonLinearBookImpl.PasteCommand command = this.m_nlb.createPasteCommand(nlbToPaste);
            this.m_undoManager.executeAndStore(command);
            this.notifyObservers();
        }
    }

    public Page createPage(float left, float top) {
        PageImpl page = new PageImpl(this.m_nlb, left, top);
        this.m_newPagesPool.put(page.getId(), page);
        return page;
    }

    public void addPage(Page page) {
        PageImpl pageImpl = this.m_newPagesPool.get(page.getId());
        NonLinearBookImpl.AddPageCommand command = this.m_nlb.createAddPageCommand(pageImpl);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public Obj createObj(float left, float top) {
        ObjImpl obj = new ObjImpl(this.m_nlb, left, top);
        this.m_newObjsPool.put(obj.getId(), obj);
        return obj;
    }

    public void addObj(Obj obj) {
        ObjImpl objImpl = this.m_newObjsPool.get(obj.getId());
        NonLinearBookImpl.AddObjCommand command = this.m_nlb.createAddObjCommand(objImpl);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public Link createLink(NodeItem item, NodeItem target) {
        NodeItem origin = this.m_nlb.getPageById(item.getId());
        if (origin == null) {
            origin = this.m_nlb.getObjById(item.getId());
        }
        LinkImpl link = new LinkImpl(origin, target.getId());
        this.m_newLinksPool.put(link.getId(), link);
        return link;
    }

    public void addLink(Link link) {
        AbstractNodeItem origin = this.m_nlb.getPageImplById(link.getParent().getId());
        if (origin == null) {
            origin = this.m_nlb.getObjImplById(link.getParent().getId());
        }
        LinkImpl linkImpl = this.m_newLinksPool.get(link.getId());
        AbstractNodeItem.AddLinkCommand command = origin.createAddLinkCommand(linkImpl);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public boolean hasChanges() {
        if (this.canUndo() || this.canRedo()) {
            return true;
        }
        for (UndoManager undoManager : this.m_undoManagersMap.values()) {
            if (!undoManager.canUndo() && !undoManager.canRedo()) continue;
            return true;
        }
        for (NonLinearBookFacade facade : this.m_moduleFacades) {
            if (!facade.hasChanges()) continue;
            return true;
        }
        return false;
    }

    public void save(boolean create, ProgressData progressData) throws NLBVCSException, NLBConsistencyException, NLBFileManipulationException, NLBIOException {
        this.saveNLB(create, progressData);
        this.clearUndosAndPools();
    }

    private void saveNLB(boolean create, ProgressData progressData) throws NLBVCSException, NLBConsistencyException, NLBFileManipulationException, NLBIOException {
        try {
            File rootDir = this.m_nlb.getRootDir();
            progressData.setProgressValue(5);
            progressData.setNoteText("Opening VCS repository...");
            if (!rootDir.exists()) {
                if (!rootDir.mkdirs()) {
                    throw new NLBIOException("Cannot create NLB root directory");
                }
                this.m_vcsAdapter.initRepo(rootDir.getCanonicalPath());
            } else if (create) {
                this.m_vcsAdapter.initRepo(rootDir.getCanonicalPath());
            } else {
                this.m_vcsAdapter.openRepo(rootDir.getCanonicalPath());
            }
            progressData.setProgressValue(15);
            progressData.setNoteText("Saving Non-Linear Book...");
            FileManipulator fileManipulator = new FileManipulator(this.m_vcsAdapter, rootDir);
            int effectivePagesCount = this.m_nlb.getEffectivePagesCountForSave();
            int startProgress = 25;
            int maxProgress = 85;
            Double itemsCountPerIncrement = Math.ceil((double)effectivePagesCount / (double)(maxProgress - startProgress));
            PartialProgressData partialProgressData = new PartialProgressData(progressData, startProgress, maxProgress, itemsCountPerIncrement.intValue());
            this.m_nlb.save(fileManipulator, progressData, partialProgressData);
        }
        catch (IOException e) {
            throw new NLBIOException("Error while obtaining canonical path during save");
        }
    }

    public boolean canUndo() {
        return this.m_undoManager.canUndo();
    }

    public void undo() {
        this.m_undoManager.undo();
        this.notifyObservers();
    }

    public boolean canUndo(String id) {
        return this.getUndoManagerByItemId(id).canUndo();
    }

    public void undo(String id) {
        this.getUndoManagerByItemId(id).undo();
        this.notifyObservers();
    }

    public boolean canRedo() {
        return this.m_undoManager.canRedo();
    }

    public void redo() {
        this.m_undoManager.redo();
        this.notifyObservers();
    }

    public boolean canRedo(String id) {
        return this.getUndoManagerByItemId(id).canRedo();
    }

    public void redo(String id) {
        this.getUndoManagerByItemId(id).redo();
        this.notifyObservers();
    }

    public void redoAll(String id) {
        this.getUndoManagerByItemId(id).redoAll();
        this.notifyObservers();
    }

    private void clearPools() {
        this.m_newPagesPool.clear();
        this.m_newObjsPool.clear();
        this.m_newLinksPool.clear();
    }

    public void saveAs(File nlbFolder, ProgressData progressData) throws NLBVCSException, NLBConsistencyException, NLBFileManipulationException, NLBIOException {
        this.m_nlb.setRootDir(nlbFolder);
        this.saveNLB(true, progressData);
        this.clearUndosAndPools();
    }

    public void load(String path, ProgressData progressData) throws NLBIOException, NLBConsistencyException, NLBVCSException {
        try {
            File rootDir = new File(path);
            if (!rootDir.exists()) {
                throw new NLBIOException("Specified NLB root directory " + path + " does not exist");
            }
            progressData.setNoteText("Opening VCS repository...");
            progressData.setProgressValue(5);
            this.m_vcsAdapter.openRepo(rootDir.getCanonicalPath());
            progressData.setNoteText("Loading book contents...");
            progressData.setProgressValue(15);
            this.m_nlb.load(path, progressData);
            progressData.setProgressValue(70);
            progressData.setNoteText("Prepare to drawing...");
            this.notifyObservers();
        }
        catch (IOException e) {
            throw new NLBIOException("Error while obtaining canonical path for path = " + path);
        }
    }

    public void deleteNode(NodeItem nodeToDelete) {
        List<Link> adjacentLinks = this.m_nlb.getAssociatedLinks(nodeToDelete);
        PageImpl page = this.m_nlb.getPageImplById(nodeToDelete.getId());
        NonLinearBookImpl.DeleteNodeCommand command = null;
        command = page != null ? this.m_nlb.createDeletePageCommand(page, adjacentLinks) : this.m_nlb.createDeleteObjCommand(this.m_nlb.getObjImplById(nodeToDelete.getId()), adjacentLinks);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public void deleteLink(Link link) {
        IdentifiableItem parent = link.getParent();
        AbstractNodeItem nodeItem = this.m_nlb.getPageImplById(parent.getId());
        if (nodeItem == null) {
            nodeItem = this.m_nlb.getObjImplById(parent.getId());
        }
        AbstractNodeItem.DeleteLinkCommand command = nodeItem.createDeleteLinkCommand(link);
        this.m_undoManager.executeAndStore(command);
        this.notifyObservers();
    }

    public void invalidateAssociatedLinks(NodeItem nodeItem) {
        List<Link> associatedLinks = this.m_nlb.getAssociatedLinks(nodeItem);
        for (Link link : associatedLinks) {
            link.notifyObservers();
        }
    }

    public void updateAllViews() {
        List<Link> links;
        for (Map.Entry<String, Page> entry : this.m_nlb.getPages().entrySet()) {
            entry.getValue().notifyObservers();
            links = entry.getValue().getLinks();
            for (Link link : links) {
                link.notifyObservers();
            }
        }
        for (Map.Entry<String, NodeItem> entry : this.m_nlb.getObjs().entrySet()) {
            ((Obj)entry.getValue()).notifyObservers();
            links = ((Obj)entry.getValue()).getLinks();
            for (Link link : links) {
                link.notifyObservers();
            }
        }
    }

    private UndoManager getUndoManagerByItemId(String id) {
        UndoManager undoManager = this.m_undoManagersMap.get(id);
        if (undoManager == null) {
            undoManager = new UndoManager();
            this.m_undoManagersMap.put(id, undoManager);
        }
        return undoManager;
    }

    @Override
    public String addObserver(NLBObserver observer) {
        return this.m_observerHandler.addObserver(observer);
    }

    @Override
    public void removeObserver(String observerId) {
        this.m_observerHandler.removeObserver(observerId);
    }

    @Override
    public void notifyObservers() {
        this.m_observerHandler.notifyObservers();
    }
}

