/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.DummyProgressData;
import com.nlbhub.nlb.api.IdentifiableItem;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.LinkLw;
import com.nlbhub.nlb.api.LinksTableModel;
import com.nlbhub.nlb.api.MediaFile;
import com.nlbhub.nlb.api.Modification;
import com.nlbhub.nlb.api.ModificationsTableModel;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NLBCommand;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.PartialProgressData;
import com.nlbhub.nlb.api.ProgressData;
import com.nlbhub.nlb.api.PropertyManager;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.api.SearchResultTableModel;
import com.nlbhub.nlb.api.SpecialVariablesNameHelper;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.domain.AbstractModifyingItem;
import com.nlbhub.nlb.domain.AbstractNodeItem;
import com.nlbhub.nlb.domain.Clipboard;
import com.nlbhub.nlb.domain.CommandChainCommand;
import com.nlbhub.nlb.domain.CoordsImpl;
import com.nlbhub.nlb.domain.LinkImpl;
import com.nlbhub.nlb.domain.MediaExportParameters;
import com.nlbhub.nlb.domain.MediaFileImpl;
import com.nlbhub.nlb.domain.ModificationImpl;
import com.nlbhub.nlb.domain.NullObj;
import com.nlbhub.nlb.domain.ObjImpl;
import com.nlbhub.nlb.domain.PageImpl;
import com.nlbhub.nlb.domain.SearchResult;
import com.nlbhub.nlb.domain.VariableImpl;
import com.nlbhub.nlb.domain.export.ASMExportManager;
import com.nlbhub.nlb.domain.export.ChoiceScriptExportManager;
import com.nlbhub.nlb.domain.export.ExportManager;
import com.nlbhub.nlb.domain.export.QSPExportManager;
import com.nlbhub.nlb.domain.export.STEADExportManager;
import com.nlbhub.nlb.domain.export.URQExportManager;
import com.nlbhub.nlb.domain.export.VNSTEADExportManager;
import com.nlbhub.nlb.domain.export.hypertext.HTMLExportManager;
import com.nlbhub.nlb.domain.export.hypertext.PDFExportManager;
import com.nlbhub.nlb.domain.export.hypertext.TaggedTextExportManager;
import com.nlbhub.nlb.domain.export.xml.JSIQ2ExportManager;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.FileManipulator;
import com.nlbhub.nlb.util.MultiLangString;
import com.nlbhub.nlb.util.StringHelper;
import com.nlbhub.nlb.util.VarFinder;
import com.nlbhub.user.domain.DecisionPoint;
import com.nlbhub.user.domain.History;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonLinearBookImpl
implements NonLinearBook {
    private static final Pattern AUTOWIRED_OUT_PATTERN = Pattern.compile("LC_(.*)_OUT_");
    private static final String MEDIA_FILE_NAME_TEMPLATE = "%s_%d%s";
    private static final String CONSTRID_EXT = ".constrid";
    private static final String FLAG_EXT = ".flag";
    private static final String REDIRECT_EXT = ".redirect";
    private static final String PRESET_EXT = ".preset";
    private static final FilenameFilter NON_SPECIAL_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.endsWith(NonLinearBookImpl.CONSTRID_EXT) && !name.endsWith(NonLinearBookImpl.REDIRECT_EXT) && !name.endsWith(NonLinearBookImpl.FLAG_EXT) && !name.endsWith(NonLinearBookImpl.PRESET_EXT);
        }
    };
    private static final String STARTPOINT_FILE_NAME = "startpoint";
    private static final String THEME_FILE_NAME = "theme";
    private static final String LANGUAGE_FILE_NAME = "language";
    private static final String LICENSE_FILE_NAME = "license";
    private static final String FULLAUTO_FILE_NAME = "fullauto";
    private static final String SUPPRESS_MEDIA_FILE_NAME = "suppmed";
    private static final String SUPPRESS_SOUND_FILE_NAME = "suppsou";
    private static final String TITLE_FILE_NAME = "title";
    private static final String AUTHOR_FILE_NAME = "author";
    private static final String VERSION_FILE_NAME = "version";
    private static final String PERFECT_GAME_ACHIEVEMENT_FILE_NAME = "perfgame";
    private static final String PAGES_DIR_NAME = "pages";
    private static final String OBJS_DIR_NAME = "objs";
    private static final String VARS_DIR_NAME = "vars";
    private static final String MODULES_DIR_NAME = "modules";
    private static final String AUTOWIRED_PAGES_FILE_NAME = "autopgs";
    private static final String GITIGNORE_FILENAME = ".gitignore";
    private static final String AUTOWIRED_SEPARATOR = "\n";
    private static final String DEFAULT_AUTOWIRED_PAGES = "";
    public static final Color JPG_BGCOLOR = new Color(255, 0, 255);
    public static final Pattern PNG_REGEX = Pattern.compile("\\.png$", 2);
    private File m_rootDir = null;
    private String m_startPoint;
    private Theme m_theme;
    private String m_language;
    private String m_license;
    private String m_title;
    private String m_author;
    private String m_version;
    private String m_perfectGameAchievementName;
    private boolean m_fullAutowire;
    private boolean m_suppressMedia;
    private boolean m_suppressSound;
    private Map<String, PageImpl> m_pages;
    private List<String> m_autowiredPages;
    private Map<String, ObjImpl> m_objs;
    private List<VariableImpl> m_variables;
    private Set<MediaFileImpl> m_imageFiles;
    private Set<MediaFileImpl> m_soundFiles;
    private NonLinearBook m_parentNLB;
    private Page m_parentPage;
    private Map<String, NonLinearBook> m_externalModules;

    public NonLinearBookImpl() {
        this.m_parentNLB = null;
        this.m_language = "ru";
        this.m_license = DEFAULT_AUTOWIRED_PAGES;
        this.m_theme = DEFAULT_THEME;
        this.m_fullAutowire = false;
        this.m_suppressMedia = false;
        this.m_suppressSound = false;
        this.m_title = DEFAULT_AUTOWIRED_PAGES;
        this.m_author = DEFAULT_AUTOWIRED_PAGES;
        this.m_version = DEFAULT_AUTOWIRED_PAGES;
        this.m_perfectGameAchievementName = DEFAULT_AUTOWIRED_PAGES;
        this.m_parentPage = null;
        this.m_pages = new HashMap<String, PageImpl>();
        this.m_autowiredPages = new ArrayList<String>();
        this.m_externalModules = new HashMap<String, NonLinearBook>();
        this.m_objs = new HashMap<String, ObjImpl>();
        this.m_variables = new ArrayList<VariableImpl>();
        this.m_imageFiles = new TreeSet<MediaFileImpl>();
        this.m_soundFiles = new TreeSet<MediaFileImpl>();
    }

    public NonLinearBookImpl(NonLinearBook parentNLB, Page parentPage) {
        this.m_parentNLB = parentNLB;
        this.m_language = parentNLB.getLanguage();
        this.m_license = parentNLB.getLicense();
        this.m_theme = DEFAULT_THEME;
        this.m_fullAutowire = parentNLB.isFullAutowire();
        this.m_suppressMedia = parentNLB.isSuppressMedia();
        this.m_suppressSound = parentNLB.isSuppressSound();
        this.m_title = parentNLB.getTitle();
        this.m_author = parentNLB.getAuthor();
        this.m_version = parentNLB.getVersion();
        this.m_perfectGameAchievementName = DEFAULT_AUTOWIRED_PAGES;
        this.m_parentPage = parentPage;
        this.m_pages = new HashMap<String, PageImpl>();
        this.m_autowiredPages = new ArrayList<String>();
        this.m_externalModules = new HashMap<String, NonLinearBook>();
        this.m_objs = new HashMap<String, ObjImpl>();
        this.m_variables = new ArrayList<VariableImpl>();
        this.m_imageFiles = new TreeSet<MediaFileImpl>();
        this.m_soundFiles = new TreeSet<MediaFileImpl>();
    }

    ChangeStartPointCommand createChangeStartPointCommand(String startPoint) {
        return new ChangeStartPointCommand(startPoint);
    }

    AddPageCommand createAddPageCommand(PageImpl page) {
        return new AddPageCommand(page, false);
    }

    UpdatePageCommand createUpdatePageCommand(Page page, String imageFileName, boolean imageBackground, boolean imageAnimated, String soundFileName, boolean soundSFX, String pageVariableName, String pageTimerVariableName, String pageDefTagVariableValue, MultiLangString pageText, MultiLangString pageCaptionText, Theme theme, boolean useCaption, boolean useMPL, String moduleName, boolean moduleExternal, MultiLangString traverseText, boolean autoTraverse, boolean autoReturn, MultiLangString returnText, String returnPageId, String moduleConsraintVariableName, boolean autowire, MultiLangString autowireInText, MultiLangString autowireOutText, boolean autoIn, boolean autoOut, String autowireInConstraint, String autowireOutConstraint, boolean globalAutowire, boolean noSave, boolean autosFirst, LinksTableModel linksTableModel) {
        return new UpdatePageCommand((NonLinearBook)this, page, imageFileName, imageBackground, imageAnimated, soundFileName, soundSFX, pageVariableName, pageTimerVariableName, pageDefTagVariableValue, pageText, pageCaptionText, theme, useCaption, useMPL, moduleName, moduleExternal, traverseText, autoTraverse, autoReturn, returnText, returnPageId, moduleConsraintVariableName, autowire, autowireInText, autowireOutText, autoIn, autoOut, autowireInConstraint, autowireOutConstraint, globalAutowire, noSave, autosFirst, linksTableModel);
    }

    UpdateObjCommand createUpdateObjCommand(Obj obj, String objVariableName, String objDefTagVariableValue, String objConstraintValue, String objCommonToName, String objName, String imageFileName, String soundFileName, boolean soundSFX, boolean animatedImage, boolean suppressDsc, MultiLangString objDisp, MultiLangString objText, MultiLangString objActText, MultiLangString objNouseText, boolean objIsGraphical, boolean objIsShowOnCursor, boolean objIsPreserved, boolean objIsLoadOnce, boolean objIsCollapsable, String offset, Obj.MovementDirection movementDirection, Obj.Effect effect, int startFrame, int maxFrame, int preloadFrames, int pauseFrames, Obj.CoordsOrigin coordsOrigin, boolean objIsClearUnderTooltip, boolean objIsActOnKey, boolean objIsCacheText, boolean objIsLooped, boolean objIsNoRedrawOnAct, String objMorphOver, String objMorphOut, boolean objIsTakable, boolean imageInScene, boolean imageInInventory) {
        return new UpdateObjCommand((NonLinearBook)this, obj, objVariableName, objDefTagVariableValue, objConstraintValue, objCommonToName, objName, imageFileName, soundFileName, soundSFX, animatedImage, suppressDsc, objDisp, objText, objActText, objNouseText, objIsGraphical, objIsShowOnCursor, objIsPreserved, objIsLoadOnce, objIsCollapsable, offset, movementDirection, effect, startFrame, maxFrame, preloadFrames, pauseFrames, coordsOrigin, objIsClearUnderTooltip, objIsActOnKey, objIsCacheText, objIsLooped, objIsNoRedrawOnAct, objMorphOver, objMorphOut, objIsTakable, imageInScene, imageInInventory);
    }

    UpdateLinkCommand createUpdateLinkCommand(Link link, String linkVariableName, String linkConstraintValue, MultiLangString linkText, MultiLangString linkAltText, boolean auto, boolean once) {
        return new UpdateLinkCommand((NonLinearBook)this, link, linkVariableName, linkConstraintValue, linkText, linkAltText, auto, once);
    }

    UpdateModificationsCommand createUpdateModificationsCommand(ModifyingItem modifyingItem, ModificationsTableModel modificationsTableModel) {
        return new UpdateModificationsCommand(modifyingItem, modificationsTableModel);
    }

    AddObjCommand createAddObjCommand(ObjImpl obj) {
        return new AddObjCommand(obj);
    }

    DeletePageCommand createDeletePageCommand(PageImpl page, List<Link> adjacentLinks) {
        return new DeletePageCommand(page, adjacentLinks);
    }

    DeleteObjCommand createDeleteObjCommand(ObjImpl obj, List<Link> adjacentLinks) {
        return new DeleteObjCommand(obj, adjacentLinks);
    }

    UpdateBookPropertiesCommand createUpdateBookPropertiesCommand(String license, Theme theme, String language, String title, String author, String version, String perfectGameAchievementName, Boolean fullAutowire, Boolean suppressMedia, Boolean suppressSound, boolean propagateToSubmodules) {
        return new UpdateBookPropertiesCommand(this.m_license.equals(license) ? null : license, this.m_theme.equals((Object)theme) ? null : theme, this.m_language.equals(language) ? null : language, this.m_title.equals(title) ? null : title, this.m_author.equals(author) ? null : author, this.m_version.equals(version) ? null : version, this.m_perfectGameAchievementName.equals(perfectGameAchievementName) ? null : perfectGameAchievementName, (Boolean)(fullAutowire != null && this.m_fullAutowire == fullAutowire ? null : fullAutowire), (Boolean)(suppressMedia != null && this.m_suppressMedia == suppressMedia ? null : suppressMedia), (Boolean)(suppressSound != null && this.m_suppressSound == suppressSound ? null : suppressSound), propagateToSubmodules);
    }

    CopyCommand createCopyCommand(Collection<String> pageIds, Collection<String> objIds) {
        return new CopyCommand(pageIds, objIds);
    }

    DeleteCommand createDeleteCommand(Collection<String> pageIds, Collection<String> objIds) {
        return new DeleteCommand(pageIds, objIds);
    }

    PasteCommand createPasteCommand(NonLinearBookImpl nlbToPaste) {
        return new PasteCommand(this, nlbToPaste);
    }

    public void append(NonLinearBook operand, boolean overwriteProperties, boolean overwriteTheme) {
        if (operand != null) {
            for (Map.Entry<String, Page> entry : operand.getPages().entrySet()) {
                Page operandPage = entry.getValue();
                PageImpl newPage = new PageImpl(operandPage, this, overwriteTheme);
                this.m_pages.put(entry.getKey(), newPage);
                if (!operand.isAutowired(entry.getKey())) continue;
                this.addAutowiredPageId(entry.getKey());
            }
            for (Map.Entry<String, NodeItem> entry : operand.getObjs().entrySet()) {
                this.m_objs.put(entry.getKey(), new ObjImpl((Obj)entry.getValue(), (NonLinearBook)this));
            }
            Iterator<VariableImpl> iterator = this.m_variables.iterator();
            block2: while (iterator.hasNext()) {
                VariableImpl variableImpl = iterator.next();
                for (Variable variable : operand.getVariables()) {
                    if (!variable.getId().equals(variableImpl.getId())) continue;
                    iterator.remove();
                    continue block2;
                }
            }
            for (Variable variable : operand.getVariables()) {
                this.m_variables.add(new VariableImpl(variable, (NonLinearBook)this));
            }
            if (overwriteProperties) {
                this.overwriteBookProperties(operand, overwriteTheme);
            }
        }
    }

    private void overwriteBookProperties(NonLinearBook operand, boolean overwriteTheme) {
        this.m_startPoint = operand.getStartPoint();
        this.m_language = operand.getLanguage();
        this.m_license = operand.getLicense();
        if (overwriteTheme) {
            this.m_theme = operand.getTheme();
        }
        this.m_fullAutowire = operand.isFullAutowire();
        this.m_suppressMedia = operand.isSuppressMedia();
        this.m_suppressSound = operand.isSuppressSound();
        this.m_title = operand.getTitle();
        this.m_author = operand.getAuthor();
        this.m_version = operand.getVersion();
    }

    public List<Link> getAssociatedLinks(NodeItem nodeItem) {
        ArrayList<Link> result = new ArrayList<Link>();
        NodeItem node = this.getPageById(nodeItem.getId());
        boolean isPage = true;
        if (node == null) {
            node = this.getObjById(nodeItem.getId());
            isPage = false;
        }
        result.addAll(node.getLinks());
        if (isPage) {
            for (Map.Entry<String, PageImpl> entry : this.m_pages.entrySet()) {
                List<Link> links = entry.getValue().getLinks();
                for (Link link : links) {
                    if (!nodeItem.getId().equals(link.getTarget())) continue;
                    result.add(link);
                }
            }
        } else {
            for (Map.Entry<String, ObjImpl> entry : this.m_objs.entrySet()) {
                List<Link> links = entry.getValue().getLinks();
                for (Link link : links) {
                    if (!nodeItem.getId().equals(link.getTarget())) continue;
                    result.add(link);
                }
            }
        }
        return result;
    }

    public void clear() throws NLBVCSException {
        this.m_pages.clear();
        this.m_objs.clear();
        this.m_variables.clear();
        this.m_startPoint = null;
        this.m_language = this.m_parentNLB != null ? this.m_parentNLB.getLanguage() : "ru";
        this.m_license = this.m_parentNLB != null ? this.m_parentNLB.getLicense() : DEFAULT_AUTOWIRED_PAGES;
        this.m_theme = DEFAULT_THEME;
        this.m_title = this.m_parentNLB != null ? this.m_parentNLB.getTitle() : DEFAULT_AUTOWIRED_PAGES;
        this.m_author = this.m_parentNLB != null ? this.m_parentNLB.getAuthor() : DEFAULT_AUTOWIRED_PAGES;
        this.m_version = this.m_parentNLB != null ? this.m_parentNLB.getVersion() : DEFAULT_AUTOWIRED_PAGES;
        this.m_perfectGameAchievementName = DEFAULT_AUTOWIRED_PAGES;
        this.m_fullAutowire = this.m_parentNLB != null ? this.m_parentNLB.isFullAutowire() : false;
        this.m_suppressMedia = this.m_parentNLB != null ? this.m_parentNLB.isSuppressMedia() : false;
        this.m_suppressSound = this.m_parentNLB != null ? this.m_parentNLB.isSuppressSound() : false;
        this.m_rootDir = null;
    }

    private Obj findObjByName(String objName) {
        if (objName == null) {
            return NullObj.create();
        }
        for (ObjImpl obj : this.m_objs.values()) {
            if (!objName.equals(obj.getName())) continue;
            return obj;
        }
        return NullObj.create();
    }

    @Override
    public Set<String> getAllAchievementNames(boolean recursive) {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<String, PageImpl> entry : this.m_pages.entrySet()) {
            PageImpl page = entry.getValue();
            result.addAll(this.getAllAchievementsForModifyingItem(page));
            for (Link link : page.getLinks()) {
                result.addAll(this.getAllAchievementsForModifyingItem(link));
            }
            NonLinearBook module = page.getModule();
            if (!recursive || module.isEmpty()) continue;
            result.addAll(module.getAllAchievementNames(true));
        }
        for (Map.Entry<String, AbstractNodeItem> entry : this.m_objs.entrySet()) {
            ObjImpl obj = (ObjImpl)entry.getValue();
            result.addAll(this.getAllAchievementsForModifyingItem(obj));
            for (Link link : obj.getLinks()) {
                result.addAll(this.getAllAchievementsForModifyingItem(link));
            }
        }
        return result;
    }

    private Set<String> getAllAchievementsForModifyingItem(ModifyingItem item) {
        HashSet<String> result = new HashSet<String>();
        for (Modification modification : item.getModifications()) {
            if (modification.getType() != Modification.Type.ACHIEVE) continue;
            Variable variable = this.getVariableById(modification.getExprId());
            result.add(variable.getValue());
        }
        return result;
    }

    @Override
    public String getPerfectGameAchievementName() {
        return this.m_perfectGameAchievementName;
    }

    @Override
    public boolean isEmpty() {
        return this.m_pages.isEmpty() && this.m_objs.isEmpty() && this.m_variables.isEmpty();
    }

    @Override
    public String getStartPoint() {
        return this.m_startPoint;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    @Override
    public String getLicense() {
        return this.m_license;
    }

    @Override
    public Theme getTheme() {
        return this.m_theme;
    }

    @Override
    public boolean isFullAutowire() {
        return this.m_fullAutowire;
    }

    @Override
    public boolean isSuppressMedia() {
        return this.m_suppressMedia;
    }

    @Override
    public boolean isSuppressSound() {
        return this.m_suppressSound;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    @Override
    public String getAuthor() {
        return this.m_author;
    }

    @Override
    public String getVersion() {
        return this.m_version;
    }

    public void setStartPoint(String startPoint) {
        this.m_startPoint = startPoint;
    }

    @Override
    public File getRootDir() {
        return this.m_rootDir;
    }

    @Override
    public File getImagesDir() {
        return this.m_rootDir == null ? null : new File(this.m_rootDir, "images");
    }

    @Override
    public Set<String> getUsedImages() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, PageImpl> entry : this.m_pages.entrySet()) {
            PageImpl page = entry.getValue();
            result.addAll(this.getUsedMedia(page.getImageFileName()));
            NonLinearBook module = page.getModule();
            if (module.isEmpty()) continue;
            result.addAll(module.getUsedImages());
        }
        for (Map.Entry<String, AbstractNodeItem> entry : this.m_objs.entrySet()) {
            ObjImpl obj = (ObjImpl)entry.getValue();
            result.addAll(this.getUsedMedia(obj.getImageFileName()));
        }
        return result;
    }

    @Override
    public Set<String> getUsedSounds() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, PageImpl> entry : this.m_pages.entrySet()) {
            PageImpl page = entry.getValue();
            result.addAll(this.getUsedMedia(page.getSoundFileName()));
            NonLinearBook module = page.getModule();
            if (module.isEmpty()) continue;
            result.addAll(module.getUsedSounds());
        }
        for (Map.Entry<String, AbstractNodeItem> entry : this.m_objs.entrySet()) {
            ObjImpl obj = (ObjImpl)entry.getValue();
            result.addAll(this.getUsedMedia(obj.getSoundFileName()));
        }
        return result;
    }

    private Set<String> getUsedMedia(String fileNamesStr) {
        HashSet<String> result = new HashSet<String>();
        if (StringHelper.notEmpty(fileNamesStr)) {
            String[] fileNames = fileNamesStr.split(";");
            Collections.addAll(result, fileNames);
        }
        return result;
    }

    @Override
    public List<MediaFile> getImageFiles() {
        ArrayList<MediaFile> imageFiles = new ArrayList<MediaFile>();
        imageFiles.addAll(this.m_imageFiles);
        return imageFiles;
    }

    @Override
    public List<MediaFile> getSoundFiles() {
        ArrayList<MediaFile> soundFiles = new ArrayList<MediaFile>();
        soundFiles.addAll(this.m_soundFiles);
        return soundFiles;
    }

    public void setMediaFileConstrId(MediaFile.Type mediaType, String fileName, String constrId) {
        block0 : switch (mediaType) {
            case Image: {
                for (MediaFileImpl mediaFile : this.m_imageFiles) {
                    if (!mediaFile.getFileName().equals(fileName)) continue;
                    mediaFile.setConstrId(constrId);
                    break block0;
                }
                break;
            }
            case Sound: {
                for (MediaFileImpl mediaFile : this.m_soundFiles) {
                    if (!mediaFile.getFileName().equals(fileName)) continue;
                    mediaFile.setConstrId(constrId);
                    break block0;
                }
                break;
            }
        }
    }

    public void setMediaFileRedirect(MediaFile.Type mediaType, String fileName, String redirect) {
        block0 : switch (mediaType) {
            case Image: {
                for (MediaFileImpl mediaFile : this.m_imageFiles) {
                    if (!mediaFile.getFileName().equals(fileName)) continue;
                    mediaFile.setRedirect(redirect);
                    break block0;
                }
                break;
            }
            case Sound: {
                for (MediaFileImpl mediaFile : this.m_soundFiles) {
                    if (!mediaFile.getFileName().equals(fileName)) continue;
                    mediaFile.setRedirect(redirect);
                    break block0;
                }
                break;
            }
        }
    }

    public void setMediaFileFlag(MediaFile.Type mediaType, String fileName, boolean flag) {
        block0 : switch (mediaType) {
            case Image: {
                for (MediaFileImpl mediaFile : this.m_imageFiles) {
                    if (!mediaFile.getFileName().equals(fileName)) continue;
                    mediaFile.setFlagged(flag);
                    break block0;
                }
                break;
            }
            case Sound: {
                for (MediaFileImpl mediaFile : this.m_soundFiles) {
                    if (!mediaFile.getFileName().equals(fileName)) continue;
                    mediaFile.setFlagged(flag);
                    break block0;
                }
                break;
            }
        }
    }

    public void setMediaFileExportParametersPreset(MediaFile.Type mediaType, String fileName, MediaExportParameters.Preset preset) {
        block0 : switch (mediaType) {
            case Image: {
                for (MediaFileImpl mediaFile : this.m_imageFiles) {
                    if (!mediaFile.getFileName().equals(fileName)) continue;
                    mediaFile.setPreset(preset);
                    break block0;
                }
                break;
            }
            case Sound: {
                for (MediaFileImpl mediaFile : this.m_soundFiles) {
                    if (!mediaFile.getFileName().equals(fileName)) continue;
                    mediaFile.setPreset(preset);
                    break block0;
                }
                break;
            }
        }
    }

    public void setRootDir(File rootDir) {
        this.m_rootDir = rootDir;
    }

    @Override
    public Map<String, Page> getPages() {
        HashMap<String, Page> result = new HashMap<String, Page>();
        result.putAll(this.m_pages);
        return result;
    }

    @Override
    public Map<String, Page> getDownwardPagesHeirarchy() {
        HashMap<String, Page> result = new HashMap<String, Page>();
        result.putAll(this.m_pages);
        for (Page page : this.m_pages.values()) {
            NonLinearBook module = page.getModule();
            if (module.isEmpty()) continue;
            result.putAll(module.getDownwardPagesHeirarchy());
        }
        return result;
    }

    @Override
    public Map<String, Page> getUpwardPagesHeirarchy() {
        HashMap<String, Page> result = new HashMap<String, Page>();
        result.putAll(this.m_pages);
        if (this.m_parentNLB != null) {
            result.putAll(this.m_parentNLB.getUpwardPagesHeirarchy());
        }
        return result;
    }

    @Override
    public List<String> getAutowiredPagesIds() {
        return this.m_autowiredPages;
    }

    @Override
    public List<String> getParentGlobalAutowiredPagesIds() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_parentNLB != null) {
            for (String id : this.m_parentNLB.getAutowiredPagesIds()) {
                Page page = this.m_parentNLB.getPageById(id);
                if (page == null || !page.isGlobalAutowire()) continue;
                result.add(id);
            }
            result.addAll(this.m_parentNLB.getParentGlobalAutowiredPagesIds());
        }
        return result;
    }

    public void addPage(@NotNull PageImpl page) {
        this.m_pages.put(page.getId(), page);
    }

    public void addAutowiredPageId(String pageId) {
        for (String existingId : this.m_autowiredPages) {
            if (!existingId.equals(pageId)) continue;
            return;
        }
        this.m_autowiredPages.add(pageId);
    }

    public void removeAutowiredPageId(String pageId) {
        ListIterator<String> iterator = this.m_autowiredPages.listIterator();
        while (iterator.hasNext()) {
            String existingId = (String)iterator.next();
            if (!existingId.equals(pageId)) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public boolean isAutowired(String pageId) {
        return this.m_autowiredPages.contains(pageId);
    }

    @Override
    public Page getPageById(String id) {
        PageImpl result = this.getPageImplById(id);
        if (result != null) {
            return result;
        }
        if (this.m_parentNLB != null) {
            return this.m_parentNLB.getPageById(id);
        }
        return null;
    }

    public PageImpl getPageImplById(String id) {
        return this.m_pages.get(id);
    }

    @Override
    public Map<String, Obj> getObjs() {
        HashMap<String, Obj> result = new HashMap<String, Obj>();
        result.putAll(this.m_objs);
        return result;
    }

    public void addObj(@NotNull ObjImpl obj) {
        this.m_objs.put(obj.getId(), obj);
    }

    @Override
    public Obj getObjById(String objId) {
        ObjImpl result = this.getObjImplById(objId);
        if (result != null) {
            return result;
        }
        if (this.m_parentNLB != null) {
            return this.m_parentNLB.getObjById(objId);
        }
        return null;
    }

    public ObjImpl getObjImplById(String objId) {
        return this.m_objs.get(objId);
    }

    @Override
    public PageImpl createFilteredPage(String sourceId, History history) throws ScriptException, NLBConsistencyException {
        LinkLw linkLw;
        PageImpl source = this.getPageImplById(sourceId);
        ScriptEngineManager factory = new ScriptEngineManager();
        List<DecisionPoint> decisionsList = history.getDecisionPoints();
        HashMap<String, Object> visitedVars = new HashMap<String, Object>();
        for (DecisionPoint decisionPoint : decisionsList) {
            this.makeDecisionVariableChange(factory, visitedVars, decisionPoint);
        }
        DecisionPoint decisionPointToBeMade = history.getDecisionPointToBeMade();
        this.makeDecisionVariableChange(factory, visitedVars, decisionPointToBeMade);
        ArrayList<String> linkIdsToBeExcluded = new ArrayList<String>();
        for (Link link : source.getLinks()) {
            if (!this.determineLinkExcludedStatus(factory, visitedVars, link, history)) continue;
            linkIdsToBeExcluded.add(link.getId());
        }
        ArrayList<Link> linksToBeAdded = new ArrayList<Link>();
        if (!source.getModule().isEmpty() && !this.determineLinkExcludedStatus(factory, visitedVars, linkLw = new LinkLw(LinkLw.Type.Traverse, source.getModule().getStartPoint(), source, source.getTraverseTexts(), Link.DEFAULT_ALT_TEXT, source.getModuleConstrId(), DEFAULT_AUTOWIRED_PAGES, source.isAutoTraverse(), false, true, false, DEFAULT_AUTOWIRED_PAGES, null), history)) {
            linksToBeAdded.add(linkLw);
        }
        if (this.m_parentNLB != null && this.m_parentPage != null && source.shouldReturn()) {
            if (source.isUseMPL()) {
                for (Link link3 : this.m_parentPage.getLinks()) {
                    LinkLw linklw = new LinkLw(LinkLw.Type.Return, link3.getTarget(), source, link3.getTexts(), link3.getAltTexts(), link3.getConstrId(), link3.getVarId(), link3.isAuto(), link3.isOnce(), link3.isPositiveConstraint(), false, link3.getId(), link3.getModifications());
                    if (this.determineLinkExcludedStatus(factory, visitedVars, linklw, history)) continue;
                    linksToBeAdded.add(linklw);
                }
            } else {
                LinkLw linkLw2 = new LinkLw(LinkLw.Type.Return, StringHelper.isEmpty(source.getReturnPageId()) ? this.m_parentPage.getId() : source.getReturnPageId(), source, source.getReturnTexts(), Link.DEFAULT_ALT_TEXT, DEFAULT_AUTOWIRED_PAGES, DEFAULT_AUTOWIRED_PAGES, source.isAutoReturn(), false, StringHelper.isEmpty(this.m_parentPage.getModuleConstrId()), !source.isLeaf(), DEFAULT_AUTOWIRED_PAGES, null);
                if (!this.determineLinkExcludedStatus(factory, visitedVars, linkLw2, history)) {
                    linksToBeAdded.add(linkLw2);
                }
            }
        }
        return source.createFilteredCloneWithSubstitutions(new ArrayList<String>(), linkIdsToBeExcluded, linksToBeAdded, visitedVars);
    }

    private void updateVisitedVars(NonLinearBook decisionModule, ModifyingItem modifyingItem, ScriptEngineManager factory, Map<String, Object> visitedVars) throws ScriptException {
        for (Modification modification : modifyingItem.getModifications()) {
            if (modification.getType() != Modification.Type.ASSIGN) continue;
            ScriptEngine engine = factory.getEngineByName("JavaScript");
            for (Map.Entry<String, Object> entry : visitedVars.entrySet()) {
                engine.put(entry.getKey(), entry.getValue());
            }
            Variable modVariable = decisionModule.getVariableById(modification.getVarId());
            Variable modExpression = decisionModule.getVariableById(modification.getExprId());
            visitedVars.put(modVariable.getName(), engine.eval(modExpression.getValue()));
        }
    }

    private NonLinearBook getModuleByBookId(String bookId) {
        NonLinearBook result = this.getMainNLB();
        HashMap<Integer, String> modulePageMap = new HashMap<Integer, String>();
        String[] idParts = bookId.split(";");
        int maxModuleIdx = 0;
        for (String idPart : idParts) {
            String[] modulePageParts = idPart.split("=");
            if (modulePageParts.length <= 1) continue;
            int curModuleIdx = Integer.parseInt(modulePageParts[0]);
            modulePageMap.put(curModuleIdx, modulePageParts[1]);
            if (curModuleIdx <= maxModuleIdx) continue;
            maxModuleIdx = curModuleIdx;
        }
        for (int i = 1; i <= maxModuleIdx; ++i) {
            result = result.getPageById((String)modulePageMap.get(i)).getModule();
        }
        return result;
    }

    private boolean determineLinkExcludedStatus(ScriptEngineManager factory, Map<String, Object> visitedVars, Link link, History history) throws ScriptException, NLBConsistencyException {
        Variable moduleConstraint;
        if (link.isOnce() && history.containsLink(link)) {
            return true;
        }
        Variable constraintVar = this.getVariableById(link.getConstrId());
        Variable variable = moduleConstraint = this.m_parentPage != null ? this.getVariableById(this.m_parentPage.getModuleConstrId()) : null;
        if (constraintVar != null || moduleConstraint != null) {
            ScriptEngine engine;
            String constraint;
            if (moduleConstraint != null && link.isObeyToModuleConstraint()) {
                constraint = moduleConstraint.getValue().trim();
                engine = this.prepareEngine(factory, constraint, visitedVars);
                Boolean evalModule = (Boolean)engine.eval(constraint);
                if (link.isPositiveConstraint() && !evalModule.booleanValue() || !link.isPositiveConstraint() && evalModule.booleanValue()) {
                    return true;
                }
            }
            if (constraintVar != null) {
                constraint = constraintVar.getValue().trim();
                engine = this.prepareEngine(factory, constraint, visitedVars);
                Object evalObject = engine.eval(constraint);
                Boolean evalResult = false;
                if (evalObject != null) {
                    evalResult = evalObject instanceof Boolean ? (Boolean)evalObject : (evalObject instanceof Double ? Boolean.valueOf((Double)evalObject != 0.0) : (evalObject instanceof Integer ? Boolean.valueOf((Integer)evalObject != 0) : Boolean.valueOf(true)));
                }
                return link.isPositiveConstraint() && evalResult == false || !link.isPositiveConstraint() && evalResult != false;
            }
        }
        return false;
    }

    private ScriptEngine prepareEngine(ScriptEngineManager factory, String constraint, Map<String, Object> visitedVars) throws NLBConsistencyException {
        Collection<String> constraintVars = VarFinder.findVariableNames(constraint);
        HashMap<String, Object> varMapping = new HashMap<String, Object>();
        for (String var : constraintVars) {
            if (visitedVars.containsKey(var)) {
                varMapping.put(var, visitedVars.get(var));
                continue;
            }
            varMapping.put(var, false);
        }
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        for (Map.Entry entry : varMapping.entrySet()) {
            engine.put((String)entry.getKey(), entry.getValue());
        }
        return engine;
    }

    private void makeDecisionVariableChange(ScriptEngineManager factory, Map<String, Object> visitedVars, DecisionPoint decisionPoint) throws ScriptException {
        NonLinearBook decisionModule = this.getModuleByBookId(decisionPoint.getBookId());
        if (decisionPoint.isLinkInfo()) {
            Page pageFrom = decisionModule.getPageById(decisionPoint.getFromPageId());
            Link linkToBeFollowedCur = this.findLink(pageFrom, decisionPoint.getLinkId());
            this.updateVisitedVars(decisionModule, linkToBeFollowedCur, factory, visitedVars);
            Variable variableLinkCur = decisionModule.getVariableById(linkToBeFollowedCur.getVarId());
            if (variableLinkCur != null && !StringHelper.isEmpty(variableLinkCur.getName())) {
                visitedVars.put(variableLinkCur.getName(), true);
            }
            this.makeVariableChangesForVisitedPage(decisionModule, linkToBeFollowedCur.getTarget(), factory, visitedVars);
        } else {
            this.makeVariableChangesForVisitedPage(decisionModule, decisionPoint.getToPageId(), factory, visitedVars);
        }
    }

    private void makeVariableChangesForVisitedPage(NonLinearBook decisionModule, String pageId, ScriptEngineManager factory, Map<String, Object> visitedVars) throws ScriptException {
        if (!StringHelper.isEmpty(pageId)) {
            Page page = decisionModule.getPageById(pageId);
            this.updateVisitedVars(decisionModule, page, factory, visitedVars);
            Variable variable = decisionModule.getVariableById(page.getVarId());
            if (variable != null && !StringHelper.isEmpty(variable.getName())) {
                visitedVars.put(variable.getName(), true);
            }
        }
    }

    private Link findLink(Page page, String linkId) {
        List<Link> links = page.getLinks();
        for (Link link : links) {
            if (!link.getId().equals(linkId)) continue;
            return link;
        }
        return null;
    }

    private boolean loadModules(File rootDir) throws NLBIOException, NLBConsistencyException, NLBVCSException {
        File modulesDir = new File(rootDir, MODULES_DIR_NAME);
        if (!modulesDir.exists() || !modulesDir.isDirectory()) {
            return false;
        }
        for (String moduleName : modulesDir.list()) {
            NonLinearBookImpl moduleImpl = this.loadModule(modulesDir, moduleName);
            if (moduleImpl == null) {
                return false;
            }
            this.m_externalModules.put(moduleName, moduleImpl);
        }
        return true;
    }

    private NonLinearBookImpl loadModule(File modulesDir, String name) throws NLBIOException, NLBVCSException, NLBConsistencyException {
        try {
            File moduleDir = new File(modulesDir, name);
            NonLinearBookImpl moduleImpl = new NonLinearBookImpl();
            if (moduleImpl.load(moduleDir.getCanonicalPath(), new DummyProgressData())) {
                return moduleImpl;
            }
        }
        catch (IOException e) {
            throw new NLBIOException("Error loading module '" + name + "'", e);
        }
        return null;
    }

    @Override
    public boolean load(String path, ProgressData progressData) throws NLBIOException, NLBConsistencyException, NLBVCSException {
        File rootDir = new File(path);
        if (!rootDir.exists()) {
            return false;
        }
        this.m_rootDir = rootDir;
        progressData.setNoteText("Reading external modules...");
        this.loadModules(rootDir);
        progressData.setProgressValue(18);
        progressData.setNoteText("Reading autowired pages...");
        this.readAutowiredPagesFile(rootDir);
        progressData.setProgressValue(20);
        progressData.setNoteText("Reading book properties...");
        this.readBookProperties(rootDir);
        progressData.setProgressValue(25);
        progressData.setNoteText("Reading objects...");
        this.readObjs(rootDir);
        progressData.setProgressValue(35);
        progressData.setNoteText("Reading pages and modules...");
        this.readPages(rootDir);
        progressData.setProgressValue(60);
        progressData.setNoteText("Reading variables...");
        this.readVariables(rootDir);
        progressData.setProgressValue(65);
        progressData.setNoteText("Reading image files...");
        this.readImageFiles(rootDir);
        this.readSoundFiles(rootDir);
        return true;
    }

    public boolean loadAndSetParent(String path, NonLinearBook parentNLB, Page parentPage) throws NLBIOException, NLBConsistencyException, NLBVCSException {
        File rootDir = new File(path);
        if (!rootDir.exists()) {
            return false;
        }
        this.m_rootDir = rootDir;
        this.m_parentNLB = parentNLB;
        this.m_parentPage = parentPage;
        this.readAutowiredPagesFile(rootDir);
        this.readBookProperties(rootDir);
        this.readObjs(rootDir);
        this.readPages(rootDir);
        this.readVariables(rootDir);
        this.readImageFiles(rootDir);
        this.readSoundFiles(rootDir);
        return true;
    }

    private void readBookProperties(File rootDir) throws NLBIOException {
        this.m_startPoint = FileManipulator.getOptionalFileAsString(rootDir, STARTPOINT_FILE_NAME, DEFAULT_AUTOWIRED_PAGES);
        this.m_language = FileManipulator.getOptionalFileAsString(rootDir, LANGUAGE_FILE_NAME, this.m_parentNLB != null ? this.m_parentNLB.getLanguage() : "ru");
        this.m_license = FileManipulator.getOptionalFileAsString(rootDir, LICENSE_FILE_NAME, this.m_parentNLB != null ? this.m_parentNLB.getLicense() : DEFAULT_AUTOWIRED_PAGES);
        this.m_theme = this.m_theme.fromString(FileManipulator.getOptionalFileAsString(rootDir, THEME_FILE_NAME, DEFAULT_THEME.name()));
        this.m_fullAutowire = "true".equals(FileManipulator.getOptionalFileAsString(rootDir, FULLAUTO_FILE_NAME, this.m_parentNLB != null ? String.valueOf(this.m_parentNLB.isFullAutowire()) : String.valueOf(false)));
        this.m_suppressMedia = "true".equals(FileManipulator.getOptionalFileAsString(rootDir, SUPPRESS_MEDIA_FILE_NAME, this.m_parentNLB != null ? String.valueOf(this.m_parentNLB.isSuppressMedia()) : String.valueOf(false)));
        this.m_suppressSound = "true".equals(FileManipulator.getOptionalFileAsString(rootDir, SUPPRESS_SOUND_FILE_NAME, this.m_parentNLB != null ? String.valueOf(this.m_parentNLB.isSuppressSound()) : String.valueOf(false)));
        this.m_title = FileManipulator.getOptionalFileAsString(rootDir, TITLE_FILE_NAME, this.m_parentNLB != null ? this.m_parentNLB.getTitle() : DEFAULT_AUTOWIRED_PAGES);
        this.m_author = FileManipulator.getOptionalFileAsString(rootDir, AUTHOR_FILE_NAME, this.m_parentNLB != null ? this.m_parentNLB.getAuthor() : DEFAULT_AUTOWIRED_PAGES);
        this.m_version = FileManipulator.getOptionalFileAsString(rootDir, VERSION_FILE_NAME, this.m_parentNLB != null ? this.m_parentNLB.getVersion() : DEFAULT_AUTOWIRED_PAGES);
        this.m_perfectGameAchievementName = FileManipulator.getOptionalFileAsString(rootDir, PERFECT_GAME_ACHIEVEMENT_FILE_NAME, DEFAULT_AUTOWIRED_PAGES);
    }

    private void readPages(File rootDir) throws NLBIOException, NLBConsistencyException, NLBVCSException {
        this.m_pages.clear();
        File pagesDir = new File(rootDir, PAGES_DIR_NAME);
        if (pagesDir.exists()) {
            File[] pageDirs = pagesDir.listFiles();
            if (pageDirs == null) {
                throw new NLBIOException("Error when enumerating pages' directory contents");
            }
            for (File pageDir : pageDirs) {
                PageImpl page = new PageImpl(this);
                page.readPage(pageDir);
                this.m_pages.put(pageDir.getName(), page);
            }
        }
    }

    private void readObjs(File rootDir) throws NLBIOException, NLBConsistencyException {
        this.m_objs.clear();
        File objsDir = new File(rootDir, OBJS_DIR_NAME);
        if (objsDir.exists()) {
            File[] objDirs = objsDir.listFiles();
            if (objDirs == null) {
                throw new NLBIOException("Error when enumerating objs' directory contents");
            }
            for (File objDir : objDirs) {
                ObjImpl obj = new ObjImpl(this);
                obj.readObj(objDir);
                this.m_objs.put(objDir.getName(), obj);
            }
        }
    }

    private void readVariables(File rootDir) throws NLBIOException, NLBConsistencyException {
        this.m_variables.clear();
        File varsDir = new File(rootDir, VARS_DIR_NAME);
        if (varsDir.exists()) {
            File[] varDirs = varsDir.listFiles();
            if (varDirs == null) {
                throw new NLBIOException("Error when enumerating vars' directory contents");
            }
            for (File varDir : varDirs) {
                VariableImpl var = new VariableImpl(this);
                var.readVariable(varDir);
                this.m_variables.add(var);
            }
        }
    }

    private void readImageFiles(File rootDir) throws NLBIOException, NLBConsistencyException {
        this.m_imageFiles.clear();
        File imagesDir = new File(rootDir, "images");
        if (imagesDir.exists()) {
            File[] listFiles = imagesDir.listFiles(NON_SPECIAL_FILTER);
            if (listFiles == null) {
                throw new NLBIOException("Error when enumerating images' directory contents");
            }
            for (File file : listFiles) {
                MediaFileImpl imageFile = new MediaFileImpl(file.getName());
                imageFile.setRedirect(FileManipulator.getOptionalFileAsString(imagesDir, file.getName() + REDIRECT_EXT, DEFAULT_AUTOWIRED_PAGES));
                imageFile.setConstrId(FileManipulator.getOptionalFileAsString(imagesDir, file.getName() + CONSTRID_EXT, DEFAULT_AUTOWIRED_PAGES));
                imageFile.setFlagged("true".equals(FileManipulator.getOptionalFileAsString(imagesDir, file.getName() + FLAG_EXT, String.valueOf(false))));
                imageFile.setPreset(MediaExportParameters.Preset.valueOf(FileManipulator.getOptionalFileAsString(imagesDir, file.getName() + PRESET_EXT, MediaExportParameters.Preset.DEFAULT.name())));
                this.m_imageFiles.add(imageFile);
            }
        }
    }

    private void readSoundFiles(File rootDir) throws NLBIOException, NLBConsistencyException {
        this.m_soundFiles.clear();
        File soundDir = new File(rootDir, "sound");
        if (soundDir.exists()) {
            File[] listFiles = soundDir.listFiles(NON_SPECIAL_FILTER);
            if (listFiles == null) {
                throw new NLBIOException("Error when enumerating sound' directory contents");
            }
            for (File file : listFiles) {
                MediaFileImpl soundFile = new MediaFileImpl(file.getName());
                soundFile.setRedirect(FileManipulator.getOptionalFileAsString(soundDir, file.getName() + REDIRECT_EXT, DEFAULT_AUTOWIRED_PAGES));
                soundFile.setConstrId(FileManipulator.getOptionalFileAsString(soundDir, file.getName() + CONSTRID_EXT, DEFAULT_AUTOWIRED_PAGES));
                soundFile.setFlagged("true".equals(FileManipulator.getOptionalFileAsString(soundDir, file.getName() + FLAG_EXT, String.valueOf(false))));
                soundFile.setPreset(MediaExportParameters.Preset.valueOf(FileManipulator.getOptionalFileAsString(soundDir, file.getName() + PRESET_EXT, MediaExportParameters.Preset.DEFAULT.name())));
                this.m_soundFiles.add(soundFile);
            }
        }
    }

    private void writeImageFiles(@NotNull FileManipulator fileManipulator, File rootDir) throws NLBIOException, NLBConsistencyException, NLBFileManipulationException, NLBVCSException {
        File imagesDir = new File(rootDir, "images");
        if (imagesDir.exists()) {
            this.writeMediaFiles(this.m_imageFiles, fileManipulator, imagesDir);
        }
    }

    private void writeSoundFiles(@NotNull FileManipulator fileManipulator, File rootDir) throws NLBIOException, NLBConsistencyException, NLBFileManipulationException, NLBVCSException {
        File soundDir = new File(rootDir, "sound");
        if (soundDir.exists()) {
            this.writeMediaFiles(this.m_soundFiles, fileManipulator, soundDir);
        }
    }

    private void writeMediaFiles(Set<MediaFileImpl> mediaFiles, @NotNull FileManipulator fileManipulator, File mediaDir) throws NLBIOException, NLBConsistencyException, NLBFileManipulationException, NLBVCSException {
        if (mediaDir.exists()) {
            for (MediaFile mediaFile : mediaFiles) {
                File constrIdFile = new File(mediaDir, mediaFile.getFileName() + CONSTRID_EXT);
                if (StringHelper.isEmpty(mediaFile.getConstrId())) {
                    if (constrIdFile.exists()) {
                        fileManipulator.deleteFileOrDir(constrIdFile);
                    }
                } else {
                    fileManipulator.writeOptionalString(mediaDir, constrIdFile.getName(), mediaFile.getConstrId(), DEFAULT_AUTOWIRED_PAGES);
                }
                File redirectFile = new File(mediaDir, mediaFile.getFileName() + REDIRECT_EXT);
                if (StringHelper.isEmpty(mediaFile.getRedirect())) {
                    if (redirectFile.exists()) {
                        fileManipulator.deleteFileOrDir(redirectFile);
                    }
                } else {
                    fileManipulator.writeOptionalString(mediaDir, redirectFile.getName(), mediaFile.getRedirect(), DEFAULT_AUTOWIRED_PAGES);
                }
                File flagFile = new File(mediaDir, mediaFile.getFileName() + FLAG_EXT);
                if (mediaFile.isFlagged()) {
                    fileManipulator.writeOptionalString(mediaDir, flagFile.getName(), String.valueOf(mediaFile.isFlagged()), String.valueOf(false));
                } else if (flagFile.exists()) {
                    fileManipulator.deleteFileOrDir(flagFile);
                }
                File presetFile = new File(mediaDir, mediaFile.getFileName() + PRESET_EXT);
                MediaExportParameters.Preset preset = mediaFile.getMediaExportParameters().getPreset();
                if (preset != MediaExportParameters.Preset.DEFAULT) {
                    fileManipulator.writeOptionalString(mediaDir, presetFile.getName(), preset.name(), MediaExportParameters.Preset.DEFAULT.name());
                    continue;
                }
                if (!presetFile.exists()) continue;
                fileManipulator.deleteFileOrDir(presetFile);
            }
        }
    }

    public void save(FileManipulator fileManipulator, ProgressData progressData, PartialProgressData partialProgressData) throws NLBIOException, NLBConsistencyException, NLBVCSException, NLBFileManipulationException {
        try {
            if (!this.m_rootDir.exists() && !this.m_rootDir.mkdirs()) {
                throw new NLBIOException("Cannot create NLB root directory");
            }
            this.writeSoundFiles(fileManipulator, this.m_rootDir);
            this.writeImageFiles(fileManipulator, this.m_rootDir);
            progressData.setProgressValue(20);
            progressData.setNoteText("Writing variables...");
            this.writeVariables(fileManipulator, this.m_rootDir);
            progressData.setProgressValue(partialProgressData.getStartingProgress());
            progressData.setNoteText("Writing pages and modules...");
            this.writePages(fileManipulator, this.m_rootDir, partialProgressData);
            progressData.setProgressValue(partialProgressData.getMaximumAllowedProgress());
            progressData.setNoteText("Writing objects...");
            this.writeObjs(fileManipulator, this.m_rootDir);
            progressData.setProgressValue(95);
            progressData.setNoteText("Writing book properties...");
            this.writeBookProperties(fileManipulator, this.m_rootDir);
            progressData.setNoteText("Writing autowired pages file...");
            this.writeAutowiredPagesFile(fileManipulator, this.m_rootDir);
            this.writeExternalModuleSupportFiles(fileManipulator);
        }
        catch (IOException e) {
            throw new NLBIOException("IO exception occurred", e);
        }
    }

    private void writeExternalModuleSupportFiles(FileManipulator fileManipulator) throws NLBIOException, NLBVCSException, NLBFileManipulationException {
        File gitignoreFile;
        File modulesDir = new File(this.m_rootDir, MODULES_DIR_NAME);
        if (modulesDir.exists()) {
            if (!modulesDir.isDirectory()) {
                throw new NLBIOException("Modules directory is not a directory");
            }
        } else if (!modulesDir.mkdir()) {
            throw new NLBIOException("Cannot create external modules directory");
        }
        if ((gitignoreFile = new File(this.m_rootDir, GITIGNORE_FILENAME)).exists()) {
            if (!gitignoreFile.isFile()) {
                throw new NLBIOException(".gitignore is not a file");
            }
        } else {
            fileManipulator.writeRequiredString(this.m_rootDir, GITIGNORE_FILENAME, "/modules/");
        }
    }

    private void writePages(FileManipulator fileManipulator, File rootDir, PartialProgressData partialProgressData) throws IOException, NLBIOException, NLBFileManipulationException, NLBVCSException, NLBConsistencyException {
        File pagesDir = new File(rootDir, PAGES_DIR_NAME);
        fileManipulator.createDir(pagesDir, "Cannot create NLB pages directory");
        ArrayList<String> deletedPagesIds = new ArrayList<String>();
        for (PageImpl page : this.m_pages.values()) {
            partialProgressData.setRealProgressValue();
            page.writePage(fileManipulator, pagesDir, this, partialProgressData);
            if (!page.isDeleted()) continue;
            deletedPagesIds.add(page.getId());
        }
        this.removeDeletedPages(deletedPagesIds);
    }

    private void writeObjs(FileManipulator fileManipulator, File rootDir) throws IOException, NLBIOException, NLBFileManipulationException, NLBVCSException {
        File objsDir = new File(rootDir, OBJS_DIR_NAME);
        fileManipulator.createDir(objsDir, "Cannot create NLB objs directory");
        ArrayList<String> deletedObjsIds = new ArrayList<String>();
        for (ObjImpl obj : this.m_objs.values()) {
            obj.writeObj(fileManipulator, objsDir, this);
            if (!obj.isDeleted()) continue;
            deletedObjsIds.add(obj.getId());
        }
        this.removeDeletedObjs(deletedObjsIds);
    }

    private void writeVariables(FileManipulator fileManipulator, File rootDir) throws IOException, NLBIOException, NLBConsistencyException, NLBFileManipulationException, NLBVCSException {
        File varsDir = new File(rootDir, VARS_DIR_NAME);
        fileManipulator.createDir(varsDir, "Cannot create NLB vars directory");
        ArrayList<String> deletedVarsIds = new ArrayList<String>();
        for (VariableImpl variable : this.m_variables) {
            this.preprocessVariable(variable);
            variable.writeVariable(fileManipulator, varsDir);
            if (!variable.isDeleted()) continue;
            deletedVarsIds.add(variable.getId());
        }
        this.removeDeletedVariables(deletedVarsIds);
    }

    protected void writeAutowiredPagesFile(FileManipulator fileManipulator, File rootDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        StringBuilder sb = new StringBuilder();
        int lastElemIndex = this.m_autowiredPages.size() - 1;
        if (lastElemIndex >= 0) {
            for (int i = 0; i < lastElemIndex; ++i) {
                String pageId = this.m_autowiredPages.get(i);
                if (this.getPageImplById(pageId).isDeleted()) continue;
                sb.append(pageId).append(AUTOWIRED_SEPARATOR);
            }
            String lastPageId = this.m_autowiredPages.get(lastElemIndex);
            if (!this.getPageImplById(lastPageId).isDeleted()) {
                sb.append(lastPageId);
            }
            fileManipulator.writeOptionalString(rootDir, AUTOWIRED_PAGES_FILE_NAME, String.valueOf(sb.toString()), DEFAULT_AUTOWIRED_PAGES);
        } else {
            fileManipulator.writeOptionalString(rootDir, AUTOWIRED_PAGES_FILE_NAME, DEFAULT_AUTOWIRED_PAGES, DEFAULT_AUTOWIRED_PAGES);
        }
    }

    protected void readAutowiredPagesFile(File rootDir) throws NLBIOException, NLBConsistencyException {
        String autowiredPagesString = FileManipulator.getOptionalFileAsString(rootDir, AUTOWIRED_PAGES_FILE_NAME, DEFAULT_AUTOWIRED_PAGES);
        if (!autowiredPagesString.isEmpty()) {
            this.m_autowiredPages.clear();
            List<String> autowiredPages = Arrays.asList(autowiredPagesString.split(AUTOWIRED_SEPARATOR));
            for (String pageId : autowiredPages) {
                this.m_autowiredPages.add(pageId);
            }
        }
    }

    private void preprocessVariable(VariableImpl variable) throws NLBConsistencyException {
        if (variable.getType() == Variable.Type.PAGE || variable.getType() == Variable.Type.TIMER) {
            this.preprocessPageRelatedVariable(variable);
        } else if (variable.getType() == Variable.Type.OBJ || variable.getType() == Variable.Type.OBJCONSTRAINT || variable.getType() == Variable.Type.OBJREF) {
            this.preprocessObjRelatedVariable(variable);
        } else if (variable.getType() == Variable.Type.LINK || variable.getType() == Variable.Type.LINKCONSTRAINT) {
            Link link = this.getLinkWithCheck(variable);
            assert (link != null);
            if (link.isDeleted() || link.hasDeletedParent()) {
                variable.setDeleted(true);
            }
        } else if (variable.getType() == Variable.Type.VAR || variable.getType() == Variable.Type.EXPRESSION || variable.getType() == Variable.Type.TAG) {
            ModifyingItemAndModification itemAndModification = this.getModifyingItemAndModification(variable);
            if (!itemAndModification.existsAndValid()) {
                if (variable.getType() == Variable.Type.TAG) {
                    if (!this.preprocessObjRelatedVariable(variable) && !this.preprocessPageRelatedVariable(variable)) {
                        variable.setDeleted(true);
                    }
                } else {
                    variable.setDeleted(true);
                }
            }
        } else if (variable.getType() == Variable.Type.MODCONSTRAINT || variable.getType() == Variable.Type.AUTOWIRECONSTRAINT) {
            Page page = this.getPageById(variable.getTarget());
            assert (page != null);
            if (page.isDeleted()) {
                variable.setDeleted(true);
            }
        }
    }

    private boolean preprocessObjRelatedVariable(VariableImpl variable) throws NLBConsistencyException {
        String id = variable.getId();
        Obj obj = this.getObjById(variable.getTarget());
        if (obj == null) {
            return false;
        }
        if (variable.isDeleted() && (id.equals(obj.getVarId()) || id.equals(obj.getConstrId()) || id.equals(obj.getCommonToId()) || id.equals(obj.getMorphOverId()) || id.equals(obj.getMorphOutId()))) {
            throw new NLBConsistencyException("Obj variable for obj with Id = " + obj.getId() + " is incorrect, because the corresponding variable with Id = " + id + " has been deleted");
        }
        if (obj.isDeleted()) {
            variable.setDeleted(true);
        }
        return true;
    }

    private boolean preprocessPageRelatedVariable(VariableImpl variable) throws NLBConsistencyException {
        String id = variable.getId();
        PageImpl page = this.getPageImplById(variable.getTarget());
        if (page == null) {
            return false;
        }
        if (variable.isDeleted() && id.equals(page.getVarId())) {
            throw new NLBConsistencyException("Page (or timer) variable for page with Id = " + page.getId() + " is incorrect, because the corresponding variable with Id = " + id + " has been deleted");
        }
        if (page.isDeleted()) {
            variable.setDeleted(true);
        }
        return true;
    }

    private Link getLinkWithCheck(VariableImpl variable) throws NLBConsistencyException {
        String[] ids = StringHelper.getItems(variable.getTarget());
        NodeItem nodeItem = this.getPageById(ids[0]);
        if (nodeItem == null) {
            nodeItem = this.getObjById(ids[0]);
        }
        Link link = nodeItem.getLinkById(ids[1]);
        if (variable.isDeleted()) {
            if (variable.getType() == Variable.Type.LINK) {
                if (variable.getId().equals(link.getVarId())) {
                    throw new NLBConsistencyException("Link variable for link with full Id = " + variable.getTarget() + " is incorrect, because the corresponding variable with Id = " + variable.getId() + " has been deleted");
                }
            } else if (variable.getType() == Variable.Type.LINKCONSTRAINT && variable.getId().equals(link.getConstrId())) {
                throw new NLBConsistencyException("Link constraint for link with full Id = " + variable.getTarget() + " is incorrect, because the corresponding variable with Id = " + variable.getId() + " has been deleted");
            }
        }
        return link;
    }

    private ModifyingItemAndModification getModifyingItemAndModification(VariableImpl variable) throws NLBConsistencyException {
        ModificationImpl modification;
        LinkImpl link;
        ModifyingItemAndModification result = new ModifyingItemAndModification();
        String[] ids = StringHelper.getItems(variable.getTarget());
        AbstractNodeItem nodeItem = this.getPageImplById(ids[0]);
        if (nodeItem == null) {
            nodeItem = this.getObjImplById(ids[0]);
        }
        if (nodeItem == null) {
            throw new NLBConsistencyException("Cannot find target page or obj with id = " + ids[0] + " for variable with id = " + variable.getId());
        }
        if (ids.length > 2) {
            link = nodeItem.getLinkById(ids[1]);
            if (link == null) {
                throw new NLBConsistencyException("Cannot find target link with id = " + ids[1] + " in page with id = " + ids[0] + " for variable with id = " + variable.getId());
            }
            modification = link.getModificationById(ids[2]);
            if (modification == null) {
                throw new NLBConsistencyException("Cannot find target modification with id = " + ids[2] + " in page with id = " + ids[0] + " and link with id = " + ids[1] + " for variable with id = " + variable.getId());
            }
        } else if (ids.length > 1) {
            link = null;
            modification = nodeItem.getModificationById(ids[1]);
            if (modification == null) {
                throw new NLBConsistencyException("Cannot find target modification with id = " + ids[1] + " in page with id = " + ids[0] + " for variable with id = " + variable.getId());
            }
        } else {
            result.setModifyingItem(null);
            result.setModification(null);
            return result;
        }
        if (variable.isDeleted()) {
            if (variable.getType() == Variable.Type.VAR) {
                if (variable.getId().equals(modification.getVarId())) {
                    throw new NLBConsistencyException("Modification variable for modification with full Id = " + variable.getTarget() + " is incorrect, because the corresponding variable with Id = " + variable.getId() + " has been deleted");
                }
            } else if ((variable.getType() == Variable.Type.EXPRESSION || variable.getType() == Variable.Type.TAG) && variable.getId().equals(modification.getExprId())) {
                throw new NLBConsistencyException("Modification expression for modification with full Id = " + variable.getTarget() + " is incorrect, because the corresponding variable with Id = " + variable.getId() + " has been deleted");
            }
        }
        result.setModifyingItem(link != null ? link : nodeItem);
        result.setModification(modification);
        return result;
    }

    private void removeDeletedPages(List<String> pagesIds) {
        for (String pageId : pagesIds) {
            this.m_pages.remove(pageId);
        }
    }

    private void removeDeletedObjs(List<String> objsIds) {
        for (String objId : objsIds) {
            this.m_pages.remove(objId);
        }
    }

    private void removeDeletedVariables(List<String> varIds) {
        ListIterator<VariableImpl> variablesIterator = this.m_variables.listIterator();
        while (variablesIterator.hasNext()) {
            VariableImpl variable = variablesIterator.next();
            for (String varId : varIds) {
                if (!variable.getId().equals(varId)) continue;
                variablesIterator.remove();
            }
        }
    }

    private void writeBookProperties(FileManipulator fileManipulator, File rootDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        fileManipulator.writeOptionalString(rootDir, STARTPOINT_FILE_NAME, this.m_startPoint, DEFAULT_AUTOWIRED_PAGES);
        fileManipulator.writeOptionalString(rootDir, PERFECT_GAME_ACHIEVEMENT_FILE_NAME, this.m_perfectGameAchievementName, DEFAULT_AUTOWIRED_PAGES);
        fileManipulator.writeOptionalString(rootDir, THEME_FILE_NAME, this.m_theme.name(), DEFAULT_THEME.name());
        if (this.m_parentNLB != null) {
            fileManipulator.writeOptionalString(rootDir, LANGUAGE_FILE_NAME, this.m_language, this.m_parentNLB.getLanguage());
            fileManipulator.writeOptionalString(rootDir, LICENSE_FILE_NAME, this.m_license, this.m_parentNLB.getLicense());
            fileManipulator.writeOptionalString(rootDir, FULLAUTO_FILE_NAME, String.valueOf(this.m_fullAutowire), String.valueOf(this.m_parentNLB.isFullAutowire()));
            fileManipulator.writeOptionalString(rootDir, SUPPRESS_MEDIA_FILE_NAME, String.valueOf(this.m_suppressMedia), String.valueOf(this.m_parentNLB.isSuppressMedia()));
            fileManipulator.writeOptionalString(rootDir, SUPPRESS_SOUND_FILE_NAME, String.valueOf(this.m_suppressSound), String.valueOf(this.m_parentNLB.isSuppressSound()));
            fileManipulator.writeOptionalString(rootDir, TITLE_FILE_NAME, this.m_title, this.m_parentNLB.getTitle());
            fileManipulator.writeOptionalString(rootDir, AUTHOR_FILE_NAME, this.m_author, this.m_parentNLB.getAuthor());
            fileManipulator.writeOptionalString(rootDir, VERSION_FILE_NAME, this.m_version, this.m_parentNLB.getVersion());
        } else {
            fileManipulator.writeRequiredString(rootDir, LANGUAGE_FILE_NAME, this.m_language);
            fileManipulator.writeOptionalString(rootDir, LICENSE_FILE_NAME, this.m_license, DEFAULT_AUTOWIRED_PAGES);
            fileManipulator.writeOptionalString(rootDir, FULLAUTO_FILE_NAME, String.valueOf(this.m_fullAutowire), String.valueOf(false));
            fileManipulator.writeOptionalString(rootDir, SUPPRESS_MEDIA_FILE_NAME, String.valueOf(this.m_suppressMedia), String.valueOf(false));
            fileManipulator.writeOptionalString(rootDir, SUPPRESS_SOUND_FILE_NAME, String.valueOf(this.m_suppressSound), String.valueOf(false));
            fileManipulator.writeOptionalString(rootDir, TITLE_FILE_NAME, this.m_title, DEFAULT_AUTOWIRED_PAGES);
            fileManipulator.writeOptionalString(rootDir, AUTHOR_FILE_NAME, this.m_author, DEFAULT_AUTOWIRED_PAGES);
            fileManipulator.writeOptionalString(rootDir, VERSION_FILE_NAME, this.m_version, DEFAULT_AUTOWIRED_PAGES);
        }
    }

    @Override
    public Variable getVariableById(String varId) {
        VariableImpl result = this.getVariableImplById(varId);
        if (result != null) {
            return result;
        }
        if (this.m_parentNLB != null) {
            return this.m_parentNLB.getVariableById(varId);
        }
        return this.getAutowiredVariable(varId);
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> result = new ArrayList<Variable>();
        result.addAll(this.m_variables);
        return result;
    }

    private VariableImpl getVariableImplById(String varId) {
        if (!StringHelper.isEmpty(varId)) {
            for (VariableImpl variable : this.m_variables) {
                if (!variable.getId().equals(varId)) continue;
                return variable;
            }
        }
        return this.getAutowiredVariable(varId);
    }

    private VariableImpl getAutowiredVariable(String varId) {
        if ("TRUE".equals(varId)) {
            VariableImpl variable = new VariableImpl();
            variable.setType(Variable.Type.EXPRESSION);
            variable.setDataType(Variable.DataType.BOOLEAN);
            variable.setValue("true");
            return variable;
        }
        if ("FALSE".equals(varId)) {
            VariableImpl variable = new VariableImpl();
            variable.setType(Variable.Type.EXPRESSION);
            variable.setDataType(Variable.DataType.BOOLEAN);
            variable.setValue("false");
            return variable;
        }
        String[] ids = NonLinearBookImpl.parseIds(varId);
        for (Page page : this.getDownwardPagesHeirarchy().values()) {
            if (varId == null || !varId.endsWith(page.getId())) continue;
            VariableImpl variable = new VariableImpl();
            boolean isLinkConstraint = varId.startsWith("LC_");
            variable.setType(isLinkConstraint ? Variable.Type.LINKCONSTRAINT : Variable.Type.VAR);
            variable.setDataType(Variable.DataType.BOOLEAN);
            if (isLinkConstraint) {
                VariableImpl autowiredOutConstraint = null;
                PageImpl autowiredPage = null;
                Matcher matcher = AUTOWIRED_OUT_PATTERN.matcher(varId);
                if (matcher.find()) {
                    String autowiredPageId = matcher.group(1);
                    autowiredPage = this.getPageImplById(autowiredPageId);
                    autowiredOutConstraint = this.getVariableImplById(autowiredPage.getAutowireOutConstrId());
                }
                variable.setValue(SpecialVariablesNameHelper.decorateId(page.getId(), autowiredPage != null ? autowiredPage.getId() : ids[0]) + (autowiredOutConstraint != null ? " && " + autowiredOutConstraint.getValue() : DEFAULT_AUTOWIRED_PAGES));
            } else {
                variable.setName(SpecialVariablesNameHelper.decorateId(page.getId(), ids[0]));
            }
            return variable;
        }
        return null;
    }

    private static String[] parseIds(String varId) {
        return varId != null ? varId.split("_") : null;
    }

    @Override
    public SearchResultTableModel getLeafs(String modulePageId) {
        SearchResultTableModel result = new SearchResultTableModel();
        for (Map.Entry<String, PageImpl> entry : this.m_pages.entrySet()) {
            PageImpl page = entry.getValue();
            if (page.isLeaf()) {
                result.addSearchResult(new SearchResult(page.getId(), modulePageId, page.getCaption()));
            }
            if (page.getModule().isEmpty()) continue;
            result.addSearchResultTableModel(page.getModuleImpl().getLeafs(page.getId()));
        }
        return result;
    }

    @Override
    public SearchResultTableModel searchText(SearchContract contract, String modulePageId) {
        SearchResultTableModel result = new SearchResultTableModel();
        if (contract.isSearchInPages()) {
            for (Map.Entry<String, AbstractNodeItem> entry : this.m_pages.entrySet()) {
                PageImpl page = (PageImpl)entry.getValue();
                if (page.isDeleted()) continue;
                SearchResult pageResult = page.searchText(contract);
                if (pageResult != null) {
                    pageResult.setModulePageId(modulePageId);
                    result.addSearchResult(pageResult);
                } else if (contract.isSearchInVars()) {
                    SearchResult varResult;
                    VariableImpl variable = this.getVariableImplById(page.getVarId());
                    VariableImpl variableTimer = this.getVariableImplById(page.getTimerVarId());
                    VariableImpl variableDefTag = this.getVariableImplById(page.getDefaultTagId());
                    if (variable != null && (varResult = variable.searchText(contract)) != null) {
                        varResult.setId(page.getId());
                        varResult.setModulePageId(modulePageId);
                        result.addSearchResult(varResult);
                    }
                    if (variableTimer != null && (varResult = variableTimer.searchText(contract)) != null) {
                        varResult.setId(page.getId());
                        varResult.setModulePageId(modulePageId);
                        result.addSearchResult(varResult);
                    }
                    if (variableDefTag != null && (varResult = variableDefTag.searchText(contract)) != null) {
                        varResult.setId(page.getId());
                        varResult.setModulePageId(modulePageId);
                        result.addSearchResult(varResult);
                    }
                    result.addSearchResults(this.getModificationSearchResults(page, contract));
                }
                NonLinearBookImpl moduleImpl = page.getModuleImpl();
                if (!moduleImpl.isEmpty()) {
                    result.addSearchResultTableModel(moduleImpl.searchText(new SearchContract(contract.getSearchText(), contract.isSearchInIds(), contract.isSearchInPages(), contract.isSearchInObjects(), contract.isSearchInLinks(), contract.isSearchInVars(), contract.isIgnoreCase(), contract.isWholeWords(), PropertyManager.getSettings().getDefaultConfig().getGeneral().isFindUnusualQuotes()), page.getId()));
                }
                if (!contract.isSearchInLinks()) continue;
                this.searchLinks(modulePageId, page, result, contract);
            }
        }
        if (contract.isSearchInObjects()) {
            for (Map.Entry<String, AbstractNodeItem> entry : this.m_objs.entrySet()) {
                ObjImpl obj = (ObjImpl)entry.getValue();
                if (obj.isDeleted()) continue;
                SearchResult objResult = obj.searchText(contract);
                if (objResult != null) {
                    objResult.setModulePageId(modulePageId);
                    result.addSearchResult(objResult);
                } else {
                    VariableImpl variable = this.getVariableImplById(obj.getVarId());
                    VariableImpl deftag = this.getVariableImplById(obj.getDefaultTagId());
                    VariableImpl constraint = this.getVariableImplById(obj.getConstrId());
                    VariableImpl commonto = this.getVariableImplById(obj.getCommonToId());
                    VariableImpl morphOver = this.getVariableImplById(obj.getMorphOverId());
                    VariableImpl morphOut = this.getVariableImplById(obj.getMorphOutId());
                    if (contract.isSearchInVars()) {
                        SearchResult morphOutResult;
                        SearchResult morphOverResult;
                        SearchResult commontoResult;
                        SearchResult constrResult;
                        SearchResult deftagResult;
                        SearchResult varResult;
                        if (variable != null && (varResult = variable.searchText(contract)) != null) {
                            varResult.setId(obj.getId());
                            varResult.setModulePageId(modulePageId);
                            result.addSearchResult(varResult);
                        }
                        if (deftag != null && (deftagResult = deftag.searchText(contract)) != null) {
                            deftagResult.setId(obj.getId());
                            deftagResult.setModulePageId(modulePageId);
                            result.addSearchResult(deftagResult);
                        }
                        if (constraint != null && (constrResult = constraint.searchText(contract)) != null) {
                            constrResult.setId(obj.getId());
                            constrResult.setModulePageId(modulePageId);
                            result.addSearchResult(constrResult);
                        }
                        if (commonto != null && (commontoResult = commonto.searchText(contract)) != null) {
                            commontoResult.setId(obj.getId());
                            commontoResult.setModulePageId(modulePageId);
                            result.addSearchResult(commontoResult);
                        }
                        if (morphOver != null && (morphOverResult = morphOver.searchText(contract)) != null) {
                            morphOverResult.setId(obj.getId());
                            morphOverResult.setModulePageId(modulePageId);
                            result.addSearchResult(morphOverResult);
                        }
                        if (morphOut != null && (morphOutResult = morphOut.searchText(contract)) != null) {
                            morphOutResult.setId(obj.getId());
                            morphOutResult.setModulePageId(modulePageId);
                            result.addSearchResult(morphOutResult);
                        }
                        result.addSearchResults(this.getModificationSearchResults(obj, contract));
                    }
                }
                if (!contract.isSearchInLinks()) continue;
                this.searchLinks(modulePageId, obj, result, contract);
            }
        }
        return result;
    }

    private List<SearchResult> getModificationSearchResults(ModifyingItem item, SearchContract contract) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        List<Modification> modifications = item.getModifications();
        for (Modification modification : modifications) {
            SearchResult modificationResult = modification.searchText(contract);
            if (modificationResult == null) continue;
            results.add(modificationResult);
        }
        return results;
    }

    @Override
    public SearchResultTableModel getVariables(String modulePageId) throws NLBConsistencyException {
        SearchResultTableModel result = new SearchResultTableModel("Type", "Name", "Value");
        for (VariableImpl variableImpl : this.m_variables) {
            if (variableImpl.isDeleted()) continue;
            SearchResult searchResult = new SearchResult();
            searchResult.setModulePageId(modulePageId);
            Variable.Type type = variableImpl.getType();
            searchResult.addInformation(type.name());
            searchResult.addInformation(variableImpl.getName());
            searchResult.addInformation(variableImpl.getValue());
            switch (type) {
                case PAGE: 
                case TIMER: {
                    Page page = this.getPageById(variableImpl.getTarget());
                    if (page.isDeleted()) break;
                    searchResult.setId(page.getId());
                    result.addSearchResult(searchResult);
                    break;
                }
                case OBJ: 
                case OBJCONSTRAINT: 
                case OBJREF: {
                    Obj obj = this.getObjById(variableImpl.getTarget());
                    if (obj.isDeleted()) break;
                    searchResult.setId(obj.getId());
                    result.addSearchResult(searchResult);
                    break;
                }
                case LINK: 
                case LINKCONSTRAINT: {
                    Link link = this.getLinkWithCheck(variableImpl);
                    if (link.isDeleted()) break;
                    searchResult.setId(link.getId());
                    result.addSearchResult(searchResult);
                    break;
                }
                case VAR: 
                case TAG: 
                case EXPRESSION: {
                    ModifyingItemAndModification itemAndModification = this.getModifyingItemAndModification(variableImpl);
                    if (!itemAndModification.existsAndValid()) break;
                    searchResult.setId(itemAndModification.getModifyingItem().getId());
                    result.addSearchResult(searchResult);
                    break;
                }
                case MODCONSTRAINT: 
                case AUTOWIRECONSTRAINT: {
                    Page targetPage = this.getPageById(variableImpl.getTarget());
                    if (targetPage.isDeleted()) break;
                    searchResult.setId(targetPage.getId());
                    result.addSearchResult(searchResult);
                    break;
                }
            }
        }
        for (Map.Entry entry : this.m_pages.entrySet()) {
            NonLinearBookImpl moduleImpl = ((PageImpl)entry.getValue()).getModuleImpl();
            if (moduleImpl.isEmpty()) continue;
            result.addSearchResultTableModel(moduleImpl.getVariables(((PageImpl)entry.getValue()).getId()));
        }
        return result;
    }

    @Override
    public SearchResultTableModel checkBook(String modulePageId) throws NLBConsistencyException {
        SearchResultTableModel result = new SearchResultTableModel("Type", "Value", "Problem");
        for (Map.Entry<String, PageImpl> entry : this.m_pages.entrySet()) {
            PageImpl page = entry.getValue();
            if (StringHelper.isEmpty(page.getReturnPageId())) continue;
            SearchResult searchResult = new SearchResult();
            searchResult.setModulePageId(modulePageId);
            searchResult.addInformation("Return page");
            searchResult.addInformation(page.getReturnPageId());
            searchResult.setId(page.getId());
            if (this.m_parentNLB != null) {
                Page targetPage = this.m_parentNLB.getPages().get(page.getReturnPageId());
                if (targetPage != null && !targetPage.isDeleted()) continue;
                searchResult.addInformation("Referenced page cannot be found in the parent book");
                result.addSearchResult(searchResult);
                continue;
            }
            searchResult.addInformation("No parent book exists to return to");
            result.addSearchResult(searchResult);
        }
        block6: for (VariableImpl variableImpl : this.m_variables) {
            if (variableImpl.isDeleted()) continue;
            SearchResult searchResult = new SearchResult();
            searchResult.setModulePageId(modulePageId);
            Variable.Type type = variableImpl.getType();
            searchResult.addInformation(type.name());
            searchResult.addInformation(variableImpl.getValue());
            switch (type) {
                case LINKCONSTRAINT: {
                    Link link = this.getLinkWithCheck(variableImpl);
                    if (link.isDeleted()) break;
                    String error = this.checkFormula(variableImpl.getValue().trim());
                    if (error == null) continue block6;
                    searchResult.addInformation(error);
                    searchResult.setId(link.getId());
                    result.addSearchResult(searchResult);
                    break;
                }
                case TAG: 
                case EXPRESSION: {
                    ModifyingItemAndModification itemAndModification = this.getModifyingItemAndModification(variableImpl);
                    if (!itemAndModification.existsAndValid()) break;
                    String error = this.checkFormula(variableImpl.getValue().trim());
                    if (error == null) continue block6;
                    searchResult.addInformation(error);
                    searchResult.setId(itemAndModification.getModifyingItem().getId());
                    result.addSearchResult(searchResult);
                    break;
                }
                case MODCONSTRAINT: 
                case AUTOWIRECONSTRAINT: {
                    Page targetPage = this.getPageById(variableImpl.getTarget());
                    if (targetPage.isDeleted()) break;
                    String error = this.checkFormula(variableImpl.getValue().trim());
                    if (error == null) continue block6;
                    searchResult.addInformation(error);
                    searchResult.setId(targetPage.getId());
                    result.addSearchResult(searchResult);
                    break;
                }
            }
        }
        for (Map.Entry entry : this.m_pages.entrySet()) {
            NonLinearBookImpl moduleImpl = ((PageImpl)entry.getValue()).getModuleImpl();
            if (moduleImpl.isEmpty()) continue;
            result.addSearchResultTableModel(moduleImpl.checkBook(((PageImpl)entry.getValue()).getId()));
        }
        return result;
    }

    private int getCharacterCount() {
        int result = 0;
        for (Map.Entry<String, PageImpl> entry : this.m_pages.entrySet()) {
            result += entry.getValue().getText().length();
            for (LinkImpl link : entry.getValue().getLinkImpls()) {
                result += link.getText().length();
                result += link.getAltText().length();
            }
        }
        for (Map.Entry<String, AbstractNodeItem> entry : this.m_objs.entrySet()) {
            result += ((ObjImpl)entry.getValue()).getText().length();
            result += ((ObjImpl)entry.getValue()).getActText().length();
            result += ((ObjImpl)entry.getValue()).getNouseText().length();
            for (LinkImpl link : ((ObjImpl)entry.getValue()).getLinkImpls()) {
                result += link.getText().length();
                result += link.getAltText().length();
            }
        }
        return result;
    }

    @Override
    public NonLinearBook.BookStatistics getBookStatistics() {
        return this.getBookStatistics(0, false);
    }

    private NonLinearBook.BookStatistics getBookStatistics(int depth, boolean deletedModule) {
        NonLinearBook.BookStatistics result = new NonLinearBook.BookStatistics();
        result.incCharactersCount(this.getCharacterCount());
        int objsCount = 0;
        int pagesCount = 0;
        int uniqueEndingsCount = 0;
        for (Map.Entry<String, ObjImpl> entry : this.m_objs.entrySet()) {
            if (entry.getValue().isDeleted()) continue;
            ++objsCount;
        }
        result.incObjsCount(objsCount);
        for (Map.Entry<String, AbstractNodeItem> entry : this.m_pages.entrySet()) {
            PageImpl page = (PageImpl)entry.getValue();
            if (!page.isDeleted() && !deletedModule) {
                ++pagesCount;
                if (page.isLeaf()) {
                    ++uniqueEndingsCount;
                }
                if (page.getModule().isEmpty()) continue;
                result.addModuleInfo(new NonLinearBook.ModuleInfo(page.getId(), page.getModuleName(), depth));
                result.addBookStatistics(page.getModuleImpl().getBookStatistics(depth + 1, false));
                continue;
            }
            if (page.getModule().isEmpty()) continue;
            result.addModuleToBeDeletedInfo(new NonLinearBook.ModuleInfo(page.getId(), page.getModuleName(), depth));
            result.addDeletedModulesFromBookStatistics(page.getModuleImpl().getBookStatistics(depth + 1, true));
        }
        result.incPagesCount(pagesCount);
        result.incUniqueEndings(uniqueEndingsCount);
        return result;
    }

    public int getEffectivePagesCountForSave() {
        int pagesCount = 0;
        for (Map.Entry<String, PageImpl> pageEntry : this.m_pages.entrySet()) {
            ++pagesCount;
            PageImpl page = pageEntry.getValue();
            if (page.isDeleted() || page.getModule().isEmpty()) continue;
            pagesCount += page.getModuleImpl().getEffectivePagesCountForSave();
        }
        return pagesCount;
    }

    @Override
    public NonLinearBook.VariableStatistics getVariableStatistics() {
        NonLinearBook.VariableStatistics result = new NonLinearBook.VariableStatistics();
        for (VariableImpl variable : this.m_variables) {
            if (variable.isDeleted()) continue;
            Variable.Type type = variable.getType();
            switch (type) {
                case PAGE: {
                    result.incPageVariablesCount();
                    break;
                }
                case TIMER: {
                    result.incPageTimerVariablesCount();
                    break;
                }
                case OBJ: {
                    result.incObjVariablesCount();
                    break;
                }
                case OBJCONSTRAINT: {
                    result.incObjConstraintsCount();
                    break;
                }
                case OBJREF: {
                    result.incObjRefsCount();
                    break;
                }
                case LINK: {
                    result.incLinkVariablesCount();
                    break;
                }
                case LINKCONSTRAINT: {
                    result.incLinkConstraintVariablesCount();
                    break;
                }
                case VAR: {
                    result.incPlainVariablesCount();
                    break;
                }
                case TAG: 
                case EXPRESSION: {
                    result.incExpressionsCount();
                    break;
                }
                case MODCONSTRAINT: {
                    result.incModuleConstraintCount();
                    break;
                }
                case AUTOWIRECONSTRAINT: {
                    result.incAutowireConstraintCount();
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public NonLinearBook getParentNLB() {
        return this.m_parentNLB;
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public Page getParentPage() {
        return this.m_parentPage;
    }

    @Override
    public Map<String, NonLinearBook> getExternalModules() {
        return this.m_externalModules;
    }

    @Override
    public NonLinearBook findExternalModule(String name) {
        for (Map.Entry<String, NonLinearBook> entry : this.m_externalModules.entrySet()) {
            if (!entry.getKey().equals(name)) continue;
            return entry.getValue();
        }
        return this.m_parentNLB.findExternalModule(name);
    }

    @Override
    public Map<String, Variable.DataType> getVariableDataTypes() throws NLBConsistencyException {
        HashMap<String, Variable.DataType> result = new HashMap<String, Variable.DataType>();
        for (VariableImpl variableImpl : this.m_variables) {
            if (variableImpl.isDeleted()) continue;
            Variable.Type type = variableImpl.getType();
            switch (type) {
                case PAGE: 
                case TIMER: {
                    Page page = this.getPageById(variableImpl.getTarget());
                    if (page.isDeleted()) break;
                    result.put(variableImpl.getName(), variableImpl.getDataType());
                    break;
                }
                case OBJ: {
                    Obj obj = this.getObjById(variableImpl.getTarget());
                    if (obj.isDeleted()) break;
                    result.put(variableImpl.getName(), variableImpl.getDataType());
                    break;
                }
                case LINK: {
                    Link link = this.getLinkWithCheck(variableImpl);
                    if (link.isDeleted()) break;
                    result.put(variableImpl.getName(), variableImpl.getDataType());
                    break;
                }
                case VAR: {
                    ModifyingItemAndModification itemAndModification = this.getModifyingItemAndModification(variableImpl);
                    if (!itemAndModification.existsAndValid()) break;
                    Variable modificationVariable = this.getVariableById(itemAndModification.getModification().getVarId());
                    result.put(modificationVariable.getName(), modificationVariable.getDataType());
                    break;
                }
            }
        }
        for (Map.Entry entry : this.m_objs.entrySet()) {
            for (Link link : ((ObjImpl)entry.getValue()).getLinks()) {
                if (!link.isOnce()) continue;
                result.put(SpecialVariablesNameHelper.decorateLinkVisitStateVar(link.getId()), Variable.DataType.BOOLEAN);
            }
        }
        for (Map.Entry entry : this.m_pages.entrySet()) {
            for (Map.Entry entry2 : this.getUpwardPagesHeirarchy().entrySet()) {
                if (!((Page)entry2.getValue()).isAutowire()) continue;
                result.put(SpecialVariablesNameHelper.decorateId((String)entry.getKey(), (String)entry2.getKey()), Variable.DataType.BOOLEAN);
            }
            for (Link link : ((PageImpl)entry.getValue()).getLinks()) {
                if (!link.isOnce()) continue;
                result.put(SpecialVariablesNameHelper.decorateLinkVisitStateVar(link.getId()), Variable.DataType.BOOLEAN);
            }
            NonLinearBookImpl moduleImpl = ((PageImpl)entry.getValue()).getModuleImpl();
            if (moduleImpl.isEmpty()) continue;
            result.putAll(moduleImpl.getVariableDataTypes());
        }
        return result;
    }

    @Override
    public Map<String, String> getMediaToConstraintMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.getMediaToConstraintMapForModule());
        for (Map.Entry<String, NonLinearBook> entry : this.getExternalModules().entrySet()) {
            Map<String, String> moduleResult = entry.getValue().getMediaToConstraintMap();
            for (Map.Entry<String, String> moduleEntry : moduleResult.entrySet()) {
                result.put(entry.getKey() + "/" + moduleEntry.getKey(), moduleEntry.getValue());
            }
        }
        return result;
    }

    public Map<String, String> getMediaToConstraintMapForModule() {
        HashMap<String, String> result = new HashMap<String, String>();
        List<MediaFile> imageFiles = this.getImageFiles();
        for (MediaFile mediaFile : imageFiles) {
            if (!StringHelper.notEmpty(mediaFile.getConstrId())) continue;
            result.put(mediaFile.getFileName(), this.getVariableById(mediaFile.getConstrId()).getValue());
        }
        List<MediaFile> soundFiles = this.getSoundFiles();
        for (MediaFile mediaFile : soundFiles) {
            if (!StringHelper.notEmpty(mediaFile.getConstrId())) continue;
            result.put(mediaFile.getFileName(), this.getVariableById(mediaFile.getConstrId()).getValue());
        }
        return result;
    }

    @Override
    public Map<String, String> getMediaRedirectsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        List<MediaFile> imageFiles = this.getImageFiles();
        for (MediaFile mediaFile : imageFiles) {
            if (!StringHelper.notEmpty(mediaFile.getRedirect())) continue;
            result.put(mediaFile.getFileName(), mediaFile.getRedirect());
        }
        List<MediaFile> soundFiles = this.getSoundFiles();
        for (MediaFile mediaFile : soundFiles) {
            if (!StringHelper.notEmpty(mediaFile.getRedirect())) continue;
            result.put(mediaFile.getFileName(), mediaFile.getRedirect());
        }
        return result;
    }

    @Override
    public Map<String, MediaExportParameters> getMediaExportParametersMap() {
        HashMap<String, MediaExportParameters> result = new HashMap<String, MediaExportParameters>();
        result.putAll(this.getMediaExportParametersMapForModule());
        for (Map.Entry<String, NonLinearBook> entry : this.getExternalModules().entrySet()) {
            Map<String, MediaExportParameters> moduleResult = entry.getValue().getMediaExportParametersMap();
            for (Map.Entry<String, MediaExportParameters> moduleEntry : moduleResult.entrySet()) {
                result.put(entry.getKey() + "/" + moduleEntry.getKey(), moduleEntry.getValue());
            }
        }
        return result;
    }

    private Map<String, MediaExportParameters> getMediaExportParametersMapForModule() {
        HashMap<String, MediaExportParameters> result = new HashMap<String, MediaExportParameters>();
        List<MediaFile> imageFiles = this.getImageFiles();
        for (MediaFile mediaFile : imageFiles) {
            if (mediaFile.getMediaExportParameters().getPreset() == MediaExportParameters.Preset.DEFAULT) continue;
            result.put(mediaFile.getFileName(), mediaFile.getMediaExportParameters());
        }
        List<MediaFile> soundFiles = this.getSoundFiles();
        for (MediaFile mediaFile : soundFiles) {
            if (mediaFile.getMediaExportParameters().getPreset() == MediaExportParameters.Preset.DEFAULT) continue;
            result.put(mediaFile.getFileName(), mediaFile.getMediaExportParameters());
        }
        return result;
    }

    @Override
    public Map<String, Boolean> getMediaFlagsMap() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.putAll(this.getMediaFlagsMapForModule());
        for (Map.Entry<String, NonLinearBook> entry : this.getExternalModules().entrySet()) {
            Map<String, Boolean> moduleResult = entry.getValue().getMediaFlagsMap();
            for (Map.Entry<String, Boolean> moduleEntry : moduleResult.entrySet()) {
                result.put(entry.getKey() + "/" + moduleEntry.getKey(), moduleEntry.getValue());
            }
        }
        return result;
    }

    private Map<String, Boolean> getMediaFlagsMapForModule() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        List<MediaFile> imageFiles = this.getImageFiles();
        for (MediaFile mediaFile : imageFiles) {
            result.put(mediaFile.getFileName(), mediaFile.isFlagged());
        }
        List<MediaFile> soundFiles = this.getSoundFiles();
        for (MediaFile mediaFile : soundFiles) {
            result.put(mediaFile.getFileName(), mediaFile.isFlagged());
        }
        return result;
    }

    private NonLinearBook getMainNLB() {
        NonLinearBook result = this;
        while (result.getParentNLB() != null && !result.getParentNLB().isDummy()) {
            result = result.getParentNLB();
        }
        return result;
    }

    private String checkFormula(String formula) throws NLBConsistencyException {
        Collection<String> constraintVars;
        try {
            constraintVars = VarFinder.findVariableNames(formula);
        }
        catch (Exception e) {
            return "Variable names cannot be extracted: " + e.getMessage();
        }
        for (String variableName : constraintVars) {
            boolean found = this.findVariable(variableName);
            if (found) {
                try {
                    ScriptEngineManager factory = new ScriptEngineManager();
                    ScriptEngine engine = factory.getEngineByName("JavaScript");
                    for (String variableNameCur : constraintVars) {
                        engine.put(variableNameCur, false);
                    }
                    engine.eval(formula);
                    continue;
                }
                catch (ScriptException e) {
                    return "Formula cannot be evaluated: " + e.getMessage();
                }
            }
            return "Variable '" + variableName + "' was not found in NLB variables";
        }
        return null;
    }

    @Override
    public boolean findVariable(String variableNameToFind) throws NLBConsistencyException {
        boolean found = false;
        for (VariableImpl variable : this.m_variables) {
            if (variable.isDeleted()) continue;
            if (variableNameToFind.equals(variable.getName())) {
                Variable.Type type = variable.getType();
                switch (type) {
                    case PAGE: 
                    case TIMER: {
                        Page page = this.getPageById(variable.getTarget());
                        if (page.isDeleted()) break;
                        found = true;
                        break;
                    }
                    case OBJ: {
                        Obj obj = this.getObjById(variable.getTarget());
                        if (obj.isDeleted()) break;
                        found = true;
                        break;
                    }
                    case LINK: {
                        Link link = this.getLinkWithCheck(variable);
                        if (link.isDeleted()) break;
                        found = true;
                        break;
                    }
                    case VAR: {
                        ModifyingItemAndModification itemAndModification = this.getModifyingItemAndModification(variable);
                        if (!itemAndModification.existsAndValid()) break;
                        found = true;
                        break;
                    }
                }
            }
        }
        if (!found && this.m_parentNLB != null) {
            found = this.m_parentNLB.findVariable(variableNameToFind);
        }
        return found;
    }

    private void searchLinks(String module, AbstractNodeItem nodeItem, SearchResultTableModel result, SearchContract contract) {
        for (LinkImpl link : nodeItem.getLinkImpls()) {
            SearchResult linkResult = link.searchText(contract);
            if (linkResult != null) {
                linkResult.setModulePageId(module);
                result.addSearchResult(linkResult);
                continue;
            }
            if (!contract.isSearchInVars()) continue;
            VariableImpl variable = this.getVariableImplById(link.getVarId());
            SearchResult varResult = variable != null ? variable.searchText(contract) : null;
            if (varResult != null) {
                varResult.setId(link.getId());
                varResult.setModulePageId(module);
                result.addSearchResult(varResult);
            } else {
                VariableImpl constraint = this.getVariableImplById(link.getConstrId());
                SearchResult constraintsResult = constraint != null ? constraint.searchText(contract) : null;
                if (constraintsResult != null) {
                    constraintsResult.setId(link.getId());
                    constraintsResult.setModulePageId(module);
                    result.addSearchResult(constraintsResult);
                }
            }
            result.addSearchResults(this.getModificationSearchResults(link, contract));
        }
    }

    public void exportToChoiceScript(File targetFile) throws NLBExportException {
        ChoiceScriptExportManager manager = new ChoiceScriptExportManager(this, "UTF-8");
        ((ExportManager)manager).exportToFile(targetFile);
    }

    public void exportToQSPTextFile(File targetFile) throws NLBExportException {
        QSPExportManager manager = new QSPExportManager(this, "UTF-16LE");
        ((ExportManager)manager).exportToFile(targetFile);
    }

    public void exportToURQTextFile(File targetFile) throws NLBExportException {
        URQExportManager manager = new URQExportManager(this, "CP1251");
        ((ExportManager)manager).exportToFile(targetFile);
    }

    public void exportToPDFFile(File targetFile) throws NLBExportException {
        PDFExportManager manager = new PDFExportManager(this, "CP1251");
        ((ExportManager)manager).exportToFile(targetFile);
    }

    public void exportToTXTFile(File targetFile) throws NLBExportException {
        TaggedTextExportManager manager = new TaggedTextExportManager(this, "UTF-8");
        ((ExportManager)manager).exportToFile(targetFile);
    }

    public void exportToHTMLFile(File targetFile) throws NLBExportException {
        HTMLExportManager manager = new HTMLExportManager(this, "UTF-8");
        ((ExportManager)manager).exportToFile(targetFile);
    }

    public void exportToJSIQFile(File targetFile) throws NLBExportException {
        JSIQ2ExportManager manager = new JSIQ2ExportManager(this, "UTF-8");
        ((ExportManager)manager).exportToFile(targetFile);
    }

    public void exportToSTEADFile(File targetFile) throws NLBExportException {
        STEADExportManager manager = new STEADExportManager(this, "UTF-8");
        ((ExportManager)manager).exportToFile(targetFile);
    }

    public void exportToVNSTEADFile(File targetFile) throws NLBExportException {
        VNSTEADExportManager manager = new VNSTEADExportManager(this, "UTF-8");
        ((ExportManager)manager).exportToFile(targetFile);
    }

    public void exportToASMFile(File targetFile) throws NLBExportException {
        ASMExportManager manager = new ASMExportManager(this, "UTF-8");
        ((ExportManager)manager).exportToFile(targetFile);
    }

    public void addVariable(@NotNull VariableImpl variable) {
        this.m_variables.add(variable);
    }

    private MediaFileImpl copyMediaFile(@NotNull FileManipulator fileManipulator, @NotNull File file, @Nullable String fileName, @NotNull String mediaDirName) throws NLBFileManipulationException, NLBIOException, NLBVCSException {
        File localFile = this.createUniqueMediaFile(fileManipulator, file, fileName, mediaDirName);
        fileManipulator.copyFile(localFile, file, "Cannot copy media file " + localFile.getName());
        MediaFileImpl mediaFile = new MediaFileImpl(localFile.getName());
        return mediaFile;
    }

    public void copyAndAddImageFile(@NotNull FileManipulator fileManipulator, @NotNull File file, @Nullable String fileName) throws NLBFileManipulationException, NLBIOException, NLBVCSException {
        this.addImageFile(this.copyMediaFile(fileManipulator, file, fileName, "images"));
    }

    public void copyAndAddSoundFile(@NotNull FileManipulator fileManipulator, @NotNull File file, @Nullable String fileName) throws NLBFileManipulationException, NLBIOException, NLBVCSException {
        this.addSoundFile(this.copyMediaFile(fileManipulator, file, fileName, "sound"));
    }

    private File createUniqueMediaFile(@NotNull FileManipulator fileManipulator, @NotNull File newFile, @Nullable String fileName, @NotNull String mediaDirName) throws NLBFileManipulationException, NLBIOException {
        String uniqueFileName = fileName != null ? fileName.toLowerCase() : newFile.getName().toLowerCase();
        File mediaDir = new File(this.m_rootDir, mediaDirName);
        fileManipulator.createDir(mediaDir, "Cannot create NLB media directory");
        File localFile = new File(mediaDir, uniqueFileName);
        int extIndex = uniqueFileName.lastIndexOf(".");
        String namePart = uniqueFileName.substring(0, extIndex);
        String extPart = uniqueFileName.substring(extIndex);
        int counter = 1;
        while (localFile.exists()) {
            uniqueFileName = String.format(MEDIA_FILE_NAME_TEMPLATE, namePart, counter++, extPart);
            localFile = new File(mediaDir, uniqueFileName);
        }
        return localFile;
    }

    public void removeImageFile(@NotNull FileManipulator fileManipulator, String imageFileName) throws NLBFileManipulationException, NLBIOException, NLBConsistencyException {
        Iterator<MediaFileImpl> imageFileIterator = this.m_imageFiles.iterator();
        while (imageFileIterator.hasNext()) {
            MediaFileImpl imageFile = imageFileIterator.next();
            if (!imageFile.getFileName().equals(imageFileName)) continue;
            File imagesDir = new File(this.m_rootDir, "images");
            if (!imagesDir.exists()) {
                throw new NLBConsistencyException("NLB images dir does not exist");
            }
            fileManipulator.deleteFileOrDir(new File(imagesDir, imageFileName));
            fileManipulator.deleteFileOrDir(new File(imagesDir, imageFileName + REDIRECT_EXT));
            fileManipulator.deleteFileOrDir(new File(imagesDir, imageFileName + CONSTRID_EXT));
            imageFileIterator.remove();
            return;
        }
        throw new NLBConsistencyException("Specified image file does not exist in images dir");
    }

    public void removeSoundFile(@NotNull FileManipulator fileManipulator, String soundFileName) throws NLBFileManipulationException, NLBIOException, NLBConsistencyException {
        Iterator<MediaFileImpl> soundFileIterator = this.m_soundFiles.iterator();
        while (soundFileIterator.hasNext()) {
            MediaFileImpl soundFile = soundFileIterator.next();
            if (!soundFile.getFileName().equals(soundFileName)) continue;
            File soundDir = new File(this.m_rootDir, "sound");
            if (!soundDir.exists()) {
                throw new NLBConsistencyException("NLB sound dir does not exist");
            }
            fileManipulator.deleteFileOrDir(new File(soundDir, soundFileName));
            fileManipulator.deleteFileOrDir(new File(soundDir, soundFileName + REDIRECT_EXT));
            fileManipulator.deleteFileOrDir(new File(soundDir, soundFileName + CONSTRID_EXT));
            soundFileIterator.remove();
            return;
        }
        throw new NLBConsistencyException("Specified sound file does not exist in sound dir");
    }

    public void addImageFile(@NotNull MediaFileImpl imageFile) {
        this.m_imageFiles.add(imageFile);
    }

    public void addSoundFile(@NotNull MediaFileImpl soundFile) {
        this.m_soundFiles.add(soundFile);
    }

    public void exportImages(boolean isRoot, File mainExportDir) throws NLBExportException {
        this.exportMedia(isRoot, mainExportDir, "images", this.getImageFiles(), MediaFile.Type.Image);
    }

    public void exportSound(boolean isRoot, File mainExportDir) throws NLBExportException {
        if (!this.m_suppressSound) {
            this.exportMedia(isRoot, mainExportDir, "sound", this.getSoundFiles(), MediaFile.Type.Sound);
        }
    }

    @Override
    public void exportMedia(boolean isRoot, File mainExportDir, String mediaDirName, List<MediaFile> mediaFiles, MediaFile.Type mediaType) throws NLBExportException {
        File exportDir;
        if (this.m_suppressMedia) {
            return;
        }
        if (this.getRootDir() == null) {
            throw new NLBExportException("NLB root dir is undefined");
        }
        File file = exportDir = isRoot ? mainExportDir : new File(mainExportDir, this.getParentPage().getId());
        if (!exportDir.exists() && !exportDir.mkdir()) {
            if (isRoot) {
                throw new NLBExportException("Cannot create media export directory for main NLB module");
            }
            throw new NLBExportException("Cannot create media export directory for module with module page id = " + this.getParentPage().getId());
        }
        try {
            File mediaDir = new File(this.getRootDir(), mediaDirName);
            if (mediaDir.exists()) {
                for (MediaFile mediaFile : mediaFiles) {
                    this.processMediaFile(mediaFile, exportDir, mediaDir, mediaType);
                }
            }
            block7: for (Map.Entry entry : this.getExternalModules().entrySet()) {
                File extModuleExportDir = new File(exportDir, (String)entry.getKey());
                extModuleExportDir.mkdir();
                NonLinearBook module = (NonLinearBook)entry.getValue();
                if (module.isEmpty()) continue;
                switch (mediaType) {
                    case Image: {
                        module.exportMedia(true, extModuleExportDir, mediaDirName, module.getImageFiles(), mediaType);
                        continue block7;
                    }
                    case Sound: {
                        module.exportMedia(true, extModuleExportDir, mediaDirName, module.getSoundFiles(), mediaType);
                        continue block7;
                    }
                }
                throw new NLBExportException("Unknown media type = " + mediaType.name());
            }
        }
        catch (IOException e) {
            throw new NLBExportException("IOException when exporting media", e);
        }
    }

    private void processMediaFile(MediaFile mediaFile, File exportDir, File mediaDir, MediaFile.Type mediaType) throws IOException, NLBExportException {
        String mediaFileName = mediaFile.getFileName();
        switch (mediaType) {
            case Image: {
                MediaExportParameters mediaExportParameters = mediaFile.getMediaExportParameters();
                Matcher matcher = PNG_REGEX.matcher(mediaFileName);
                if (mediaExportParameters.isConvertPNG2JPG() && matcher.find()) {
                    String targetFileName = matcher.replaceAll(".jpg");
                    File targetMedia = new File(exportDir, targetFileName);
                    File sourceMedia = new File(mediaDir, mediaFileName);
                    JPEGImageWriteParam jpegParams = new JPEGImageWriteParam(null);
                    jpegParams.setCompressionMode(2);
                    jpegParams.setCompressionQuality((float)mediaExportParameters.getQuality() / 100.0f);
                    BufferedImage bufferedImage = ImageIO.read(sourceMedia);
                    BufferedImage newBufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
                    newBufferedImage.createGraphics().drawImage(bufferedImage, 0, 0, JPG_BGCOLOR, null);
                    ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                    writer.setOutput(new FileImageOutputStream(targetMedia));
                    writer.write(null, new IIOImage(newBufferedImage, null, null), jpegParams);
                    break;
                }
                File targetMedia = new File(exportDir, mediaFileName);
                File sourceMedia = new File(mediaDir, mediaFileName);
                FileManipulator.transfer(sourceMedia, targetMedia);
                break;
            }
            case Sound: {
                File targetMedia = new File(exportDir, mediaFileName);
                File sourceMedia = new File(mediaDir, mediaFileName);
                FileManipulator.transfer(sourceMedia, targetMedia);
                break;
            }
            default: {
                throw new NLBExportException("Unknown media type = " + mediaType.name());
            }
        }
    }

    class DeleteCommand
    extends NotifyingCommand {
        private CommandChainCommand m_deletionCommandChain;

        DeleteCommand(Collection<String> pageIds, Collection<String> objIds) {
            List<Link> adjacentLinks;
            this.m_deletionCommandChain = new CommandChainCommand();
            for (String pageId : pageIds) {
                PageImpl existingPage = NonLinearBookImpl.this.getPageImplById(pageId);
                if (existingPage == null || existingPage.isDeleted()) continue;
                adjacentLinks = NonLinearBookImpl.this.getAssociatedLinks(existingPage);
                this.m_deletionCommandChain.addCommand(new DeletePageCommand(existingPage, adjacentLinks));
            }
            for (String objId : objIds) {
                ObjImpl existingObj = NonLinearBookImpl.this.getObjImplById(objId);
                if (existingObj == null || existingObj.isDeleted()) continue;
                adjacentLinks = NonLinearBookImpl.this.getAssociatedLinks(existingObj);
                this.m_deletionCommandChain.addCommand(new DeleteObjCommand(existingObj, adjacentLinks));
            }
        }

        @Override
        public void execute() {
            this.m_deletionCommandChain.execute();
            this.notifyAllChildren();
        }

        @Override
        public void revert() {
            this.m_deletionCommandChain.revert();
            this.notifyAllChildren();
        }
    }

    class CopyCommand
    implements NLBCommand {
        private NonLinearBookImpl m_prevClipboardData = Clipboard.singleton().getNonLinearBook();
        private NonLinearBookImpl m_newClipboardData = new NonLinearBookImpl();

        CopyCommand(Collection<String> pageIds, Collection<String> objIds) {
            this.processPages(pageIds, objIds);
            this.processObjs(objIds);
        }

        private void processObjs(Collection<String> objIds) {
            for (String objId : objIds) {
                VariableImpl objMorphOut;
                VariableImpl objMorphOver;
                VariableImpl objCommonTo;
                VariableImpl objConstraint;
                VariableImpl deftagVariable;
                ObjImpl existingObj = NonLinearBookImpl.this.getObjImplById(objId);
                if (existingObj == null || existingObj.isDeleted()) continue;
                ObjImpl obj = new ObjImpl(existingObj, (NonLinearBook)this.m_newClipboardData);
                this.m_newClipboardData.addObj(obj);
                this.copyModificationVariables(obj, this.m_newClipboardData);
                VariableImpl objVariable = NonLinearBookImpl.this.getVariableImplById(obj.getVarId());
                if (objVariable != null && !objVariable.isDeleted()) {
                    this.m_newClipboardData.addVariable(objVariable);
                }
                if ((deftagVariable = NonLinearBookImpl.this.getVariableImplById(obj.getDefaultTagId())) != null && !deftagVariable.isDeleted()) {
                    this.m_newClipboardData.addVariable(deftagVariable);
                }
                if ((objConstraint = NonLinearBookImpl.this.getVariableImplById(obj.getConstrId())) != null && !objConstraint.isDeleted()) {
                    this.m_newClipboardData.addVariable(objConstraint);
                }
                if ((objCommonTo = NonLinearBookImpl.this.getVariableImplById(obj.getCommonToId())) != null && !objCommonTo.isDeleted()) {
                    this.m_newClipboardData.addVariable(objCommonTo);
                }
                if ((objMorphOver = NonLinearBookImpl.this.getVariableImplById(obj.getMorphOverId())) != null && !objMorphOver.isDeleted()) {
                    this.m_newClipboardData.addVariable(objMorphOver);
                }
                if ((objMorphOut = NonLinearBookImpl.this.getVariableImplById(obj.getMorphOutId())) != null && !objMorphOut.isDeleted()) {
                    this.m_newClipboardData.addVariable(objMorphOut);
                }
                this.checkContainedObjects(obj, objIds);
                this.copyLinks(obj, objIds, this.m_newClipboardData);
                if (objIds.contains(obj.getContainerId())) continue;
                obj.setContainerId(NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES);
            }
        }

        private void processPages(Collection<String> pageIds, Collection<String> objIds) {
            for (String pageId : pageIds) {
                PageImpl existingPage = NonLinearBookImpl.this.getPageImplById(pageId);
                if (existingPage == null || existingPage.isDeleted()) continue;
                PageImpl page = new PageImpl(existingPage, this.m_newClipboardData, false);
                this.m_newClipboardData.addPage(page);
                this.copyModificationVariables(page, this.m_newClipboardData);
                VariableImpl autowireInConstraint = NonLinearBookImpl.this.getVariableImplById(page.getAutowireInConstrId());
                VariableImpl autowireOutConstraint = NonLinearBookImpl.this.getVariableImplById(page.getAutowireOutConstrId());
                VariableImpl moduleConstraint = NonLinearBookImpl.this.getVariableImplById(page.getModuleConstrId());
                VariableImpl pageVariable = NonLinearBookImpl.this.getVariableImplById(page.getVarId());
                VariableImpl pageTimerVariable = NonLinearBookImpl.this.getVariableImplById(page.getTimerVarId());
                VariableImpl pageDefTagVariable = NonLinearBookImpl.this.getVariableImplById(page.getDefaultTagId());
                if (autowireInConstraint != null && !autowireInConstraint.isDeleted()) {
                    this.m_newClipboardData.addVariable(new VariableImpl(autowireInConstraint, (NonLinearBook)this.m_newClipboardData));
                }
                if (autowireOutConstraint != null && !autowireOutConstraint.isDeleted()) {
                    this.m_newClipboardData.addVariable(new VariableImpl(autowireOutConstraint, (NonLinearBook)this.m_newClipboardData));
                }
                if (moduleConstraint != null && !moduleConstraint.isDeleted()) {
                    this.m_newClipboardData.addVariable(new VariableImpl(moduleConstraint, (NonLinearBook)this.m_newClipboardData));
                }
                if (pageVariable != null && !pageVariable.isDeleted()) {
                    this.m_newClipboardData.addVariable(new VariableImpl(pageVariable, (NonLinearBook)this.m_newClipboardData));
                }
                if (pageTimerVariable != null && !pageTimerVariable.isDeleted()) {
                    this.m_newClipboardData.addVariable(new VariableImpl(pageTimerVariable, (NonLinearBook)this.m_newClipboardData));
                }
                if (pageDefTagVariable != null && !pageDefTagVariable.isDeleted()) {
                    this.m_newClipboardData.addVariable(new VariableImpl(pageDefTagVariable, (NonLinearBook)this.m_newClipboardData));
                }
                this.checkContainedObjects(page, objIds);
                this.copyLinks(page, pageIds, this.m_newClipboardData);
            }
        }

        private void checkContainedObjects(AbstractNodeItem nodeItem, Collection<String> objIds) {
            ArrayList<String> objIdsToRemove = new ArrayList<String>();
            for (String containedObjId : nodeItem.getContainedObjIds()) {
                if (objIds.contains(containedObjId)) continue;
                objIdsToRemove.add(containedObjId);
            }
            for (String objIdToRemove : objIdsToRemove) {
                nodeItem.removeContainedObjId(objIdToRemove);
            }
        }

        private void copyLinks(AbstractNodeItem nodeItem, Collection<String> itemIds, NonLinearBookImpl target) {
            ArrayList<String> malformedLinksIds = new ArrayList<String>();
            for (LinkImpl link : nodeItem.getLinkImpls()) {
                if (!link.isDeleted() && itemIds.contains(link.getTarget())) {
                    this.copyModificationVariables(link, target);
                    VariableImpl linkVariable = NonLinearBookImpl.this.getVariableImplById(link.getVarId());
                    VariableImpl linkConstraint = NonLinearBookImpl.this.getVariableImplById(link.getConstrId());
                    if (linkVariable != null && !linkVariable.isDeleted()) {
                        target.addVariable(new VariableImpl(linkVariable, (NonLinearBook)target));
                    }
                    if (linkConstraint == null || linkConstraint.isDeleted()) continue;
                    target.addVariable(new VariableImpl(linkConstraint, (NonLinearBook)target));
                    continue;
                }
                malformedLinksIds.add(link.getId());
            }
            for (String linkId : malformedLinksIds) {
                nodeItem.removeLinkById(linkId);
            }
        }

        private void copyModificationVariables(AbstractModifyingItem modifyingItem, NonLinearBookImpl target) {
            for (ModificationImpl modification : modifyingItem.getModificationImpls()) {
                if (modification.isDeleted()) continue;
                VariableImpl modificationVariable = NonLinearBookImpl.this.getVariableImplById(modification.getVarId());
                VariableImpl modificationExpression = NonLinearBookImpl.this.getVariableImplById(modification.getExprId());
                if (modificationVariable != null && !modificationVariable.isDeleted()) {
                    target.addVariable(new VariableImpl(modificationVariable, (NonLinearBook)target));
                }
                if (modificationExpression == null || modificationExpression.isDeleted()) continue;
                target.addVariable(new VariableImpl(modificationExpression, (NonLinearBook)target));
            }
        }

        @Override
        public void execute() {
            Clipboard.singleton().setNonLinearBook(this.m_newClipboardData);
        }

        @Override
        public void revert() {
            Clipboard.singleton().setNonLinearBook(this.m_prevClipboardData);
        }
    }

    class PasteCommand
    extends NotifyingCommand {
        private CommandChainCommand m_commandChain;

        PasteCommand(NonLinearBookImpl currentNLB, NonLinearBookImpl nlbToPaste) {
            CoordsImpl newCoords;
            CoordsImpl coords;
            ObjImpl newObj;
            PageImpl page;
            this.m_commandChain = new CommandChainCommand();
            HashMap<String, String> idsMapping = new HashMap<String, String>();
            HashMap<String, PageImpl> newPages = new HashMap<String, PageImpl>();
            HashMap<String, ObjImpl> newObjs = new HashMap<String, ObjImpl>();
            for (Map.Entry entry : nlbToPaste.m_pages.entrySet()) {
                page = (PageImpl)entry.getValue();
                CoordsImpl coords2 = page.getCoords();
                PageImpl newPage = new PageImpl(currentNLB, coords2.getLeft() + coords2.getWidth(), coords2.getTop() + coords2.getHeight());
                idsMapping.put((String)entry.getKey(), newPage.getId());
                newPages.put(newPage.getId(), newPage);
                AddPageCommand command = NonLinearBookImpl.this.createAddPageCommand(newPage);
                this.m_commandChain.addCommand(command);
                if (page.getModule().isEmpty()) continue;
                PasteCommand pasteCommand = newPage.getModuleImpl().createPasteCommand(page.getModuleImpl());
                this.m_commandChain.addCommand(pasteCommand);
            }
            for (Map.Entry entry : nlbToPaste.m_objs.entrySet()) {
                CoordsImpl coords3 = ((ObjImpl)entry.getValue()).getCoords();
                newObj = new ObjImpl(currentNLB, coords3.getLeft() + coords3.getWidth(), coords3.getTop() + coords3.getHeight());
                idsMapping.put((String)entry.getKey(), newObj.getId());
                newObjs.put(newObj.getId(), newObj);
                AddObjCommand command = NonLinearBookImpl.this.createAddObjCommand(newObj);
                this.m_commandChain.addCommand(command);
            }
            for (Map.Entry entry : nlbToPaste.m_pages.entrySet()) {
                page = (PageImpl)entry.getValue();
                PageImpl newPage = (PageImpl)newPages.get(idsMapping.get(entry.getKey()));
                Variable pageVariable = nlbToPaste.getVariableById(page.getVarId());
                Variable pageTimerVariable = nlbToPaste.getVariableById(page.getTimerVarId());
                Variable pageDefTagVariable = nlbToPaste.getVariableById(page.getDefaultTagId());
                Variable modConstraint = nlbToPaste.getVariableById(page.getModuleConstrId());
                Variable autoInConstraint = nlbToPaste.getVariableById(page.getAutowireInConstrId());
                Variable autoOutConstraint = nlbToPaste.getVariableById(page.getAutowireOutConstrId());
                UpdatePageCommand updatePageCommand = new UpdatePageCommand((NonLinearBook)currentNLB, newPage, page.getImageFileName(), page.isImageBackground(), page.isImageAnimated(), page.getSoundFileName(), page.isSoundSFX(), pageVariable != null ? pageVariable.getName() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, pageTimerVariable != null ? pageTimerVariable.getName() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, pageDefTagVariable != null ? pageDefTagVariable.getValue() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, page.getTexts(), page.getCaptions(), page.getTheme(), page.isUseCaption(), page.isUseMPL(), page.getModuleName(), page.isModuleExternal(), page.getTraverseTexts(), page.isAutoTraverse(), page.isAutoReturn(), page.getReturnTexts(), page.getReturnPageId(), modConstraint != null ? modConstraint.getName() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, page.isAutowire(), page.getAutowireInTexts(), page.getAutowireOutTexts(), page.isAutoIn(), page.isAutoOut(), autoInConstraint != null ? autoInConstraint.getValue() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, autoOutConstraint != null ? autoOutConstraint.getValue() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, page.isGlobalAutowire(), page.isNoSave(), page.isAutosFirst(), new LinksTableModel(new ArrayList<Link>()));
                this.m_commandChain.addCommand(updatePageCommand);
                coords = page.getCoords();
                newCoords = newPage.getCoords();
                this.resizeNode(newPage, coords, newCoords);
                this.copyModifications(currentNLB, nlbToPaste, page, newPage);
                this.addLinks(currentNLB, nlbToPaste, idsMapping, page, newPage);
            }
            for (Map.Entry entry : nlbToPaste.m_objs.entrySet()) {
                ObjImpl obj = (ObjImpl)entry.getValue();
                newObj = (ObjImpl)newObjs.get(idsMapping.get(entry.getKey()));
                Variable objVariable = nlbToPaste.getVariableById(obj.getVarId());
                Variable deftagVariable = nlbToPaste.getVariableById(obj.getDefaultTagId());
                Variable objConstraint = nlbToPaste.getVariableById(obj.getConstrId());
                Variable objCommonTo = nlbToPaste.getVariableById(obj.getCommonToId());
                Variable objMorphOver = nlbToPaste.getVariableById(obj.getMorphOverId());
                Variable objMorphOut = nlbToPaste.getVariableById(obj.getMorphOutId());
                UpdateObjCommand updateObjCommand = new UpdateObjCommand((NonLinearBook)currentNLB, newObj, objVariable != null ? objVariable.getName() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, deftagVariable != null ? deftagVariable.getValue() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, objConstraint != null ? objConstraint.getValue() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, objCommonTo != null ? objCommonTo.getName() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, obj.getName(), obj.getImageFileName(), obj.getSoundFileName(), obj.isSoundSFX(), obj.isAnimatedImage(), obj.isSuppressDsc(), obj.getDisps(), obj.getTexts(), obj.getActTexts(), obj.getNouseTexts(), obj.isGraphical(), obj.isShowOnCursor(), obj.isPreserved(), obj.isLoadOnce(), obj.isCollapsable(), obj.getOffset(), obj.getMovementDirection(), obj.getEffect(), obj.getStartFrame(), obj.getMaxFrame(), obj.getPreloadFrames(), obj.getPauseFrames(), obj.getCoordsOrigin(), obj.isClearUnderTooltip(), obj.isActOnKey(), obj.isCacheText(), obj.isLooped(), obj.isNoRedrawOnAct(), objMorphOver != null ? objMorphOver.getName() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, objMorphOut != null ? objMorphOut.getName() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, obj.isTakable(), obj.isImageInScene(), obj.isImageInInventory());
                this.m_commandChain.addCommand(updateObjCommand);
                coords = obj.getCoords();
                newCoords = newObj.getCoords();
                this.resizeNode(newObj, coords, newCoords);
                this.copyModifications(currentNLB, nlbToPaste, obj, newObj);
                this.addLinks(currentNLB, nlbToPaste, idsMapping, obj, newObj);
            }
        }

        private void resizeNode(AbstractNodeItem nodeItem, Coords coords, Coords newCoords) {
            double deltaX = coords.getWidth() - newCoords.getWidth();
            double deltaY = coords.getHeight() - newCoords.getHeight();
            AbstractNodeItem.ResizeNodeCommand rightResizeCommand = nodeItem.createResizeNodeCommand(NodeItem.Orientation.RIGHT, deltaX, 0.0);
            this.m_commandChain.addCommand(rightResizeCommand);
            AbstractNodeItem.ResizeNodeCommand bottomResizeCommand = nodeItem.createResizeNodeCommand(NodeItem.Orientation.BOTTOM, 0.0, deltaY);
            this.m_commandChain.addCommand(bottomResizeCommand);
        }

        private void copyModifications(NonLinearBookImpl currentNLB, NonLinearBookImpl nlbToPaste, AbstractModifyingItem existingItem, AbstractModifyingItem newItem) {
            ModificationsTableModel existingModel = new ModificationsTableModel(nlbToPaste, existingItem.getModifications());
            ModificationsTableModel model = new ModificationsTableModel(currentNLB, new ArrayList<Modification>());
            int maxRow = existingModel.getRowCount();
            int maxCol = existingModel.getColumnCount();
            for (int row = 0; row < maxRow; ++row) {
                model.add(newItem);
                for (int col = maxCol - 1; col > 0; --col) {
                    Object value = existingModel.getValueAt(row, col);
                    String text = value instanceof Enum ? ((Enum)value).name() : value.toString();
                    model.setValueAt(text, row, col);
                }
            }
            UpdateModificationsCommand command = new UpdateModificationsCommand(newItem, model);
            this.m_commandChain.addCommand(command);
        }

        private void addLinks(NonLinearBookImpl currentNLB, NonLinearBookImpl nlbToPaste, Map<String, String> idsMapping, AbstractNodeItem node, AbstractNodeItem newNode) {
            for (LinkImpl link : node.getLinkImpls()) {
                LinkImpl newLink = new LinkImpl((NodeItem)newNode, idsMapping.get(link.getTarget()));
                AbstractNodeItem.AddLinkCommand command = newNode.createAddLinkCommand(newLink);
                this.m_commandChain.addCommand(command);
                Variable linkVariable = nlbToPaste.getVariableById(link.getVarId());
                Variable linkConstraint = nlbToPaste.getVariableById(link.getConstrId());
                UpdateLinkCommand updateLinkCommand = new UpdateLinkCommand((NonLinearBook)currentNLB, newLink, linkVariable != null ? linkVariable.getName() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, linkConstraint != null ? linkConstraint.getValue() : NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, link.getTexts(), link.getAltTexts(), link.isAuto(), link.isOnce());
                this.m_commandChain.addCommand(updateLinkCommand);
                this.copyModifications(currentNLB, nlbToPaste, link, newLink);
            }
        }

        @Override
        public void execute() {
            this.m_commandChain.execute();
            this.notifyAllChildren();
        }

        @Override
        public void revert() {
            this.m_commandChain.revert();
            this.notifyAllChildren();
        }
    }

    class UpdateBookPropertiesCommand
    extends NotifyingCommand {
        private final String m_prevLicense;
        private final Theme m_prevTheme;
        private final String m_prevLanguage;
        private final String m_prevTitle;
        private final String m_prevPerfectGameAchievementName;
        private final String m_prevAuthor;
        private final String m_prevVersion;
        private final Boolean m_prevFullAutowire;
        private final Boolean m_prevSuppressMedia;
        private final Boolean m_prevSuppressSound;
        private final String m_newLicense;
        private final Theme m_newTheme;
        private final String m_newLanguage;
        private final String m_newTitle;
        private final String m_newPerfectGameAchievementName;
        private final String m_newAuthor;
        private final String m_newVersion;
        private final Boolean m_newFullAutowire;
        private final Boolean m_newSuppressMedia;
        private final Boolean m_newSuppressSound;
        private List<UpdateBookPropertiesCommand> m_submodulesCommands;

        UpdateBookPropertiesCommand(String license, Theme theme, String language, String title, String author, String version, String perfectGameAchievementName, Boolean fullAutowire, Boolean suppressMedia, Boolean suppressSound, boolean propagateToSubmodules) {
            this.m_submodulesCommands = new ArrayList<UpdateBookPropertiesCommand>();
            this.m_prevLicense = NonLinearBookImpl.this.m_license;
            this.m_prevTheme = NonLinearBookImpl.this.m_theme;
            this.m_prevLanguage = NonLinearBookImpl.this.m_language;
            this.m_prevTitle = NonLinearBookImpl.this.m_title;
            this.m_prevAuthor = NonLinearBookImpl.this.m_author;
            this.m_prevVersion = NonLinearBookImpl.this.m_version;
            this.m_prevPerfectGameAchievementName = NonLinearBookImpl.this.m_perfectGameAchievementName;
            this.m_prevFullAutowire = NonLinearBookImpl.this.m_fullAutowire;
            this.m_prevSuppressMedia = NonLinearBookImpl.this.m_suppressMedia;
            this.m_prevSuppressSound = NonLinearBookImpl.this.m_suppressSound;
            this.m_newLicense = license;
            this.m_newTheme = theme;
            this.m_newLanguage = language;
            this.m_newTitle = title;
            this.m_newAuthor = author;
            this.m_newVersion = version;
            this.m_newPerfectGameAchievementName = perfectGameAchievementName;
            this.m_newFullAutowire = fullAutowire;
            this.m_newSuppressMedia = suppressMedia;
            this.m_newSuppressSound = suppressSound;
            if (propagateToSubmodules) {
                for (PageImpl page : NonLinearBookImpl.this.m_pages.values()) {
                    NonLinearBookImpl moduleImpl = page.getModuleImpl();
                    if (moduleImpl.isEmpty()) continue;
                    this.m_submodulesCommands.add(moduleImpl.createUpdateBookPropertiesCommand(license, null, language, title, author, version, null, fullAutowire, suppressMedia, suppressSound, true));
                }
            }
        }

        @Override
        public void execute() {
            if (this.m_newLicense != null) {
                NonLinearBookImpl.this.m_license = this.m_newLicense;
            }
            if (this.m_newTheme != null) {
                NonLinearBookImpl.this.m_theme = this.m_newTheme;
            }
            if (this.m_newLanguage != null) {
                NonLinearBookImpl.this.m_language = this.m_newLanguage;
            }
            if (this.m_newTitle != null) {
                NonLinearBookImpl.this.m_title = this.m_newTitle;
            }
            if (this.m_newAuthor != null) {
                NonLinearBookImpl.this.m_author = this.m_newAuthor;
            }
            if (this.m_newVersion != null) {
                NonLinearBookImpl.this.m_version = this.m_newVersion;
            }
            if (this.m_newPerfectGameAchievementName != null) {
                NonLinearBookImpl.this.m_perfectGameAchievementName = this.m_newPerfectGameAchievementName;
            }
            if (this.m_newFullAutowire != null) {
                NonLinearBookImpl.this.m_fullAutowire = this.m_newFullAutowire;
            }
            if (this.m_newSuppressMedia != null) {
                NonLinearBookImpl.this.m_suppressMedia = this.m_newSuppressMedia;
            }
            if (this.m_newSuppressSound != null) {
                NonLinearBookImpl.this.m_suppressSound = this.m_newSuppressSound;
            }
            for (UpdateBookPropertiesCommand command : this.m_submodulesCommands) {
                command.execute();
            }
            this.notifyAllChildren();
        }

        @Override
        public void revert() {
            NonLinearBookImpl.this.m_license = this.m_prevLicense;
            NonLinearBookImpl.this.m_theme = this.m_prevTheme;
            NonLinearBookImpl.this.m_language = this.m_prevLanguage;
            NonLinearBookImpl.this.m_title = this.m_prevTitle;
            NonLinearBookImpl.this.m_author = this.m_prevAuthor;
            NonLinearBookImpl.this.m_version = this.m_prevVersion;
            NonLinearBookImpl.this.m_perfectGameAchievementName = this.m_prevPerfectGameAchievementName;
            NonLinearBookImpl.this.m_fullAutowire = this.m_prevFullAutowire;
            NonLinearBookImpl.this.m_suppressMedia = this.m_prevSuppressMedia;
            NonLinearBookImpl.this.m_suppressSound = this.m_prevSuppressSound;
            for (UpdateBookPropertiesCommand command : this.m_submodulesCommands) {
                command.revert();
            }
            this.notifyAllChildren();
        }
    }

    abstract class NotifyingCommand
    implements NLBCommand {
        NotifyingCommand() {
        }

        protected void notifyAllChildren() {
            for (Page page : NonLinearBookImpl.this.m_pages.values()) {
                page.notifyObservers();
                for (Link link : page.getLinks()) {
                    link.notifyObservers();
                }
            }
            for (Obj obj : NonLinearBookImpl.this.m_objs.values()) {
                obj.notifyObservers();
                for (Link link : obj.getLinks()) {
                    link.notifyObservers();
                }
            }
        }
    }

    class DeleteObjCommand
    extends DeleteNodeCommand
    implements NLBCommand {
        private ObjImpl m_obj;

        private DeleteObjCommand(ObjImpl obj, List<Link> adjacentLinks) {
            super(obj, obj.getContainerId(), adjacentLinks);
            this.m_obj = obj;
        }

        @Override
        public void execute() {
            super.execute();
            this.m_obj.setDeleted(true);
            this.m_obj.notifyObservers();
        }

        @Override
        public void revert() {
            this.m_obj.setDeleted(false);
            this.m_obj.notifyObservers();
            super.revert();
        }
    }

    class DeletePageCommand
    extends DeleteNodeCommand
    implements NLBCommand {
        private PageImpl m_page;
        private boolean m_isAutowired;
        private ChangeStartPointCommand m_changeStartPointCommand;

        private DeletePageCommand(PageImpl page, List<Link> adjacentLinks) {
            super(page, NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES, adjacentLinks);
            this.m_changeStartPointCommand = null;
            this.m_page = page;
            this.m_isAutowired = NonLinearBookImpl.this.isAutowired(page.getId());
            if (page.getId().equals(NonLinearBookImpl.this.getStartPoint())) {
                this.m_changeStartPointCommand = new ChangeStartPointCommand(NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES);
            }
        }

        @Override
        public void execute() {
            super.execute();
            this.m_page.setDeleted(true);
            if (this.m_changeStartPointCommand != null) {
                this.m_changeStartPointCommand.execute();
            }
            if (this.m_isAutowired) {
                NonLinearBookImpl.this.removeAutowiredPageId(this.m_page.getId());
            }
            this.m_page.notifyObservers();
        }

        @Override
        public void revert() {
            this.m_page.setDeleted(false);
            if (this.m_changeStartPointCommand != null) {
                this.m_changeStartPointCommand.revert();
            }
            if (this.m_isAutowired) {
                NonLinearBookImpl.this.addAutowiredPageId(this.m_page.getId());
            }
            this.m_page.notifyObservers();
            super.revert();
        }
    }

    abstract class DeleteNodeCommand
    implements NLBCommand {
        private List<LinkImpl> m_links = new ArrayList<LinkImpl>();
        private Map<String, Boolean> m_linksDeletionStates = new HashMap<String, Boolean>();
        private AbstractNodeItem m_node;
        private AbstractNodeItem m_container;

        protected DeleteNodeCommand(AbstractNodeItem node, String containerId, List<Link> adjacentLinks) {
            this.m_node = node;
            this.m_container = NonLinearBookImpl.this.getPageImplById(containerId);
            if (this.m_container == null) {
                this.m_container = NonLinearBookImpl.this.getObjImplById(containerId);
            }
            for (Link linkToDelete : adjacentLinks) {
                AbstractNodeItem parent = NonLinearBookImpl.this.getPageImplById(linkToDelete.getParent().getId());
                if (parent == null) {
                    parent = NonLinearBookImpl.this.getObjImplById(linkToDelete.getParent().getId());
                }
                LinkImpl link = parent.getLinkById(linkToDelete.getId());
                this.m_links.add(link);
            }
            for (LinkImpl link : this.m_links) {
                this.m_linksDeletionStates.put(link.getId(), link.isDeleted());
            }
        }

        @Override
        public void execute() {
            for (LinkImpl link : this.m_links) {
                link.setDeleted(true);
                link.notifyObservers();
            }
            if (this.m_container != null) {
                this.m_container.removeContainedObjId(this.m_node.getId());
            }
            for (String containedObjId : this.m_node.getContainedObjIds()) {
                ObjImpl objImpl = NonLinearBookImpl.this.getObjImplById(containedObjId);
                objImpl.setContainerId(NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES);
                objImpl.notifyObservers();
            }
        }

        @Override
        public void revert() {
            for (LinkImpl link : this.m_links) {
                link.setDeleted(this.m_linksDeletionStates.get(link.getId()));
                link.notifyObservers();
            }
            if (this.m_container != null) {
                this.m_container.addContainedObjId(this.m_node.getId());
            }
            for (String containedObjId : this.m_node.getContainedObjIds()) {
                ObjImpl objImpl = NonLinearBookImpl.this.getObjImplById(containedObjId);
                objImpl.setContainerId(this.m_node.getId());
                objImpl.notifyObservers();
            }
        }
    }

    class AddObjCommand
    implements NLBCommand {
        private ObjImpl m_obj;

        private AddObjCommand(ObjImpl obj) {
            this.m_obj = obj;
        }

        @Override
        public void execute() {
            this.m_obj.setDeleted(false);
            NonLinearBookImpl.this.addObj(this.m_obj);
            this.m_obj.notifyObservers();
        }

        @Override
        public void revert() {
            this.m_obj.setDeleted(true);
            NonLinearBookImpl.this.m_objs.remove(this.m_obj.getId());
            this.m_obj.notifyObservers();
        }
    }

    class UpdateModificationsCommand
    implements NLBCommand {
        private AbstractModifyingItem m_item;
        private ModificationComparator m_initialComparator;
        private ModificationComparator m_modifiedComparator;
        private Map<String, ModificationImpl> m_modificationsToBeDeleted = new HashMap<String, ModificationImpl>();
        private Map<String, Boolean> m_modificationsDeletionInitState = new HashMap<String, Boolean>();
        private Map<String, ModificationImpl> m_modificationsToBeReplaced = new HashMap<String, ModificationImpl>();
        private Map<String, ModificationImpl> m_modificationsToBeReplacedPrev = new HashMap<String, ModificationImpl>();
        private List<String> m_modificationsToBeAddedIdsInCorrectOrder = new ArrayList<String>();
        private Map<String, ModificationImpl> m_modificationsToBeAdded = new HashMap<String, ModificationImpl>();
        private Map<String, VariableImpl> m_variablesToBeReplaced = new HashMap<String, VariableImpl>();
        private Map<String, VariableImpl> m_variablesToBeReplacedPrev = new HashMap<String, VariableImpl>();
        private Map<String, VariableImpl> m_variablesToBeAdded = new HashMap<String, VariableImpl>();

        private UpdateModificationsCommand(ModifyingItem modifyingItem, ModificationsTableModel modificationsTableModel) {
            this.init(this.getModifyingItemImpl(modifyingItem), modificationsTableModel);
        }

        private UpdateModificationsCommand(AbstractModifyingItem modifyingItem, ModificationsTableModel modificationsTableModel) {
            this.init(modifyingItem, modificationsTableModel);
        }

        private void init(AbstractModifyingItem modifyingItem, ModificationsTableModel modificationsTableModel) {
            HashMap<String, Integer> initialIndicesMap = new HashMap<String, Integer>();
            HashMap<String, Integer> modifiedIndicesMap = new HashMap<String, Integer>();
            this.m_item = modifyingItem;
            if (modifyingItem != null) {
                int initIdx = 0;
                for (ModificationImpl modificationImpl : this.m_item.getModificationImpls()) {
                    initialIndicesMap.put(modificationImpl.getId(), initIdx++);
                }
                int modifiedIdx = 0;
                for (Modification modification : modificationsTableModel.getModifications()) {
                    modifiedIndicesMap.put(modification.getId(), modifiedIdx++);
                    boolean toBeAdded = true;
                    for (ModificationImpl existingModification : this.m_item.getModificationImpls()) {
                        if (!existingModification.getId().equals(modification.getId())) continue;
                        if (modification.isDeleted()) {
                            this.m_modificationsToBeDeleted.put(existingModification.getId(), existingModification);
                            this.m_modificationsDeletionInitState.put(existingModification.getId(), existingModification.isDeleted());
                        } else {
                            this.m_modificationsToBeReplaced.put(modification.getId(), new ModificationImpl(modification, this.m_item.getCurrentNLB()));
                            this.m_modificationsToBeReplacedPrev.put(existingModification.getId(), new ModificationImpl(existingModification, this.m_item.getCurrentNLB()));
                        }
                        toBeAdded = false;
                    }
                    if (!toBeAdded) continue;
                    this.m_modificationsToBeAddedIdsInCorrectOrder.add(modification.getId());
                    this.m_modificationsToBeAdded.put(modification.getId(), new ModificationImpl(modification, this.m_item.getCurrentNLB()));
                }
                Map<String, Variable> map = modificationsTableModel.getVariableMap();
                for (Map.Entry<String, Variable> entry : map.entrySet()) {
                    VariableImpl existingVariable = NonLinearBookImpl.this.getVariableImplById(entry.getKey());
                    Variable variable = entry.getValue();
                    if (existingVariable != null) {
                        this.m_variablesToBeReplacedPrev.put(existingVariable.getId(), new VariableImpl(existingVariable, this.m_item.getCurrentNLB()));
                        this.m_variablesToBeReplaced.put(existingVariable.getId(), new VariableImpl(variable, this.m_item.getCurrentNLB()));
                        continue;
                    }
                    if (variable.isDeleted()) continue;
                    this.m_variablesToBeAdded.put(variable.getId(), new VariableImpl(variable, this.m_item.getCurrentNLB()));
                }
            }
            this.m_initialComparator = new ModificationComparator(initialIndicesMap);
            this.m_modifiedComparator = new ModificationComparator(modifiedIndicesMap);
        }

        @Override
        public void execute() {
            if (this.m_item != null) {
                ListIterator<ModificationImpl> existingModificationsIterator = this.m_item.getModificationImpls().listIterator();
                while (existingModificationsIterator.hasNext()) {
                    ModificationImpl existingModification = existingModificationsIterator.next();
                    if (this.m_modificationsToBeDeleted.containsKey(existingModification.getId())) {
                        existingModification.setDeleted(true);
                        continue;
                    }
                    if (!this.m_modificationsToBeReplaced.containsKey(existingModification.getId())) continue;
                    existingModification.copy(this.m_modificationsToBeReplaced.get(existingModification.getId()));
                }
                for (String string : this.m_modificationsToBeAddedIdsInCorrectOrder) {
                    this.m_item.addModification(this.m_modificationsToBeAdded.get(string));
                }
                for (Map.Entry entry : this.m_variablesToBeReplaced.entrySet()) {
                    VariableImpl existingVariable = NonLinearBookImpl.this.getVariableImplById((String)entry.getKey());
                    Variable variable = (Variable)entry.getValue();
                    existingVariable.copy(variable);
                }
                for (Map.Entry entry : this.m_variablesToBeAdded.entrySet()) {
                    NonLinearBookImpl.this.addVariable((VariableImpl)entry.getValue());
                }
                Collections.sort(this.m_item.getModificationImpls(), this.m_modifiedComparator);
            }
        }

        @Override
        public void revert() {
            if (this.m_item != null) {
                ListIterator<ModificationImpl> existingModificationsIterator = this.m_item.getModificationImpls().listIterator();
                while (existingModificationsIterator.hasNext()) {
                    ModificationImpl existingModification = existingModificationsIterator.next();
                    if (this.m_modificationsToBeDeleted.containsKey(existingModification.getId())) {
                        existingModification.setDeleted(this.m_modificationsDeletionInitState.get(existingModification.getId()));
                        continue;
                    }
                    if (this.m_modificationsToBeReplaced.containsKey(existingModification.getId())) {
                        existingModification.copy(this.m_modificationsToBeReplacedPrev.get(existingModification.getId()));
                        continue;
                    }
                    if (!this.m_modificationsToBeAdded.containsKey(existingModification.getId())) continue;
                    existingModificationsIterator.remove();
                }
                for (Map.Entry entry : this.m_variablesToBeReplacedPrev.entrySet()) {
                    VariableImpl existingVariable = NonLinearBookImpl.this.getVariableImplById((String)entry.getKey());
                    Variable variable = (Variable)entry.getValue();
                    existingVariable.copy(variable);
                }
                ListIterator iterator = NonLinearBookImpl.this.m_variables.listIterator();
                while (iterator.hasNext()) {
                    VariableImpl variableImpl = (VariableImpl)iterator.next();
                    for (Map.Entry<String, VariableImpl> entry : this.m_variablesToBeAdded.entrySet()) {
                        if (!variableImpl.getId().equals(entry.getValue().getId())) continue;
                        iterator.remove();
                    }
                }
                Collections.sort(this.m_item.getModificationImpls(), this.m_initialComparator);
            }
        }

        private ModificationImpl getModificationImpl(Modification modification) {
            IdentifiableItem[] parents = new IdentifiableItem[2];
            parents[1] = modification.getParent();
            assert (parents[1] != null);
            parents[0] = parents[1].getParent();
            AbstractModifyingItem modifyingItem = null;
            AbstractModifyingItem nodeItem = null;
            for (int i = 0; i < 2; ++i) {
                if (parents[i] == null) continue;
                if (nodeItem == null) {
                    nodeItem = NonLinearBookImpl.this.getPageImplById(parents[i].getId());
                    if (nodeItem != null) continue;
                    nodeItem = NonLinearBookImpl.this.getObjImplById(parents[i].getId());
                    continue;
                }
                modifyingItem = ((AbstractNodeItem)nodeItem).getLinkById(parents[1].getId());
            }
            if (modifyingItem == null) {
                modifyingItem = nodeItem;
            }
            assert (modifyingItem != null);
            return modifyingItem.getModificationById(modification.getId());
        }

        private AbstractModifyingItem getModifyingItemImpl(ModifyingItem modifyingItem) {
            IdentifiableItem[] parents = new IdentifiableItem[2];
            parents[1] = modifyingItem;
            assert (parents[1] != null);
            parents[0] = parents[1].getParent();
            AbstractModifyingItem item = null;
            AbstractNodeItem nodeItem = null;
            for (int i = 0; i < 2; ++i) {
                if (parents[i] == null) continue;
                if (nodeItem == null) {
                    nodeItem = NonLinearBookImpl.this.getPageImplById(parents[i].getId());
                    if (nodeItem != null) continue;
                    nodeItem = NonLinearBookImpl.this.getObjImplById(parents[i].getId());
                    continue;
                }
                item = nodeItem.getLinkById(parents[i].getId());
            }
            if (item == null) {
                item = nodeItem;
            }
            assert (item != null);
            return item;
        }

        private class ModificationComparator
        implements Comparator<ModificationImpl> {
            private Map<String, Integer> m_indicesMap;

            public ModificationComparator(Map<String, Integer> indicesMap) {
                this.m_indicesMap = indicesMap;
            }

            @Override
            public int compare(ModificationImpl o1, ModificationImpl o2) {
                int idx1 = this.m_indicesMap.get(o1.getId());
                int idx2 = this.m_indicesMap.get(o2.getId());
                return idx1 - idx2;
            }
        }
    }

    class UpdateLinkCommand
    implements NLBCommand {
        private LinkImpl m_link;
        private VariableTracker m_variableTracker;
        private VariableTracker m_constraintTracker;
        private MultiLangString m_newLinkText;
        private MultiLangString m_existingLinkText;
        private MultiLangString m_newAltText;
        private MultiLangString m_existingAltText;
        private boolean m_existingAuto;
        private boolean m_existingOnce;
        private boolean m_newAuto;
        private boolean m_newOnce;

        private UpdateLinkCommand(NonLinearBook currentNLB, Link link, String linkVariableName, String linkConstraintValue, MultiLangString linkText, MultiLangString linkAltText, boolean auto, boolean once) {
            IdentifiableItem parent = link.getParent();
            AbstractNodeItem nodeItem = NonLinearBookImpl.this.getPageImplById(parent.getId());
            if (nodeItem == null) {
                nodeItem = NonLinearBookImpl.this.getObjImplById(parent.getId());
            }
            this.init(currentNLB, nodeItem.getLinkById(link.getId()), linkVariableName, linkConstraintValue, linkText, linkAltText, auto, once);
        }

        private UpdateLinkCommand(NonLinearBook currentNLB, LinkImpl link, String linkVariableName, String linkConstraintValue, MultiLangString linkText, MultiLangString linkAltText, boolean auto, boolean once) {
            this.init(currentNLB, link, linkVariableName, linkConstraintValue, linkText, linkAltText, auto, once);
        }

        private void init(NonLinearBook currentNLB, LinkImpl link, String linkVariableName, String linkConstraintValue, MultiLangString linkText, MultiLangString linkAltText, boolean auto, boolean once) {
            this.m_link = link;
            this.m_variableTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_link.getVarId()), StringHelper.isEmpty(linkVariableName), Variable.Type.LINK, Variable.DataType.BOOLEAN, linkVariableName, "N/A", link.getFullId());
            this.m_constraintTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_link.getConstrId()), StringHelper.isEmpty(linkConstraintValue), Variable.Type.LINKCONSTRAINT, Variable.DataType.BOOLEAN, "N/A", linkConstraintValue, link.getFullId());
            this.m_existingLinkText = link.getTexts();
            this.m_newLinkText = linkText;
            this.m_existingAltText = link.getAltTexts();
            this.m_newAltText = linkAltText;
            this.m_existingAuto = link.isAuto();
            this.m_existingOnce = link.isOnce();
            this.m_newAuto = auto;
            this.m_newOnce = once;
        }

        @Override
        public void execute() {
            this.m_link.setVarId(this.m_variableTracker.execute());
            this.m_link.setConstrId(this.m_constraintTracker.execute());
            this.m_link.setTexts(this.m_newLinkText);
            this.m_link.setAltTexts(this.m_newAltText);
            this.m_link.setAuto(this.m_newAuto);
            this.m_link.setOnce(this.m_newOnce);
            this.m_link.notifyObservers();
        }

        @Override
        public void revert() {
            this.m_link.setVarId(this.m_variableTracker.revert());
            this.m_link.setConstrId(this.m_constraintTracker.revert());
            this.m_link.setTexts(this.m_existingLinkText);
            this.m_link.setAltTexts(this.m_existingAltText);
            this.m_link.setAuto(this.m_existingAuto);
            this.m_link.setOnce(this.m_existingOnce);
            this.m_link.notifyObservers();
        }
    }

    class UpdateObjCommand
    implements NLBCommand {
        private final ObjImpl m_obj;
        private VariableTracker m_variableTracker;
        private VariableTracker m_deftagTracker;
        private VariableTracker m_constraintTracker;
        private VariableTracker m_commonToTracker;
        private VariableTracker m_morphOverTracker;
        private VariableTracker m_morphOutTracker;
        private String m_existingObjName;
        private String m_existingImageFileName;
        private String m_existingSoundFileName;
        private boolean m_existingSoundSFX;
        private boolean m_existingAnimatedImage;
        private boolean m_existingSuppressDsc;
        private MultiLangString m_existingObjDisp;
        private MultiLangString m_existingObjText;
        private MultiLangString m_existingObjActText;
        private MultiLangString m_existingObjNouseText;
        private boolean m_existingObjIsGraphical;
        private boolean m_existingObjIsShowOnCursor;
        private boolean m_existingObjIsPreserved;
        private boolean m_existingObjIsLoadOnce;
        private boolean m_existingObjIsCollapsable;
        private String m_existingOffset;
        private Obj.MovementDirection m_existingMovementDirection;
        private Obj.Effect m_existingEffect;
        private int m_existingStartFrame;
        private int m_existingMaxFrame;
        private int m_existingPreloadFrames;
        private int m_existingPauseFrames;
        private Obj.CoordsOrigin m_existingCoordsOrigin;
        private boolean m_existingObjIsClearUnderTooltip;
        private boolean m_existingObjIsActOnKey;
        private boolean m_existingObjIsCacheText;
        private boolean m_existingObjIsLooped;
        private boolean m_existingObjIsNoRedrawOnAct;
        private boolean m_existingObjIsTakable;
        private boolean m_existingImageInScene;
        private boolean m_existingImageInInventory;
        private String m_newObjName;
        private String m_newImageFileName;
        private String m_newSoundFileName;
        private boolean m_newSoundSFX;
        private boolean m_newAnimatedImage;
        private boolean m_newSuppressDsc;
        private MultiLangString m_newObjDisp;
        private MultiLangString m_newObjText;
        private MultiLangString m_newObjActText;
        private MultiLangString m_newObjNouseText;
        private boolean m_newObjIsGraphical;
        private boolean m_newObjIsShowOnCursor;
        private boolean m_newObjIsPreserved;
        private boolean m_newObjIsLoadOnce;
        private boolean m_newObjIsCollapsable;
        private String m_newOffset;
        private Obj.MovementDirection m_newMovementDirection;
        private Obj.Effect m_newEffect;
        private int m_newStartFrame;
        private int m_newMaxFrame;
        private int m_newPreloadFrames;
        private int m_newPauseFrames;
        private Obj.CoordsOrigin m_newCoordsOrigin;
        private boolean m_newObjIsClearUnderTooltip;
        private boolean m_newObjIsActOnKey;
        private boolean m_newObjIsCacheText;
        private boolean m_newObjIsLooped;
        private boolean m_newObjIsNoRedrawOnAct;
        private boolean m_newObjIsTakable;
        private boolean m_newImageInScene;
        private boolean m_newImageInInventory;

        private UpdateObjCommand(NonLinearBook currentNLB, Obj obj, String objVariableName, String objDefTagVariableValue, String objConstraintValue, String objCommonToName, String objName, String imageFileName, String soundFileName, boolean soundSFX, boolean animatedImage, boolean suppressDsc, MultiLangString objDisp, MultiLangString objText, MultiLangString objActText, MultiLangString objNouseText, boolean objIsGraphical, boolean objIsShowOnCursor, boolean objIsPreserved, boolean objIsLoadOnce, boolean objIsCollapsable, String offset, Obj.MovementDirection movementDirection, Obj.Effect effect, int startFrame, int maxFrame, int preloadFrames, int pauseFrames, Obj.CoordsOrigin coordsOrigin, boolean objIsClearUnderTooltip, boolean objIsActOnKey, boolean objIsCacheText, boolean objIsLooped, boolean objIsNoRedrawOnAct, String objMorphOverName, String objMorphOutName, boolean objIsTakable, boolean imageInScene, boolean imageInInventory) {
            this(currentNLB, this$0.getObjImplById(obj.getId()), objVariableName, objDefTagVariableValue, objConstraintValue, objCommonToName, objName, imageFileName, soundFileName, soundSFX, animatedImage, suppressDsc, objDisp, objText, objActText, objNouseText, objIsGraphical, objIsShowOnCursor, objIsPreserved, objIsLoadOnce, objIsCollapsable, offset, movementDirection, effect, startFrame, maxFrame, preloadFrames, pauseFrames, coordsOrigin, objIsClearUnderTooltip, objIsActOnKey, objIsCacheText, objIsLooped, objIsNoRedrawOnAct, objMorphOverName, objMorphOutName, objIsTakable, imageInScene, imageInInventory);
        }

        private UpdateObjCommand(NonLinearBook currentNLB, ObjImpl obj, String objVariableName, String objDefTagVariableValue, String objConstraintValue, String objCommonToName, String objName, String imageFileName, String soundFileName, boolean soundSFX, boolean animatedImage, boolean suppressDsc, MultiLangString objDisp, MultiLangString objText, MultiLangString objActText, MultiLangString objNouseText, boolean objIsGraphical, boolean objIsShowOnCursor, boolean objIsPreserved, boolean objIsLoadOnce, boolean objIsCollapsable, String offset, Obj.MovementDirection movementDirection, Obj.Effect effect, int startFrame, int maxFrame, int preloadFrames, int pauseFrames, Obj.CoordsOrigin coordsOrigin, boolean objIsClearUnderTooltip, boolean objIsActOnKey, boolean objIsCacheText, boolean objIsLooped, boolean objIsNoRedrawOnAct, String objMorphOverName, String objMorphOutName, boolean objIsTakable, boolean imageInScene, boolean imageInInventory) {
            this.m_obj = obj;
            this.m_variableTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_obj.getVarId()), StringHelper.isEmpty(objVariableName), Variable.Type.OBJ, Variable.DataType.BOOLEAN, objVariableName, "N/A", this.m_obj.getFullId());
            this.m_deftagTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_obj.getDefaultTagId()), StringHelper.isEmpty(objDefTagVariableValue), Variable.Type.TAG, Variable.DataType.STRING, "N/A", objDefTagVariableValue, this.m_obj.getFullId());
            this.m_constraintTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_obj.getConstrId()), StringHelper.isEmpty(objConstraintValue), Variable.Type.OBJCONSTRAINT, Variable.DataType.BOOLEAN, "N/A", objConstraintValue, this.m_obj.getFullId());
            this.m_commonToTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_obj.getCommonToId()), StringHelper.isEmpty(objCommonToName), Variable.Type.OBJREF, Variable.DataType.STRING, objCommonToName, NonLinearBookImpl.this.findObjByName(objCommonToName).getId(), this.m_obj.getFullId());
            this.m_morphOverTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_obj.getMorphOverId()), StringHelper.isEmpty(objMorphOverName), Variable.Type.OBJREF, Variable.DataType.STRING, objMorphOverName, NonLinearBookImpl.this.findObjByName(objMorphOverName).getId(), this.m_obj.getFullId());
            this.m_morphOutTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_obj.getMorphOutId()), StringHelper.isEmpty(objMorphOutName), Variable.Type.OBJREF, Variable.DataType.STRING, objMorphOutName, NonLinearBookImpl.this.findObjByName(objMorphOutName).getId(), this.m_obj.getFullId());
            this.m_existingObjName = obj.getName();
            this.m_existingImageFileName = obj.getImageFileName();
            this.m_existingSoundFileName = obj.getSoundFileName();
            this.m_existingSoundSFX = obj.isSoundSFX();
            this.m_existingAnimatedImage = obj.isAnimatedImage();
            this.m_existingSuppressDsc = obj.isSuppressDsc();
            this.m_existingObjDisp = obj.getDisps();
            this.m_existingObjText = obj.getTexts();
            this.m_existingObjActText = obj.getActTexts();
            this.m_existingObjNouseText = obj.getNouseTexts();
            this.m_existingObjIsGraphical = obj.isGraphical();
            this.m_existingObjIsShowOnCursor = obj.isShowOnCursor();
            this.m_existingObjIsPreserved = obj.isPreserved();
            this.m_existingObjIsLoadOnce = obj.isLoadOnce();
            this.m_existingObjIsCollapsable = obj.isCollapsable();
            this.m_existingOffset = obj.getOffset();
            this.m_existingMovementDirection = obj.getMovementDirection();
            this.m_existingEffect = obj.getEffect();
            this.m_existingStartFrame = obj.getStartFrame();
            this.m_existingMaxFrame = obj.getMaxFrame();
            this.m_existingPreloadFrames = obj.getPreloadFrames();
            this.m_existingPauseFrames = obj.getPauseFrames();
            this.m_existingCoordsOrigin = obj.getCoordsOrigin();
            this.m_existingObjIsClearUnderTooltip = obj.isClearUnderTooltip();
            this.m_existingObjIsActOnKey = obj.isActOnKey();
            this.m_existingObjIsCacheText = obj.isCacheText();
            this.m_existingObjIsLooped = obj.isLooped();
            this.m_existingObjIsNoRedrawOnAct = obj.isNoRedrawOnAct();
            this.m_existingObjIsTakable = obj.isTakable();
            this.m_existingImageInScene = obj.isImageInScene();
            this.m_existingImageInInventory = obj.isImageInInventory();
            this.m_newObjName = objName;
            this.m_newImageFileName = imageFileName;
            this.m_newSoundFileName = soundFileName;
            this.m_newSoundSFX = soundSFX;
            this.m_newAnimatedImage = animatedImage;
            this.m_newSuppressDsc = suppressDsc;
            this.m_newObjDisp = objDisp;
            this.m_newObjText = objText;
            this.m_newObjActText = objActText;
            this.m_newObjNouseText = objNouseText;
            this.m_newObjIsGraphical = objIsGraphical;
            this.m_newObjIsShowOnCursor = objIsShowOnCursor;
            this.m_newObjIsPreserved = objIsPreserved;
            this.m_newObjIsLoadOnce = objIsLoadOnce;
            this.m_newObjIsCollapsable = objIsCollapsable;
            this.m_newOffset = offset;
            this.m_newMovementDirection = movementDirection;
            this.m_newEffect = effect;
            this.m_newStartFrame = startFrame;
            this.m_newMaxFrame = maxFrame;
            this.m_newPreloadFrames = preloadFrames;
            this.m_newPauseFrames = pauseFrames;
            this.m_newCoordsOrigin = coordsOrigin;
            this.m_newObjIsClearUnderTooltip = objIsClearUnderTooltip;
            this.m_newObjIsActOnKey = objIsActOnKey;
            this.m_newObjIsCacheText = objIsCacheText;
            this.m_newObjIsLooped = objIsLooped;
            this.m_newObjIsNoRedrawOnAct = objIsNoRedrawOnAct;
            this.m_newObjIsTakable = objIsTakable;
            this.m_newImageInScene = imageInScene;
            this.m_newImageInInventory = imageInInventory;
        }

        @Override
        public void execute() {
            this.m_obj.setVarId(this.m_variableTracker.execute());
            this.m_obj.setDefaultTagId(this.m_deftagTracker.execute());
            this.m_obj.setConstrId(this.m_constraintTracker.execute());
            this.m_obj.setCommonToId(this.m_commonToTracker.execute());
            this.m_obj.setMorphOverId(this.m_morphOverTracker.execute());
            this.m_obj.setMorphOutId(this.m_morphOutTracker.execute());
            this.m_obj.setName(this.m_newObjName);
            this.m_obj.setImageFileName(this.m_newImageFileName);
            this.m_obj.setSoundFileName(this.m_newSoundFileName);
            this.m_obj.setSoundSFX(this.m_newSoundSFX);
            this.m_obj.setAnimatedImage(this.m_newAnimatedImage);
            this.m_obj.setSuppressDsc(this.m_newSuppressDsc);
            this.m_obj.setDisps(this.m_newObjDisp);
            this.m_obj.setTexts(this.m_newObjText);
            this.m_obj.setActTexts(this.m_newObjActText);
            this.m_obj.setNouseTexts(this.m_newObjNouseText);
            this.m_obj.setGraphical(this.m_newObjIsGraphical);
            this.m_obj.setShowOnCursor(this.m_newObjIsShowOnCursor);
            this.m_obj.setPreserved(this.m_newObjIsPreserved);
            this.m_obj.setLoadOnce(this.m_newObjIsLoadOnce);
            this.m_obj.setCollapsable(this.m_newObjIsCollapsable);
            this.m_obj.setOffset(this.m_newOffset);
            this.m_obj.setMovementDirection(this.m_newMovementDirection);
            this.m_obj.setEffect(this.m_newEffect);
            this.m_obj.setStartFrame(this.m_newStartFrame);
            this.m_obj.setMaxFrame(this.m_newMaxFrame);
            this.m_obj.setPreloadFrames(this.m_newPreloadFrames);
            this.m_obj.setPauseFrames(this.m_newPauseFrames);
            this.m_obj.setCoordsOrigin(this.m_newCoordsOrigin);
            this.m_obj.setClearUnderTooltip(this.m_newObjIsClearUnderTooltip);
            this.m_obj.setActOnKey(this.m_newObjIsActOnKey);
            this.m_obj.setCacheText(this.m_newObjIsCacheText);
            this.m_obj.setLooped(this.m_newObjIsLooped);
            this.m_obj.setNoRedrawOnAct(this.m_newObjIsNoRedrawOnAct);
            this.m_obj.setTakable(this.m_newObjIsTakable);
            this.m_obj.setImageInScene(this.m_newImageInScene);
            this.m_obj.setImageInInventory(this.m_newImageInInventory);
            this.m_obj.notifyObservers();
        }

        @Override
        public void revert() {
            this.m_obj.setVarId(this.m_variableTracker.revert());
            this.m_obj.setDefaultTagId(this.m_deftagTracker.revert());
            this.m_obj.setConstrId(this.m_constraintTracker.revert());
            this.m_obj.setCommonToId(this.m_commonToTracker.revert());
            this.m_obj.setMorphOverId(this.m_morphOverTracker.revert());
            this.m_obj.setMorphOutId(this.m_morphOutTracker.revert());
            this.m_obj.setName(this.m_existingObjName);
            this.m_obj.setImageFileName(this.m_existingImageFileName);
            this.m_obj.setSoundFileName(this.m_existingSoundFileName);
            this.m_obj.setSoundSFX(this.m_existingSoundSFX);
            this.m_obj.setAnimatedImage(this.m_existingAnimatedImage);
            this.m_obj.setSuppressDsc(this.m_existingSuppressDsc);
            this.m_obj.setDisps(this.m_existingObjDisp);
            this.m_obj.setTexts(this.m_existingObjText);
            this.m_obj.setActTexts(this.m_existingObjActText);
            this.m_obj.setNouseTexts(this.m_existingObjNouseText);
            this.m_obj.setGraphical(this.m_existingObjIsGraphical);
            this.m_obj.setShowOnCursor(this.m_existingObjIsShowOnCursor);
            this.m_obj.setPreserved(this.m_existingObjIsPreserved);
            this.m_obj.setLoadOnce(this.m_existingObjIsLoadOnce);
            this.m_obj.setCollapsable(this.m_existingObjIsCollapsable);
            this.m_obj.setOffset(this.m_existingOffset);
            this.m_obj.setMovementDirection(this.m_existingMovementDirection);
            this.m_obj.setEffect(this.m_existingEffect);
            this.m_obj.setStartFrame(this.m_existingStartFrame);
            this.m_obj.setMaxFrame(this.m_existingMaxFrame);
            this.m_obj.setPreloadFrames(this.m_existingPreloadFrames);
            this.m_obj.setPauseFrames(this.m_existingPauseFrames);
            this.m_obj.setCoordsOrigin(this.m_existingCoordsOrigin);
            this.m_obj.setClearUnderTooltip(this.m_existingObjIsClearUnderTooltip);
            this.m_obj.setActOnKey(this.m_existingObjIsActOnKey);
            this.m_obj.setCacheText(this.m_existingObjIsCacheText);
            this.m_obj.setLooped(this.m_existingObjIsLooped);
            this.m_obj.setNoRedrawOnAct(this.m_existingObjIsNoRedrawOnAct);
            this.m_obj.setTakable(this.m_existingObjIsTakable);
            this.m_obj.setImageInScene(this.m_existingImageInScene);
            this.m_obj.setImageInInventory(this.m_existingImageInInventory);
            this.m_obj.notifyObservers();
        }
    }

    class UpdatePageCommand
    implements NLBCommand {
        private final PageImpl m_page;
        private VariableTracker m_variableTracker;
        private VariableTracker m_timerVariableTracker;
        private VariableTracker m_defTagVariableTracker;
        private VariableTracker m_moduleConstrIdTracker;
        private VariableTracker m_autowireInConstrIdTracker;
        private VariableTracker m_autowireOutConstrIdTracker;
        private final String m_existingImageFileName;
        private final boolean m_existingImageBackground;
        private final boolean m_existingImageAnimated;
        private final String m_existingSoundFileName;
        private final boolean m_existingSoundSFX;
        private final MultiLangString m_existingPageText;
        private final MultiLangString m_existingPageCaptionText;
        private final Theme m_existingTheme;
        private final boolean m_existingUseCaption;
        private final boolean m_existingUseMPL;
        private final String m_existingModuleName;
        private final boolean m_existingModuleExternal;
        private final MultiLangString m_existingTraverseText;
        private final MultiLangString m_existingReturnText;
        private final boolean m_existingAutoTraverse;
        private final boolean m_existingAutoReturn;
        private final String m_existingReturnPageId;
        private final boolean m_existingAutowire;
        private final MultiLangString m_existingAutowireInText;
        private final MultiLangString m_existingAutowireOutText;
        private final boolean m_existingGlobalAutowired;
        private final boolean m_existingNoSave;
        private final boolean m_existingAutosFirst;
        private final boolean m_existingAutoIn;
        private final boolean m_existingAutoOut;
        private final String m_newImageFileName;
        private final boolean m_newImageBackground;
        private final boolean m_newImageAnimated;
        private final String m_newSoundFileName;
        private final boolean m_newSoundSFX;
        private final MultiLangString m_newPageText;
        private final MultiLangString m_newPageCaptionText;
        private final Theme m_newTheme;
        private final boolean m_newUseCaption;
        private final boolean m_newUseMPL;
        private final String m_newModuleName;
        private final boolean m_newModuleExternal;
        private final MultiLangString m_newTraverseText;
        private final boolean m_newAutoTraverse;
        private final boolean m_newAutoReturn;
        private final MultiLangString m_newReturnText;
        private final String m_newReturnPageId;
        private final boolean m_newAutowire;
        private final MultiLangString m_newAutowireInText;
        private final MultiLangString m_newAutowireOutText;
        private final boolean m_newAutoIn;
        private final boolean m_newAutoOut;
        private final boolean m_newGlobalAutowired;
        private final boolean m_newNoSave;
        private final boolean m_newAutosFirst;
        private AbstractNodeItem.SortLinksCommand m_sortLinkCommand;
        private List<AbstractNodeItem.DeleteLinkCommand> m_deleteLinkCommands = new ArrayList<AbstractNodeItem.DeleteLinkCommand>();

        private UpdatePageCommand(NonLinearBook currentNLB, Page page, String imageFileName, boolean imageBackground, boolean imageAnimated, String soundFileName, boolean soundSFX, String pageVariableName, String pageTimerVariableName, String pageDefTagVariableValue, MultiLangString pageText, MultiLangString pageCaptionText, Theme theme, boolean useCaption, boolean useMPL, String moduleName, boolean moduleExternal, MultiLangString traverseText, boolean autoTraverse, boolean autoReturn, MultiLangString returnText, String returnPageId, String moduleConsraintVariableBody, boolean autowire, MultiLangString autowireInText, MultiLangString autowireOutText, boolean autoIn, boolean autoOut, String autowireInConstraintVariableBody, String autowireOutConstraintVariableBody, boolean globalAutowire, boolean noSave, boolean autosFirst, LinksTableModel linksTableModel) {
            this(currentNLB, this$0.getPageImplById(page.getId()), imageFileName, imageBackground, imageAnimated, soundFileName, soundSFX, pageVariableName, pageTimerVariableName, pageDefTagVariableValue, pageText, pageCaptionText, theme, useCaption, useMPL, moduleName, moduleExternal, traverseText, autoTraverse, autoReturn, returnText, returnPageId, moduleConsraintVariableBody, autowire, autowireInText, autowireOutText, autoIn, autoOut, autowireInConstraintVariableBody, autowireOutConstraintVariableBody, globalAutowire, noSave, autosFirst, linksTableModel);
        }

        private UpdatePageCommand(NonLinearBook currentNLB, PageImpl page, String imageFileName, boolean imageBackground, boolean imageAnimated, String soundFileName, boolean soundSFX, String pageVariableName, String pageTimerVariableName, String pageDefTagVariableValue, MultiLangString pageText, MultiLangString pageCaptionText, Theme theme, boolean useCaption, boolean useMPL, String moduleName, boolean moduleExternal, MultiLangString traverseText, boolean autoTraverse, boolean autoReturn, MultiLangString returnText, String returnPageId, String moduleConsraintVariableBody, boolean autowire, MultiLangString autowireInText, MultiLangString autowireOutText, boolean autoIn, boolean autoOut, String autowireInConstraintVariableBody, String autowireOutConstraintVariableBody, boolean globalAutowire, boolean noSave, boolean autosFirst, LinksTableModel linksTableModel) {
            this.m_page = page;
            this.m_variableTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_page.getVarId()), StringHelper.isEmpty(pageVariableName), Variable.Type.PAGE, Variable.DataType.BOOLEAN, pageVariableName, "N/A", this.m_page.getFullId());
            this.m_timerVariableTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_page.getTimerVarId()), StringHelper.isEmpty(pageTimerVariableName), Variable.Type.TIMER, Variable.DataType.NUMBER, pageTimerVariableName, "N/A", this.m_page.getFullId());
            this.m_defTagVariableTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_page.getDefaultTagId()), StringHelper.isEmpty(pageDefTagVariableValue), Variable.Type.TAG, Variable.DataType.STRING, "N/A", pageDefTagVariableValue, this.m_page.getFullId());
            this.m_moduleConstrIdTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_page.getModuleConstrId()), StringHelper.isEmpty(moduleConsraintVariableBody), Variable.Type.MODCONSTRAINT, Variable.DataType.BOOLEAN, "N/A", moduleConsraintVariableBody, this.m_page.getFullId());
            this.m_autowireInConstrIdTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_page.getAutowireInConstrId()), StringHelper.isEmpty(autowireInConstraintVariableBody), Variable.Type.AUTOWIRECONSTRAINT, Variable.DataType.BOOLEAN, "N/A", autowireInConstraintVariableBody, this.m_page.getFullId());
            this.m_autowireOutConstrIdTracker = new VariableTracker(currentNLB, NonLinearBookImpl.this.getVariableImplById(this.m_page.getAutowireOutConstrId()), StringHelper.isEmpty(autowireOutConstraintVariableBody), Variable.Type.AUTOWIRECONSTRAINT, Variable.DataType.BOOLEAN, "N/A", autowireOutConstraintVariableBody, this.m_page.getFullId());
            this.m_existingImageFileName = this.m_page.getImageFileName();
            this.m_existingImageBackground = this.m_page.isImageBackground();
            this.m_existingImageAnimated = this.m_page.isImageAnimated();
            this.m_existingSoundFileName = this.m_page.getSoundFileName();
            this.m_existingSoundSFX = this.m_page.isSoundSFX();
            this.m_existingPageText = this.m_page.getTexts();
            this.m_existingPageCaptionText = this.m_page.getCaptions();
            this.m_existingTheme = this.m_page.getTheme();
            this.m_existingUseCaption = this.m_page.isUseCaption();
            this.m_existingUseMPL = this.m_page.isUseMPL();
            this.m_existingModuleName = this.m_page.getModuleName();
            this.m_existingModuleExternal = this.m_page.isModuleExternal();
            this.m_existingTraverseText = this.m_page.getTraverseTexts();
            this.m_existingAutoTraverse = this.m_page.isAutoTraverse();
            this.m_existingAutoReturn = this.m_page.isAutoReturn();
            this.m_existingReturnText = this.m_page.getReturnTexts();
            this.m_existingReturnPageId = this.m_page.getReturnPageId();
            this.m_existingAutowire = this.m_page.isAutowire();
            this.m_existingAutowireInText = this.m_page.getAutowireInTexts();
            this.m_existingAutowireOutText = this.m_page.getAutowireOutTexts();
            this.m_existingGlobalAutowired = this.m_page.isGlobalAutowire();
            this.m_existingNoSave = this.m_page.isNoSave();
            this.m_existingAutosFirst = this.m_page.isAutosFirst();
            this.m_existingAutoIn = this.m_page.isAutoIn();
            this.m_existingAutoOut = this.m_page.isAutoOut();
            this.m_newImageFileName = imageFileName;
            this.m_newImageBackground = imageBackground;
            this.m_newImageAnimated = imageAnimated;
            this.m_newSoundFileName = soundFileName;
            this.m_newSoundSFX = soundSFX;
            this.m_newPageText = pageText;
            this.m_newPageCaptionText = pageCaptionText;
            this.m_newTheme = theme;
            this.m_newUseCaption = useCaption;
            this.m_newUseMPL = useMPL;
            this.m_newModuleName = moduleName;
            this.m_newModuleExternal = moduleExternal;
            this.m_newTraverseText = traverseText;
            this.m_newAutoTraverse = autoTraverse;
            this.m_newAutoReturn = autoReturn;
            this.m_newReturnText = returnText;
            this.m_newReturnPageId = returnPageId;
            this.m_newAutowire = autowire;
            this.m_newAutowireInText = autowireInText;
            this.m_newAutowireOutText = autowireOutText;
            this.m_newGlobalAutowired = globalAutowire;
            this.m_newNoSave = noSave;
            this.m_newAutosFirst = autosFirst;
            this.m_newAutoIn = autoIn;
            this.m_newAutoOut = autoOut;
            for (Link link : this.m_page.getLinks()) {
                boolean absentInModel = true;
                for (Link modelLink : linksTableModel.getLinks()) {
                    if (!modelLink.getId().equals(link.getId())) continue;
                    absentInModel = false;
                    break;
                }
                if (!absentInModel) continue;
                this.m_deleteLinkCommands.add(this.m_page.createDeleteLinkCommand(link));
            }
            this.m_sortLinkCommand = this.m_page.createSortLinksCommand(linksTableModel.getLinks());
        }

        @Override
        public void execute() {
            this.m_sortLinkCommand.execute();
            for (AbstractNodeItem.DeleteLinkCommand command : this.m_deleteLinkCommands) {
                command.execute();
            }
            this.m_page.setImageFileName(this.m_newImageFileName);
            this.m_page.setImageBackground(this.m_newImageBackground);
            this.m_page.setImageAnimated(this.m_newImageAnimated);
            this.m_page.setSoundFileName(this.m_newSoundFileName);
            this.m_page.setSoundSFX(this.m_newSoundSFX);
            this.m_page.setVarId(this.m_variableTracker.execute());
            this.m_page.setTimerVarId(this.m_timerVariableTracker.execute());
            this.m_page.setDefaultTagId(this.m_defTagVariableTracker.execute());
            this.m_page.setModuleConstrId(this.m_moduleConstrIdTracker.execute());
            this.m_page.setAutowireInConstrId(this.m_autowireInConstrIdTracker.execute());
            this.m_page.setAutowireOutConstrId(this.m_autowireOutConstrIdTracker.execute());
            this.m_page.setTexts(this.m_newPageText);
            this.m_page.setCaptions(this.m_newPageCaptionText);
            this.m_page.setTheme(this.m_newTheme);
            this.m_page.setUseCaption(this.m_newUseCaption);
            this.m_page.setUseMPL(this.m_newUseMPL);
            this.m_page.setModuleName(this.m_newModuleName);
            this.m_page.setModuleExternal(this.m_newModuleExternal);
            this.m_page.setTraverseTexts(this.m_newTraverseText);
            this.m_page.setAutoTraverse(this.m_newAutoTraverse);
            this.m_page.setAutoReturn(this.m_newAutoReturn);
            this.m_page.setReturnTexts(this.m_newReturnText);
            this.m_page.setReturnPageId(this.m_newReturnPageId);
            if (this.m_newAutowire) {
                NonLinearBookImpl.this.addAutowiredPageId(this.m_page.getId());
            } else {
                NonLinearBookImpl.this.removeAutowiredPageId(this.m_page.getId());
            }
            this.m_page.setAutowireInTexts(this.m_newAutowireInText);
            this.m_page.setAutowireOutTexts(this.m_newAutowireOutText);
            this.m_page.setAutoIn(this.m_newAutoIn);
            this.m_page.setAutoOut(this.m_newAutoOut);
            this.m_page.setGlobalAutoWired(this.m_newGlobalAutowired);
            this.m_page.setNoSave(this.m_newNoSave);
            this.m_page.setAutosFirst(this.m_newAutosFirst);
            this.m_page.notifyObservers();
        }

        @Override
        public void revert() {
            for (AbstractNodeItem.DeleteLinkCommand command : this.m_deleteLinkCommands) {
                command.revert();
            }
            this.m_sortLinkCommand.revert();
            this.m_page.setImageFileName(this.m_existingImageFileName);
            this.m_page.setImageBackground(this.m_existingImageBackground);
            this.m_page.setImageAnimated(this.m_existingImageAnimated);
            this.m_page.setSoundFileName(this.m_existingSoundFileName);
            this.m_page.setSoundSFX(this.m_existingSoundSFX);
            this.m_page.setVarId(this.m_variableTracker.revert());
            this.m_page.setTimerVarId(this.m_timerVariableTracker.revert());
            this.m_page.setDefaultTagId(this.m_defTagVariableTracker.revert());
            this.m_page.setModuleConstrId(this.m_moduleConstrIdTracker.revert());
            this.m_page.setAutowireInConstrId(this.m_autowireInConstrIdTracker.revert());
            this.m_page.setAutowireOutConstrId(this.m_autowireOutConstrIdTracker.revert());
            this.m_page.setTexts(this.m_existingPageText);
            this.m_page.setCaptions(this.m_existingPageCaptionText);
            this.m_page.setTheme(this.m_existingTheme);
            this.m_page.setUseCaption(this.m_existingUseCaption);
            this.m_page.setUseMPL(this.m_existingUseMPL);
            this.m_page.setModuleName(this.m_existingModuleName);
            this.m_page.setModuleExternal(this.m_existingModuleExternal);
            this.m_page.setTraverseTexts(this.m_existingTraverseText);
            this.m_page.setAutoTraverse(this.m_existingAutoTraverse);
            this.m_page.setAutoReturn(this.m_existingAutoReturn);
            this.m_page.setReturnTexts(this.m_existingReturnText);
            this.m_page.setReturnPageId(this.m_existingReturnPageId);
            if (this.m_existingAutowire) {
                NonLinearBookImpl.this.addAutowiredPageId(this.m_page.getId());
            } else {
                NonLinearBookImpl.this.removeAutowiredPageId(this.m_page.getId());
            }
            this.m_page.setAutowireInTexts(this.m_existingAutowireInText);
            this.m_page.setAutowireOutTexts(this.m_existingAutowireOutText);
            this.m_page.setAutoIn(this.m_existingAutoIn);
            this.m_page.setAutoOut(this.m_existingAutoOut);
            this.m_page.setGlobalAutoWired(this.m_existingGlobalAutowired);
            this.m_page.setNoSave(this.m_existingNoSave);
            this.m_page.setAutosFirst(this.m_existingAutosFirst);
            this.m_page.notifyObservers();
        }
    }

    private class VariableTracker {
        private final VariableImpl m_existingVariable;
        private final boolean m_existingVariableDeletionState;
        private final String m_existingVariableName;
        private final String m_existingVariableValue;
        private final Variable.Type m_existingVariableType;
        private final Variable.DataType m_existingVariableDataType;
        private final VariableImpl m_newVariable;
        private final String m_newVariableName;
        private final String m_newVariableValue;
        private final Variable.Type m_newVariableType;
        private final Variable.DataType m_newVariableDataType;
        private final boolean m_deleteFlag;

        private VariableTracker(NonLinearBook currentNLB, VariableImpl existingVariable, boolean deleteFlag, Variable.Type newVariableType, Variable.DataType newVariableDataType, String newVariableName, String newVariableValue, String newVariableTarget) {
            this.m_existingVariable = existingVariable;
            this.m_existingVariableDeletionState = this.m_existingVariable != null && this.m_existingVariable.isDeleted();
            this.m_deleteFlag = deleteFlag;
            this.m_newVariableName = newVariableName;
            this.m_newVariableValue = newVariableValue;
            this.m_newVariableType = newVariableType;
            this.m_newVariableDataType = newVariableDataType;
            this.m_existingVariableName = this.m_existingVariable != null ? this.m_existingVariable.getName() : "N/A";
            this.m_existingVariableValue = this.m_existingVariable != null ? this.m_existingVariable.getValue() : "N/A";
            this.m_existingVariableType = this.m_existingVariable != null ? this.m_existingVariable.getType() : Variable.Type.VAR;
            this.m_existingVariableDataType = this.m_existingVariable != null ? this.m_existingVariable.getDataType() : Variable.DataType.AUTO;
            this.m_newVariable = existingVariable == null && !deleteFlag ? new VariableImpl(currentNLB, newVariableType, newVariableDataType, newVariableName, newVariableValue, newVariableTarget) : null;
        }

        private String execute() {
            String variableId;
            if (this.m_deleteFlag) {
                variableId = NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES;
                if (this.m_existingVariable != null) {
                    this.m_existingVariable.setDeleted(true);
                }
            } else if (this.m_existingVariable == null) {
                assert (this.m_newVariable != null);
                NonLinearBookImpl.this.addVariable(this.m_newVariable);
                variableId = this.m_newVariable.getId();
            } else {
                this.m_existingVariable.setName(this.m_newVariableName);
                this.m_existingVariable.setValue(this.m_newVariableValue);
                this.m_existingVariable.setType(this.m_newVariableType);
                this.m_existingVariable.setDataType(this.m_newVariableDataType);
                this.m_existingVariable.setDeleted(false);
                variableId = this.m_existingVariable.getId();
            }
            return variableId;
        }

        private String revert() {
            String variableId;
            if (this.m_deleteFlag) {
                if (this.m_existingVariable != null) {
                    this.m_existingVariable.setDeleted(false);
                    variableId = this.m_existingVariable.getId();
                } else {
                    variableId = NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES;
                }
            } else if (this.m_existingVariable == null) {
                assert (this.m_newVariable != null);
                ListIterator iterator = NonLinearBookImpl.this.m_variables.listIterator();
                while (iterator.hasNext()) {
                    VariableImpl variableImpl = (VariableImpl)iterator.next();
                    if (!variableImpl.getId().equals(this.m_newVariable.getId())) continue;
                    iterator.remove();
                }
                variableId = NonLinearBookImpl.DEFAULT_AUTOWIRED_PAGES;
            } else {
                this.m_existingVariable.setName(this.m_existingVariableName);
                this.m_existingVariable.setValue(this.m_existingVariableValue);
                this.m_existingVariable.setType(this.m_existingVariableType);
                this.m_existingVariable.setDataType(this.m_existingVariableDataType);
                this.m_existingVariable.setDeleted(this.m_existingVariableDeletionState);
                variableId = this.m_existingVariable.getId();
            }
            return variableId;
        }
    }

    class AddPageCommand
    implements NLBCommand {
        private PageImpl m_page;
        private boolean m_autowired;
        private ChangeStartPointCommand m_changeStartPointCommand = null;

        private AddPageCommand(PageImpl page, boolean isAutowired) {
            this.m_page = page;
            this.m_autowired = isAutowired;
            if (NonLinearBookImpl.this.getPages().values().size() == 0) {
                this.m_changeStartPointCommand = new ChangeStartPointCommand(page.getId());
            }
        }

        @Override
        public void execute() {
            this.m_page.setDeleted(false);
            NonLinearBookImpl.this.addPage(this.m_page);
            if (this.m_changeStartPointCommand != null) {
                this.m_changeStartPointCommand.execute();
            }
            if (this.m_autowired) {
                NonLinearBookImpl.this.addAutowiredPageId(this.m_page.getId());
            }
            this.m_page.notifyObservers();
        }

        @Override
        public void revert() {
            this.m_page.setDeleted(true);
            if (this.m_changeStartPointCommand != null) {
                this.m_changeStartPointCommand.revert();
            }
            NonLinearBookImpl.this.m_pages.remove(this.m_page.getId());
            if (this.m_autowired) {
                NonLinearBookImpl.this.removeAutowiredPageId(this.m_page.getId());
            }
            this.m_page.notifyObservers();
        }
    }

    class ChangeStartPointCommand
    implements NLBCommand {
        private String m_newStartPoint;
        private String m_previousStartPoint;

        private ChangeStartPointCommand(String newStartPoint) {
            this.m_newStartPoint = newStartPoint;
            this.m_previousStartPoint = NonLinearBookImpl.this.getStartPoint();
        }

        @Override
        public void execute() {
            NonLinearBookImpl.this.setStartPoint(this.m_newStartPoint);
            this.notifyChangedPages();
        }

        @Override
        public void revert() {
            NonLinearBookImpl.this.setStartPoint(this.m_previousStartPoint);
            this.notifyChangedPages();
        }

        private void notifyChangedPages() {
            if (!StringHelper.isEmpty(this.m_newStartPoint)) {
                NonLinearBookImpl.this.getPageById(this.m_newStartPoint).notifyObservers();
            }
            if (!StringHelper.isEmpty(this.m_previousStartPoint)) {
                NonLinearBookImpl.this.getPageById(this.m_previousStartPoint).notifyObservers();
            }
        }
    }

    private class ModifyingItemAndModification {
        AbstractModifyingItem m_modifyingItem;
        Modification m_modification;

        private ModifyingItemAndModification() {
        }

        private AbstractModifyingItem getModifyingItem() {
            return this.m_modifyingItem;
        }

        private void setModifyingItem(AbstractModifyingItem modifyingItem) {
            this.m_modifyingItem = modifyingItem;
        }

        private Modification getModification() {
            return this.m_modification;
        }

        private void setModification(Modification modification) {
            this.m_modification = modification;
        }

        public boolean existsAndValid() {
            return this.m_modifyingItem != null && !this.m_modifyingItem.isDeleted() && !this.m_modifyingItem.hasDeletedParent() && this.m_modification != null && !this.m_modification.isDeleted() && !this.m_modification.hasDeletedParent();
        }
    }
}

