/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.CoordsLw;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.domain.AbstractNodeItem;
import com.nlbhub.nlb.domain.CoordsImpl;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.SearchResult;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.FileManipulator;
import com.nlbhub.nlb.util.MultiLangString;
import com.nlbhub.nlb.util.StringHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="obj")
public class ObjImpl
extends AbstractNodeItem
implements Obj {
    private static final String TEXT_SUBDIR_NAME = "text";
    private static final String ACT_TEXT_SUBDIR_NAME = "acttext";
    private static final String NOUSE_TEXT_SUBDIR_NAME = "nousetxt";
    private static final String VARID_FILE_NAME = "varid";
    private static final String CONSTRID_FILE_NAME = "constrid";
    private static final String COMMONTOID_FILE_NAME = "commonto";
    private static final String NAME_FILE_NAME = "name";
    private static final String IMAGE_FILE_NAME = "image";
    private static final String SOUND_FILE_NAME = "sound";
    private static final String SOUND_SFX_FILE_NAME = "soundsfx";
    private static final String SUPPRESS_DSC_FILE_NAME = "suppdsc";
    private static final String ANIMATED_FILE_NAME = "animated";
    private static final String DISP_SUBDIR_NAME = "disp";
    private static final String GRAPHICAL_FILE_NAME = "graphical";
    private static final String SHOW_ON_CURSOR_FILE_NAME = "showoncur";
    private static final String PRESERVED_FILE_NAME = "preserved";
    private static final String LOADONCE_FILE_NAME = "loadonce";
    private static final String COLLAPSABLE_FILE_NAME = "collapsable";
    private static final String MVDIRECTION_FILE_NAME = "mvdirection";
    private static final String EFFECT_FILE_NAME = "effect";
    private static final String START_FRAME_FILE_NAME = "startframe";
    private static final String MAX_FRAME_FILE_NAME = "maxframe";
    private static final String PRELOAD_FRAMES_FILE_NAME = "preloadf";
    private static final String PAUSE_FRAMES_FILE_NAME = "pausef";
    private static final String COORDSOR_FILE_NAME = "coordsor";
    private static final String CLEARUTT_FILE_NAME = "clearutt";
    private static final String ACTONKEY_FILE_NAME = "actonkey";
    private static final String CACHETEXT_FILE_NAME = "cachetxt";
    private static final String NO_REDRAW_ON_ACT_FILE_NAME = "noactredraw";
    private static final String LOOPED_FILE_NAME = "looped";
    private static final String MORPH_OVER_FILE_NAME = "morphover";
    private static final String MORPH_OUT_FILE_NAME = "morphout";
    private static final String OFFSET_FILE_NAME = "offset";
    private static final String TAKABLE_FILE_NAME = "takable";
    private static final String IMAGE_IN_SCENE_FILE_NAME = "imgscene";
    private static final String IMAGE_IN_INVENTORY_FILE_NAME = "imginv";
    private static final String CONTAINERID_FILE_NAME = "containerid";
    private String m_varId = "";
    private String m_constrId = "";
    private String m_commonToId = "";
    private String m_name = "";
    private MultiLangString m_disp = DEFAULT_DISP;
    private MultiLangString m_text = DEFAULT_TEXT;
    private MultiLangString m_actText = DEFAULT_ACT_TEXT;
    private MultiLangString m_nouseText = DEFAULT_NOUSE_TEXT;
    private boolean m_graphical = false;
    private boolean m_showOnCursor = false;
    private boolean m_preserved = false;
    private boolean m_loadOnce = false;
    private boolean m_collapsable = false;
    private Obj.MovementDirection m_movementDirection = DEFAULT_MOVEMENT_DIRECTION;
    private Obj.Effect m_effect = DEFAULT_EFFECT;
    private int m_startFrame = 0;
    private int m_maxFrame = 8;
    private int m_preloadFrames = 0;
    private int m_pauseFrames = 0;
    private Obj.CoordsOrigin m_coordsOrigin = Obj.CoordsOrigin.LeftTop;
    private boolean m_clearUnderTooltip = false;
    private boolean m_actOnKey = false;
    private boolean m_cacheText = false;
    private boolean m_looped = false;
    private boolean m_noRedrawOnAct = false;
    private String m_morphOverId = "";
    private String m_morphOutId = "";
    private String m_offset;
    private boolean m_takable = false;
    private String m_containerId = "";
    private String m_imageFileName = "";
    private boolean m_animatedImage = false;
    private String m_soundFileName = "";
    private boolean m_soundSFX = true;
    private boolean m_suppressDsc = false;
    private boolean m_imageInScene = true;
    private boolean m_imageInInventory = true;

    @Override
    public SearchResult searchText(SearchContract contract) {
        SearchResult result = super.searchText(contract);
        if (result != null) {
            return result;
        }
        if (this.textMatches(this.m_text, contract) || this.textMatches(this.m_actText, contract) || this.textMatches(this.m_nouseText, contract) || this.textMatches(this.m_name, contract) || this.textMatches(this.m_disp, contract) || this.textMatches(this.m_imageFileName, contract) || this.textMatches(this.m_soundFileName, contract)) {
            result = new SearchResult();
            result.setId(this.getId());
            result.setInformation(this.getName());
            return result;
        }
        return null;
    }

    public ObjImpl(Obj source, NonLinearBook currentNLB) {
        super(source, currentNLB);
        this.m_varId = source.getVarId();
        this.m_constrId = source.getConstrId();
        this.m_commonToId = source.getCommonToId();
        this.m_name = source.getName();
        this.m_imageFileName = source.getImageFileName();
        this.m_soundFileName = source.getSoundFileName();
        this.m_soundSFX = source.isSoundSFX();
        this.m_animatedImage = source.isAnimatedImage();
        this.setDisps(source.getDisps());
        this.setTexts(source.getTexts());
        this.setActTexts(source.getActTexts());
        this.setNouseTexts(source.getNouseTexts());
        this.m_graphical = source.isGraphical();
        this.m_showOnCursor = source.isShowOnCursor();
        this.m_preserved = source.isPreserved();
        this.m_loadOnce = source.isLoadOnce();
        this.m_collapsable = source.isCollapsable();
        this.m_offset = source.getOffset();
        this.m_movementDirection = source.getMovementDirection();
        this.m_effect = source.getEffect();
        this.m_startFrame = source.getStartFrame();
        this.m_maxFrame = source.getMaxFrame();
        this.m_preloadFrames = source.getPreloadFrames();
        this.m_pauseFrames = source.getPauseFrames();
        this.m_coordsOrigin = source.getCoordsOrigin();
        this.m_clearUnderTooltip = source.isClearUnderTooltip();
        this.m_actOnKey = source.isActOnKey();
        this.m_cacheText = source.isCacheText();
        this.m_looped = source.isLooped();
        this.m_noRedrawOnAct = source.isNoRedrawOnAct();
        this.m_morphOverId = source.getMorphOverId();
        this.m_morphOutId = source.getMorphOutId();
        this.m_takable = source.isTakable();
        this.m_suppressDsc = source.isSuppressDsc();
        this.m_imageInScene = source.isImageInScene();
        this.m_imageInInventory = source.isImageInInventory();
        this.m_containerId = source.getContainerId();
    }

    public ObjImpl(NonLinearBook currentNLB) {
        super(currentNLB);
    }

    public ObjImpl(NonLinearBook currentNLB, float left, float top) {
        super(currentNLB, left, top);
    }

    public void setText(String text) {
        this.m_text.put(this.getCurrentNLB().getLanguage(), text);
    }

    @Override
    @XmlElement(name="text")
    public String getText() {
        return this.m_text.get(this.getCurrentNLB().getLanguage());
    }

    public void setActText(String actText) {
        this.m_actText.put(this.getCurrentNLB().getLanguage(), actText);
    }

    @Override
    @XmlElement(name="acttext")
    public String getActText() {
        return this.m_actText.get(this.getCurrentNLB().getLanguage());
    }

    public void setNouseText(String nouseText) {
        this.m_nouseText.put(this.getCurrentNLB().getLanguage(), nouseText);
    }

    @Override
    @XmlElement(name="nousetxt")
    public String getNouseText() {
        return this.m_nouseText.get(this.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getTexts() {
        return MultiLangString.createCopy(this.m_text);
    }

    public void setTexts(MultiLangString text) {
        this.m_text = text;
    }

    @Override
    public MultiLangString getActTexts() {
        return MultiLangString.createCopy(this.m_actText);
    }

    public void setActTexts(MultiLangString actText) {
        this.m_actText = actText;
    }

    @Override
    public MultiLangString getNouseTexts() {
        return MultiLangString.createCopy(this.m_nouseText);
    }

    public void setNouseTexts(MultiLangString nouseText) {
        this.m_nouseText = nouseText;
    }

    @Override
    public Theme getEffectiveTheme() {
        NonLinearBook currentNLB = this.getCurrentNLB();
        String containerId = this.getContainerId();
        if (containerId == null) {
            return Theme.DEFAULT;
        }
        Page containerPage = currentNLB.getPageById(containerId);
        if (containerPage == null) {
            Obj containerObj = currentNLB.getObjById(containerId);
            if (containerObj != null) {
                return containerObj.getEffectiveTheme();
            }
        } else {
            return containerPage.getEffectiveTheme();
        }
        return Theme.DEFAULT;
    }

    @Override
    @XmlElement(name="varid")
    public String getVarId() {
        return this.m_varId;
    }

    @Override
    @XmlElement(name="constrid")
    public String getConstrId() {
        return this.m_constrId;
    }

    @Override
    @XmlElement(name="commontoid")
    public String getCommonToId() {
        return this.m_commonToId;
    }

    @Override
    public Obj getCommonToObj(NonLinearBook nonLinearBook) {
        Variable commonTo;
        if (!StringHelper.isEmpty(this.getCommonToId()) && !(commonTo = nonLinearBook.getVariableById(this.getCommonToId())).isDeleted()) {
            return nonLinearBook.getObjById(commonTo.getValue());
        }
        return null;
    }

    public void setCommonToId(String commonToId) {
        this.m_commonToId = commonToId;
    }

    public void setVarId(String varId) {
        this.m_varId = varId;
    }

    public void setConstrId(String constrId) {
        this.m_constrId = constrId;
    }

    @Override
    @XmlElement(name="name")
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getImageFileName() {
        return this.m_imageFileName;
    }

    @Override
    public String getSoundFileName() {
        return this.m_soundFileName;
    }

    public void setSoundFileName(String soundFileName) {
        this.m_soundFileName = soundFileName;
    }

    @Override
    public boolean isSoundSFX() {
        return this.m_soundSFX;
    }

    public void setSoundSFX(boolean soundSFX) {
        this.m_soundSFX = soundSFX;
    }

    public void setAnimatedImage(boolean animatedImage) {
        this.m_animatedImage = animatedImage;
    }

    @Override
    public boolean isAnimatedImage() {
        return this.m_animatedImage;
    }

    public void setSuppressDsc(boolean suppressDsc) {
        this.m_suppressDsc = suppressDsc;
    }

    @Override
    public boolean isSuppressDsc() {
        return this.m_suppressDsc;
    }

    public void setImageFileName(String imageFileName) {
        this.m_imageFileName = imageFileName;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    @XmlElement(name="disp")
    public String getDisp() {
        return this.m_disp.get(this.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getDisps() {
        return MultiLangString.createCopy(this.m_disp);
    }

    @Override
    public boolean isGraphical() {
        return this.m_graphical;
    }

    public void setGraphical(boolean graphical) {
        this.m_graphical = graphical;
    }

    @Override
    public boolean isShowOnCursor() {
        return this.m_showOnCursor;
    }

    public void setShowOnCursor(boolean showOnCursor) {
        this.m_showOnCursor = showOnCursor;
    }

    @Override
    public boolean isPreserved() {
        return this.m_preserved;
    }

    public void setPreserved(boolean preserved) {
        this.m_preserved = preserved;
    }

    @Override
    public boolean isLoadOnce() {
        return this.m_loadOnce;
    }

    public void setLoadOnce(boolean loadOnce) {
        this.m_loadOnce = loadOnce;
    }

    @Override
    public boolean isCollapsable() {
        return this.m_collapsable;
    }

    public void setCollapsable(boolean collapsable) {
        this.m_collapsable = collapsable;
    }

    @Override
    public String getOffset() {
        return this.m_offset;
    }

    public void setOffset(String offset) {
        this.m_offset = offset;
    }

    @Override
    public Obj.MovementDirection getMovementDirection() {
        return this.m_movementDirection;
    }

    public void setMovementDirection(Obj.MovementDirection movementDirection) {
        this.m_movementDirection = movementDirection;
    }

    @Override
    public Obj.Effect getEffect() {
        return this.m_effect;
    }

    public void setEffect(Obj.Effect effect) {
        this.m_effect = effect;
    }

    @Override
    public int getStartFrame() {
        return this.m_startFrame;
    }

    public void setStartFrame(int startFrame) {
        this.m_startFrame = startFrame;
    }

    @Override
    public int getMaxFrame() {
        return this.m_maxFrame;
    }

    public void setMaxFrame(int maxFrame) {
        this.m_maxFrame = maxFrame;
    }

    @Override
    public int getPreloadFrames() {
        return this.m_preloadFrames;
    }

    public void setPreloadFrames(int preloadFrames) {
        this.m_preloadFrames = preloadFrames;
    }

    @Override
    public int getPauseFrames() {
        return this.m_pauseFrames;
    }

    public void setPauseFrames(int pauseFrames) {
        this.m_pauseFrames = pauseFrames;
    }

    @Override
    public Obj.CoordsOrigin getCoordsOrigin() {
        return this.m_coordsOrigin;
    }

    public void setCoordsOrigin(Obj.CoordsOrigin coordsOrigin) {
        this.m_coordsOrigin = coordsOrigin;
    }

    @Override
    public boolean isClearUnderTooltip() {
        return this.m_clearUnderTooltip;
    }

    public void setClearUnderTooltip(boolean clearUnderTooltip) {
        this.m_clearUnderTooltip = clearUnderTooltip;
    }

    @Override
    public boolean isActOnKey() {
        return this.m_actOnKey;
    }

    public void setActOnKey(boolean actOnKey) {
        this.m_actOnKey = actOnKey;
    }

    @Override
    public boolean isCacheText() {
        return this.m_cacheText;
    }

    public void setCacheText(boolean cacheText) {
        this.m_cacheText = cacheText;
    }

    @Override
    public boolean isLooped() {
        return this.m_looped;
    }

    public void setLooped(boolean looped) {
        this.m_looped = looped;
    }

    @Override
    public boolean isNoRedrawOnAct() {
        return this.m_noRedrawOnAct;
    }

    public void setNoRedrawOnAct(boolean noRedrawOnAct) {
        this.m_noRedrawOnAct = noRedrawOnAct;
    }

    @Override
    public String getMorphOverId() {
        return this.m_morphOverId;
    }

    @Override
    public Obj getMorphOverObj() {
        return this.getCurrentNLB().getObjById(this.getObjIdByMorphId(this.m_morphOverId));
    }

    public void setMorphOverId(String morphOverId) {
        this.m_morphOverId = morphOverId;
    }

    @Override
    public String getMorphOutId() {
        return this.m_morphOutId;
    }

    @Override
    public Obj getMorphOutObj() {
        return this.getCurrentNLB().getObjById(this.getObjIdByMorphId(this.m_morphOutId));
    }

    public void setMorphOutId(String morphOutId) {
        this.m_morphOutId = morphOutId;
    }

    @Override
    public Coords getRelativeCoords(boolean lookInMorphs) {
        NonLinearBook nlb = this.getCurrentNLB();
        NodeItem node = nlb.getPageById(this.m_containerId);
        if (node == null) {
            node = this.getCurrentNLB().getObjById(this.m_containerId);
        }
        if (node == null) {
            return this.getRelativeCoordsByMorph(lookInMorphs);
        }
        Coords coordsParent = node.getCoords();
        CoordsImpl coordsThis = this.getCoords();
        CoordsLw result = new CoordsLw();
        result.setLeft(coordsThis.getLeft() - coordsParent.getLeft());
        result.setTop(coordsThis.getTop() - coordsParent.getTop());
        result.setWidth(coordsParent.getWidth());
        result.setHeight(coordsParent.getHeight());
        return result;
    }

    private Coords getRelativeCoordsByMorph(boolean lookInMorphs) {
        if (!lookInMorphs) {
            return CoordsLw.ZERO_COORDS;
        }
        Obj morphOut = this.getMorphOutObj();
        if (morphOut != null) {
            return morphOut.getRelativeCoords(false);
        }
        Obj morphOver = this.getMorphOverObj();
        if (morphOver != null) {
            return morphOver.getRelativeCoords(false);
        }
        return CoordsLw.ZERO_COORDS;
    }

    private String getObjIdByMorphId(String morphId) {
        Variable morphVar;
        if (!StringHelper.isEmpty(morphId) && !(morphVar = this.getCurrentNLB().getVariableById(morphId)).isDeleted()) {
            return morphVar.getValue();
        }
        return "";
    }

    public void setDisps(MultiLangString disp) {
        this.m_disp = disp;
    }

    public void setDisp(String disp) {
        this.m_disp.put(this.getCurrentNLB().getLanguage(), disp);
    }

    @Override
    @XmlElement(name="takable")
    public boolean isTakable() {
        return this.m_takable;
    }

    public void setTakable(boolean takable) {
        this.m_takable = takable;
    }

    @Override
    @XmlElement(name="image-in-scene")
    public boolean isImageInScene() {
        return this.m_imageInScene;
    }

    public void setImageInScene(boolean imageInScene) {
        this.m_imageInScene = imageInScene;
    }

    @Override
    @XmlElement(name="image-in-inventory")
    public boolean isImageInInventory() {
        return this.m_imageInInventory;
    }

    public void setImageInInventory(boolean imageInInventory) {
        this.m_imageInInventory = imageInInventory;
    }

    @Override
    @XmlElement(name="containerId")
    public String getContainerId() {
        return this.m_containerId;
    }

    @Override
    public Obj.ContainerType getContainerType() {
        NonLinearBook nlb = this.getCurrentNLB();
        NodeItem node = nlb.getPageById(this.m_containerId);
        if (node != null) {
            return Obj.ContainerType.Page;
        }
        node = this.getCurrentNLB().getObjById(this.m_containerId);
        if (node != null) {
            return Obj.ContainerType.Obj;
        }
        return Obj.ContainerType.None;
    }

    public void setContainerId(String containerId) {
        this.m_containerId = containerId;
    }

    public void writeObj(@NotNull FileManipulator fileManipulator, @NotNull File objsDir, @NotNull NonLinearBookImpl nonLinearBook) throws IOException, NLBIOException, NLBFileManipulationException, NLBVCSException {
        File objDir = new File(objsDir, this.getId());
        if (this.isDeleted()) {
            fileManipulator.deleteFileOrDir(objDir);
        } else {
            fileManipulator.createDir(objDir, "Cannot create NLB obj directory for obj with Id = " + this.getId());
            fileManipulator.writeOptionalString(objDir, VARID_FILE_NAME, this.m_varId, "");
            fileManipulator.writeOptionalString(objDir, CONSTRID_FILE_NAME, this.m_constrId, "");
            fileManipulator.writeOptionalString(objDir, COMMONTOID_FILE_NAME, this.m_commonToId, "");
            fileManipulator.writeOptionalString(objDir, NAME_FILE_NAME, this.m_name, "");
            fileManipulator.writeOptionalString(objDir, IMAGE_FILE_NAME, this.m_imageFileName, "");
            fileManipulator.writeOptionalString(objDir, SOUND_FILE_NAME, this.m_soundFileName, "");
            fileManipulator.writeOptionalString(objDir, SOUND_SFX_FILE_NAME, String.valueOf(this.m_soundSFX), String.valueOf(true));
            fileManipulator.writeOptionalString(objDir, ANIMATED_FILE_NAME, String.valueOf(this.m_animatedImage), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, SUPPRESS_DSC_FILE_NAME, String.valueOf(this.m_suppressDsc), String.valueOf(false));
            fileManipulator.writeOptionalMultiLangString(new File(objDir, DISP_SUBDIR_NAME), this.m_disp, DEFAULT_DISP);
            fileManipulator.writeOptionalMultiLangString(new File(objDir, TEXT_SUBDIR_NAME), this.m_text, DEFAULT_TEXT);
            fileManipulator.writeOptionalMultiLangString(new File(objDir, ACT_TEXT_SUBDIR_NAME), this.m_actText, DEFAULT_ACT_TEXT);
            fileManipulator.writeOptionalMultiLangString(new File(objDir, NOUSE_TEXT_SUBDIR_NAME), this.m_nouseText, DEFAULT_NOUSE_TEXT);
            fileManipulator.writeOptionalString(objDir, GRAPHICAL_FILE_NAME, String.valueOf(this.m_graphical), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, SHOW_ON_CURSOR_FILE_NAME, String.valueOf(this.m_showOnCursor), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, PRESERVED_FILE_NAME, String.valueOf(this.m_preserved), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, LOADONCE_FILE_NAME, String.valueOf(this.m_loadOnce), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, COLLAPSABLE_FILE_NAME, String.valueOf(this.m_collapsable), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, OFFSET_FILE_NAME, this.m_offset, "");
            fileManipulator.writeOptionalString(objDir, MVDIRECTION_FILE_NAME, this.m_movementDirection.name(), DEFAULT_MOVEMENT_DIRECTION.name());
            fileManipulator.writeOptionalString(objDir, EFFECT_FILE_NAME, this.m_effect.name(), DEFAULT_EFFECT.name());
            fileManipulator.writeOptionalString(objDir, START_FRAME_FILE_NAME, String.valueOf(this.m_startFrame), String.valueOf(0));
            fileManipulator.writeOptionalString(objDir, MAX_FRAME_FILE_NAME, String.valueOf(this.m_maxFrame), String.valueOf(8));
            fileManipulator.writeOptionalString(objDir, PRELOAD_FRAMES_FILE_NAME, String.valueOf(this.m_preloadFrames), String.valueOf(0));
            fileManipulator.writeOptionalString(objDir, PAUSE_FRAMES_FILE_NAME, String.valueOf(this.m_pauseFrames), String.valueOf(0));
            fileManipulator.writeOptionalString(objDir, COORDSOR_FILE_NAME, this.m_coordsOrigin.name(), Obj.CoordsOrigin.LeftTop.name());
            fileManipulator.writeOptionalString(objDir, CLEARUTT_FILE_NAME, String.valueOf(this.m_clearUnderTooltip), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, ACTONKEY_FILE_NAME, String.valueOf(this.m_actOnKey), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, CACHETEXT_FILE_NAME, String.valueOf(this.m_cacheText), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, LOOPED_FILE_NAME, String.valueOf(this.m_looped), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, NO_REDRAW_ON_ACT_FILE_NAME, String.valueOf(this.m_noRedrawOnAct), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, MORPH_OVER_FILE_NAME, this.m_morphOverId, "");
            fileManipulator.writeOptionalString(objDir, MORPH_OUT_FILE_NAME, this.m_morphOutId, "");
            fileManipulator.writeOptionalString(objDir, TAKABLE_FILE_NAME, String.valueOf(this.m_takable), String.valueOf(false));
            fileManipulator.writeOptionalString(objDir, IMAGE_IN_SCENE_FILE_NAME, String.valueOf(this.m_imageInScene), String.valueOf(true));
            fileManipulator.writeOptionalString(objDir, IMAGE_IN_INVENTORY_FILE_NAME, String.valueOf(this.m_imageInInventory), String.valueOf(true));
            fileManipulator.writeOptionalString(objDir, CONTAINERID_FILE_NAME, this.m_containerId, "");
            this.writeModOrderFile(fileManipulator, objDir);
            this.writeModifications(fileManipulator, objDir);
            this.writeNodeItemProperties(fileManipulator, objDir, nonLinearBook);
        }
    }

    public void readObj(File objDir) throws NLBIOException, NLBConsistencyException {
        String coordsOrigin;
        String effect;
        String movementDirection;
        this.setId(objDir.getName());
        this.m_varId = FileManipulator.getOptionalFileAsString(objDir, VARID_FILE_NAME, "");
        this.m_constrId = FileManipulator.getOptionalFileAsString(objDir, CONSTRID_FILE_NAME, "");
        this.m_commonToId = FileManipulator.getOptionalFileAsString(objDir, COMMONTOID_FILE_NAME, "");
        this.m_name = FileManipulator.getOptionalFileAsString(objDir, NAME_FILE_NAME, "");
        this.m_imageFileName = FileManipulator.getOptionalFileAsString(objDir, IMAGE_FILE_NAME, "");
        this.m_soundFileName = FileManipulator.getOptionalFileAsString(objDir, SOUND_FILE_NAME, "");
        this.m_soundSFX = "true".equals(FileManipulator.getOptionalFileAsString(objDir, SOUND_SFX_FILE_NAME, String.valueOf(true)));
        this.m_animatedImage = "true".equals(FileManipulator.getOptionalFileAsString(objDir, ANIMATED_FILE_NAME, String.valueOf(false)));
        this.m_suppressDsc = "true".equals(FileManipulator.getOptionalFileAsString(objDir, SUPPRESS_DSC_FILE_NAME, String.valueOf(false)));
        this.m_disp = FileManipulator.readOptionalMultiLangString(new File(objDir, DISP_SUBDIR_NAME), DEFAULT_DISP);
        this.m_text = FileManipulator.readOptionalMultiLangString(new File(objDir, TEXT_SUBDIR_NAME), DEFAULT_TEXT);
        this.m_actText = FileManipulator.readOptionalMultiLangString(new File(objDir, ACT_TEXT_SUBDIR_NAME), DEFAULT_ACT_TEXT);
        this.m_nouseText = FileManipulator.readOptionalMultiLangString(new File(objDir, NOUSE_TEXT_SUBDIR_NAME), DEFAULT_NOUSE_TEXT);
        this.m_graphical = "true".equals(FileManipulator.getOptionalFileAsString(objDir, GRAPHICAL_FILE_NAME, String.valueOf(false)));
        this.m_showOnCursor = "true".equals(FileManipulator.getOptionalFileAsString(objDir, SHOW_ON_CURSOR_FILE_NAME, String.valueOf(false)));
        this.m_preserved = "true".equals(FileManipulator.getOptionalFileAsString(objDir, PRESERVED_FILE_NAME, String.valueOf(false)));
        this.m_loadOnce = "true".equals(FileManipulator.getOptionalFileAsString(objDir, LOADONCE_FILE_NAME, String.valueOf(false)));
        this.m_collapsable = "true".equals(FileManipulator.getOptionalFileAsString(objDir, COLLAPSABLE_FILE_NAME, String.valueOf(false)));
        this.m_offset = FileManipulator.getOptionalFileAsString(objDir, OFFSET_FILE_NAME, "");
        switch (movementDirection = FileManipulator.getOptionalFileAsString(objDir, MVDIRECTION_FILE_NAME, DEFAULT_MOVEMENT_DIRECTION.name())) {
            case "Top": {
                this.m_movementDirection = Obj.MovementDirection.Top;
                break;
            }
            case "Left": {
                this.m_movementDirection = Obj.MovementDirection.Left;
                break;
            }
            case "Right": {
                this.m_movementDirection = Obj.MovementDirection.Right;
                break;
            }
            case "Bottom": {
                this.m_movementDirection = Obj.MovementDirection.Bottom;
                break;
            }
            default: {
                this.m_movementDirection = Obj.MovementDirection.None;
            }
        }
        switch (effect = FileManipulator.getOptionalFileAsString(objDir, EFFECT_FILE_NAME, DEFAULT_EFFECT.name()).toLowerCase()) {
            case "movein": {
                this.m_effect = Obj.Effect.MoveIn;
                break;
            }
            case "moveout": {
                this.m_effect = Obj.Effect.MoveOut;
                break;
            }
            case "zoomin": {
                this.m_effect = Obj.Effect.ZoomIn;
                break;
            }
            case "zoomout": {
                this.m_effect = Obj.Effect.ZoomOut;
                break;
            }
            case "fadein": {
                this.m_effect = Obj.Effect.FadeIn;
                break;
            }
            case "fadeout": {
                this.m_effect = Obj.Effect.FadeOut;
                break;
            }
            case "overlap": {
                this.m_effect = Obj.Effect.Overlap;
                break;
            }
            default: {
                this.m_effect = Obj.Effect.None;
            }
        }
        this.m_startFrame = Integer.parseInt(FileManipulator.getOptionalFileAsString(objDir, START_FRAME_FILE_NAME, String.valueOf(0)));
        this.m_maxFrame = Integer.parseInt(FileManipulator.getOptionalFileAsString(objDir, MAX_FRAME_FILE_NAME, String.valueOf(8)));
        this.m_preloadFrames = Integer.parseInt(FileManipulator.getOptionalFileAsString(objDir, PRELOAD_FRAMES_FILE_NAME, String.valueOf(0)));
        this.m_pauseFrames = Integer.parseInt(FileManipulator.getOptionalFileAsString(objDir, PAUSE_FRAMES_FILE_NAME, String.valueOf(0)));
        switch (coordsOrigin = FileManipulator.getOptionalFileAsString(objDir, COORDSOR_FILE_NAME, Obj.CoordsOrigin.LeftTop.name()).toLowerCase()) {
            case "lefttop": {
                this.m_coordsOrigin = Obj.CoordsOrigin.LeftTop;
                break;
            }
            case "middletop": {
                this.m_coordsOrigin = Obj.CoordsOrigin.MiddleTop;
                break;
            }
            case "righttop": {
                this.m_coordsOrigin = Obj.CoordsOrigin.RightTop;
                break;
            }
            case "leftmiddle": {
                this.m_coordsOrigin = Obj.CoordsOrigin.LeftMiddle;
                break;
            }
            case "middlemiddle": {
                this.m_coordsOrigin = Obj.CoordsOrigin.MiddleMiddle;
                break;
            }
            case "rightmiddle": {
                this.m_coordsOrigin = Obj.CoordsOrigin.RightMiddle;
                break;
            }
            case "leftbottom": {
                this.m_coordsOrigin = Obj.CoordsOrigin.LeftBottom;
                break;
            }
            case "middlebottom": {
                this.m_coordsOrigin = Obj.CoordsOrigin.MiddleBottom;
                break;
            }
            case "rightbottom": {
                this.m_coordsOrigin = Obj.CoordsOrigin.RightBottom;
                break;
            }
            default: {
                this.m_coordsOrigin = Obj.CoordsOrigin.LeftTop;
            }
        }
        this.m_clearUnderTooltip = "true".equals(FileManipulator.getOptionalFileAsString(objDir, CLEARUTT_FILE_NAME, String.valueOf(false)));
        this.m_actOnKey = "true".equals(FileManipulator.getOptionalFileAsString(objDir, ACTONKEY_FILE_NAME, String.valueOf(false)));
        this.m_cacheText = "true".equals(FileManipulator.getOptionalFileAsString(objDir, CACHETEXT_FILE_NAME, String.valueOf(false)));
        this.m_looped = "true".equals(FileManipulator.getOptionalFileAsString(objDir, LOOPED_FILE_NAME, String.valueOf(false)));
        this.m_noRedrawOnAct = "true".equals(FileManipulator.getOptionalFileAsString(objDir, NO_REDRAW_ON_ACT_FILE_NAME, String.valueOf(false)));
        this.m_morphOverId = FileManipulator.getOptionalFileAsString(objDir, MORPH_OVER_FILE_NAME, "");
        this.m_morphOutId = FileManipulator.getOptionalFileAsString(objDir, MORPH_OUT_FILE_NAME, "");
        this.m_takable = "true".equals(FileManipulator.getOptionalFileAsString(objDir, TAKABLE_FILE_NAME, String.valueOf(false)));
        this.m_imageInScene = "true".equals(FileManipulator.getOptionalFileAsString(objDir, IMAGE_IN_SCENE_FILE_NAME, String.valueOf(true)));
        this.m_imageInInventory = "true".equals(FileManipulator.getOptionalFileAsString(objDir, IMAGE_IN_INVENTORY_FILE_NAME, String.valueOf(true)));
        this.m_containerId = FileManipulator.getOptionalFileAsString(objDir, CONTAINERID_FILE_NAME, "");
        this.readNodeItemProperties(objDir);
        this.readModifications(objDir);
    }

    @Override
    public String getCumulativeText(List<String> objIdsToBeExcluded, Map<String, Object> visitedVars) {
        StringBuilder result = new StringBuilder();
        if (!objIdsToBeExcluded.contains(this.getId())) {
            result.append(StringHelper.replaceVariables(this.getText(), visitedVars));
            for (String objId : this.getContainedObjIds()) {
                Obj obj = this.getCurrentNLB().getObjById(objId);
                if (obj == null) continue;
                result.append(obj.getCumulativeText(objIdsToBeExcluded, visitedVars));
            }
        }
        return result.toString();
    }
}

