/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.DummyProgressData;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.PartialProgressData;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.AbstractNodeItem;
import com.nlbhub.nlb.domain.CoordsImpl;
import com.nlbhub.nlb.domain.LinkImpl;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.SearchResult;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.FileManipulator;
import com.nlbhub.nlb.util.MultiLangString;
import com.nlbhub.nlb.util.StringHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="page")
public class PageImpl
extends AbstractNodeItem
implements Page {
    private static final String TEXT_SUBDIR_NAME = "text";
    private static final String IMAGE_FILE_NAME = "image";
    private static final String IMAGEBG_FILE_NAME = "imagebg";
    private static final String IMGANIM_FILE_NAME = "imganim";
    private static final String SOUND_FILE_NAME = "sound";
    private static final String SOUND_SFX_FILE_NAME = "soundsfx";
    private static final String THEME_FILE_NAME = "theme";
    private static final String VARID_FILE_NAME = "varid";
    private static final String TVARID_FILE_NAME = "tvarid";
    private static final String CAPTION_SUBDIR_NAME = "caption";
    private static final String USE_CAPT_FILE_NAME = "use_capt";
    private static final String USE_MPL_FILE_NAME = "use_mpl";
    private static final String MODULE_SUBDIR_NAME = "module";
    private static final String MODNAME_FILE_NAME = "modname";
    private static final String EXTMOD_FILE_NAME = "extmod";
    private static final String TRAVTEXT_FILE_NAME = "travtext";
    private static final String AUTOTRAV_FILE_NAME = "autotrav";
    private static final String AUTORET_FILE_NAME = "autoret";
    private static final String RETTEXT_SUBDIR_NAME = "rettext";
    private static final String RETPAGE_FILE_NAME = "retpage";
    private static final String MODCNSID_FILE_NAME = "modcnsid";
    private static final String AUTO_IN_TEXT_SUBDIR_NAME = "aintext";
    private static final String AUTO_OUT_TEXT_SUBDIR_NAME = "aouttext";
    private static final String AUTO_IN_FILE_NAME = "auto_in";
    private static final String AUTO_OUT_FILE_NAME = "auto_out";
    private static final String AUTOWIRE_IN_CONSTRID_FILE_NAME = "autoid";
    private static final String AUTOWIRE_OUT_CONSTRID_FILE_NAME = "autoutid";
    private static final String NOSAVE_FILE_NAME = "nosave";
    private static final String AUTOS_FIRST_FILE_NAME = "autfirst";
    private static final String GLOBAL_AUTOWIRE_FILE_NAME = "globauto";
    private static final String DEFAULT_MODULE_NAME_FORMAT = "%s's submodule";
    private String m_imageFileName = "";
    private boolean m_imageBackground = false;
    private boolean m_imageAnimated = false;
    private String m_soundFileName = "";
    private boolean m_soundSFX = false;
    private String m_varId = "";
    private String m_timerVarId = "";
    private MultiLangString m_caption = DEFAULT_CAPTION;
    private boolean m_useCaption = false;
    private boolean m_useMPL = false;
    private MultiLangString m_text = DEFAULT_TEXT;
    private Theme m_theme = DEFAULT_THEME;
    private String m_moduleName;
    private boolean m_moduleExternal = false;
    private String m_defaultModuleName;
    private MultiLangString m_traverseText;
    private boolean m_autoTraverse = false;
    private boolean m_autoReturn = false;
    private MultiLangString m_returnText = DEFAULT_RETURN_TEXT;
    private String m_returnPageId = "";
    private String m_moduleConstrId = "";
    private NonLinearBookImpl m_module;
    private MultiLangString m_autowireInText = DEFAULT_AUTOWIRE_IN_TEXT;
    private MultiLangString m_autowireOutText = DEFAULT_AUTOWIRE_OUT_TEXT;
    private boolean m_autoIn = false;
    private boolean m_autoOut = false;
    private String m_autowireInConstrId = "";
    private String m_autowireOutConstrId = "";
    private boolean m_globalAutoWired = false;
    private boolean m_noSave = false;
    private boolean m_autosFirst = false;

    public PageImpl() {
    }

    public PageImpl(NonLinearBook currentNLB) {
        super(currentNLB);
        this.init();
    }

    public PageImpl(Page source, NonLinearBook currentNLB, boolean overwriteTheme) {
        super(source, currentNLB);
        this.m_imageFileName = source.getImageFileName();
        this.m_imageBackground = source.isImageBackground();
        this.m_imageAnimated = source.isImageAnimated();
        this.m_soundFileName = source.getSoundFileName();
        this.setSoundSFX(source.isSoundSFX());
        this.setVarId(source.getVarId());
        this.setTimerVarId(source.getTimerVarId());
        this.setCaptions(source.getCaptions());
        this.setUseCaption(source.isUseCaption());
        this.setUseMPL(source.isUseMPL());
        this.setTexts(source.getTexts());
        this.setTheme(source.getTheme());
        this.setModuleName(source.getModuleName());
        this.setModuleExternal(source.isModuleExternal());
        this.resetDefaultModuleName();
        this.setTraverseTexts(source.getTraverseTexts());
        this.setAutoTraverse(source.isAutoTraverse());
        this.setAutoReturn(source.isAutoReturn());
        this.setReturnTexts(source.getReturnTexts());
        this.setReturnPageId(source.getReturnPageId());
        this.setModuleConstrId(source.getModuleConstrId());
        this.m_module = new NonLinearBookImpl(currentNLB, this);
        this.m_module.append(source.getModule(), true, overwriteTheme);
        this.setAutowireInTexts(source.getAutowireInTexts());
        this.setAutowireOutTexts(source.getAutowireOutTexts());
        this.setGlobalAutoWired(source.isGlobalAutowire());
        this.setNoSave(source.isNoSave());
        this.setAutosFirst(source.isAutosFirst());
        this.setAutoIn(source.isAutoIn());
        this.setAutoOut(source.isAutoOut());
        this.setAutowireInConstrId(source.getAutowireInConstrId());
        this.setAutowireOutConstrId(source.getAutowireOutConstrId());
    }

    private void init() {
        this.m_module = new NonLinearBookImpl(this.getCurrentNLB(), this);
        this.resetDefaultModuleName();
        this.m_moduleName = this.m_defaultModuleName;
        this.m_moduleExternal = false;
        this.m_traverseText = MultiLangString.createCopy(DEFAULT_TRAVERSE_TEXT);
    }

    private void resetDefaultModuleName() {
        this.m_defaultModuleName = String.format(DEFAULT_MODULE_NAME_FORMAT, this.getId());
    }

    @Override
    public SearchResult searchText(SearchContract contract) {
        SearchResult result = super.searchText(contract);
        if (result != null) {
            return result;
        }
        if (this.textMatches(this.m_text, contract) || this.textMatches(this.m_caption, contract) || this.textMatches(this.m_returnText, contract) || this.textMatches(this.m_traverseText, contract) || this.textMatches(this.m_autowireInText, contract) || this.textMatches(this.m_autowireOutText, contract) || this.textMatches(this.m_imageFileName, contract) || this.textMatches(this.m_soundFileName, contract) || this.textMatches(this.m_moduleName, contract)) {
            result = new SearchResult();
            result.setId(this.getId());
            result.setInformation(this.getCaption());
            return result;
        }
        return null;
    }

    public PageImpl(NonLinearBook currentNLB, float left, float top) {
        super(currentNLB, left, top);
        this.init();
    }

    public void setImageFileName(String imageFileName) {
        this.m_imageFileName = imageFileName;
    }

    @Override
    public String getImageFileName() {
        return this.m_imageFileName;
    }

    public void setImageBackground(boolean imageBackground) {
        this.m_imageBackground = imageBackground;
    }

    @Override
    public boolean isImageBackground() {
        return this.m_imageBackground;
    }

    public void setImageAnimated(boolean imageAnimated) {
        this.m_imageAnimated = imageAnimated;
    }

    @Override
    public boolean isImageAnimated() {
        return this.m_imageAnimated;
    }

    public void setSoundFileName(String soundFileName) {
        this.m_soundFileName = soundFileName;
    }

    @Override
    public String getSoundFileName() {
        return this.m_soundFileName;
    }

    @Override
    public boolean isSoundSFX() {
        return this.m_soundSFX;
    }

    public void setSoundSFX(boolean soundSFX) {
        this.m_soundSFX = soundSFX;
    }

    public void setText(String text) {
        this.m_text.put(this.getCurrentNLB().getLanguage(), text);
    }

    @Override
    @XmlElement(name="text")
    public String getText() {
        return this.m_text.get(this.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getTexts() {
        return MultiLangString.createCopy(this.m_text);
    }

    @Override
    public Theme getTheme() {
        return this.m_theme;
    }

    @Override
    public Theme getEffectiveTheme() {
        Theme bookTheme = this.getCurrentNLB().getTheme();
        if (this.m_theme == Theme.DEFAULT) {
            return bookTheme;
        }
        return this.m_theme;
    }

    public void setTheme(Theme theme) {
        this.m_theme = theme;
    }

    public void setTexts(MultiLangString text) {
        this.m_text = text;
    }

    @Override
    @XmlElement(name="varid")
    public String getVarId() {
        return this.m_varId;
    }

    @Override
    @XmlElement(name="tvarid")
    public String getTimerVarId() {
        return this.m_timerVarId;
    }

    public void setVarId(String varId) {
        this.m_varId = varId;
    }

    public void setTimerVarId(String timerVarId) {
        this.m_timerVarId = timerVarId;
    }

    @Override
    @XmlElement(name="moduleconstrid")
    public String getModuleConstrId() {
        return this.m_moduleConstrId;
    }

    public void setModuleConstrId(String moduleConstrId) {
        this.m_moduleConstrId = moduleConstrId;
    }

    @Override
    @XmlElement(name="caption")
    public String getCaption() {
        return this.m_caption.get(this.getCurrentNLB().getLanguage());
    }

    @Override
    public String getNotes() {
        String caption = this.getCaption();
        if (StringHelper.notEmpty(caption)) {
            return caption;
        }
        return this.m_caption.get("ru");
    }

    @Override
    public MultiLangString getCaptions() {
        return MultiLangString.createCopy(this.m_caption);
    }

    public void setCaptions(MultiLangString caption) {
        this.m_caption = caption;
    }

    public void setCaption(String caption) {
        this.m_caption.put(this.getCurrentNLB().getLanguage(), caption);
    }

    @Override
    @XmlElement(name="usecaption")
    public boolean isUseCaption() {
        return this.m_useCaption;
    }

    @Override
    @XmlElement(name="usempl")
    public boolean isUseMPL() {
        return this.m_useMPL;
    }

    @Override
    public boolean isLeaf() {
        return this.getLinkCount() == 0;
    }

    @Override
    public boolean isFinish() {
        return this.isLeaf() && this.getModule().isEmpty() && !this.isAutowire() && StringHelper.isEmpty(this.m_returnText);
    }

    @Override
    public String getTraverseText() {
        return this.m_traverseText.get(this.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getTraverseTexts() {
        return MultiLangString.createCopy(this.m_traverseText);
    }

    public void setTraverseTexts(MultiLangString traverseText) {
        this.m_traverseText = traverseText;
    }

    @Override
    @XmlElement(name="is-auto-traverse")
    public boolean isAutoTraverse() {
        return this.m_autoTraverse;
    }

    public void setAutoTraverse(boolean autoTraverse) {
        this.m_autoTraverse = autoTraverse;
    }

    @Override
    @XmlElement(name="is-auto-return")
    public boolean isAutoReturn() {
        return this.m_autoReturn;
    }

    public void setAutoReturn(boolean autoReturn) {
        this.m_autoReturn = autoReturn;
    }

    @Override
    public String getReturnText() {
        return this.m_returnText.get(this.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getReturnTexts() {
        return MultiLangString.createCopy(this.m_returnText);
    }

    public void setReturnTexts(MultiLangString returnText) {
        this.m_returnText = returnText;
    }

    @Override
    @XmlElement(name="return-page-id")
    public String getReturnPageId() {
        return this.m_returnPageId;
    }

    public void setReturnPageId(String returnPageId) {
        this.m_returnPageId = returnPageId;
    }

    @Override
    public boolean shouldReturn() {
        return !StringHelper.isEmpty(this.m_returnText) || this.m_autoReturn || this.m_useMPL;
    }

    @Override
    public String getModuleName() {
        return this.m_moduleName;
    }

    public void setModuleName(String moduleName) {
        this.m_moduleName = moduleName;
    }

    @Override
    public boolean isModuleExternal() {
        return this.m_moduleExternal;
    }

    public void setModuleExternal(boolean moduleExternal) {
        this.m_moduleExternal = moduleExternal;
    }

    public void setTraverseText(String traverseText) {
        this.m_traverseText.put(this.getCurrentNLB().getLanguage(), traverseText);
    }

    public void setReturnText(String returnText) {
        this.m_returnText.put(this.getCurrentNLB().getLanguage(), returnText);
    }

    @Override
    public NonLinearBook getModule() {
        return this.m_module;
    }

    public void setAutoIn(boolean autoIn) {
        this.m_autoIn = autoIn;
    }

    public void setAutoOut(boolean autoOut) {
        this.m_autoOut = autoOut;
    }

    public void setAutowireInConstrId(String autowireInConstrId) {
        this.m_autowireInConstrId = autowireInConstrId;
    }

    public void setAutowireOutConstrId(String autowireOutConstrId) {
        this.m_autowireOutConstrId = autowireOutConstrId;
    }

    @Override
    public boolean isAutowire() {
        return this.getCurrentNLB().isAutowired(this.getId());
    }

    @Override
    public boolean isGlobalAutowire() {
        return this.m_globalAutoWired;
    }

    public void setGlobalAutoWired(boolean globalAutoWired) {
        this.m_globalAutoWired = globalAutoWired;
    }

    @Override
    public boolean isNoSave() {
        return this.m_noSave;
    }

    public void setNoSave(boolean noSave) {
        this.m_noSave = noSave;
    }

    @Override
    public boolean isAutosFirst() {
        return this.m_autosFirst;
    }

    public void setAutosFirst(boolean autosFirst) {
        this.m_autosFirst = autosFirst;
    }

    @Override
    public String getAutowireInText() {
        return this.m_autowireInText.get(this.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getAutowireInTexts() {
        return MultiLangString.createCopy(this.m_autowireInText);
    }

    public void setAutowireInText(String autowireInText) {
        this.m_autowireInText.put(this.getCurrentNLB().getLanguage(), autowireInText);
    }

    public void setAutowireInTexts(MultiLangString autowireInText) {
        this.m_autowireInText = autowireInText;
    }

    @Override
    public String getAutowireOutText() {
        return this.m_autowireOutText.get(this.getCurrentNLB().getLanguage());
    }

    @Override
    public MultiLangString getAutowireOutTexts() {
        return MultiLangString.createCopy(this.m_autowireOutText);
    }

    public void setAutowireOutText(String autowireOutText) {
        this.m_autowireOutText.put(this.getCurrentNLB().getLanguage(), autowireOutText);
    }

    public void setAutowireOutTexts(MultiLangString autowireOutText) {
        this.m_autowireOutText = autowireOutText;
    }

    @Override
    public boolean isAutoIn() {
        return this.m_autoIn;
    }

    @Override
    public boolean isAutoOut() {
        return this.m_autoOut;
    }

    @Override
    public String getAutowireInConstrId() {
        return this.m_autowireInConstrId;
    }

    @Override
    public String getAutowireOutConstrId() {
        return this.m_autowireOutConstrId;
    }

    public NonLinearBookImpl getModuleImpl() {
        return this.m_module;
    }

    public void setUseCaption(boolean useCaption) {
        this.m_useCaption = useCaption;
    }

    public void setUseMPL(boolean useMPL) {
        this.m_useMPL = useMPL;
    }

    public void writePage(@NotNull FileManipulator fileManipulator, @NotNull File pagesDir, @NotNull NonLinearBookImpl nonLinearBook, @NotNull PartialProgressData partialProgressData) throws IOException, NLBIOException, NLBFileManipulationException, NLBVCSException, NLBConsistencyException {
        File pageDir = new File(pagesDir, this.getId());
        if (this.isDeleted()) {
            fileManipulator.deleteFileOrDir(pageDir);
        } else {
            fileManipulator.createDir(pageDir, "Cannot create NLB page directory for page with Id = " + this.getId());
            File moduleDir = new File(pageDir, MODULE_SUBDIR_NAME);
            if (this.m_module.isEmpty()) {
                if (moduleDir.exists()) {
                    fileManipulator.deleteFileOrDir(moduleDir);
                }
            } else if (!this.isModuleExternal()) {
                this.m_module.setRootDir(moduleDir);
                this.m_module.save(fileManipulator, new DummyProgressData(), partialProgressData);
            }
            fileManipulator.writeOptionalString(pageDir, VARID_FILE_NAME, this.m_varId, "");
            fileManipulator.writeOptionalString(pageDir, TVARID_FILE_NAME, this.m_timerVarId, "");
            fileManipulator.writeOptionalMultiLangString(new File(pageDir, CAPTION_SUBDIR_NAME), this.m_caption, DEFAULT_CAPTION);
            fileManipulator.writeOptionalString(pageDir, USE_CAPT_FILE_NAME, String.valueOf(this.m_useCaption), String.valueOf(false));
            fileManipulator.writeOptionalString(pageDir, USE_MPL_FILE_NAME, String.valueOf(this.m_useMPL), String.valueOf(false));
            fileManipulator.writeOptionalString(pageDir, IMAGE_FILE_NAME, this.m_imageFileName, "");
            fileManipulator.writeOptionalString(pageDir, IMAGEBG_FILE_NAME, String.valueOf(this.m_imageBackground), String.valueOf(false));
            fileManipulator.writeOptionalString(pageDir, IMGANIM_FILE_NAME, String.valueOf(this.m_imageAnimated), String.valueOf(false));
            fileManipulator.writeOptionalString(pageDir, SOUND_FILE_NAME, this.m_soundFileName, "");
            fileManipulator.writeOptionalString(pageDir, SOUND_SFX_FILE_NAME, String.valueOf(this.m_soundSFX), String.valueOf(false));
            fileManipulator.writeOptionalMultiLangString(new File(pageDir, TEXT_SUBDIR_NAME), this.m_text, DEFAULT_TEXT);
            fileManipulator.writeOptionalString(pageDir, THEME_FILE_NAME, this.m_theme.name(), DEFAULT_THEME.name());
            fileManipulator.writeOptionalString(pageDir, MODNAME_FILE_NAME, this.m_moduleName, this.m_defaultModuleName);
            fileManipulator.writeOptionalString(pageDir, EXTMOD_FILE_NAME, String.valueOf(this.m_moduleExternal), String.valueOf(false));
            fileManipulator.writeOptionalMultiLangString(new File(pageDir, TRAVTEXT_FILE_NAME), this.m_traverseText, DEFAULT_TRAVERSE_TEXT);
            fileManipulator.writeOptionalString(pageDir, AUTOTRAV_FILE_NAME, String.valueOf(this.m_autoTraverse), String.valueOf(false));
            fileManipulator.writeOptionalString(pageDir, AUTORET_FILE_NAME, String.valueOf(this.m_autoReturn), String.valueOf(false));
            fileManipulator.writeOptionalMultiLangString(new File(pageDir, RETTEXT_SUBDIR_NAME), this.m_returnText, DEFAULT_RETURN_TEXT);
            fileManipulator.writeOptionalString(pageDir, RETPAGE_FILE_NAME, this.m_returnPageId, "");
            fileManipulator.writeOptionalString(pageDir, MODCNSID_FILE_NAME, this.m_moduleConstrId, "");
            fileManipulator.writeOptionalMultiLangString(new File(pageDir, AUTO_IN_TEXT_SUBDIR_NAME), this.m_autowireInText, DEFAULT_AUTOWIRE_IN_TEXT);
            fileManipulator.writeOptionalMultiLangString(new File(pageDir, AUTO_OUT_TEXT_SUBDIR_NAME), this.m_autowireOutText, DEFAULT_AUTOWIRE_OUT_TEXT);
            fileManipulator.writeOptionalString(pageDir, AUTO_IN_FILE_NAME, String.valueOf(this.m_autoIn), String.valueOf(false));
            fileManipulator.writeOptionalString(pageDir, AUTO_OUT_FILE_NAME, String.valueOf(this.m_autoOut), String.valueOf(false));
            fileManipulator.writeOptionalString(pageDir, AUTOWIRE_IN_CONSTRID_FILE_NAME, this.m_autowireInConstrId, "");
            fileManipulator.writeOptionalString(pageDir, AUTOWIRE_OUT_CONSTRID_FILE_NAME, this.m_autowireOutConstrId, "");
            fileManipulator.writeOptionalString(pageDir, GLOBAL_AUTOWIRE_FILE_NAME, String.valueOf(this.m_globalAutoWired), String.valueOf(false));
            fileManipulator.writeOptionalString(pageDir, NOSAVE_FILE_NAME, String.valueOf(this.m_noSave), String.valueOf(false));
            fileManipulator.writeOptionalString(pageDir, AUTOS_FIRST_FILE_NAME, String.valueOf(this.m_autosFirst), String.valueOf(false));
            this.writeModOrderFile(fileManipulator, pageDir);
            this.writeModifications(fileManipulator, pageDir);
            this.writeNodeItemProperties(fileManipulator, pageDir, nonLinearBook);
        }
    }

    public void readPage(File pageDir) throws NLBIOException, NLBConsistencyException, NLBVCSException {
        try {
            this.setId(pageDir.getName());
            this.resetDefaultModuleName();
            this.m_varId = FileManipulator.getOptionalFileAsString(pageDir, VARID_FILE_NAME, "");
            this.m_timerVarId = FileManipulator.getOptionalFileAsString(pageDir, TVARID_FILE_NAME, "");
            this.m_caption = FileManipulator.readOptionalMultiLangString(new File(pageDir, CAPTION_SUBDIR_NAME), DEFAULT_CAPTION);
            this.m_useCaption = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, USE_CAPT_FILE_NAME, String.valueOf(false)));
            this.m_useMPL = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, USE_MPL_FILE_NAME, String.valueOf(false)));
            this.m_imageFileName = FileManipulator.getOptionalFileAsString(pageDir, IMAGE_FILE_NAME, "");
            this.m_imageBackground = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, IMAGEBG_FILE_NAME, String.valueOf(false)));
            this.m_imageAnimated = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, IMGANIM_FILE_NAME, String.valueOf(false)));
            this.m_soundFileName = FileManipulator.getOptionalFileAsString(pageDir, SOUND_FILE_NAME, "");
            this.m_soundSFX = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, SOUND_SFX_FILE_NAME, String.valueOf(false)));
            this.m_text = FileManipulator.readOptionalMultiLangString(new File(pageDir, TEXT_SUBDIR_NAME), DEFAULT_TEXT);
            this.m_theme = this.m_theme.fromString(FileManipulator.getOptionalFileAsString(pageDir, THEME_FILE_NAME, DEFAULT_THEME.name()));
            this.m_moduleName = FileManipulator.getOptionalFileAsString(pageDir, MODNAME_FILE_NAME, this.m_defaultModuleName);
            this.m_moduleExternal = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, EXTMOD_FILE_NAME, String.valueOf(false)));
            this.m_traverseText = FileManipulator.readOptionalMultiLangString(new File(pageDir, TRAVTEXT_FILE_NAME), DEFAULT_TRAVERSE_TEXT);
            this.m_autoTraverse = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, AUTOTRAV_FILE_NAME, String.valueOf(false)));
            this.m_autoReturn = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, AUTORET_FILE_NAME, String.valueOf(false)));
            this.m_returnText = FileManipulator.readOptionalMultiLangString(new File(pageDir, RETTEXT_SUBDIR_NAME), DEFAULT_RETURN_TEXT);
            this.m_returnPageId = FileManipulator.getOptionalFileAsString(pageDir, RETPAGE_FILE_NAME, "");
            this.m_moduleConstrId = FileManipulator.getOptionalFileAsString(pageDir, MODCNSID_FILE_NAME, "");
            this.m_autowireInText = FileManipulator.readOptionalMultiLangString(new File(pageDir, AUTO_IN_TEXT_SUBDIR_NAME), DEFAULT_AUTOWIRE_IN_TEXT);
            this.m_autowireOutText = FileManipulator.readOptionalMultiLangString(new File(pageDir, AUTO_OUT_TEXT_SUBDIR_NAME), DEFAULT_AUTOWIRE_OUT_TEXT);
            this.m_autoIn = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, AUTO_IN_FILE_NAME, String.valueOf(false)));
            this.m_autoOut = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, AUTO_OUT_FILE_NAME, String.valueOf(false)));
            this.m_autowireInConstrId = FileManipulator.getOptionalFileAsString(pageDir, AUTOWIRE_IN_CONSTRID_FILE_NAME, "");
            this.m_autowireOutConstrId = FileManipulator.getOptionalFileAsString(pageDir, AUTOWIRE_OUT_CONSTRID_FILE_NAME, "");
            this.m_globalAutoWired = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, GLOBAL_AUTOWIRE_FILE_NAME, String.valueOf(false)));
            this.m_noSave = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, NOSAVE_FILE_NAME, String.valueOf(false)));
            this.m_autosFirst = "true".equals(FileManipulator.getOptionalFileAsString(pageDir, AUTOS_FIRST_FILE_NAME, String.valueOf(false)));
            if (this.isModuleExternal()) {
                this.m_module.clear();
                this.m_module.append(this.getCurrentNLB().findExternalModule(this.m_moduleName), true, true);
            } else {
                File moduleDir = new File(pageDir, MODULE_SUBDIR_NAME);
                this.m_module.loadAndSetParent(moduleDir.getCanonicalPath(), this.getCurrentNLB(), this);
            }
            this.readNodeItemProperties(pageDir);
            this.readModifications(pageDir);
        }
        catch (IOException e) {
            throw new NLBIOException("Cannot get module dir canonical path for page with Id = " + this.getId(), e);
        }
    }

    public PageImpl createFilteredCloneWithSubstitutions(List<String> objIdsToBeExcluded, List<String> linkIdsToBeExcluded, List<Link> linksToBeAdded, Map<String, Object> visitedVars) {
        PageImpl result = new PageImpl(this.getCurrentNLB());
        result.setId(this.getId());
        result.setText(StringHelper.replaceVariables(this.getText(), visitedVars) + this.generateObjText(objIdsToBeExcluded, visitedVars));
        CoordsImpl sourceCoords = this.getCoords();
        CoordsImpl resultCoords = result.getCoords();
        resultCoords.setLeft(sourceCoords.getLeft());
        resultCoords.setTop(sourceCoords.getTop());
        resultCoords.setWidth(sourceCoords.getWidth());
        resultCoords.setHeight(sourceCoords.getHeight());
        result.setImageFileName(this.getImageFileName());
        result.setDeleted(this.isDeleted());
        result.setReturnPageId(this.getReturnPageId());
        result.setTheme(this.getTheme());
        result.setVarId(this.getVarId());
        result.setTimerVarId(this.getTimerVarId());
        result.setCaption(this.getCaption());
        result.setModuleConstrId(this.getModuleConstrId());
        result.setModuleName(this.getModuleName());
        result.setModuleExternal(this.isModuleExternal());
        result.setReturnText(this.getReturnText());
        result.setTraverseText(this.getTraverseText());
        result.setUseCaption(this.isUseCaption());
        result.setUseMPL(this.isUseMPL());
        result.setAutoTraverse(this.isAutoTraverse());
        result.setAutoReturn(this.isAutoReturn());
        result.setAutowireInText(this.getAutowireInText());
        result.setAutowireOutText(this.getAutowireOutText());
        result.setAutoIn(this.isAutoIn());
        result.setAutoOut(this.isAutoOut());
        result.setGlobalAutoWired(this.isGlobalAutowire());
        result.setNoSave(this.isNoSave());
        result.setAutosFirst(this.isAutosFirst());
        result.setAutowireInConstrId(this.getAutowireInConstrId());
        result.setAutowireOutConstrId(this.getAutowireOutConstrId());
        result.setFill(this.getFill());
        result.setParent(this.getParent());
        result.setStroke(this.getStroke());
        result.setDefaultTagId(this.getDefaultTagId());
        result.setTextColor(this.getTextColor());
        AbstractNodeItem.filterTargetLinkList(result, this, linkIdsToBeExcluded);
        for (Link link : linksToBeAdded) {
            result.addLink(new LinkImpl((NodeItem)result, link));
        }
        result.replaceVariablesInLinks(visitedVars);
        return result;
    }

    private void replaceVariablesInLinks(Map<String, Object> visitedVars) {
        for (LinkImpl link : this.getLinkImpls()) {
            link.setText(StringHelper.replaceVariables(link.getText(), visitedVars));
        }
    }

    private String generateObjText(List<String> objIdsToBeExcluded, Map<String, Object> visitedVars) {
        StringBuilder result = new StringBuilder();
        for (String objId : this.getContainedObjIds()) {
            Obj obj;
            if (objIdsToBeExcluded.contains(objId) || (obj = this.getCurrentNLB().getObjById(objId)) == null) continue;
            result.append(obj.getCumulativeText(objIdsToBeExcluded, visitedVars));
        }
        return result.toString();
    }
}

