/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.NLBCommand;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.domain.AbstractNodeItem;
import com.nlbhub.nlb.domain.CoordsImpl;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import java.util.List;

public class UpdateNodeCoordsCommand
implements NLBCommand {
    private AbstractNodeItem m_nodeItem;
    private List<Link> m_associatedLinks;
    private float m_left;
    private float m_top;
    private float m_height;
    private float m_width;
    private float m_leftPrev;
    private float m_topPrev;
    private float m_heightPrev;
    private float m_widthPrev;

    private UpdateNodeCoordsCommand(NonLinearBookImpl nonLinearBook, NodeItem node) {
        this.m_nodeItem = nonLinearBook.getPageImplById(node.getId());
        if (this.m_nodeItem == null) {
            this.m_nodeItem = nonLinearBook.getObjImplById(node.getId());
        }
        this.m_associatedLinks = nonLinearBook.getAssociatedLinks(node);
        CoordsImpl coords = this.m_nodeItem.getCoords();
        this.m_leftPrev = coords.getLeft();
        this.m_topPrev = coords.getTop();
        this.m_heightPrev = coords.getHeight();
        this.m_widthPrev = coords.getWidth();
    }

    public UpdateNodeCoordsCommand(NonLinearBookImpl nonLinearBook, NodeItem node, float deltaX, float deltaY) {
        this(nonLinearBook, node);
        this.m_width = this.m_widthPrev;
        this.m_height = this.m_heightPrev;
        CoordsImpl coords = this.m_nodeItem.getCoords();
        this.m_left = coords.getLeft() + deltaX;
        this.m_top = coords.getTop() + deltaY;
    }

    public UpdateNodeCoordsCommand(NonLinearBookImpl nonLinearBook, NodeItem node, float left, float top, float width, float height) {
        this(nonLinearBook, node);
        this.m_width = width;
        this.m_height = height;
        this.m_left = left;
        this.m_top = top;
    }

    @Override
    public void execute() {
        CoordsImpl coords = this.m_nodeItem.getCoords();
        coords.setLeft(this.m_left);
        coords.setTop(this.m_top);
        coords.setWidth(this.m_width);
        coords.setHeight(this.m_height);
        this.m_nodeItem.notifyObservers();
        for (Link link : this.m_associatedLinks) {
            link.notifyObservers();
        }
    }

    @Override
    public void revert() {
        CoordsImpl coords = this.m_nodeItem.getCoords();
        coords.setLeft(this.m_leftPrev);
        coords.setTop(this.m_topPrev);
        coords.setWidth(this.m_widthPrev);
        coords.setHeight(this.m_heightPrev);
        this.m_nodeItem.notifyObservers();
        for (Link link : this.m_associatedLinks) {
            link.notifyObservers();
        }
    }
}

