/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain;

import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.SearchContract;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.domain.AbstractIdentifiableItem;
import com.nlbhub.nlb.domain.SearchResult;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.FileManipulator;
import java.io.File;

public class VariableImpl
extends AbstractIdentifiableItem
implements Variable {
    private static final String TYPE_FILE_NAME = "type";
    private static final String DATATYPE_FILE_NAME = "datatype";
    private static final String NAME_FILE_NAME = "name";
    private static final String TARGET_FILE_NAME = "target";
    private static final String VALUE_FILE_NAME = "value";
    private Variable.Type m_type = Variable.Type.PAGE;
    private Variable.DataType m_dataType = Variable.DataType.AUTO;
    private String m_name = "N/A";
    private String m_target;
    private String m_value = "N/A";

    @Override
    public SearchResult searchText(SearchContract contract) {
        SearchResult result = super.searchText(contract);
        if (result != null) {
            return result;
        }
        result = new SearchResult();
        if (!"N/A".equals(this.m_name) && this.textMatches(this.m_name, contract)) {
            result.setId(this.getId());
            result.setInformation(this.m_name);
            return result;
        }
        if (!"N/A".equals(this.m_value) && this.textMatches(this.m_value, contract)) {
            result.setId(this.getId());
            result.setInformation(this.m_value);
            return result;
        }
        return null;
    }

    public VariableImpl() {
    }

    public VariableImpl(NonLinearBook currentNLB) {
        super(currentNLB);
    }

    public VariableImpl(Variable variable, NonLinearBook currentNLB) {
        super(variable, currentNLB);
        this.m_type = variable.getType();
        this.m_dataType = variable.getDataType();
        this.m_name = variable.getName();
        this.m_target = variable.getTarget();
        this.m_value = variable.getValue();
    }

    public void copy(Variable variable) {
        super.copy(variable);
        this.m_type = variable.getType();
        this.m_dataType = variable.getDataType();
        this.m_name = variable.getName();
        this.m_target = variable.getTarget();
        this.m_value = variable.getValue();
    }

    public VariableImpl(NonLinearBook currentNLB, Variable.Type type, Variable.DataType dataType, String name, String value, String target) {
        this(currentNLB);
        this.m_type = type;
        this.m_dataType = dataType;
        this.m_name = name;
        this.m_value = value;
        this.m_target = target;
    }

    @Override
    public Variable.Type getType() {
        return this.m_type;
    }

    @Override
    public Variable.DataType getDataType() {
        return this.m_dataType;
    }

    public void setType(Variable.Type type) {
        this.m_type = type;
    }

    public void setDataType(Variable.DataType dataType) {
        this.m_dataType = dataType;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getTarget() {
        return this.m_target;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getValue() {
        return this.m_value;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public void readVariable(File varDir) throws NLBIOException, NLBConsistencyException {
        String type;
        this.setId(varDir.getName());
        switch (type = FileManipulator.getRequiredFileAsString(varDir, TYPE_FILE_NAME, "Error while reading variable type for variable with Id = " + this.getId())) {
            case "PAGE": {
                this.m_type = Variable.Type.PAGE;
                break;
            }
            case "TIMER": {
                this.m_type = Variable.Type.TIMER;
                break;
            }
            case "OBJ": {
                this.m_type = Variable.Type.OBJ;
                break;
            }
            case "OBJCONSTRAINT": {
                this.m_type = Variable.Type.OBJCONSTRAINT;
                break;
            }
            case "COMMONTO": 
            case "OBJREF": {
                this.m_type = Variable.Type.OBJREF;
                break;
            }
            case "LINK": {
                this.m_type = Variable.Type.LINK;
                break;
            }
            case "LINKCONSTRAINT": {
                this.m_type = Variable.Type.LINKCONSTRAINT;
                break;
            }
            case "VAR": {
                this.m_type = Variable.Type.VAR;
                break;
            }
            case "TAG": {
                this.m_type = Variable.Type.TAG;
                break;
            }
            case "EXPRESSION": {
                this.m_type = Variable.Type.EXPRESSION;
                break;
            }
            case "MODCONSTRAINT": {
                this.m_type = Variable.Type.MODCONSTRAINT;
                break;
            }
            case "AUTOWIRECONSTRAINT": {
                this.m_type = Variable.Type.AUTOWIRECONSTRAINT;
                break;
            }
            default: {
                throw new NLBConsistencyException("Variable type '" + type + "' cannot be determined for variable with Id = " + this.getId());
            }
        }
        block29 : switch (this.m_type) {
            case PAGE: 
            case OBJ: 
            case LINK: 
            case OBJCONSTRAINT: 
            case LINKCONSTRAINT: 
            case MODCONSTRAINT: 
            case AUTOWIRECONSTRAINT: {
                this.m_dataType = Variable.DataType.BOOLEAN;
                break;
            }
            case TIMER: {
                this.m_dataType = Variable.DataType.NUMBER;
                break;
            }
            case OBJREF: {
                this.m_dataType = Variable.DataType.STRING;
                break;
            }
            default: {
                String dataType;
                switch (dataType = FileManipulator.getOptionalFileAsString(varDir, DATATYPE_FILE_NAME, DEFAULT_DATATYPE.name())) {
                    case "AUTO": {
                        this.m_dataType = Variable.DataType.AUTO;
                        break block29;
                    }
                    case "BOOLEAN": {
                        this.m_dataType = Variable.DataType.BOOLEAN;
                        break block29;
                    }
                    case "NUMBER": {
                        this.m_dataType = Variable.DataType.NUMBER;
                        break block29;
                    }
                    case "STRING": {
                        this.m_dataType = Variable.DataType.STRING;
                        break block29;
                    }
                }
                throw new NLBConsistencyException("Variable datatype '" + dataType + "' cannot be determined for variable with Id = " + this.getId());
            }
        }
        this.m_name = FileManipulator.getOptionalFileAsString(varDir, NAME_FILE_NAME, "N/A");
        this.m_value = FileManipulator.getOptionalFileAsString(varDir, VALUE_FILE_NAME, "N/A");
        this.m_target = FileManipulator.getRequiredFileAsString(varDir, TARGET_FILE_NAME, "Error while reading variable target for variable with Id = " + this.getId());
    }

    public void writeVariable(FileManipulator fileManipulator, File varsDir) throws NLBIOException, NLBFileManipulationException, NLBVCSException {
        File varDir = new File(varsDir, this.getId());
        if (this.isDeleted()) {
            fileManipulator.deleteFileOrDir(varDir);
        } else {
            fileManipulator.createDir(varDir, "Cannot create NLB variable directory for variable with Id = " + this.getId());
            fileManipulator.writeRequiredString(varDir, TYPE_FILE_NAME, this.m_type.name());
            fileManipulator.writeOptionalString(varDir, DATATYPE_FILE_NAME, this.m_dataType.name(), DEFAULT_DATATYPE.name());
            fileManipulator.writeOptionalString(varDir, NAME_FILE_NAME, this.m_name, "N/A");
            fileManipulator.writeOptionalString(varDir, VALUE_FILE_NAME, this.m_value, "N/A");
            fileManipulator.writeRequiredString(varDir, TARGET_FILE_NAME, this.m_target);
        }
    }
}

