/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export;

import com.nlbhub.nlb.api.TextChunk;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.export.ImagePathData;
import com.nlbhub.nlb.domain.export.LinkBuildingBlocks;
import com.nlbhub.nlb.domain.export.NLBBuildingBlocks;
import com.nlbhub.nlb.domain.export.ObjBuildingBlocks;
import com.nlbhub.nlb.domain.export.PageBuildingBlocks;
import com.nlbhub.nlb.domain.export.SoundPathData;
import com.nlbhub.nlb.domain.export.TextExportManager;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.util.StringHelper;
import java.util.List;

public class QSPExportManager
extends TextExportManager {
    private static final String LINE_SEPARATOR = "\r\n";

    public QSPExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        super(nlb, encoding);
    }

    @Override
    protected String generatePreambleText(NLBBuildingBlocks nlbBuildingBlocks) {
        return "! Generated with Non-Linear Book Builder, http://nlbhub.com\r\n";
    }

    @Override
    protected String generateObjText(ObjBuildingBlocks objBlocks) {
        return "";
    }

    @Override
    protected String generatePageText(PageBuildingBlocks pageBlocks) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(pageBlocks.getPageComment());
        stringBuilder.append(pageBlocks.getPageLabel());
        stringBuilder.append(pageBlocks.getPageCaption());
        stringBuilder.append(pageBlocks.getPageImage());
        stringBuilder.append(pageBlocks.getPageTextStart());
        stringBuilder.append(pageBlocks.getPageTextEnd());
        stringBuilder.append(pageBlocks.getPageModifications());
        stringBuilder.append(pageBlocks.getPageVariable());
        List<LinkBuildingBlocks> linksBlocks = pageBlocks.getLinksBuildingBlocks();
        for (LinkBuildingBlocks linkBlocks : linksBlocks) {
            boolean hasConstraint = !StringHelper.isEmpty(linkBlocks.getLinkConstraint());
            stringBuilder.append(linkBlocks.getLinkComment());
            if (hasConstraint) {
                stringBuilder.append("IF ").append(linkBlocks.getLinkConstraint()).append(":");
                stringBuilder.append(LINE_SEPARATOR);
            }
            if (!linkBlocks.isAuto()) {
                stringBuilder.append(linkBlocks.getLinkStart());
            }
            stringBuilder.append(linkBlocks.getLinkModifications());
            stringBuilder.append(linkBlocks.getLinkVariable());
            stringBuilder.append(linkBlocks.getLinkVisitStateVariable());
            stringBuilder.append(linkBlocks.getLinkGoTo());
            if (!linkBlocks.isAuto()) {
                stringBuilder.append(linkBlocks.getLinkEnd());
            }
            if (!hasConstraint) continue;
            stringBuilder.append("END").append(LINE_SEPARATOR);
        }
        stringBuilder.append(pageBlocks.getPageEnd());
        return stringBuilder.toString();
    }

    @Override
    protected String generatePostPageText(PageBuildingBlocks pageBlocks) {
        return "";
    }

    @Override
    protected String generateTrailingText() {
        return "";
    }

    @Override
    protected String decorateTrue() {
        return "1";
    }

    @Override
    protected String decorateFalse() {
        return "0";
    }

    @Override
    protected String decorateEq() {
        return "=";
    }

    @Override
    protected String decorateNEq() {
        return "<>";
    }

    @Override
    protected String decorateGt() {
        return ">";
    }

    @Override
    protected String decorateGte() {
        return ">=";
    }

    @Override
    protected String decorateLt() {
        return "<";
    }

    @Override
    protected String decorateLte() {
        return "<=";
    }

    @Override
    protected String decorateNot() {
        return "NO ";
    }

    @Override
    protected String decorateOr() {
        return "OR";
    }

    @Override
    protected String decorateAnd() {
        return "AND";
    }

    @Override
    protected String decorateExistence(String decoratedVariable) {
        return "";
    }

    @Override
    protected String decorateBooleanVar(String constraintVar) {
        return "(" + constraintVar + " = 1)";
    }

    @Override
    protected String decorateStringVar(String constraintVar) {
        return "\\$" + constraintVar;
    }

    @Override
    protected String decorateNumberVar(String constraintVar) {
        return constraintVar;
    }

    @Override
    protected String decorateLinkLabel(String linkId, String linkText, Theme theme) {
        return "#" + linkId + LINE_SEPARATOR;
    }

    @Override
    protected String decorateLinkComment(String comment) {
        return "! Link -- " + comment + LINE_SEPARATOR;
    }

    @Override
    protected String decorateLinkStart(String linkId, String linkText, boolean isAuto, boolean isTrivial, int pageNumber, Theme theme) {
        return "  ACT '" + linkText + "':" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateLinkGoTo(String linkId, String linkText, String linkSource, int sourcePageNumber, String linkTarget, int targetPageNumber, Theme theme) {
        return "    GOTO '" + linkTarget + "'" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateLinkEnd(Theme theme) {
        return "  END\r\n";
    }

    @Override
    protected String decoratePageEnd(boolean isFinish) {
        return "-\r\n";
    }

    @Override
    protected String decorateLinkVariable(String variableName) {
        return "    " + variableName + " = 1" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateLinkVisitStateVariable(String linkVisitStateVariable) {
        return "    " + linkVisitStateVariable + " = 1" + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageVariable(String variableName) {
        return variableName + " = 1" + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageTimerVariableInit(String variableName) {
        return "";
    }

    @Override
    protected String decoratePageTimerVariable(String variableName) {
        return "";
    }

    @Override
    protected String decoratePageModifications(String modificationsText) {
        return modificationsText;
    }

    @Override
    protected String decoratePageThemeModifications(String modificationsText) {
        return "";
    }

    @Override
    protected String decorateLinkModifications(String modificationsText) {
        return modificationsText;
    }

    @Override
    protected String decoratePageCaption(String caption, boolean useCaption, String moduleTitle, boolean noSave) {
        if (StringHelper.notEmpty(caption) && useCaption) {
            return "'" + caption.toUpperCase() + "'" + LINE_SEPARATOR + "'" + StringHelper.createRepeatedString(caption.length(), "-") + "'" + LINE_SEPARATOR + "''" + LINE_SEPARATOR;
        }
        return "";
    }

    @Override
    protected String decoratePageNotes(String notes) {
        return "";
    }

    @Override
    protected String decoratePageImage(List<ImagePathData> pageImagePathDatas, boolean imageBackground, Theme theme) {
        ImagePathData pageImagePathData = pageImagePathDatas.get(0);
        if (pageImagePathData.getMaxFrameNumber() == 0) {
            String pageImagePath = pageImagePathData.getImagePath();
            if (StringHelper.isEmpty(pageImagePath)) {
                return "";
            }
            return "USEHTML = 1\r\n'<img src=\"" + pageImagePath + "\">'" + LINE_SEPARATOR;
        }
        return "";
    }

    @Override
    protected String decoratePageSound(String pageName, List<SoundPathData> pageSoundPathDatas, boolean soundSFX, Theme theme) {
        return "";
    }

    @Override
    protected String decoratePageTextStart(String labelText, int pageNumber, List<TextChunk> pageTextChunks, Theme theme) {
        return "'" + super.decoratePageTextStart(labelText, pageNumber, pageTextChunks, theme);
    }

    @Override
    protected String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageTextEnd(String labelText, int pageNumber, Theme theme, boolean hasChoicesOrLeaf) {
        return "'\r\n";
    }

    @Override
    protected String decoratePageLabel(String labelText, int pageNumber, Theme theme) {
        return "#" + labelText + LINE_SEPARATOR;
    }

    @Override
    protected String decoratePageNumber(int pageNumber) {
        return String.valueOf(pageNumber);
    }

    @Override
    protected String decoratePageComment(String comment) {
        return "! Page -- " + comment + LINE_SEPARATOR;
    }

    @Override
    protected String decorateAssignment(String variableName, String variableValue) {
        return variableName + " = " + variableValue + LINE_SEPARATOR;
    }

    @Override
    protected String decorateTag(String variable, String objId, String tag) {
        return "";
    }

    @Override
    protected String decorateGetTagOperation(String resultingVariable, String objId, String objVariableName) {
        return "";
    }

    @Override
    protected String decorateWhile(String constraint) {
        return "";
    }

    @Override
    protected String decorateIf(String constraint) {
        return "";
    }

    @Override
    protected String decorateIfHave(String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateElse() {
        return "";
    }

    @Override
    protected String decorateElseIf(String constraint) {
        return "";
    }

    @Override
    protected String decorateEnd() {
        return "";
    }

    @Override
    protected String decorateReturn(String returnValue) {
        return "";
    }

    @Override
    protected String decorateHaveOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateCloneOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateContainerOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateGetIdOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateDelObj(String destinationId, String destinationName, String objectId, String objectVar, String objectName, String objectDisplayName) {
        return "";
    }

    @Override
    protected String decorateDelInvObj(String objectId, String objectVar, String objectName, String objectDisplayName) {
        return "DELOBJ '" + objectDisplayName + "'" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateAddObj(String destinationId, String objectId, String objectVar, String objectName, String objectDisplayName, boolean unique) {
        return "";
    }

    @Override
    protected String decorateAddInvObj(String objectId, String objectVar, String objectName, String objectDisplayName) {
        return "ADDOBJ '" + objectDisplayName + "'" + LINE_SEPARATOR;
    }

    @Override
    protected String decorateAddAllOperation(String destinationId, String destinationListVariableName, String sourceListVariableName, boolean unique) {
        return "";
    }

    @Override
    protected String decorateObjsOperation(String listVariableName, String srcObjId, String objectVar) {
        return "";
    }

    @Override
    protected String decorateSSndOperation() {
        return "";
    }

    @Override
    protected String decorateWSndOperation() {
        return "";
    }

    @Override
    protected String decorateSndOperation(String objectId, String objectVar) {
        return "";
    }

    @Override
    protected String decorateSPushOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decorateWPushOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decoratePushOperation(String listVariableName, String objectId, String objectVar) {
        return "";
    }

    @Override
    protected String decoratePopOperation(String variableName, String listVariableName) {
        return "";
    }

    @Override
    protected String decorateSInjectOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decorateInjectOperation(String listVariableName, String objectId, String objectVar) {
        return "";
    }

    @Override
    protected String decorateEjectOperation(String variableName, String listVariableName) {
        return "";
    }

    @Override
    protected String decorateClearOperation(String destinationId, String destinationVar) {
        return "";
    }

    @Override
    protected String decorateClearInvOperation() {
        return "";
    }

    @Override
    protected String decorateSizeOperation(String variableName, String listVariableName) {
        return "";
    }

    @Override
    protected String decorateRndOperation(String variableName, String maxValue) {
        return "";
    }

    @Override
    protected String decorateAchMaxOperation(String achievementName, int max) {
        return "";
    }

    @Override
    protected String decorateAchieveOperation(String achievementName, String modificationId) {
        return "";
    }

    @Override
    protected String decorateAchievedOperation(String variableName, String achievementName) {
        return "";
    }

    @Override
    protected String decorateGoToOperation(String locationId) {
        return "";
    }

    @Override
    protected String decorateSnapshotOperation(String snapshotId) {
        return "";
    }

    @Override
    protected String decorateOpenURLOperation(String url) {
        return "";
    }

    @Override
    protected String decorateWinGeomOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateInvGeomOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateWinColorOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateInvColorOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateShuffleOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decoratePRNOperation(String variableName) {
        return "";
    }

    @Override
    protected String decorateDSCOperation(String resultVariableName, String dscObjVariable, String dscObjId) {
        return "";
    }

    @Override
    protected String decoratePDscOperation(String objVariableName) {
        return "";
    }

    @Override
    protected String decoratePDscsOperation(String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateActOperation(String actingObjVariable, String actingObjId) {
        return "";
    }

    @Override
    protected String decorateActtOperation(String resultVariableName, String actObjVariable, String actObjId) {
        return "";
    }

    @Override
    protected String decorateActfOperation(String actingObjVariable, String actingObjId) {
        return "";
    }

    @Override
    protected String decorateUseOperation(String sourceVariable, String sourceId, String targetVariable, String targetId) {
        return "";
    }
}

